/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LastModCmdOpts;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class LastModCmd
extends AbstractSubcommand {
    private IFilesystemRestClient client;
    private DateFormat shortDateFormat = new SimpleDateFormat("yyyyMMddhhmm");

    public void run() throws FileSystemException {
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        this.execute();
    }

    private List<ShareDTO> consumeArguments() throws FileSystemException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        this.shortDateFormat = new SimpleDateFormat(subargs.getOption((IOptionKey)LastModCmdOpts.OPT_DATE_FORMAT, SubcommandUtil.getDateFormat((String)"yyyyMMddhhmm", (IScmClientConfiguration)this.config).toPattern()));
        List paths = subargs.getOptions((IOptionKey)LastModCmdOpts.OPT_TO_CALCULATE);
        return this.findFoldersInCFA(paths);
    }

    private List<ShareDTO> findFoldersInCFA(List<String> strPaths) throws FileSystemException {
        PathLocation cfaRoot = new PathLocation(this.config.getContext().getCurrentWorkingDirectory());
        List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, strPaths);
        if (paths.contains(cfaRoot)) {
            List shareDTOList = RepoUtil.getSharesInSandbox(null, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            return shareDTOList;
        }
        for (ILocation path : paths) {
            if (SubcommandUtil.exists((ILocation)path, null)) continue;
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)path.toOSString()));
        }
        List resPropList = RepoUtil.getResourceProperties(strPaths, (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config, (boolean)false);
        ArrayList<ShareDTO> folders = new ArrayList<ShareDTO>(strPaths.size());
        for (ResourcePropertiesDTO resProp : resPropList) {
            if (!resProp.getVersionableItemType().equals("folder")) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.LastModCmd_5, (Object)resProp.getFullPath()));
            }
            if (resProp.getItemId() == null) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)resProp.getFullPath()));
            }
            folders.add(resProp.getShare());
        }
        return folders;
    }

    private Map<ItemId<IItem>, List<IShareable>> groupShareablesByConnection(List<IShareable> commitRoots) throws FileSystemException {
        HashMap<ItemId<IItem>, List<IShareable>> map = new HashMap<ItemId<IItem>, List<IShareable>>();
        for (IShareable shareable : commitRoots) {
            IShare share = shareable.getShare(null);
            IContextHandle handle = share.getSharingDescriptor().getConnectionHandle();
            ItemId id = ItemId.create((IItemHandle)handle);
            SubcommandUtil.addToMapOfLists(map, (Object)id, (Object)shareable);
        }
        return map;
    }

    private void execute() throws FileSystemException {
        ResourcesPlugin.getWorkspace().getRoot();
        List<ShareDTO> folders = this.consumeArguments();
        HashMap<ParmsWorkspace, ArrayList<ShareDTO>> groupShareByWs = new HashMap<ParmsWorkspace, ArrayList<ShareDTO>>();
        for (ShareDTO shareDTO : folders) {
            ParmsWorkspace ws = new ParmsWorkspace(RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ShareDTO)shareDTO), shareDTO.getContextItemId());
            ArrayList<ShareDTO> shareList = (ArrayList<ShareDTO>)groupShareByWs.get(ws);
            if (shareList == null) {
                shareList = new ArrayList<ShareDTO>();
                groupShareByWs.put(ws, shareList);
                RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ConnectionInfo)this.config.getConnectionInfo(ws.repositoryUrl));
            }
            shareList.add(shareDTO);
        }
        if (this.config.isDryRun()) {
            return;
        }
        for (Map.Entry entry : groupShareByWs.entrySet()) {
            this.commit((ParmsWorkspace)entry.getKey(), (List)entry.getValue());
        }
    }

    private void commit(ParmsWorkspace ws, List<ShareDTO> shareables) throws FileSystemException {
        ITeamRepository repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
        Map<ItemId<IComponent>, List<ShareDTO>> groupedByComponent = this.groupByComponent(shareables);
        for (Map.Entry<ItemId<IComponent>, List<ShareDTO>> entry : groupedByComponent.entrySet()) {
            IComponentHandle compHandle = (IComponentHandle)entry.getKey().toHandle();
            ArrayList<IFolderHandle> folders = new ArrayList<IFolderHandle>(entry.getValue().size());
            ArrayList<ShareDTO> shares = new ArrayList<ShareDTO>(entry.getValue().size());
            for (ShareDTO shareDTO : entry.getValue()) {
                if (shareDTO.getRootVersionableItemType().equals("folder")) {
                    IVersionableHandle handle = RepoUtil.getVersionableHandle((ITeamRepository)repo, (String)shareDTO.getRootVersionableItemId(), null, (String)shareDTO.getRootVersionableItemType(), (IScmClientConfiguration)this.config);
                    folders.add((IFolderHandle)handle);
                    shares.add(shareDTO);
                    continue;
                }
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.LastModCmd_5, (Object)StringUtil.createPathString((List)shareDTO.getPath().getSegments())));
            }
            try {
                List baselines = ws.getWorkspaceConnection(null).getMostRecentBaselinesAffecting(compHandle, folders, null);
                int i = 0;
                while (i < baselines.size()) {
                    IBaseline baseline = (IBaseline)baselines.get(i);
                    ShareDTO shareable = (ShareDTO)shares.get(i);
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.LastModCmd_6, (Object)StringUtil.createPathString((List)shareable.getPath().getSegments()), (Object)this.shortDateFormat.format(baseline.getCreationDate())));
                    ++i;
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.LastModCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
        }
    }

    private Map<ItemId<IComponent>, List<ShareDTO>> groupByComponent(List<ShareDTO> shareables) throws FileSystemException {
        HashMap<ItemId<IComponent>, List<ShareDTO>> grouped = new HashMap<ItemId<IComponent>, List<ShareDTO>>();
        for (ShareDTO shareable : shareables) {
            ItemId id = new ItemId(IComponent.ITEM_TYPE, UUID.valueOf((String)shareable.getComponentItemId()));
            SubcommandUtil.addToMapOfLists(grouped, (Object)id, (Object)shareable);
        }
        return grouped;
    }
}

