/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.HistoryCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmBaselineHistoryEntry;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentHistory2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentHistory3;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmContributor;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmContributorList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHistoryEntry;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemHistory2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionable;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class HistoryCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        List<ScmHistoryEntry> entries;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        boolean isRemotePath = cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_REMOTE_PATH);
        boolean hasLocalPath = cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_LOCAL_PATH);
        boolean hasComponent = cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT) || cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT_DEPRECATED);
        boolean includeBaselines = cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_INCLUDE_BASELINES);
        if (includeBaselines && !hasComponent) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.HistoryCmd_INCLUDE_BASELINES_MISSING_ARGS, (Object)HistoryCmdOpts.OPT_INCLUDE_BASELINES.toString()));
        }
        if (!(!isRemotePath || cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_WORKSPACE) && hasComponent && hasLocalPath)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.HistoryCmd_RemotePath_Missing_Args, (Object)HistoryCmdOpts.OPT_REMOTE_PATH.toString()));
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        if (cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_WORKSPACE)) {
            ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)HistoryCmdOpts.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        WsCompInfo wsCompInfo = null;
        if (cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT) || cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT_DEPRECATED)) {
            ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)(cli.hasOption((IOptionKey)HistoryCmdOpts.OPT_COMPONENT) ? cli.getOptionValue((IOptionKey)HistoryCmdOpts.OPT_COMPONENT) : cli.getOptionValue((IOptionKey)HistoryCmdOpts.OPT_COMPONENT_DEPRECATED)), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            if (repo != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, Collections.singletonList(compSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            }
            wsCompInfo = this.getComponent(ws, compSelector.getItemSelector(), client, this.config, out);
            if (repo == null) {
                repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(wsCompInfo.getRepositoryUrl()));
                ws = wsCompInfo.getWorkspace();
            }
        }
        String versionableId = null;
        String versionableType = null;
        String versionableNameSpace = null;
        if (!isRemotePath) {
            if (hasLocalPath) {
                String path = cli.getOption((IOptionKey)HistoryCmdOpts.OPT_LOCAL_PATH);
                ResourcePropertiesDTO dto = RepoUtil.getResourceProperties((String)path, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                ShareDTO share = dto.getShare();
                String repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ShareDTO)share);
                if (wsCompInfo != null && !wsCompInfo.getComponentId().equals(share.getComponentItemId()) && !wsCompInfo.getWorkspaceId().equals(share.getContextItemId())) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.HistoryCmd_PATH_NOT_IN_COMPONENT, (Object)path, (Object)wsCompInfo.getComponentName()));
                }
                versionableId = dto.getItemId();
                if (dto.getVersionableItemType().equals("file")) {
                    versionableType = IFileItem.ITEM_TYPE.getName();
                    versionableNameSpace = IFileItem.ITEM_TYPE.getNamespaceURI();
                } else if (dto.getVersionableItemType().equals("folder")) {
                    versionableType = IFolder.ITEM_TYPE.getName();
                    versionableNameSpace = IFolder.ITEM_TYPE.getNamespaceURI();
                } else if (dto.getVersionableItemType().equals("symbolic_link")) {
                    versionableType = ISymbolicLink.ITEM_TYPE.getName();
                    versionableNameSpace = ISymbolicLink.ITEM_TYPE.getNamespaceURI();
                }
                if (wsCompInfo == null) {
                    wsCompInfo = new WsCompInfo(new ParmsWorkspace(repositoryUrl, share.getContextItemId()), share.getContextName(), share.getComponentItemId(), share.getRootVersionableItemId(), share.getComponentName(), RepoUtil.ItemType.WORKSPACE);
                }
                if (ws == null) {
                    ws = wsCompInfo.getWorkspace();
                } else if (!ws.workspaceItemId.equals(wsCompInfo.getWorkspaceId())) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.HistoryCmd_PATH_NOT_IN_WORKSPACE, (Object)path, (Object)wsCompInfo.getComponentName()));
                }
                repo = RepoUtil.getSharedRepository((String)repositoryUrl, (boolean)true);
            } else if (wsCompInfo == null) {
                List shareList = new ArrayList();
                if (ws != null) {
                    shareList = RepoUtil.getSharesInSandbox((String)ws.workspaceItemId, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                } else {
                    String repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI, null);
                    if (repoUri != null) {
                        repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
                    }
                    ParmsWorkspace wsFound = RepoUtil.findWorkspaceInSandbox(null, (UUID)(repo != null ? repo.getId() : null), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                    shareList = RepoUtil.getSharesInSandbox((String)wsFound.workspaceItemId, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                }
                if (shareList.size() != 1) {
                    throw StatusHelper.ambiguousSelector((String)Messages.Common_UNIQUE_LOADED_COMP);
                }
                ShareDTO share = (ShareDTO)shareList.get(0);
                String repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ShareDTO)share);
                wsCompInfo = new WsCompInfo(new ParmsWorkspace(repositoryUrl, share.getContextItemId()), share.getContextName(), share.getComponentItemId(), share.getRootVersionableItemId(), share.getComponentName(), RepoUtil.ItemType.WORKSPACE);
                if (ws == null) {
                    ws = new ParmsWorkspace(repositoryUrl, share.getContextItemId());
                } else if (!ws.workspaceItemId.equals(wsCompInfo.getWorkspaceId())) {
                    throw StatusHelper.ambiguousSelector((String)Messages.Common_UNIQUE_LOADED_COMP);
                }
                repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repositoryUrl));
            }
        } else {
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            String remotePath = cli.getOption((IOptionKey)HistoryCmdOpts.OPT_LOCAL_PATH);
            String[] path = StringUtil.splitEscapedPath((String)remotePath);
            remotePath = StringUtil.createPathString((String[])path);
            ScmVersionable ver = RepoUtil.getVersionableByPath((IScmRichClientRestService)scmService, (String)wsCompInfo.getWorkspaceId(), (String)wsCompInfo.getComponentId(), (String)remotePath, (IScmClientConfiguration)this.config);
            versionableId = ver.getVersionable().getItemId().getUuidValue();
            versionableType = ver.getVersionable().getItemType().getName();
            versionableNameSpace = ver.getVersionable().getItemType().getNamespaceURI();
        }
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE) || this.config.isJSONEnabled();
        IScmRichClientRestService scmRichService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        int requestSize = maxResults;
        boolean hasMore = false;
        ChangeHistoryWithBaselinesResult historiesForComponentResult = null;
        if (hasLocalPath || versionableId != null) {
            if (requestSize < Integer.MAX_VALUE) {
                ++requestSize;
            }
            if (!(entries = this.getHistoryEntriesForVersionable(scmRichService, ws, wsCompInfo.getComponentId(), versionableId, versionableType, versionableNameSpace, requestSize, this.config)).isEmpty() && requestSize < Integer.MAX_VALUE && entries.size() > maxResults) {
                hasMore = true;
                entries.remove(entries.size() - 1);
            }
        } else {
            historiesForComponentResult = this.getHistoryEntriesForComponent(scmRichService, ws, wsCompInfo.getComponentId(), requestSize, includeBaselines, this.config);
            entries = historiesForComponentResult.getChangeSets();
            hasMore = historiesForComponentResult.hasMore();
        }
        boolean isDeliveryInfoRequested = !hasLocalPath;
        ArrayList<String> changeSetIds = new ArrayList<String>();
        HashSet<String> contributorsToFetch = new HashSet<String>();
        for (ScmHistoryEntry entry : entries) {
            changeSetIds.add(entry.getChangeSetItemId());
            if (!isDeliveryInfoRequested) continue;
            contributorsToFetch.add(entry.getAddedById());
        }
        HashSet<String> baselinesToFetch = new HashSet<String>();
        if (includeBaselines && historiesForComponentResult != null) {
            for (Collection<ScmBaselineHistoryEntry> historicEntryLists : historiesForComponentResult.getChangeSetToBaselineMap().values()) {
                for (ScmBaselineHistoryEntry historicEntry : historicEntryLists) {
                    baselinesToFetch.add(historicEntry.getItemId());
                    contributorsToFetch.add(historicEntry.getAddedById());
                }
            }
        }
        HashMap<String, String> contributorNames = new HashMap();
        if (isDeliveryInfoRequested || includeBaselines) {
            contributorNames = this.fetchContributorNames(scmRichService, contributorsToFetch);
        }
        HashMap<String, BaselineDTO> baselines = new HashMap();
        if (includeBaselines) {
            baselines = this.fetchBaselines(baselinesToFetch, repo, client);
        }
        Map<String, PendingChangesUtil.DeliveryInfo> deliveryInfoMap = null;
        if (isDeliveryInfoRequested) {
            deliveryInfoMap = this.createChangesDeliveryInfoMap(entries, contributorNames);
        }
        Map<String, List<PendingChangesUtil.BaselineDeliveryInfo>> baselineDeliveryInfoMap = null;
        if (includeBaselines && historiesForComponentResult != null) {
            baselineDeliveryInfoMap = this.createBaselineDeliveryInfoMap(historiesForComponentResult, contributorNames, baselines);
        }
        PendingChangesUtil.PendingChangesOptions pcOptions = new PendingChangesUtil.PendingChangesOptions();
        pcOptions.enablePrinter(4);
        pcOptions.enablePrinter(22);
        if (!hasLocalPath) {
            pcOptions.enablePrinter(34);
        }
        if (verbose) {
            pcOptions.setVerbose(true);
            pcOptions.enablePrinter(6);
            pcOptions.enablePrinter(7);
            pcOptions.enablePrinter(31);
            pcOptions.enablePrinter(21);
            if (this.config.getAliasConfig().showUuid() || this.config.isJSONEnabled()) {
                pcOptions.enablePrinter(14);
                pcOptions.enablePrinter(26);
            }
            if (this.config.isJSONEnabled()) {
                pcOptions.enablePrinter(22);
                pcOptions.enablePrinter(19);
            }
        }
        if (includeBaselines) {
            pcOptions.enablePrinter(43);
        }
        String workspaceId = null;
        String workspaceType = null;
        if (ws != null) {
            workspaceId = ws.workspaceItemId;
            workspaceType = "workspace";
        }
        ChangeSetStateFactory stateFactory = ChangeSetStateFactory.createChangeSetstateFactory((IFilesystemRestClient)client, (ITeamRepository)repo, (String)workspaceId, (String)wsCompInfo.getComponentId());
        PendingChangesUtil.printChangeSets2((ITeamRepository)repo, (String)workspaceId, (String)workspaceType, changeSetIds, (ChangeSetStateFactory)stateFactory, (PendingChangesUtil.PendingChangesOptions)pcOptions, (IndentingPrintStream)out, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, deliveryInfoMap, baselineDeliveryInfoMap);
        if (hasMore && !this.config.isJSONEnabled()) {
            this.config.getWrappedOutputStream().println((CharSequence)Messages.HistoryCmd_10);
        }
    }

    private Map<String, PendingChangesUtil.DeliveryInfo> createChangesDeliveryInfoMap(List<ScmHistoryEntry> entries, Map<String, String> contributorNames) {
        HashMap<String, PendingChangesUtil.DeliveryInfo> deliveryInfoMap = new HashMap<String, PendingChangesUtil.DeliveryInfo>();
        for (ScmHistoryEntry entry : entries) {
            PendingChangesUtil.DeliveryInfo deliveryInfo = new PendingChangesUtil.DeliveryInfo(entry.getChangeSetItemId(), entry.getAddedById(), this.formatDate(this.config, entry.getDateAdded().getTime()));
            deliveryInfo.setDeliveredBy(contributorNames.get(entry.getAddedById()));
            deliveryInfoMap.put(entry.getChangeSetItemId(), deliveryInfo);
        }
        return deliveryInfoMap;
    }

    private Map<String, List<PendingChangesUtil.BaselineDeliveryInfo>> createBaselineDeliveryInfoMap(ChangeHistoryWithBaselinesResult historiesForComponentResult, Map<String, String> contributorNames, Map<String, BaselineDTO> baselines) {
        HashMap<String, List<PendingChangesUtil.BaselineDeliveryInfo>> baselineDeliveryInfoMap = new HashMap<String, List<PendingChangesUtil.BaselineDeliveryInfo>>();
        for (Map.Entry<String, Collection<ScmBaselineHistoryEntry>> mapEntry : historiesForComponentResult.getChangeSetToBaselineMap().entrySet()) {
            ArrayList<PendingChangesUtil.BaselineDeliveryInfo> deliveryInfoList = new ArrayList<PendingChangesUtil.BaselineDeliveryInfo>();
            baselineDeliveryInfoMap.put(mapEntry.getKey(), deliveryInfoList);
            for (ScmBaselineHistoryEntry entry : mapEntry.getValue()) {
                BaselineDTO baseline = baselines.get(entry.getItemId());
                if (baseline == null) continue;
                PendingChangesUtil.BaselineDeliveryInfo deliveryInfo = new PendingChangesUtil.BaselineDeliveryInfo(entry.getItemId(), entry.getAddedById(), this.formatDate(this.config, entry.getDateAdded()));
                deliveryInfo.setDeliveredBy(contributorNames.get(entry.getAddedById()));
                deliveryInfo.setComment(baseline.getComment());
                deliveryInfo.setCreatedBy(baseline.getCreatorContributorName());
                deliveryInfo.setCreatedByItemId(baseline.getCreatorContributorItemId());
                deliveryInfo.setCreatedDate(this.formatDate(this.config, baseline.getCreationDate()));
                deliveryInfo.setId(baseline.getId());
                deliveryInfo.setName(baseline.getName());
                deliveryInfoList.add(deliveryInfo);
            }
        }
        return baselineDeliveryInfoMap;
    }

    private Map<String, BaselineDTO> fetchBaselines(Set<String> baselinesToFetchSet, ITeamRepository repo, IFilesystemRestClient client) throws FileSystemException {
        HashMap<String, BaselineDTO> result = new HashMap<String, BaselineDTO>();
        try {
            List<String> toFetch;
            Iterator<String> iterator;
            if (baselinesToFetchSet.size() < 512) {
                iterator = Collections.EMPTY_SET.iterator();
                toFetch = new ArrayList<String>(baselinesToFetchSet);
            } else {
                iterator = baselinesToFetchSet.iterator();
                toFetch = Arrays.asList(this.nextChunk(iterator, 512));
            }
            while (!toFetch.isEmpty()) {
                List fetchResult = RepoUtil.getBaselinesById(toFetch, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                for (BaselineDTO baseline : fetchResult) {
                    result.put(baseline.getItemId(), baseline);
                }
                toFetch = Arrays.asList(this.nextChunk(iterator, 512));
            }
        }
        catch (TeamRepositoryException e) {
            String message = NLS.bind((String)Messages.ErrorFetchingUser, (Object)e.getMessage());
            StatusHelper.logException((String)message, (Throwable)e);
        }
        return result;
    }

    private ChangeHistoryWithBaselinesResult getHistoryEntriesForComponent(IScmRichClientRestService scmRichService, ParmsWorkspace ws, String componentId, int maxResults, boolean includeBaselines, IScmClientConfiguration config) throws CLIFileSystemClientException, FileSystemException {
        IScmRichClientRestService.ParmsGetComponentHistory parms = new IScmRichClientRestService.ParmsGetComponentHistory();
        parms.contextItemType = IWorkspace.ITEM_TYPE.getName();
        parms.contextItemNamespace = IWorkspace.ITEM_TYPE.getNamespaceURI();
        parms.contextItemId = ws.workspaceItemId;
        parms.componentItemId = componentId;
        parms.includeBaselines = includeBaselines;
        int remainingToFetch = maxResults;
        ScmComponentHistory2 componentHistory = null;
        String nextPage = null;
        ArrayList<ScmHistoryEntry> historyEntries = new ArrayList<ScmHistoryEntry>();
        HashMap<String, Collection<ScmBaselineHistoryEntry>> changeSetToBaslinesMap = new HashMap<String, Collection<ScmBaselineHistoryEntry>>();
        try {
            do {
                parms.desiredPageSize = Math.min(remainingToFetch, 512);
                parms.pageToken = nextPage;
                componentHistory = scmRichService.postGetComponentHistory(parms);
                List entries = componentHistory.getHistoryEntries();
                historyEntries.addAll(entries);
                if (!includeBaselines) continue;
                changeSetToBaslinesMap.putAll(((ScmComponentHistory3)componentHistory).getChangeSetToBaselinesMap());
            } while ((nextPage = componentHistory.getNextPageToken()) != null && (remainingToFetch -= 512) > 0);
        }
        catch (TeamRepositoryException e) {
            String message = NLS.bind((String)Messages.OperationsCmd_OPERATION_FETCH_ERROR, (Object)e.getMessage());
            StatusHelper.logException((String)message, (Throwable)e);
        }
        return new ChangeHistoryWithBaselinesResult(historyEntries, changeSetToBaslinesMap, nextPage != null);
    }

    private String formatDate(IScmClientConfiguration config, long time) {
        SimpleDateFormat sdf = SubcommandUtil.getDateFormat((String)"dd-MMM-yyyy hh:mm a", (IScmClientConfiguration)config);
        return sdf.format(new Date(time));
    }

    private List<ScmHistoryEntry> getHistoryEntriesForVersionable(IScmRichClientRestService scmService, ParmsWorkspace ws, String componentId, String versionableId, String versionableType, String versionableNameSpace, int maxResults, IScmClientConfiguration config) throws CLIFileSystemClientException, FileSystemException {
        IScmRichClientRestService.ParmsGetItemHistory parms = new IScmRichClientRestService.ParmsGetItemHistory();
        parms.componentItemId = componentId;
        parms.desiredPageSize = maxResults;
        parms.versionableItemId = versionableId;
        parms.versionableItemNamespace = versionableNameSpace;
        parms.versionableItemType = versionableType;
        parms.contextItemType = IWorkspace.ITEM_TYPE.getName();
        parms.contextItemId = ws.workspaceItemId;
        parms.contextItemNamespace = IWorkspace.ITEM_TYPE.getNamespaceURI();
        parms.requireMergeGraph = !parms.versionableItemType.equals(IFolder.ITEM_TYPE.getName());
        int entriesToFetch = maxResults;
        ScmItemHistory2 versionableHistory2 = null;
        String nextPage = null;
        ArrayList<ScmHistoryEntry> historyEntries = new ArrayList<ScmHistoryEntry>();
        try {
            do {
                parms.desiredPageSize = Math.min(entriesToFetch, 512);
                parms.pageToken = nextPage;
                versionableHistory2 = parms.versionableItemType.equals(IFolder.ITEM_TYPE.getName()) ? scmService.postGetFolderHistory(parms) : scmService.postGetItemHistory(parms);
                historyEntries.addAll(versionableHistory2.getHistoryEntries());
            } while ((nextPage = versionableHistory2.getNextPageToken()) != null && (entriesToFetch -= 512) > 0);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.HistoryCmd_25, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        return historyEntries;
    }

    String[] nextChunk(Iterator<String> iterator, int chunkSize) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext() && i < chunkSize) {
            result.add(iterator.next());
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    Map<String, String> fetchContributorNames(IScmRichClientRestService scmService, Set<String> itemIds) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String[] toFetch;
            Iterator<String> iterator;
            if (itemIds.size() < 512) {
                iterator = Collections.EMPTY_SET.iterator();
                toFetch = itemIds.toArray(new String[itemIds.size()]);
            } else {
                iterator = itemIds.iterator();
                toFetch = this.nextChunk(iterator, 512);
            }
            while (toFetch.length > 0) {
                IScmRichClientRestService.ParmsGetContributors cParms = new IScmRichClientRestService.ParmsGetContributors();
                cParms.contributorItemIds = toFetch;
                ScmContributorList contributors = scmService.postGetContributors(cParms);
                List all = contributors.getContributors();
                for (ScmContributor contributor : all) {
                    result.put(contributor.getItemId(), contributor.getName());
                }
                toFetch = this.nextChunk(iterator, 512);
            }
        }
        catch (TeamRepositoryException e) {
            String message = NLS.bind((String)Messages.ErrorFetchingUser, (Object)e.getMessage());
            StatusHelper.logException((String)message, (Throwable)e);
        }
        return result;
    }

    private WsCompInfo getComponent(ParmsWorkspace ws, String compSelector, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        ArrayList<WsCompInfo> wsCompList = new ArrayList<WsCompInfo>();
        IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector);
        if (ws == null) {
            List shareList = RepoUtil.getSharesInSandbox(null, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            ArrayList<String> compsFound = new ArrayList<String>();
            for (ShareDTO share : shareList) {
                if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(share.getComponentItemId())) && !compSelector.equals(share.getComponentName()) || compsFound.contains(share.getComponentItemId())) continue;
                wsCompList.add(new WsCompInfo(new ParmsWorkspace(RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ShareDTO)share), share.getContextItemId()), share.getContextName(), share.getComponentItemId(), share.getRootVersionableItemId(), share.getComponentName(), RepoUtil.ItemType.WORKSPACE));
                compsFound.add(share.getComponentItemId());
            }
        } else {
            WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
            for (WorkspaceComponentDTO wsComp : wsDetails.getComponents()) {
                if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(wsComp.getItemId())) && !compSelector.equals(wsComp.getName())) continue;
                wsCompList.add(new WsCompInfo(new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId()), wsDetails.getName(), wsComp.getItemId(), wsComp.getRootFolder(), wsComp.getName(), wsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE));
            }
        }
        if (wsCompList.size() == 0) {
            String message = NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector);
            if (ws == null) {
                message = NLS.bind((String)Messages.Common_LOADED_COMP_NOT_FOUND, (Object)compSelector);
            }
            throw StatusHelper.itemNotFound((String)message);
        }
        if (wsCompList.size() > 1) {
            out.println((CharSequence)Messages.HistroyCmd_COMPONENT_MATCHED_MULTI_WORKSPACE);
            for (WsCompInfo wsComp : wsCompList) {
                out.indent().println((CharSequence)AliasUtil.selector((String)wsComp.getWorkspaceName(), (UUID)UUID.valueOf((String)wsComp.getWorkspaceId()), (String)wsComp.getRepositoryUrl(), (RepoUtil.ItemType)wsComp.getWsType()));
            }
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.Common_AMBIGUOUS_COMPONENT, (Object)compSelector));
        }
        return (WsCompInfo)wsCompList.get(0);
    }

    private class ChangeHistoryWithBaselinesResult {
        private List<ScmHistoryEntry> changeSets;
        private Map<String, Collection<ScmBaselineHistoryEntry>> changeSetToBaslinesMap;
        private boolean hasMore;

        ChangeHistoryWithBaselinesResult(List<ScmHistoryEntry> changeSets, Map<String, Collection<ScmBaselineHistoryEntry>> changeSetToBaslinesMap, boolean hasMore) {
            this.changeSets = changeSets;
            this.changeSetToBaslinesMap = changeSetToBaslinesMap;
            this.hasMore = hasMore;
        }

        public List<ScmHistoryEntry> getChangeSets() {
            return this.changeSets;
        }

        public Map<String, Collection<ScmBaselineHistoryEntry>> getChangeSetToBaselineMap() {
            return this.changeSetToBaslinesMap;
        }

        public boolean hasMore() {
            return this.hasMore;
        }
    }

    class WsCompInfo {
        ParmsWorkspace workspace;
        String workspaceName;
        String componentId;
        String componentRootFolderId;
        String componentName;
        RepoUtil.ItemType wsType;

        public WsCompInfo(ParmsWorkspace ws, String wsName, String compId, String compRootFolderId, String compName, RepoUtil.ItemType type) {
            this.workspace = ws;
            this.workspaceName = wsName;
            this.componentId = compId;
            this.componentRootFolderId = compRootFolderId;
            this.componentName = compName;
            this.wsType = type;
        }

        public ParmsWorkspace getWorkspace() {
            return this.workspace;
        }

        public String getWorkspaceId() {
            return this.workspace.workspaceItemId;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public String getRepositoryUrl() {
            return this.workspace.repositoryUrl;
        }

        public String getComponentId() {
            return this.componentId;
        }

        public String getComponentRootFolderId() {
            return this.componentRootFolderId;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public RepoUtil.ItemType getWsType() {
            return this.wsType;
        }
    }
}

