/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspaceDetails;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.GetWorkspaceDetailsErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.GetWorkspaceDetailsResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.List;

public class FlowWorkspaceTargetUnsetCmd
extends AbstractSubcommand {
    protected List<ParmsWorkspace> init(IScmClientConfiguration config, IFilesystemRestClient client, ParmsWorkspace pw1) throws FileSystemException {
        ParmsGetWorkspace parm = new ParmsGetWorkspace();
        parm.workspace = pw1;
        parm.includeFlowTargets = true;
        ParmsGetWorkspaceDetails parms = new ParmsGetWorkspaceDetails();
        parms.workspaces = new ParmsGetWorkspace[]{parm};
        GetWorkspaceDetailsResultDTO result = null;
        try {
            result = client.postGetWorkspaceDetails(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowTargetUnsetCmd_WORKSPACE_DETAILS_NOT_FOUND, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)pw1.repositoryUrl);
        }
        if (result.getErrors().size() > 0) {
            GetWorkspaceDetailsErrorDTO error = (GetWorkspaceDetailsErrorDTO)result.getErrors().get(0);
            throw StatusHelper.failure((String)error.getMessage(), null);
        }
        if (result.getWorkspaceDetails().size() != 1) {
            throw StatusHelper.failure((String)Messages.FlowTargetUnsetCmd_WORKSPACE_NOT_FOUND, null);
        }
        WorkspaceDetailsDTO workspace = (WorkspaceDetailsDTO)result.getWorkspaceDetails().get(0);
        if (workspace.getFlowEntries().size() == 0) {
            throw StatusHelper.failure((String)Messages.FlowTargetUnsetCmd_NOTHING_TO_UNSET, null);
        }
        ArrayList<ParmsWorkspace> list = new ArrayList<ParmsWorkspace>();
        for (WorkspaceFlowEntryDTO flowEntry : workspace.getFlowEntries()) {
            if (!flowEntry.isCurrentIncomingFlow() && !flowEntry.isCurrentOutgoingFlow()) continue;
            ParmsWorkspace targetWS = new ParmsWorkspace();
            targetWS.repositoryUrl = flowEntry.getRepositoryURL();
            targetWS.workspaceItemId = flowEntry.getWorkspaceItemId();
            list.add(targetWS);
        }
        if (list.size() == 0) {
            throw StatusHelper.failure((String)Messages.FlowTargetUnsetCmd_NOTHING_TO_UNSET, null);
        }
        return list;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace src = new ParmsWorkspace();
        src.repositoryUrl = repo.getRepositoryURI();
        src.workspaceItemId = ws.getItemId().getUuidValue();
        List<ParmsWorkspace> flowTargets = this.init(this.config, client, src);
        if (this.config.isDryRun()) {
            return;
        }
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = src;
        parms.flowTargetsToRemove = new ParmsWorkspace[flowTargets.size()];
        flowTargets.toArray(parms.flowTargetsToRemove);
        try {
            client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowTargetUnsetCmd_UNSET_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)src.repositoryUrl);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.FlowTargetUnsetCmd_TARGET_SUCCESSFULLY_UNSET);
    }
}

