/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowWorkspaceTargetCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;

public class FlowWorkspaceTargetCmd
extends AbstractSubcommand {
    ParmsWorkspace ws;
    ParmsWorkspace targetWs;

    protected void init(IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ScmCommandLineArgument srcSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)srcSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)srcSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)srcSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        this.ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        ScmCommandLineArgument targetCmdArg = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)FlowWorkspaceTargetCmdOptions.OPT_TARGET), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)targetCmdArg, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)targetCmdArg);
        wsFound = RepoUtil.getWorkspace((String)targetCmdArg.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        this.targetWs = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
    }

    public void run() throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        this.init(this.config, client);
        FlowWorkspaceTargetCmd.setWorkspaceFlowTarget(this.ws, this.targetWs, client, this.config);
    }

    public static void setWorkspaceFlowTarget(ParmsWorkspace ws, ParmsWorkspace targetWs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        if (config.isDryRun()) {
            return;
        }
        ParmsWorkspaceTarget parms = new ParmsWorkspaceTarget();
        parms.activeWorkspace = ws;
        parms.targetWorkspace = targetWs;
        try {
            client.postSetWorkspaceTarget(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowTargetCmd_CHANGE_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.targetWorkspace.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.FlowTargetCmd_TARGET_SUCCESFULLY_CHANGED);
    }
}

