/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowComponentTargetCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.FlowWorkspaceTargetCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentTarget;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.Collections;
import java.util.List;

public class FlowComponentTargetCmd
extends FlowWorkspaceTargetCmd {
    @Override
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        this.init(this.config, client);
        ScmCommandLineArgument targetSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)FlowComponentTargetCmdOptions.OPT_COMPONENT), (IScmClientConfiguration)this.config);
        FlowComponentTargetCmd.setComponentFlowTarget(this.ws, this.targetWs, (IScmCommandLineArgument)targetSelector, client, this.config);
    }

    public static void setComponentFlowTarget(ParmsWorkspace ws, ParmsWorkspace targetWs, IScmCommandLineArgument targetSelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        SubcommandUtil.validateArgument((IScmCommandLineArgument)targetSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        ITeamRepository repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, Collections.singletonList(targetSelector), (ITeamRepository)repo, (IScmClientConfiguration)config);
        WorkspaceComponentDTO compDTO = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)targetSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        if (config.isDryRun()) {
            return;
        }
        if (!FlowComponentTargetCmd.canSetComponentFlowTarget(wsDetails, compDTO.getItemId())) {
            throw StatusHelper.disallowed((String)Messages.FlowComponentTargetCmd_CANNOT_SET_FLOWTARGET);
        }
        ParmsComponentTarget parms = new ParmsComponentTarget();
        parms.activeWorkspace = ws;
        parms.targetWorkspace = targetWs;
        parms.activeComponentItemIds = new String[]{compDTO.getItemId()};
        try {
            client.postSetComponentTarget(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.FlowTargetCmd_CHANGE_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.targetWorkspace.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.FlowTargetCmd_TARGET_SUCCESFULLY_CHANGED);
    }

    private static boolean canSetComponentFlowTarget(WorkspaceDetailsDTO wsDetails, String componentId) {
        List incomingComponentScopes = null;
        List outgoingComponentScopes = null;
        List wsFlowList = wsDetails.getFlowEntries();
        for (WorkspaceFlowEntryDTO flowEntryDTO : wsFlowList) {
            if (flowEntryDTO.isCurrentIncomingFlow()) {
                incomingComponentScopes = flowEntryDTO.getScopedComponentItemIds();
            }
            if (!flowEntryDTO.isCurrentOutgoingFlow()) continue;
            outgoingComponentScopes = flowEntryDTO.getScopedComponentItemIds();
        }
        return FlowComponentTargetCmd.isComponentScoped(incomingComponentScopes, componentId) && FlowComponentTargetCmd.isComponentScoped(outgoingComponentScopes, componentId);
    }

    private static boolean isComponentScoped(List<String> componentScopes, String componentId) {
        if (componentScopes == null || componentScopes.size() == 0) {
            return true;
        }
        for (String compId : componentScopes) {
            if (!compId.equals(componentId)) continue;
            return true;
        }
        return false;
    }
}

