/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetExtractCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ExtractFileCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;
import com.ibm.team.scm.common.internal.dto2.VersionableIdentifier;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.util.VersionableIdentifierUtil;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ExtractFileCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
        UUID itemUuid = null;
        UUID itemState = null;
        if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_WORKSPACE) || cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_SNAPSHOT) || cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_BASELINE)) {
            if (!cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_COMPONENT)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_MissingOption, (Object)ExtractFileCmdOptions.OPT_COMPONENT.getShortOpt()));
            }
            if (!cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_FILEPATH)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_MissingOption, (Object)ExtractFileCmdOptions.OPT_FILEPATH.getShortOpt()));
            }
            ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ExtractFileCmdOptions.OPT_VER_ITEM.getId()), (IScmClientConfiguration)this.config);
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
            ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ExtractFileCmdOptions.OPT_COMPONENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, Collections.singletonList(compSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            IComponent comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            String filePath = cli.getOptionValue((IOptionKey)ExtractFileCmdOptions.OPT_FILEPATH).getValue();
            String[] path = StringUtil.splitEscapedPath((String)filePath);
            filePath = path.length == 0 ? Character.toString('/') : this.toPath(path, false);
            ParmsWorkspace ws = null;
            String itemId = null;
            IItemType itemType = null;
            boolean foundCompInContext = false;
            if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_WORKSPACE)) {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
                IWorkspace wsFound = RepoUtil.getWorkspace((String)selector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
                itemId = ws.workspaceItemId;
                itemType = IWorkspace.ITEM_TYPE;
                WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
                for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
                    if (!comp.getItemId().getUuidValue().equals(compDTO.getItemId())) continue;
                    foundCompInContext = true;
                    break;
                }
            } else if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_SNAPSHOT)) {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
                IBaselineSet snapshot = RepoUtil.getSnapshot(null, (String)selector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                itemId = snapshot.getItemId().getUuidValue();
                itemType = IBaselineSet.ITEM_TYPE;
                List blHandles = snapshot.getBaselines();
                ArrayList<String> blIds = new ArrayList<String>();
                for (IBaselineHandle blHandle : blHandles) {
                    blIds.add(blHandle.getItemId().getUuidValue());
                }
                List baselineDTOList = RepoUtil.getBaselinesById(blIds, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                for (BaselineDTO blDTO : baselineDTOList) {
                    if (!blDTO.getComponentItemId().equals(comp.getItemId().getUuidValue())) continue;
                    foundCompInContext = true;
                    break;
                }
            } else if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_BASELINE)) {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
                IBaseline bl = RepoUtil.getBaseline((String)selector.getItemSelector(), (String)comp.getItemId().getUuidValue(), (String)comp.getName(), (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                itemId = bl.getItemId().getUuidValue();
                itemType = IBaseline.ITEM_TYPE;
                foundCompInContext = true;
            }
            if (!foundCompInContext) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
            }
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            ScmVersionablePath scmPath = RepoUtil.getVersionable2((IScmRichClientRestService)scmService, (String)itemId, (IItemType)itemType, (String)comp.getItemId().getUuidValue(), (String)filePath, (IScmClientConfiguration)this.config);
            if (scmPath == null || scmPath.getVersionable() == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ExtractFileCmd_PATH_NOT_FOUND, (Object)filePath));
            }
            IVersionableHandle vh = scmPath.getVersionable();
            itemUuid = vh.getItemId();
            itemState = vh.getStateId();
        } else {
            if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_COMPONENT)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_MissingOption2, (Object[])new Object[]{ExtractFileCmdOptions.OPT_COMPONENT.getShortOpt(), ExtractFileCmdOptions.OPT_BASELINE.getShortOpt(), ExtractFileCmdOptions.OPT_WORKSPACE.getShortOpt(), ExtractFileCmdOptions.OPT_SNAPSHOT.getShortOpt()}));
            }
            if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_FILEPATH)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_MissingOption2, (Object[])new Object[]{ExtractFileCmdOptions.OPT_FILEPATH.getShortOpt(), ExtractFileCmdOptions.OPT_BASELINE.getShortOpt(), ExtractFileCmdOptions.OPT_WORKSPACE.getShortOpt(), ExtractFileCmdOptions.OPT_SNAPSHOT.getShortOpt()}));
            }
            ScmCommandLineArgument itemSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ExtractFileCmdOptions.OPT_VER_ITEM.getId()), (IScmClientConfiguration)this.config);
            try {
                itemUuid = UUID.valueOf((String)itemSelector.getItemSelector());
            }
            catch (IllegalArgumentException e) {
                throw StatusHelper.argSyntax((String)e.getMessage());
            }
        }
        ScmCommandLineArgument stateSelector = null;
        String diskPathStr = null;
        String stateStr = null;
        if (cli.hasOption(ExtractFileCmdOptions.OPT_VER_STATE.getId())) {
            stateStr = cli.getOption(ExtractFileCmdOptions.OPT_VER_STATE.getId());
        }
        if (cli.hasOption(ExtractFileCmdOptions.OPT_DISKPATH.getId())) {
            diskPathStr = cli.getOption(ExtractFileCmdOptions.OPT_DISKPATH.getId());
        }
        if (stateStr == null && diskPathStr == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_0, (Object)ExtractFileCmdOptions.OPT_VER_STATE.toString(), (Object)ExtractFileCmdOptions.OPT_DISKPATH.toString()));
        }
        if (stateStr != null && diskPathStr == null) {
            diskPathStr = stateStr;
            stateStr = null;
        } else {
            stateSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ExtractFileCmdOptions.OPT_VER_STATE.getId()), (IScmClientConfiguration)this.config);
        }
        UUID requestedState = null;
        if (stateSelector != null) {
            block32: {
                String stateArg = stateSelector.getItemSelector();
                try {
                    requestedState = UUID.valueOf((String)stateArg);
                }
                catch (IllegalArgumentException iae) {
                    VersionableIdentifier version;
                    try {
                        version = VersionableIdentifierUtil.toVersionIdentifier((String)stateArg);
                    }
                    catch (IllegalArgumentException e) {
                        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_1, (Object)stateArg));
                    }
                    IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
                    UUID repositoryId = VersionableIdentifierUtil.getRepositoryId((IVersionableIdentifier)version);
                    String repoIdStr = repositoryId == null ? null : repositoryId.getUuidValue();
                    UUID result = RepoUtil.getStateId((IScmRichClientRestService)scmService, (UUID)itemUuid, (String)version.getShortVersionId(), (String)repoIdStr, (IScmClientConfiguration)this.config);
                    UUID uUID = requestedState = result == null ? null : result;
                    if (requestedState != null) break block32;
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ExtractFileCmd_VERSION_NUMBER_NOT_FOUND, (Object)stateArg));
                }
            }
            if (itemState == null) {
                itemState = requestedState;
            }
            if (requestedState != null) {
                itemState = requestedState;
            }
        }
        ILocation diskPath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)diskPathStr);
        this.validateDiskPath(diskPath, client, this.config);
        if (itemState == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExtractFileCmd_3, (Object[])new Object[]{ExtractFileCmdOptions.OPT_WORKSPACE.toString(), ExtractFileCmdOptions.OPT_BASELINE.toString(), ExtractFileCmdOptions.OPT_SNAPSHOT.toString()}));
        }
        this.extractContent(diskPath, itemUuid.getUuidValue(), itemState.getUuidValue(), repo, this.config);
        this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetExtractCmd_SUCCESS, (Object)diskPath.toOSString()));
    }

    private void validateDiskPath(ILocation diskPath, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        if (RepoUtil.isSandboxPath((String)diskPath.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config)) {
            throw StatusHelper.failure((String)Messages.ExtractFileCmd_PATH_SANDBOX_DESCENDANT, null);
        }
        ILocation parentPath = diskPath.getParent();
        if (!parentPath.isEmpty() && !SubcommandUtil.exists((ILocation)parentPath, null)) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangesetExtractCmd_ITEM_DOES_NOT_EXIST, (Object)parentPath.toOSString()));
        }
        this.checkForOverwrite(diskPath, config);
    }

    private void checkForOverwrite(ILocation path, IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_OVERWRITE)) {
            ResourceType resType = SubcommandUtil.getResourceType((ILocation)path, null);
            if (resType != null && resType == ResourceType.FOLDER) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ChangesetExtractCmd_COMPLAIN_NOT_A_FILE, (Object)path.toOSString()), null);
            }
        } else if (SubcommandUtil.exists((ILocation)path, null)) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.ChangesetExtractCmd_COMPLAIN_OVERWRITE, (Object)path.toOSString(), (Object)cli.getDefinition().getOption((IOptionKey)ExtractFileCmdOptions.OPT_OVERWRITE).getName()), null);
        }
    }

    private void extractContent(ILocation diskPath, String itemId, String stateId, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IVersionable versionable = RepoUtil.getVersionable3((String)itemId, (String)stateId, (String)"file", (ITeamRepository)repo, (IScmClientConfiguration)config, (boolean)false);
        ICommandLine cli = config.getSubcommandCommandLine();
        ChangesetExtractCmd.extractContent(diskPath, null, null, versionable, repo, config, cli.hasOption((IOptionKey)ExtractFileCmdOptions.OPT_OVERWRITE));
    }

    private String toPath(String[] path, boolean isFolder) {
        return String.valueOf(StringUtil.createPathString((String[])path)) + (isFolder ? Character.valueOf('/') : "");
    }
}

