/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ExternalToolUtils;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListChangesCmd;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListChangesetsCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.DiffCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.BatchingPrinter;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.ClientConfigurationChangeFactory;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.patches.CreatePatchDilemmaHandler;
import com.ibm.team.filesystem.client.internal.patches.CreatePatchUtil;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContext;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.changemodel.ChangeDescription;
import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.ResolvedConfigurationChangePaths;
import com.ibm.team.filesystem.common.internal.patch.CreateDiffUtil;
import com.ibm.team.filesystem.common.internal.patch.DiffParticipant;
import com.ibm.team.filesystem.common.internal.patch.HunkRange;
import com.ibm.team.filesystem.common.internal.patch.StringDiffParticipant;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.impl.ChangeFolderSyncDTOImpl;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ConfigurationChangeFactory;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.FallbackPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.RemotePathResolver;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.SnapshotPathResolver;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.patches.FileStateFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IHistoricBaselineIterator;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeHistoryEntryChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class DiffCmd
extends AbstractSubcommand {
    IFilesystemRestClient client;
    boolean hasContentDiff;
    boolean displayContentDiff;
    boolean displayPropertyDiff;
    String componentItemSelector;
    int maxValue;
    IComponent component;
    Map<String, IBaseline> baselineMap = new HashMap<String, IBaseline>();
    String compBaselineSelector = null;
    boolean hasMoreItems = false;
    private static final String CHARACTER_ENCODING = "character-encoding";
    private final Log logger = LogFactory.getLog((String)DiffCmd.class.getName());

    public void run() throws FileSystemException {
        ResourcesPlugin.getWorkspace();
        StateSelector before = null;
        StateSelector after = null;
        List changeSelectors = null;
        boolean fullPatch = false;
        ScmCommandLineArgument wsSelector = null;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (!cli.hasOption((IOptionKey)DiffCmdOpts.OPT_AFTER_TYPE) || !cli.hasOption((IOptionKey)DiffCmdOpts.OPT_AFTER_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.DiffCmd_1);
        }
        after = new StateSelector(cli.getOption((IOptionKey)DiffCmdOpts.OPT_AFTER_TYPE), (IScmCommandLineArgument)ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)DiffCmdOpts.OPT_AFTER_SELECTOR), (IScmClientConfiguration)this.config));
        SubcommandUtil.validateArgument((IScmCommandLineArgument)after.getSelector(), (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.VERSIONABLE, RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM, RepoUtil.ItemType.BASELINE, RepoUtil.ItemType.CHANGESET, RepoUtil.ItemType.SNAPSHOT});
        if (cli.hasOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_TYPE)) {
            if (!cli.hasOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_SELECTOR)) {
                throw StatusHelper.argSyntax((String)Messages.DiffCmd_0);
            }
            before = new StateSelector(cli.getOption((IOptionKey)DiffCmdOpts.OPT_BEFORE_TYPE), (IScmCommandLineArgument)ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)DiffCmdOpts.OPT_BEFORE_SELECTOR), (IScmClientConfiguration)this.config));
            SubcommandUtil.validateArgument((IScmCommandLineArgument)before.getSelector(), (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM, RepoUtil.ItemType.BASELINE, RepoUtil.ItemType.CHANGESET, RepoUtil.ItemType.SNAPSHOT});
        }
        if ((fullPatch = cli.hasOption((IOptionKey)DiffCmdOpts.OPT_FULL_PATCH)) && (cli.hasOption((IOptionKey)DiffCmdOpts.OPT_DISPLAY) || cli.hasOption((IOptionKey)DiffCmdOpts.OPT_EXTERNAL_COMPARE))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_FULLPATCH_MUTUALLYEXCLUSIVE, (Object[])new String[]{DiffCmdOpts.OPT_DISPLAY.getName(), DiffCmdOpts.OPT_EXTERNAL_COMPARE.getName(), DiffCmdOpts.OPT_FULL_PATCH.getName()}));
        }
        if (cli.hasOption((IOptionKey)DiffCmdOpts.OPT_WORKSPACE)) {
            wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)DiffCmdOpts.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        }
        String display = cli.getOption((IOptionKey)DiffCmdOpts.OPT_DISPLAY, "c");
        this.displayContentDiff = display.contains("c");
        this.displayPropertyDiff = display.contains("p");
        this.maxValue = RepoUtil.getMaxResultsOption((ICommandLine)cli, (NamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, (String)Messages.DiffCmd_MaxResultNumberFormatException, (int)512);
        if (display.length() > 2 || display.length() == 2 && (!this.displayContentDiff || !this.displayPropertyDiff) || !this.displayContentDiff && !this.displayPropertyDiff) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_INVALID_OPTION_VALUE, (Object)display, (Object)DiffCmdOpts.OPT_DISPLAY.toString()));
        }
        if (this.displayPropertyDiff && cli.hasOption((IOptionKey)DiffCmdOpts.OPT_EXTERNAL_COMPARE)) {
            throw StatusHelper.argSyntax((String)Messages.DiffCmd_CANNOT_COMPARE_EXTERNAL_PROPERTY_DIFF);
        }
        if (cli.getOption((IOptionKey)DiffCmdOpts.OPT_COMPONENT, null) != null && (after.getType().equalsIgnoreCase("file") || after.getType().equalsIgnoreCase("changeset"))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_CANNOT_SPECIFY_COMPONENT, (Object)DiffCmdOpts.OPT_COMPONENT.toString()));
        }
        if (cli.hasOption((IOptionKey)DiffCmdOpts.OPT_DIFF_FILE_SELECTOR)) {
            changeSelectors = cli.getOptions((IOptionKey)DiffCmdOpts.OPT_DIFF_FILE_SELECTOR);
            if (cli.hasOption((IOptionKey)DiffCmdOpts.OPT_EXTERNAL_COMPARE) && changeSelectors.size() > 1) {
                throw StatusHelper.inappropriateArgument((String)Messages.DiffCmd_EXTERNAL_ONE_FILE);
            }
            if (after != null && after.getType().equalsIgnoreCase("file")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_FILE_MUTUALLYEXCLUSIVE, (Object)DiffCmdOpts.OPT_DIFF_FILE_SELECTOR.getLongOpt(), (Object)"file"));
            }
        } else if (!after.getType().equalsIgnoreCase("file") && cli.hasOption((IOptionKey)DiffCmdOpts.OPT_EXTERNAL_COMPARE)) {
            throw StatusHelper.inappropriateArgument((String)Messages.DiffCmd_EXTERNAL_ONLY_FILE);
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        try {
            if (after.getType().equalsIgnoreCase("file")) {
                this.singleFileDiff(this.config, after, before, fullPatch, cli.hasOption((IOptionKey)DiffCmdOpts.OPT_EXTERNAL_COMPARE));
                return;
            }
            if (after.getType().equalsIgnoreCase("workspace") || after.getType().equalsIgnoreCase("stream") || after.getType().equalsIgnoreCase("snapshot") || after.getType().equalsIgnoreCase("baseline")) {
                this.contextDiff(this.config, after, before, changeSelectors, fullPatch);
                return;
            }
            if (after.getType().equalsIgnoreCase("changeset")) {
                this.changesetDiff(this.config, after, before, fullPatch, wsSelector != null ? wsSelector.getItemSelector() : null, changeSelectors);
                return;
            }
        }
        finally {
            if (this.hasMoreItems && !this.config.isJSONEnabled()) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.DiffCmd_SpeficyMaxResultOrAHigherValue, (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_MAXRESULTS).getName()));
            }
        }
        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_87, (Object)after.getType()));
    }

    private Set<String> getMisMatchedChangeSelectors(List<String> changeSelectors, Map<String, String> pathTochangeItemId, List<String> changeItemIds) throws FileSystemException {
        HashSet<String> misMatchedChangeItemIds = null;
        String itemUUID = null;
        IUuidAliasRegistry.IUuidAlias alias = null;
        if (changeSelectors != null) {
            misMatchedChangeItemIds = new HashSet<String>();
            for (String change : changeSelectors) {
                alias = RepoUtil.lookupUuidAndAlias((String)change);
                if (alias != null) {
                    itemUUID = alias.getUuid().getUuidValue();
                    if (pathTochangeItemId.containsValue(itemUUID)) {
                        changeItemIds.add(itemUUID);
                        continue;
                    }
                    misMatchedChangeItemIds.add(change);
                    continue;
                }
                ILocation changePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)change);
                if (pathTochangeItemId.get(changePath.toOSString()) != null) {
                    changeItemIds.add(pathTochangeItemId.get(changePath.toOSString()));
                    continue;
                }
                misMatchedChangeItemIds.add(change);
            }
        }
        return misMatchedChangeItemIds;
    }

    private void updatePathToChangeItemIdMap(Map<String, String> pathTochangeItemIdMap, ChangeSetSyncDTO csDTO) throws FileSystemException {
        String pathHint = null;
        if (pathTochangeItemIdMap != null) {
            List nextChanges = csDTO.getChanges();
            for (ChangeFolderSyncDTOImpl next : nextChanges) {
                for (ChangeSyncDTO changeSyncDTO : next.getChanges()) {
                    pathHint = changeSyncDTO.getPathHint();
                    if (pathHint == null) continue;
                    if (pathHint.contains("<unresolved>")) {
                        pathHint = pathHint.replace("<unresolved>", "");
                    }
                    ILocation changePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)pathHint);
                    pathTochangeItemIdMap.put(changePath.toOSString(), changeSyncDTO.getVersionableItemId());
                }
            }
        }
    }

    private FileState getFileStateFromChangeHistory(ITeamRepository repo, IChangeHistory history, IVersionableHandle verHandle, IScmClientConfiguration config) throws FileSystemException {
        List changeHistories;
        try {
            changeHistories = history.getHistoryFor(verHandle, 1, true, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_31, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        if (changeHistories.isEmpty()) {
            return FileState.getDeletedState((IItemType)verHandle.getItemType(), null);
        }
        IChangeHistoryEntryChange changeHistory = (IChangeHistoryEntryChange)changeHistories.get(0);
        return this.getFileStateFromChangeSet(repo, changeHistory.changeSet(), verHandle, config);
    }

    private FileState getFileStateFromChangeSet(ITeamRepository repo, IChangeSetHandle csHandle, IVersionableHandle verHandle, IScmClientConfiguration config) throws FileSystemException {
        IVersionable afterState;
        IChangeSet cs;
        try {
            cs = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_32, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        IVersionableHandle stateHandle = null;
        for (IChange change : cs.changes()) {
            if (!change.item().getItemId().equals((Object)verHandle.getItemId())) continue;
            stateHandle = change.afterState();
            break;
        }
        if (stateHandle == null) {
            throw StatusHelper.itemNotFound((String)Messages.DiffCmd_ItemNotFound_Changeset);
        }
        try {
            afterState = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(stateHandle, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_33, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        return ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)stateHandle.getItemType(), (IVersionable)afterState);
    }

    private IBaselineHandle getBaseline(IBaselineSet snapshot, ITeamRepository repo, String componentId) throws FileSystemException {
        IBaseline blHandle = null;
        List baselines = RepoUtil.getExistingAccessibleItems((IItemType)IBaseline.ITEM_TYPE, (List)snapshot.getBaselines(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        for (IBaseline baseline : baselines) {
            if (!componentId.equals(baseline.getComponent().getItemId().getUuidValue())) continue;
            blHandle = baseline;
            break;
        }
        return blHandle;
    }

    private void singleFileDiff(IScmClientConfiguration config, StateSelector after, StateSelector before, boolean fullPatch, boolean externalCompare) throws FileSystemException {
        ITeamRepository beforeRepo;
        IVersionable versionable;
        IVersionableHandle stateHandle;
        LocalChangeSyncDTO localChangeSync;
        boolean isDefaultSelector = false;
        if (before != null) {
            if (!(before.getType().equalsIgnoreCase("baseline") || before.getType().equalsIgnoreCase("snapshot") || before.getType().equalsIgnoreCase("changeset") || before.getType().equalsIgnoreCase("workspace") || before.getType().equalsIgnoreCase("stream"))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_UNSUPPORTED_BEFORE_TYPE, (Object)before.getType(), (Object)after.getType()));
            }
        } else {
            isDefaultSelector = true;
        }
        ILocation absolutePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)after.getItemSelector());
        ResourcePropertiesDTO resourceProperties = RepoUtil.getResourceProperties((String)absolutePath.toOSString(), (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)config), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config, (boolean)false);
        RelativeLocation relativeLocation = new RelativeLocation(resourceProperties.getPath().getRelativePath().getSegments());
        ShareDTO share = resourceProperties.getShare();
        ITeamRepository repo = RepoUtil.getTeamRepository((UUID)UUID.valueOf((String)share.getRepositoryId()));
        ParmsWorkspace afterWs = new ParmsWorkspace(repo.getRepositoryURI(), share.getContextItemId());
        String versionableItemId = resourceProperties.getItemId();
        String versionableItemType = resourceProperties.getVersionableItemType();
        boolean afterStateDeleted = false;
        String defaultBeforeStateId = null;
        boolean defaultBeforeStateDeleted = false;
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(afterWs), (boolean)true, (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
        WorkspaceSyncDTO workspaceSync = SubcommandUtil.getWorkspaceSync((SyncViewDTO)syncView, (String)share.getContextItemId());
        if (workspaceSync == null) {
            throw StatusHelper.unexpectedFailure((String)NLS.bind((String)Messages.DiffCmd_UNABLE_TO_DETERMINE_WS, (Object)absolutePath.toOSString()));
        }
        ComponentSyncDTO componentSync = SubcommandUtil.getComponentSync((WorkspaceSyncDTO)workspaceSync, (String)share.getComponentItemId());
        if (componentSync == null) {
            throw StatusHelper.unexpectedFailure((String)NLS.bind((String)Messages.DiffCmd_UNABLE_TO_DETERMINE_COMP, (Object)absolutePath.toOSString()));
        }
        LocalChangeSyncDTO localChangeSyncDTO = localChangeSync = versionableItemId != null ? SubcommandUtil.getLocalChangeSync((ComponentSyncDTO)componentSync, (String)versionableItemId) : SubcommandUtil.getLocalChangeSync((ComponentSyncDTO)componentSync, (IRelativeLocation)relativeLocation);
        if (localChangeSync != null) {
            if (localChangeSync.isDeletionType()) {
                versionableItemId = localChangeSync.getTargetVersionableItemId();
                versionableItemType = localChangeSync.getVersionableItemType();
                afterStateDeleted = true;
            } else if (localChangeSync.isAdditionType()) {
                versionableItemId = localChangeSync.getTargetVersionableItemId() != null ? localChangeSync.getTargetVersionableItemId() : ItemId.getNullItemUUID().getUuidValue();
                defaultBeforeStateDeleted = true;
            }
            if (!defaultBeforeStateDeleted) {
                defaultBeforeStateId = localChangeSync.getTargetVersionableStateId();
            }
        } else {
            ChangeSyncDTO changeSync;
            ChangeSyncDTO changeSyncDTO = changeSync = versionableItemId != null ? SubcommandUtil.getChangeSync((ComponentSyncDTO)componentSync, (String)versionableItemId, (boolean)true) : SubcommandUtil.getChangeSync((ComponentSyncDTO)componentSync, (IRelativeLocation)relativeLocation, (boolean)true);
            if (changeSync != null) {
                if (changeSync.isDeleteType()) {
                    versionableItemId = changeSync.getVersionableItemId();
                    versionableItemType = changeSync.getVersionableItemType();
                    afterStateDeleted = true;
                } else if (changeSync.isAddType()) {
                    defaultBeforeStateDeleted = true;
                }
                if (!defaultBeforeStateDeleted) {
                    defaultBeforeStateId = changeSync.getBeforeStateId();
                }
            }
        }
        if (versionableItemId == null || versionableItemType == null) {
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)absolutePath.toOSString()));
        }
        if (externalCompare && !versionableItemType.equals("file")) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_MUST_BE_FILE, (Object)absolutePath.toOSString()));
        }
        IItemType itemType = SubcommandUtil.getVersionableItemType((String)versionableItemType);
        IVersionableHandle verHandle = (IVersionableHandle)itemType.createItemHandle(UUID.valueOf((String)versionableItemId), null);
        SiloedItemId siloedVer = SiloedItemId.create((IItemType)itemType, (UUID)UUID.valueOf((String)versionableItemId), (UUID)UUID.valueOf((String)share.getComponentItemId()));
        FileState afterState = null;
        FileState beforeState = null;
        IBaselineConnection beforeSelectorConn = null;
        if (afterStateDeleted) {
            afterState = FileState.getDeletedState((IItemType)itemType, null);
        } else if (localChangeSync != null) {
            IShareable shareable = SharingManager.getInstance().findShareable(absolutePath, ResourceType.FILE);
            afterState = FileStateFactory.create((IShareable)shareable, null);
        } else {
            stateHandle = RepoUtil.getVersionableHandle((ITeamRepository)repo, (String)versionableItemId, (String)resourceProperties.getStateId(), (String)versionableItemType, (IScmClientConfiguration)config);
            try {
                versionable = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(stateHandle, null);
                afterState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiffCmd_33, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
        }
        if (isDefaultSelector) {
            if (defaultBeforeStateDeleted) {
                beforeState = FileState.getDeletedState((IItemType)itemType, null);
            } else if (defaultBeforeStateId != null) {
                stateHandle = RepoUtil.getVersionableHandle((ITeamRepository)repo, (String)versionableItemId, (String)defaultBeforeStateId, (String)versionableItemType, (IScmClientConfiguration)config);
                try {
                    versionable = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(stateHandle, null);
                    beforeState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.DiffCmd_33, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
                }
            } else {
                beforeState = afterState;
            }
        } else if (before.getType().equalsIgnoreCase("baseline") || before.getType().equalsIgnoreCase("snapshot")) {
            beforeRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)before.selector);
            IBaseline blHandle = null;
            if (before.getType().equalsIgnoreCase("snapshot")) {
                IBaselineSet snapshot = RepoUtil.getSnapshot(null, (String)before.getItemSelector(), (ITeamRepository)beforeRepo, (IScmClientConfiguration)config);
                blHandle = this.getBaseline(snapshot, beforeRepo, share.getComponentItemId());
                if (blHandle == null) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.DiffCmd_COMPONENT_NOT_FOUND_IN_SNAPSHOT, (Object)share.getComponentName(), (Object)relativeLocation.toString()));
                }
            } else {
                blHandle = RepoUtil.getBaseline((String)before.getItemSelector(), (String)share.getComponentItemId(), (String)share.getComponentName(), (ITeamRepository)beforeRepo, (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
            }
            IBaselineConnection blConn = this.getBlConn(blHandle.getItemId().getUuidValue(), beforeRepo.getRepositoryURI(), config);
            beforeState = this.getFileStateFromChangeHistory(beforeRepo, blConn.changeHistory(), verHandle, config);
            beforeSelectorConn = blConn;
        } else if (before.getType().equalsIgnoreCase("changeset")) {
            beforeRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)before.selector);
            IChangeSet changeSet = RepoUtil.findChangeSet((String)before.getItemSelector(), (ITeamRepository)beforeRepo, (IScmClientConfiguration)config);
            beforeState = this.getFileStateFromChangeSet(beforeRepo, (IChangeSetHandle)changeSet, verHandle, config);
        } else {
            boolean isWorkspaceSelector;
            beforeRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)before.selector);
            String wsId = before.getItemSelector();
            IWorkspace wsHandle = RepoUtil.getWorkspace((String)wsId, (boolean)isWorkspaceSelector, (!(isWorkspaceSelector = before.getType().equalsIgnoreCase("workspace")) ? 1 : 0) != 0, (ITeamRepository)beforeRepo, (IScmClientConfiguration)config);
            ParmsWorkspace beforeWs = new ParmsWorkspace(beforeRepo.getRepositoryURI(), wsHandle.getItemId().getUuidValue());
            IComponent compHandle = RepoUtil.getComponent((String)share.getComponentItemId(), (ITeamRepository)beforeRepo, (IScmClientConfiguration)config);
            IWorkspaceConnection wsConn = this.getWsConn(beforeWs, config);
            try {
                beforeState = this.getFileStateFromChangeHistory(beforeRepo, wsConn.changeHistory((IComponentHandle)compHandle), verHandle, config);
            }
            catch (ItemNotFoundException e) {
                throw StatusHelper.itemNotFound((String)Messages.DiffCmd_28);
            }
            catch (ComponentNotInWorkspaceException e) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.DiffCmd_29, (Object)share.getComponentName(), (Object)relativeLocation.toString()));
            }
            beforeSelectorConn = wsConn;
        }
        if (externalCompare) {
            String externalCompareTool = ExternalToolUtils.getExternalCompareTool((ScmClientConfiguration)config, false);
            OpenFileItemInExternalCompareOperation externalCompareOperation = null;
            if (!afterStateDeleted) {
                IShareable shareable = SharingManager.getInstance().findShareable(absolutePath, ResourceType.FILE);
                externalCompareOperation = new OpenShareableInExternalCompareOperation(externalCompareTool, shareable, beforeState, null, true);
            } else {
                externalCompareOperation = new OpenFileItemInExternalCompareOperation(externalCompareTool, afterState, null, beforeState, null, null, true);
            }
            try {
                externalCompareOperation.setEnvironment(config.getContext().environment());
                externalCompareOperation.run(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.failure((String)Messages.DiffCmd_ERROR_EXTERNAL_COMPARE, (Throwable)e);
            }
            if (externalCompareOperation.returnValue() != 0) {
                throw StatusHelper.returnValue((int)externalCompareOperation.returnValue());
            }
            return;
        }
        FileChange fileChange = new FileChange(beforeState, afterState, siloedVer);
        ConfigurationChange confChange = new ConfigurationChange();
        confChange.addChange(fileChange);
        ChangeDescription changeDesc = new ChangeDescription("", (Collection)Collections.EMPTY_LIST, new ItemId(IComponent.ITEM_TYPE, UUID.valueOf((String)share.getComponentItemId())), (Collection)Collections.EMPTY_LIST, new Date());
        RemotePathResolver afterPathResolver = new RemotePathResolver((IConnection)this.getWsConn(afterWs, config));
        RemotePathResolver beforePathResolver = beforeSelectorConn != null ? new RemotePathResolver((IConnection)beforeSelectorConn) : null;
        this.doDiff((IPathResolver)afterPathResolver, (IPathResolver)beforePathResolver, confChange, changeDesc, fullPatch, config);
    }

    private IWorkspaceConnection getWsConn(ParmsWorkspace ws, IScmClientConfiguration config) throws FileSystemException {
        IWorkspaceConnection wsConn = null;
        if (ws != null) {
            try {
                wsConn = ws.getWorkspaceConnection(null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiffCmd_84, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
            }
        }
        return wsConn;
    }

    private IBaselineConnection getBlConn(String baselineItemId, String repoUri, IScmClientConfiguration config) throws FileSystemException {
        IBaselineConnection blConn = null;
        ParmsBaseline bl = new ParmsBaseline();
        bl.baselineItemId = baselineItemId;
        bl.repositoryUrl = repoUri;
        try {
            blConn = bl.getBaselineConnection(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_26, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)bl.repositoryUrl);
        }
        return blConn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBaseline getBaseline(String baselineSelector, ITeamRepository repo) throws FileSystemException {
        IBaseline baseline = this.baselineMap.get(baselineSelector);
        if (baseline != null) {
            return baseline;
        }
        if (this.componentItemSelector == null) {
            IUuidAliasRegistry.IUuidAlias blAlias = RepoUtil.lookupUuidAndAlias((String)baselineSelector, (String)repo.getRepositoryURI());
            if (blAlias == null) throw StatusHelper.argSyntax((String)Messages.CompareCmd_SPECIFY_COMPONENT);
            BaselineDTO blDTO = RepoUtil.getBaselineById((String)blAlias.getUuid().getUuidValue(), (String)repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            if (blDTO == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_BASELINE_OR_COMP_MISSING, (Object)baselineSelector, (Object)DiffCmdOpts.OPT_COMPONENT.getLongOpt()));
            }
            baseline = (IBaseline)RepoUtil.getItem((IItemType)IBaseline.ITEM_TYPE, (UUID)UUID.valueOf((String)blDTO.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            BaselineDTO blDTO;
            IUuidAliasRegistry.IUuidAlias blAlias = RepoUtil.lookupUuidAndAlias((String)baselineSelector, (String)repo.getRepositoryURI());
            if (blAlias != null && (blDTO = RepoUtil.getBaselineById((String)blAlias.getUuid().getUuidValue(), (String)repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config)) != null) {
                baseline = (IBaseline)RepoUtil.getItem((IItemType)IBaseline.ITEM_TYPE, (UUID)UUID.valueOf((String)blDTO.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            }
            if (baseline == null) {
                baseline = RepoUtil.getBaseline((String)baselineSelector, (String)this.component.getItemId().getUuidValue(), (String)this.component.getName(), (ITeamRepository)repo, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            }
        }
        this.baselineMap.put(baselineSelector, baseline);
        return baseline;
    }

    private ContextDiffInput getContextDiffInput(String itemSelector, String contextType, ITeamRepository repo, boolean resolveItem) throws FileSystemException {
        resolveItem = resolveItem || !RepoUtil.isUuid((String)itemSelector);
        boolean hasComponent = true;
        ContextDiffInput contextDiffInput = null;
        if ("snapshot".equalsIgnoreCase(contextType)) {
            IBaselineSet snapshot = null;
            if (resolveItem || this.component != null) {
                snapshot = RepoUtil.getSnapshot(null, (String)itemSelector, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                if (this.component != null) {
                    hasComponent = this.getBaseline(snapshot, repo, this.component.getItemId().getUuidValue()) != null;
                }
            } else {
                snapshot = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)itemSelector), null);
            }
            ParmsContext context = new ParmsContext("baselineset", repo.getRepositoryURI(), snapshot.getItemId().getUuidValue());
            SnapshotPathResolver pathResolver = SnapshotPathResolver.create((SnapshotId)SnapshotId.getSnapshotId((ITeamRepository)repo, (IItemHandle)snapshot));
            contextDiffInput = new ContextDiffInput(context, (IPathResolver)pathResolver, hasComponent, contextType);
        } else if ("baseline".equalsIgnoreCase(contextType)) {
            if (resolveItem || this.component != null) {
                IBaseline baseline = this.getBaseline(itemSelector, repo);
                itemSelector = baseline.getItemId().getUuidValue();
                if (this.component != null) {
                    hasComponent = baseline.getComponent().getItemId().equals((Object)this.component.getItemId());
                }
            }
            ParmsContext context = new ParmsContext("baseline", repo.getRepositoryURI(), itemSelector);
            RemotePathResolver pathResolver = new RemotePathResolver((IConnection)this.getBlConn(itemSelector, repo.getRepositoryURI(), this.config));
            contextDiffInput = new ContextDiffInput(context, (IPathResolver)pathResolver, hasComponent, contextType);
        } else {
            if (resolveItem) {
                boolean isWorkspace;
                IWorkspace workspace = RepoUtil.getWorkspace((String)itemSelector, (boolean)isWorkspace, (!(isWorkspace = "workspace".equalsIgnoreCase(contextType)) ? 1 : 0) != 0, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                itemSelector = workspace.getItemId().getUuidValue();
            }
            ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), itemSelector);
            ParmsContext context = new ParmsContext("workspace", ws.repositoryUrl, ws.workspaceItemId);
            IWorkspaceConnection wsConn = this.getWsConn(ws, this.config);
            RemotePathResolver pathResolver = new RemotePathResolver((IConnection)wsConn);
            if (this.component != null) {
                ICurrentComponentInfo compInfo = null;
                try {
                    compInfo = wsConn.getComponentInfo((IComponentHandle)this.component);
                }
                catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
                    // empty catch block
                }
                hasComponent = compInfo != null;
            }
            contextDiffInput = new ContextDiffInput(context, (IPathResolver)pathResolver, hasComponent, contextType);
        }
        return contextDiffInput;
    }

    private void validateComponentSelector(StateSelector after, StateSelector before, ITeamRepository afterRepo, ITeamRepository beforeRepo) throws FileSystemException {
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)this.config.getSubcommandCommandLine().getOptionValue((IOptionKey)DiffCmdOpts.OPT_COMPONENT, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)componentSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        if (componentSelector != null) {
            this.componentItemSelector = componentSelector.getItemSelector();
            ITeamRepository componentRepo = afterRepo;
            try {
                this.component = RepoUtil.getComponent((String)this.componentItemSelector, (ITeamRepository)componentRepo, (IScmClientConfiguration)this.config);
                if (beforeRepo != null && !RepoUtil.isRepoUriSame((String)afterRepo.getRepositoryURI(), (String)beforeRepo.getRepositoryURI(), (IScmClientConfiguration)this.config)) {
                    componentRepo = beforeRepo;
                    this.component = (IComponent)RepoUtil.getItem((IItemType)IComponent.ITEM_TYPE, (UUID)this.component.getItemId(), (ITeamRepository)componentRepo, (IScmClientConfiguration)this.config);
                }
            }
            catch (CLIFileSystemClientException e) {
                if (e.getStatus().getCode() == 25) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_FOUND, (Object)this.componentItemSelector, (Object)componentRepo.getRepositoryURI()));
                }
                if (e.getStatus().getCode() == 9) {
                    throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_AMBIGUOUS_COMP, (Object)this.componentItemSelector, (Object)componentRepo.getRepositoryURI()));
                }
                throw e;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Component in context: " + this.component.getName() + this.component.getItemId()));
            }
        } else if (before != null && (after.type.equalsIgnoreCase("baseline") || before.type.equalsIgnoreCase("baseline"))) {
            StateSelector baselineSelector = before;
            ITeamRepository baselineRepo = beforeRepo;
            ITeamRepository otherRepo = afterRepo;
            if (after.type.equalsIgnoreCase("baseline")) {
                baselineSelector = after;
                baselineRepo = afterRepo;
                otherRepo = beforeRepo;
            }
            IBaseline baseline = this.getBaseline(baselineSelector.getItemSelector(), baselineRepo);
            ITeamRepository componentRepo = baselineRepo;
            try {
                this.component = (IComponent)RepoUtil.getItem((IItemType)IComponent.ITEM_TYPE, (UUID)baseline.getComponent().getItemId(), (ITeamRepository)componentRepo, (IScmClientConfiguration)this.config);
                if (!RepoUtil.isRepoUriSame((String)baselineRepo.getRepositoryURI(), (String)otherRepo.getRepositoryURI(), (IScmClientConfiguration)this.config)) {
                    componentRepo = otherRepo;
                    this.component = (IComponent)RepoUtil.getItem((IItemType)IComponent.ITEM_TYPE, (UUID)baseline.getComponent().getItemId(), (ITeamRepository)componentRepo, (IScmClientConfiguration)this.config);
                }
            }
            catch (CLIFileSystemClientException e) {
                if (e.getStatus().getCode() == 25) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.DiffCmd_COMP_BL_NOT_FOUND, (Object[])new String[]{baseline.getComponent().getItemId().getUuidValue(), baselineSelector.getItemSelector(), componentRepo.getRepositoryURI()}));
                }
                throw e;
            }
            this.compBaselineSelector = baselineSelector.getItemSelector();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Component in context: " + this.component.getName() + this.component.getItemId()));
                this.logger.debug((Object)("Baseline in context: " + this.compBaselineSelector));
            }
        }
    }

    private void failMissingComponent(StateSelector stateSelector, ContextDiffInput context) throws FileSystemException {
        if (this.componentItemSelector != null) {
            if (stateSelector.type.equalsIgnoreCase("baseline")) {
                IBaseline baseline = this.baselineMap.get(stateSelector.getItemSelector());
                String componentId = baseline != null ? baseline.getComponent().getItemId().getUuidValue() : null;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_BL_NOT_BELONG_TO_COMP, (Object[])new String[]{stateSelector.getItemSelector(), componentId, this.componentItemSelector}));
            }
            if (stateSelector.type.equalsIgnoreCase("snapshot")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_FOUND_IN_SS, (Object[])new String[]{stateSelector.getItemSelector(), this.componentItemSelector}));
            }
            if (stateSelector.type.equalsIgnoreCase("stream")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_FOUND_IN_ST, (Object[])new String[]{stateSelector.getItemSelector(), this.componentItemSelector}));
            }
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_FOUND_IN_WS, (Object[])new String[]{stateSelector.getItemSelector(), this.componentItemSelector}));
        }
        if (this.compBaselineSelector != null) {
            if (stateSelector.type.equalsIgnoreCase("baseline")) {
                IBaseline baseline = this.baselineMap.get(stateSelector.getItemSelector());
                String componentId = baseline != null ? baseline.getComponent().getItemId().getUuidValue() : null;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_BL_NOT_BELONG_TO_COMP_BL, (Object[])new String[]{stateSelector.getItemSelector(), componentId, this.component.getItemId().getUuidValue(), this.compBaselineSelector}));
            }
            if (stateSelector.type.equalsIgnoreCase("snapshot")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_BL_NOT_FOUND_IN_SS, (Object[])new String[]{stateSelector.getItemSelector(), this.component.getItemId().getUuidValue(), this.compBaselineSelector}));
            }
            if (stateSelector.type.equalsIgnoreCase("stream")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_BL_NOT_FOUND_IN_ST, (Object[])new String[]{stateSelector.getItemSelector(), this.component.getItemId().getUuidValue(), this.compBaselineSelector}));
            }
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_BL_NOT_FOUND_IN_WS, (Object[])new String[]{stateSelector.getItemSelector(), this.component.getItemId().getUuidValue(), this.compBaselineSelector}));
        }
    }

    private void failMissingComponent(StateSelector after, ContextDiffInput afterContext, StateSelector before, ContextDiffInput beforeContext) throws FileSystemException {
        boolean afterHasComponent = afterContext.hasComponent;
        boolean beforeHasComponent = beforeContext.hasComponent;
        if (!afterHasComponent) {
            this.failMissingComponent(after, afterContext);
        } else if (before != null && !beforeHasComponent) {
            this.failMissingComponent(before, beforeContext);
        } else if (!beforeHasComponent && this.componentItemSelector != null) {
            if (after.type.equalsIgnoreCase("snapshot")) {
                if (beforeContext.type.equalsIgnoreCase("stream")) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_IN_ST_FOR_SS, (Object[])new String[]{beforeContext.context.itemId, after.getItemSelector(), this.componentItemSelector}));
                }
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_IN_WS_FOR_SS, (Object[])new String[]{beforeContext.context.itemId, after.getItemSelector(), this.componentItemSelector}));
            }
            if (after.type.equalsIgnoreCase("stream")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_IN_COLLAB_WS_ST, (Object[])new String[]{beforeContext.context.itemId, after.getItemSelector(), this.componentItemSelector}));
            }
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_COMP_NOT_IN_COLLAB_WS_WS, (Object[])new String[]{beforeContext.context.itemId, after.getItemSelector(), this.componentItemSelector}));
        }
    }

    private void contextDiff(IScmClientConfiguration config, StateSelector after, StateSelector before, List<String> changeSelectors, boolean fullPatch) throws FileSystemException {
        ChangeDescription changeDesc;
        ConfigurationChange incomingConfChange;
        ConfigurationChange outgoingConfChange;
        if (!(before == null || before.getType().equalsIgnoreCase("workspace") || before.getType().equalsIgnoreCase("stream") || before.getType().equalsIgnoreCase("snapshot") || before.getType().equalsIgnoreCase("baseline"))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_UNSUPPORTED_BEFORE_TYPE, (Object)before.getType(), (Object)after.getType()));
        }
        ITeamRepository afterRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)after.getSelector());
        ITeamRepository beforeRepo = null;
        if (before != null) {
            beforeRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)before.getSelector());
        }
        this.validateComponentSelector(after, before, afterRepo, beforeRepo);
        ContextDiffInput afterContext = null;
        ContextDiffInput beforeContext = null;
        if (before != null) {
            afterContext = this.getContextDiffInput(after.getItemSelector(), after.type, afterRepo, true);
            beforeContext = this.getContextDiffInput(before.getItemSelector(), before.type, beforeRepo, true);
        } else if (after.type.equalsIgnoreCase("snapshot")) {
            IBaselineSet snapshot = RepoUtil.getSnapshot(null, (String)after.getItemSelector(), (ITeamRepository)afterRepo, (IScmClientConfiguration)config);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Snapshot in context: " + after.getItemSelector()));
                this.logger.debug((Object)("Snapshot owner: " + snapshot.getOwner().getItemId()));
            }
            IWorkspace beforeWs = (IWorkspace)RepoUtil.getItem((IItemType)IWorkspace.ITEM_TYPE, (UUID)snapshot.getOwner().getItemId(), (ITeamRepository)afterRepo, (IScmClientConfiguration)config);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Snapshot owner(name): " + beforeWs.getName()));
            }
            String beforeType = beforeWs.isStream() ? "stream" : "workspace";
            afterContext = this.getContextDiffInput(snapshot.getItemId().getUuidValue(), after.type, afterRepo, false);
            beforeContext = this.getContextDiffInput(beforeWs.getItemId().getUuidValue(), beforeType, afterRepo, false);
        } else if (after.type.equalsIgnoreCase("baseline")) {
            IBaseline baseline = this.getBaseline(after.getItemSelector(), afterRepo);
            IBaselineConnection blConn = this.getBlConn(baseline.getItemId().getUuidValue(), afterRepo.getRepositoryURI(), config);
            IBaselineHandle prevBaseline = null;
            try {
                IHistoricBaselineIterator blIter = blConn.getBaselinesInHistory(1, null);
                if (blIter.getBaselines().isEmpty()) {
                    config.getWrappedOutputStream().println((CharSequence)Messages.DiffCmd_NO_PREV_BL);
                    return;
                }
                prevBaseline = (IBaselineHandle)blIter.getBaselines().get(0);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiffCmd_UNABLE_TO_FETCH_BL_HIST, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)afterRepo.getRepositoryURI());
            }
            afterContext = this.getContextDiffInput(baseline.getItemId().getUuidValue(), after.type, afterRepo, false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Baseline: " + after.getItemSelector()));
                this.logger.debug((Object)("Previous baseline " + prevBaseline.getItemId()));
            }
            beforeContext = this.getContextDiffInput(prevBaseline.getItemId().getUuidValue(), after.type, afterRepo, false);
        } else {
            boolean isWorkspace = after.getType().equalsIgnoreCase("workspace");
            IWorkspace afterWsFound = RepoUtil.getWorkspace((String)after.getItemSelector(), (boolean)isWorkspace, (!isWorkspace ? 1 : 0) != 0, (ITeamRepository)afterRepo, (IScmClientConfiguration)config);
            ParmsWorkspace afterWs = new ParmsWorkspace(afterRepo.getRepositoryURI(), afterWsFound.getItemId().getUuidValue());
            WorkspaceDetailsDTO afterWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(afterWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config).get(0);
            ParmsWorkspace wsFlow = RepoUtil.getFlowTarget((WorkspaceDetailsDTO)afterWsDetails, (RepoUtil.FlowType)RepoUtil.FlowType.INCOMING, (boolean)false);
            if (wsFlow == null) {
                config.getWrappedOutputStream().println((CharSequence)Messages.DiffCmd_NO_COLLABORATION);
                return;
            }
            beforeRepo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (ConnectionInfo)config.getConnectionInfo(wsFlow.repositoryUrl));
            IWorkspace beforeWs = (IWorkspace)RepoUtil.getItem((IItemType)IWorkspace.ITEM_TYPE, (UUID)UUID.valueOf((String)wsFlow.workspaceItemId), (ITeamRepository)beforeRepo, (IScmClientConfiguration)config);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(String.valueOf(after.type) + " in context: " + after.getItemSelector()));
                this.logger.debug((Object)("Current flow target: " + beforeWs.getName() + beforeWs.getItemId()));
            }
            String beforeType = beforeWs.isStream() ? "stream" : "workspace";
            afterContext = this.getContextDiffInput(afterWs.workspaceItemId, after.type, afterRepo, false);
            beforeContext = this.getContextDiffInput(wsFlow.workspaceItemId, beforeType, beforeRepo, false);
        }
        if (!(this.component == null || afterContext.hasComponent && beforeContext.hasComponent)) {
            this.failMissingComponent(after, afterContext, before, beforeContext);
        }
        List outgoingChanges = null;
        List incomingChanges = null;
        String componentId = this.component != null ? this.component.getItemId().getUuidValue() : null;
        try {
            outgoingChanges = SubcommandUtil.compareAndGetChangeSetItemIds((ParmsContext)afterContext.context, (ParmsContext)beforeContext.context, (String)componentId, (IFilesystemRestClient)this.client, (boolean)false);
            incomingChanges = SubcommandUtil.compareAndGetChangeSetItemIds((ParmsContext)afterContext.context, (ParmsContext)beforeContext.context, (String)componentId, (IFilesystemRestClient)this.client, (boolean)true);
        }
        catch (TeamRepositoryException tre) {
            StatusHelper.wrap((String)Messages.DiffCmd_FAILED_WHEN_DET_DIFF, (TeamRepositoryException)tre, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        if (outgoingChanges.isEmpty() && incomingChanges.isEmpty()) {
            if (changeSelectors == null) {
                config.getWrappedOutputStream().println((CharSequence)Messages.DiffCmd_NO_DIFFERENCES);
            } else {
                config.getWrappedOutputStream().println((CharSequence)Messages.DiffCmd_NO_DIFFERENCES_FILE_SELECTOR);
            }
            return;
        }
        ArrayList<String> changeItemIds = null;
        if (changeSelectors != null) {
            ChangeSetSyncDTO csDTO = null;
            String itemType = null;
            changeItemIds = new ArrayList<String>(changeSelectors.size());
            HashMap<String, String> pathTochangeItemIdMap = new HashMap<String, String>();
            for (ItemId cs : incomingChanges) {
                itemType = before.type;
                if (itemType.equals("stream")) {
                    itemType = "workspace";
                }
                csDTO = RepoUtil.findChangeSet((String)cs.getItemUUID().getUuidValue(), (boolean)true, (String)RepoUtil.lookupUuidAndAlias((String)beforeContext.context.itemId).getUuid().getUuidValue(), (String)itemType, (String)(beforeRepo == null ? afterRepo.getRepositoryURI() : beforeRepo.getRepositoryURI()), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
                this.updatePathToChangeItemIdMap(pathTochangeItemIdMap, csDTO);
            }
            for (ItemId cs : outgoingChanges) {
                itemType = after.type;
                if (itemType.equals("stream")) {
                    itemType = "workspace";
                }
                csDTO = RepoUtil.findChangeSet((String)cs.getItemUUID().getUuidValue(), (boolean)true, (String)RepoUtil.lookupUuidAndAlias((String)afterContext.context.itemId).getUuid().getUuidValue(), (String)itemType, (String)afterRepo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
                this.updatePathToChangeItemIdMap(pathTochangeItemIdMap, csDTO);
            }
            Set<String> mismatchedChangeSelectors = this.getMisMatchedChangeSelectors(changeSelectors, pathTochangeItemIdMap, changeItemIds);
            if (mismatchedChangeSelectors != null && mismatchedChangeSelectors.size() > 0) {
                IndentingPrintStream err = config.getWrappedErrorStream();
                err.println((CharSequence)Messages.DiffCmd_NO_DIFFERENCES_CS);
                for (String selector : mismatchedChangeSelectors) {
                    err.indent().println((CharSequence)selector);
                }
                throw StatusHelper.inappropriateArgument((String)Messages.DiffCmd_NOT_IN_WS_STREAM_HELP);
            }
        }
        try {
            outgoingConfChange = ClientConfigurationChangeFactory.createChangeForHandles((ITeamRepository)afterRepo, (List)outgoingChanges, changeItemIds, null);
            incomingConfChange = ClientConfigurationChangeFactory.createChangeForHandles((ITeamRepository)(beforeRepo == null ? afterRepo : beforeRepo), (List)incomingChanges, changeItemIds, null);
            changeDesc = ConfigurationChangeFactory.getDescriptionForHandles((ITeamRepository)(outgoingChanges.isEmpty() ? (beforeRepo == null ? afterRepo : beforeRepo) : afterRepo), (List)(outgoingChanges.isEmpty() ? incomingChanges : outgoingChanges), null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_79, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        ConfigurationChange confChange = outgoingConfChange.merge(incomingConfChange.reverse());
        this.doDiff(afterContext.pathResolver, beforeContext.pathResolver, confChange, changeDesc, fullPatch, config);
    }

    private void changesetDiff(IScmClientConfiguration config, StateSelector after, StateSelector before, boolean fullPatch, String wsSelector, List<String> changeSelectors) throws FileSystemException {
        ChangeDescription changeDesc;
        ConfigurationChange confChange;
        Set<String> mismatchedChangeSelectors;
        IScmCommandLineArgument afterSelector = after.getSelector();
        ChangeSetSyncDTO csDTO = null;
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)afterSelector);
        ParmsWorkspace ws = null;
        if (wsSelector != null) {
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector, (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            csDTO = RepoUtil.findChangeSet((String)afterSelector.getItemSelector(), (boolean)true, (String)ws.workspaceItemId, (String)"workspace", (String)repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
        } else {
            csDTO = RepoUtil.findChangeSet((String)afterSelector.getItemSelector(), (boolean)true, null, null, (String)repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
        }
        ChangeSetSyncDTO beforeCsDTO = null;
        if (before != null) {
            ITeamRepository repo2 = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)before.getSelector());
            if (repo.getId() != repo2.getId()) {
                StatusHelper.argSyntax((String)Messages.DiffCmd_CHANGESETS_REPO_NOTSAME);
            }
            if (before.getType().equalsIgnoreCase("changeset")) {
                beforeCsDTO = ws != null ? RepoUtil.findChangeSet((String)before.getItemSelector(), (boolean)true, (String)ws.workspaceItemId, (String)"workspace", (String)repo2.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config) : RepoUtil.findChangeSet((String)before.getItemSelector(), (boolean)true, null, null, (String)repo2.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
            } else {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DiffCmd_UNSUPPORTED_BEFORE_TYPE, (Object)before.getType(), (Object)after.getType()));
            }
        }
        LinkedList<Object> csHandles = new LinkedList<Object>();
        ItemId afterCsId = null;
        ArrayList<String> changeItemIds = null;
        if (changeSelectors != null) {
            changeItemIds = new ArrayList<String>();
        }
        HashMap<String, String> pathTochangeItemIdMap = new HashMap<String, String>();
        if (beforeCsDTO == null || csDTO.getLastChangeDate() > beforeCsDTO.getLastChangeDate()) {
            afterCsId = new ItemId(IChangeSet.ITEM_TYPE, UUID.valueOf((String)csDTO.getChangeSetItemId()));
            if (changeSelectors != null) {
                this.updatePathToChangeItemIdMap(pathTochangeItemIdMap, csDTO);
            }
        } else {
            afterCsId = new ItemId(IChangeSet.ITEM_TYPE, UUID.valueOf((String)beforeCsDTO.getChangeSetItemId()));
            if (changeSelectors != null) {
                this.updatePathToChangeItemIdMap(pathTochangeItemIdMap, beforeCsDTO);
            }
        }
        if ((mismatchedChangeSelectors = this.getMisMatchedChangeSelectors(changeSelectors, pathTochangeItemIdMap, changeItemIds)) != null && mismatchedChangeSelectors.size() > 0) {
            if (!RepoUtil.isSandboxPath((String)SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)changeSelectors.get(0)).toOSString(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)config) && ws == null) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_PROVIDE_WS, (Object)DiffCmdOpts.OPT_WORKSPACE.getLongOpt()));
            }
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.DiffCmd_NOT_FOUND_IN_CS);
            for (String selector : mismatchedChangeSelectors) {
                err.indent().println((CharSequence)selector);
            }
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ListChangesCmd.class);
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_NOT_IN_CS_HELP, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString()}));
        }
        csHandles.add(afterCsId);
        try {
            confChange = ClientConfigurationChangeFactory.createChangeForHandles((ITeamRepository)repo, csHandles, changeItemIds, null);
            changeDesc = ConfigurationChangeFactory.getDescriptionForHandles((ITeamRepository)repo, csHandles, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_79, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        if (beforeCsDTO != null) {
            csHandles.clear();
            List<ItemId<IChangeSet>> csList = null;
            csList = csDTO.getLastChangeDate() > beforeCsDTO.getLastChangeDate() ? this.findChangeSetsInBetween(csDTO, beforeCsDTO, ws, repo) : this.findChangeSetsInBetween(beforeCsDTO, csDTO, ws, repo);
            csHandles.addAll(csList);
            try {
                ConfigurationChange confChange1 = ClientConfigurationChangeFactory.createChangeForHandles((ITeamRepository)repo, csHandles, null);
                confChange = confChange.merge(confChange1);
                ChangeDescription changeDesc1 = ConfigurationChangeFactory.getDescriptionForHandles((ITeamRepository)repo, csHandles, null);
                changeDesc = changeDesc.merge(changeDesc1);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiffCmd_79, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
        }
        RemotePathResolver pathResolver = ws != null ? new RemotePathResolver((IConnection)this.getWsConn(ws, config)) : null;
        this.doDiff((IPathResolver)pathResolver, null, confChange, changeDesc, fullPatch, config);
    }

    private List<ItemId<IChangeSet>> findChangeSetsInBetween(ChangeSetSyncDTO csDTO, ChangeSetSyncDTO beforeCsDTO, ParmsWorkspace ws, ITeamRepository repo) throws FileSystemException {
        ArrayList<ItemId<IChangeSet>> csList = new ArrayList<ItemId<IChangeSet>>();
        HashMap<String, ChangeSyncDTO> beforeVerItemsMap = new HashMap<String, ChangeSyncDTO>();
        for (ChangeFolderSyncDTO changeFolderSyncDTO : beforeCsDTO.getChanges()) {
            for (ChangeSyncDTO changeDTO : changeFolderSyncDTO.getChanges()) {
                beforeVerItemsMap.put(changeDTO.getVersionableItemId(), changeDTO);
            }
        }
        HashSet<ChangeSyncDTO> matchingChanges = new HashSet<ChangeSyncDTO>();
        for (ChangeFolderSyncDTO changeFolderSyncDTO : csDTO.getChanges()) {
            for (ChangeSyncDTO changeDTO : changeFolderSyncDTO.getChanges()) {
                boolean beforeIsPredecessor;
                if (!beforeVerItemsMap.containsKey(changeDTO.getVersionableItemId())) continue;
                ChangeSyncDTO beforeChangeDTO = (ChangeSyncDTO)beforeVerItemsMap.get(changeDTO.getVersionableItemId());
                boolean bl = beforeChangeDTO.getAfterStateId() == null ? changeDTO == null : (beforeIsPredecessor = beforeChangeDTO.getAfterStateId().equals(changeDTO.getBeforeStateId()));
                if (beforeIsPredecessor) continue;
                matchingChanges.add(changeDTO);
            }
        }
        for (ChangeSyncDTO changeDTO : matchingChanges) {
            List<String> csIdList = this.findChangeSetsInBetweenDates(repo, ws != null ? ws.workspaceItemId : null, csDTO.getComponentItemId(), changeDTO, csDTO.getLastChangeDate(), beforeCsDTO.getLastChangeDate());
            for (String csId : csIdList) {
                ItemId csItemId = new ItemId(IChangeSet.ITEM_TYPE, UUID.valueOf((String)csId));
                csList.add((ItemId<IChangeSet>)csItemId);
            }
        }
        return csList;
    }

    private List<String> findChangeSetsInBetweenDates(ITeamRepository repo, String wsId, String compId, ChangeSyncDTO changeDTO, long beforeDate, long afterDate) throws FileSystemException {
        String verId = changeDTO.getVersionableItemId();
        IItemType itemType = SubcommandUtil.getVersionableItemType((String)changeDTO.getVersionableItemType());
        String csFilterPrefix = "ChangeSetFilter:";
        ArrayList<String> criteria = new ArrayList<String>();
        criteria.add("Component:" + compId);
        criteria.add("DateRange:" + afterDate + "\n" + beforeDate);
        criteria.add(String.valueOf(csFilterPrefix) + "Versionable" + "\n" + itemType.getNamespaceURI() + "\n" + itemType.getName() + "\n" + verId);
        if (wsId != null) {
            criteria.add(String.valueOf(csFilterPrefix) + "Workspace" + "\n" + wsId);
        }
        ListChangesetsCmd.ListChangeSetParms parms = new ListChangesetsCmd.ListChangeSetParms();
        parms.searchCriteria = criteria.toArray(new String[criteria.size()]);
        parms.repo = repo;
        ArrayList<String> csList = new ArrayList<String>();
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        BatchingPrinter.BatchProvider<String> provider = ListChangesetsCmd.getChangeSetsProvider(scmService, parms, this.maxValue, this.config, this.client, this.config.getSubcommandCommandLine());
        List batch = provider.nextBatch();
        while (!batch.isEmpty()) {
            csList.addAll(batch);
            batch = provider.nextBatch();
        }
        this.hasMoreItems = provider.hasMore();
        return csList;
    }

    private void doDiff(IPathResolver pathResolver1, IPathResolver pathResolver2, ConfigurationChange confChange, ChangeDescription changeDesc, boolean fullPatch, IScmClientConfiguration config) throws FileSystemException {
        ResolvedConfigurationChangePaths paths;
        LinkedList<Object> resolvers = new LinkedList<Object>();
        resolvers.add(CopyFileAreaPathResolver.create());
        if (pathResolver1 != null) {
            resolvers.add(pathResolver1);
        }
        if (pathResolver2 != null) {
            resolvers.add(pathResolver2);
        }
        FallbackPathResolver resolver = new FallbackPathResolver(resolvers);
        if (fullPatch) {
            try {
                CreatePatchUtil.createPatch((CreatePatchDilemmaHandler)new CreatePatchDilemmaHandler(){}, (OutputStream)config.getContext().stdout(), (ConfigurationChange)confChange, (ChangeDescription)changeDesc, (IPathResolver)resolver, (String)"UTF-8", null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiffCmd_22, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
        }
        try {
            paths = ResolvedConfigurationChangePaths.resolve((IPathResolver)resolver, (ConfigurationChange)confChange, null);
        }
        catch (TeamRepositoryException e) {
            Log log = LogFactory.getLog((String)DiffCmd.class.getName());
            log.error((Object)e);
            throw StatusHelper.failure((String)Messages.ERROR_CHECK_LOG, null);
        }
        final PrintStream stdOut = config.getContext().stdout();
        StringDiffParticipant diffParticipant = new StringDiffParticipant(){

            protected void writeHeader(String header) throws IOException {
                DiffCmd.this.hasContentDiff = true;
                stdOut.write(header.getBytes());
            }

            public void writeHunkRange(HunkRange range) throws IOException {
                stdOut.write((String.valueOf(range.toString()) + "\n").getBytes());
            }

            public void writeCommonLine(List<String> range, int lineNum) throws IOException {
                stdOut.write(" ".getBytes());
                stdOut.write(range.get(lineNum).getBytes());
            }

            public void writeAddedLine(List<String> range, int lineNum) throws IOException {
                stdOut.write("+".getBytes());
                stdOut.write(range.get(lineNum).getBytes());
            }

            public void writeRemovedLine(List<String> range, int lineNum) throws IOException {
                stdOut.write("-".getBytes());
                stdOut.write(range.get(lineNum).getBytes());
            }

            public void writeNoTrailingNL(List<String> range) throws IOException {
                stdOut.write("\n\\ No newline at end of file\n".getBytes());
            }
        };
        for (FileChange fileChange : confChange.getChanges()) {
            try {
                this.hasContentDiff = false;
                if (this.displayContentDiff) {
                    CreateDiffUtil.writeDiff((DiffParticipant)diffParticipant, (FileChange)fileChange, (ResolvedConfigurationChangePaths)paths, null);
                }
                if (!this.displayPropertyDiff || !fileChange.hasPropertyChange() && fileChange.isModify()) continue;
                this.writePropertyDiff(stdOut, fileChange, paths, this.hasContentDiff);
            }
            catch (IOException e) {
                String path;
                if (e.getCause() instanceof VersionedContentDeleted) {
                    path = this.getFilePath(fileChange, paths, config);
                    config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.DiffCmd_DELETED_CONTENT, (Object)path));
                    continue;
                }
                if (e.getCause() instanceof VersionablePermissionDeniedException) {
                    path = this.getFilePath(fileChange, paths, config);
                    config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.Common_VERSIONABLE_ITEM_PERMISSSION_DENIED, (Object)path));
                    continue;
                }
                throw StatusHelper.failure((String)Messages.DiffCmd_22, (Throwable)e);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiffCmd_22, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
        }
    }

    private String getFilePath(FileChange fileChange, ResolvedConfigurationChangePaths paths, IScmClientConfiguration config) throws FileSystemException {
        String path = null;
        try {
            if (paths != null && (path = paths.computePath(fileChange.getSiloedItemId(), false, null).toPath().toString()) == null) {
                path = paths.computePath(fileChange.getSiloedItemId(), true, null).toPath().toString();
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_23, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        if (path == null) {
            path = fileChange.getItemId().getItemUUID().getUuidValue();
        }
        return path;
    }

    private void writePropertyDiff(OutputStream out, FileChange change, ResolvedConfigurationChangePaths paths, boolean hasContentDiff) throws IOException, TeamRepositoryException {
        FileState beforeState = change.getInitial();
        FileState afterState = change.getFinal();
        Map beforeStateProperties = beforeState.getProperties();
        Map afterStateProperties = afterState.getProperties();
        TreeSet propertyNames = new TreeSet(beforeStateProperties.keySet());
        propertyNames.addAll(afterStateProperties.keySet());
        if (!change.isModify() && !change.getItemId().getItemType().equals(IFileItem.ITEM_TYPE) && propertyNames.size() == 0) {
            return;
        }
        if (!hasContentDiff) {
            String beforePath = null;
            String afterPath = null;
            if (paths != null) {
                if (!beforeState.isDeleted()) {
                    beforePath = paths.computePath(change.getSiloedItemId(), true, null).toPath().toString();
                }
                if (!afterState.isDeleted()) {
                    afterPath = paths.computePath(change.getSiloedItemId(), false, null).toPath().toString();
                }
            }
            String diffHeader = CreateDiffUtil.getFilePatchHeader(beforePath, afterPath, (Date)change.getInitial().getTimestamp(), (Date)change.getFinal().getTimestamp());
            out.write(diffHeader.getBytes());
        }
        HashMap<String, PropertyModificationType> modifiedProperties = new HashMap<String, PropertyModificationType>();
        for (String name : propertyNames) {
            String initialValue = (String)beforeStateProperties.get(name);
            String finalValue = (String)afterStateProperties.get(name);
            if (finalValue == null) {
                modifiedProperties.put(name, PropertyModificationType.DELETE_PROPERTY);
                continue;
            }
            if (initialValue == null) {
                modifiedProperties.put(name, PropertyModificationType.ADD_PROPERTY);
                continue;
            }
            if (initialValue.equals(finalValue)) continue;
            modifiedProperties.put(name, PropertyModificationType.MODIFY_PROPERTY);
        }
        if (change.getItemId().getItemType().equals(IFileItem.ITEM_TYPE)) {
            if (!change.isModify()) {
                PropertyModificationType modType = change.getInitial().isDeleted() ? PropertyModificationType.ADD_PROPERTY : PropertyModificationType.DELETE_PROPERTY;
                modifiedProperties.put("jazz.executable", modType);
                modifiedProperties.put("jazz.mime", modType);
                modifiedProperties.put("jazz.line-delimiter", modType);
                modifiedProperties.put(CHARACTER_ENCODING, modType);
            } else {
                String finalFileEncoding;
                String initialFileEncoding;
                FileLineDelimiter finalLineDelimeter;
                FileLineDelimiter initialLineDelimeter;
                String finalContentType;
                String initialContentType;
                boolean finalExecutable;
                boolean initialExecutable = beforeState.isExectuable();
                if (initialExecutable != (finalExecutable = afterState.isExectuable())) {
                    modifiedProperties.put("jazz.executable", PropertyModificationType.MODIFY_PROPERTY);
                }
                if (!(initialContentType = beforeState.getContentType()).equals(finalContentType = afterState.getContentType())) {
                    modifiedProperties.put("jazz.mime", PropertyModificationType.MODIFY_PROPERTY);
                }
                if ((initialLineDelimeter = beforeState.getLineDelimiter()) != (finalLineDelimeter = afterState.getLineDelimiter())) {
                    modifiedProperties.put("jazz.line-delimiter", PropertyModificationType.MODIFY_PROPERTY);
                }
                if (!(initialFileEncoding = beforeState.getCharacterEncoding()).equals(finalFileEncoding = afterState.getCharacterEncoding())) {
                    modifiedProperties.put(CHARACTER_ENCODING, PropertyModificationType.MODIFY_PROPERTY);
                }
            }
        }
        TreeSet modifiedPropertyNames = new TreeSet(modifiedProperties.keySet());
        int maxWidth = 0;
        for (String propertyName : modifiedPropertyNames) {
            maxWidth = Math.max(maxWidth, propertyName.length());
        }
        out.write((String.valueOf(Messages.ConflictsCmd_Properties) + "\n").getBytes());
        for (String name : modifiedPropertyNames) {
            if (((PropertyModificationType)((Object)modifiedProperties.get(name))).equals((Object)PropertyModificationType.DELETE_PROPERTY)) {
                this.writePropertyDiffLine(out, maxWidth, true, name, (String)beforeStateProperties.get(name), beforeState);
                continue;
            }
            if (((PropertyModificationType)((Object)modifiedProperties.get(name))).equals((Object)PropertyModificationType.ADD_PROPERTY)) {
                this.writePropertyDiffLine(out, maxWidth, false, name, (String)afterStateProperties.get(name), afterState);
                continue;
            }
            if (!((PropertyModificationType)((Object)modifiedProperties.get(name))).equals((Object)PropertyModificationType.MODIFY_PROPERTY)) continue;
            this.writePropertyDiffLine(out, maxWidth, true, name, (String)beforeStateProperties.get(name), beforeState);
            this.writePropertyDiffLine(out, maxWidth, false, name, (String)afterStateProperties.get(name), afterState);
        }
    }

    private void writePropertyDiffLine(OutputStream out, int maxWidth, boolean writeBeforeState, String name, String value, FileState fileState) throws IOException {
        if (value != null) {
            this.writePropertyDiffLine(out, maxWidth, writeBeforeState, name, value);
        } else if (name.equals("jazz.executable")) {
            this.writePropertyDiffLine(out, maxWidth, writeBeforeState, name, Boolean.toString(fileState.isExectuable()));
        } else if (name.equals("jazz.mime")) {
            this.writePropertyDiffLine(out, maxWidth, writeBeforeState, name, fileState.getContentType());
        } else if (name.equals("jazz.line-delimiter")) {
            this.writePropertyDiffLine(out, maxWidth, writeBeforeState, name, fileState.getLineDelimiter().toString());
        } else if (name.equals(CHARACTER_ENCODING)) {
            this.writePropertyDiffLine(out, maxWidth, writeBeforeState, name, fileState.getCharacterEncoding());
        }
    }

    private void writePropertyDiffLine(OutputStream out, int maxWidth, boolean writeBeforeState, String name, String value) throws IOException {
        out.write((writeBeforeState ? "-" : "+").getBytes());
        out.write((String.valueOf(NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)name, (int)maxWidth), (Object)value)) + "\n").getBytes());
    }

    private static class ContextDiffInput {
        ParmsContext context;
        IPathResolver pathResolver;
        boolean hasComponent;
        String type;

        ContextDiffInput(ParmsContext context, IPathResolver pathResolver, boolean hasComponent, String type) {
            this.context = context;
            this.pathResolver = pathResolver;
            this.hasComponent = hasComponent;
            this.type = type;
        }
    }

    private static enum PropertyModificationType {
        ADD_PROPERTY,
        DELETE_PROPERTY,
        MODIFY_PROPERTY;

    }

    private static class StateSelector {
        public static final String TYPE_FILE = "file";
        public static final String TYPE_WORKSPACE = "workspace";
        public static final String TYPE_STREAM = "stream";
        public static final String TYPE_BASELINE = "baseline";
        public static final String TYPE_CHANGESET = "changeset";
        public static final String TYPE_SNAPSHOT = "snapshot";
        private final String type;
        private final IScmCommandLineArgument selector;

        public StateSelector(String type, IScmCommandLineArgument selector) {
            this.type = type;
            this.selector = selector;
        }

        public String getType() {
            return this.type;
        }

        public IScmCommandLineArgument getSelector() {
            return this.selector;
        }

        public String getItemSelector() {
            return this.selector.getItemSelector();
        }
    }
}

