/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ExternalToolUtils;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmdOpts;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.Property;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.JSONConflictPrinter;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ConflictsCmd
extends AbstractSubcommand {
    boolean quiet;
    private Set<String> missingCompSelectors = new HashSet<String>();
    private Set<UUID> matchedCompIdSet = new HashSet<UUID>();
    private Set<String> matchedCompSelectors = new HashSet<String>();
    private Map<String, UUID> compSelectorToUUIDMap = new HashMap<String, UUID>();

    public void run() throws FileSystemException {
        List<Object> conflictResults;
        ILocation pathLoc;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.quiet = subargs.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        boolean hasComponentFilter = subargs.hasOption((IOptionKey)ConflictsCmdOpts.OPT_COMPONENTS_SELECTOR);
        ScmCommandLineArgument mine = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_MINE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument proposed = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_PROPOSED, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument ancestor = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_ANCESTOR, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument compare = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ConflictsCmdOpts.OPT_CONFLICTS_EXTERNAL_COMPARE, null), (IScmClientConfiguration)this.config);
        Mode conflictMode = Mode.MINE;
        ScmCommandLineArgument conflictItem = null;
        int modeCount = 0;
        if (mine != null) {
            conflictMode = Mode.MINE;
            conflictItem = mine;
            ++modeCount;
        }
        if (proposed != null) {
            conflictMode = Mode.PROPOSED;
            conflictItem = proposed;
            ++modeCount;
        }
        if (ancestor != null) {
            conflictMode = Mode.ANCESTOR;
            conflictItem = ancestor;
            ++modeCount;
        }
        if (compare != null) {
            conflictMode = Mode.COMPARE;
            conflictItem = compare;
            ++modeCount;
        }
        if (modeCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_1, (Object[])new String[]{ConflictsCmdOpts.OPT_CONFLICTS_MINE.getName(), ConflictsCmdOpts.OPT_CONFLICTS_PROPOSED.getName(), ConflictsCmdOpts.OPT_CONFLICTS_ANCESTOR.getName(), ConflictsCmdOpts.OPT_CONFLICTS_EXTERNAL_COMPARE.getName()}));
        }
        boolean showContent = subargs.hasOption((IOptionKey)ConflictsCmdOpts.OPT_CONTENT);
        boolean allProperties = subargs.hasOption((IOptionKey)ConflictsCmdOpts.OPT_ALL_PROPERTIES);
        boolean listPropertyNames = subargs.hasOption((IOptionKey)ConflictsCmdOpts.OPT_PROPERTY_NAMES);
        String propertyName = subargs.getOption((IOptionKey)ConflictsCmdOpts.OPT_PROPERTY_NAME_VALUE, null);
        Property showProperty = Property.NONE;
        int propertyOptions = 0;
        if (allProperties) {
            showProperty = Property.ALL;
            ++propertyOptions;
        }
        if (listPropertyNames) {
            showProperty = Property.LIST_NAMES;
            ++propertyOptions;
        }
        if (propertyName != null) {
            showProperty = Property.NAME_VALUE;
            ++propertyOptions;
        }
        if (propertyOptions > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_5, (Object[])new String[]{ConflictsCmdOpts.OPT_ALL_PROPERTIES.getName(), ConflictsCmdOpts.OPT_PROPERTY_NAMES.getName(), ConflictsCmdOpts.OPT_PROPERTY_NAME_VALUE.getName()}));
        }
        if ((showContent || propertyOptions > 0) && modeCount == 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_3, (Object[])new String[]{ConflictsCmdOpts.OPT_CONTENT.getName(), ConflictsCmdOpts.OPT_ALL_PROPERTIES.getName(), ConflictsCmdOpts.OPT_PROPERTY_NAMES.getName(), ConflictsCmdOpts.OPT_PROPERTY_NAME_VALUE.getName(), ConflictsCmdOpts.OPT_CONFLICTS_MINE.getName(), ConflictsCmdOpts.OPT_CONFLICTS_PROPOSED.getName(), ConflictsCmdOpts.OPT_CONFLICTS_ANCESTOR.getName(), ConflictsCmdOpts.OPT_CONFLICTS_EXTERNAL_COMPARE.getName()}));
        }
        String externalCompareTool = null;
        if (conflictMode == Mode.COMPARE) {
            if (showProperty != Property.NONE) {
                throw StatusHelper.argSyntax((String)Messages.ResolveCmd_CANNOT_EXTERNAL_COMPARE_PROPERTY);
            }
            externalCompareTool = ExternalToolUtils.getExternalCompareTool((ScmClientConfiguration)this.config, true);
        }
        if (!showContent && propertyOptions == 0) {
            showContent = true;
            if (conflictMode != Mode.COMPARE) {
                showProperty = Property.ALL;
            }
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        List wsInSandboxList = null;
        if (modeCount != 0 && SubcommandUtil.exists((ILocation)(pathLoc = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)conflictItem.getItemSelector())), null)) {
            wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IPath)new Path(pathLoc.toOSString()), (IScmClientConfiguration)this.config);
        }
        if (wsInSandboxList == null) {
            wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(wsInSandboxList.size());
        for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
            String uri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(uri));
            wsList.add(new ParmsWorkspace(uri, wsInSandbox.getWorkspaceItemId()));
        }
        if (hasComponentFilter) {
            this.createSelectorListFromCompOpts(subargs);
        }
        String legacyDisplayStr = (String)this.config.getContext().environment().get("SCM_CONFLICTS_ENABLE_LEGACY_DISPLAY");
        boolean useLegacyJSonStruct = Boolean.valueOf(legacyDisplayStr);
        if (modeCount == 0) {
            if (subargs.hasOption((IOptionKey)ConflictsCmdOpts.OPT_LOCAL)) {
                conflictResults = this.findLocalConflicts(wsList, hasComponentFilter, client, this.config);
                ConflictsCmd.showLocalConflictItems(conflictResults, useLegacyJSonStruct, this.getUnMatchedComponents(), this.config);
            } else {
                conflictResults = this.findConflicts(wsList, hasComponentFilter, client, this.config);
                this.showConflictItems(conflictResults, useLegacyJSonStruct, this.config);
            }
            return;
        }
        if (subargs.hasOption((IOptionKey)ConflictsCmdOpts.OPT_LOCAL)) {
            conflictResults = this.findLocalConflicts(wsList, hasComponentFilter, client, this.config);
            this.showLocalConflictItemInfo(conflictResults, (IScmCommandLineArgument)conflictItem, conflictMode, showContent, showProperty, propertyName, client, this.config, externalCompareTool);
        } else {
            conflictResults = this.findConflicts(wsList, hasComponentFilter, client, this.config);
            this.showConflictItemInfo(conflictResults, (IScmCommandLineArgument)conflictItem, conflictMode, showContent, showProperty, propertyName, client, this.config, externalCompareTool);
        }
    }

    private void showConflictItems(List<ConflictResult> conflictResults, boolean legacyDisplay, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream printStream = config.getWrappedOutputStream();
        if (conflictResults.size() == 0) {
            if (!config.isJSONEnabled()) {
                printStream.println((CharSequence)Messages.ConflictsCmd_NoConflictsFound);
            }
            return;
        }
        HashMap<ITeamRepository, ArrayList<ConflictSyncDTO>> conflictsMap = new HashMap<ITeamRepository, ArrayList<ConflictSyncDTO>>();
        for (ConflictResult conflictResult : conflictResults) {
            ArrayList<ConflictSyncDTO> conflictList = (ArrayList<ConflictSyncDTO>)conflictsMap.get(conflictResult.repo);
            if (conflictList == null) {
                conflictList = new ArrayList<ConflictSyncDTO>();
                conflictsMap.put(conflictResult.repo, conflictList);
            }
            conflictList.add(conflictResult.conflict);
        }
        boolean printHeader = true;
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        List<String> unMatchedComponents = this.getUnMatchedComponents();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Map.Entry entry : conflictsMap.entrySet()) {
            List conflictList = (List)entry.getValue();
            if (conflictList.isEmpty()) continue;
            JSONArray jsonConflictItems = new JSONConflictPrinter().jsonizeConflictItems(conflictList, options);
            if (!((ScmClientConfiguration)config).isJSONEnabled()) {
                JSONConflictPrinter.printConflictItems((JSONArray)jsonConflictItems, (String)((ITeamRepository)entry.getKey()).getRepositoryURI(), (boolean)printHeader, (IndentingPrintStream)printStream);
                printHeader = false;
                continue;
            }
            JSONObject conflictComps = new JSONObject();
            conflictComps.put((Object)"conflicts", (Object)jsonConflictItems);
            jsonList.add(conflictComps);
        }
        if (!((ScmClientConfiguration)config).isJSONEnabled()) {
            ConflictsCmd.printUnMatchedComponentsMessage(unMatchedComponents, printStream, true);
        } else if (((ScmClientConfiguration)config).isJSONEnabled()) {
            ConflictsCmd.printConflictsInJsonFormat(config, legacyDisplay, jsonList, false, unMatchedComponents);
        }
        throw StatusHelper.returnValue((int)11);
    }

    private static JSONArray createStatusMessage(List<String> unMatchedCompList) {
        JSONArray status = new JSONArray();
        JSONObject warning = new JSONObject();
        warning.put((Object)"code", (Object)25);
        warning.put((Object)"message", (Object)Messages.ConflictsCmd_Components_NotFound);
        JSONArray items = new JSONArray();
        for (String item : unMatchedCompList) {
            items.add((Object)item);
        }
        warning.put((Object)"components", (Object)items);
        warning.put((Object)"severity", (Object)Constants.Severity.warning.toString());
        status.add((Object)warning);
        return status;
    }

    private static void showLocalConflictItems(List<LocalConflictResult> conflictResults, boolean legacyDisplay, List<String> unMatchedComponents, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream printStream = config.getWrappedOutputStream();
        if (conflictResults.size() == 0 && !config.isJSONEnabled()) {
            printStream.println((CharSequence)Messages.ConflictsCmd_NoLocalConflictsFound);
            return;
        }
        HashMap<ITeamRepository, ArrayList<LocalConflictSyncDTO>> conflictsMap = new HashMap<ITeamRepository, ArrayList<LocalConflictSyncDTO>>();
        for (LocalConflictResult conflictResult : conflictResults) {
            ArrayList<LocalConflictSyncDTO> conflictList = (ArrayList<LocalConflictSyncDTO>)conflictsMap.get(conflictResult.repo);
            if (conflictList == null) {
                conflictList = new ArrayList<LocalConflictSyncDTO>();
                conflictsMap.put(conflictResult.repo, conflictList);
            }
            conflictList.add(conflictResult.conflict);
        }
        boolean printHeader = true;
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
        for (Map.Entry entry : conflictsMap.entrySet()) {
            List localConflictsList = (List)entry.getValue();
            if (localConflictsList.isEmpty()) continue;
            JSONObject comp = new JSONObject();
            JSONPrintUtil.jsonizeLocalConflictItems((JSONObject)comp, (List)localConflictsList, (PendingChangesUtil.PendingChangesOptions)options);
            if (!((ScmClientConfiguration)config).isJSONEnabled()) {
                PendingChangesUtil.printLocalConflicts((JSONObject)comp, (String)((ITeamRepository)entry.getKey()).getRepositoryURI(), (PendingChangesUtil.PendingChangesOptions)options, (boolean)printHeader, (IndentingPrintStream)printStream);
                printHeader = false;
                continue;
            }
            jsonList.add(comp);
        }
        if (!((ScmClientConfiguration)config).isJSONEnabled()) {
            ConflictsCmd.printUnMatchedComponentsMessage(unMatchedComponents, printStream, true);
        } else if (((ScmClientConfiguration)config).isJSONEnabled()) {
            ConflictsCmd.printConflictsInJsonFormat(config, legacyDisplay, jsonList, true, unMatchedComponents);
        }
        throw StatusHelper.returnValue((int)11);
    }

    private void showConflictItemInfo(List<ConflictResult> conflictResults, IScmCommandLineArgument conflictItem, Mode conflictMode, boolean showContent, Property showProperty, String propertyName, IFilesystemRestClient client, IScmClientConfiguration config, String externalCompareTool) throws FileSystemException {
        ResourcePropertiesDTO resProp = null;
        IUuidAliasRegistry.IUuidAlias conflictAlias = null;
        ILocation path = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)conflictItem.getItemSelector());
        if (!SubcommandUtil.exists((ILocation)path, null)) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)conflictItem, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            conflictAlias = RepoUtil.lookupUuidAndAlias((String)conflictItem.getItemSelector());
        } else {
            resProp = RepoUtil.getResourceProperties((String)path.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        ConflictResult result = ConflictsCmd.findConflict(conflictResults, conflictAlias, resProp, config);
        if (result == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_2, (Object)conflictItem.getItemSelector()));
        }
        String itemId = null;
        String stateId = null;
        String stateMessageOnError = Messages.ConflictsCmd_ItemState_Deleted;
        switch (conflictMode) {
            case MINE: {
                itemId = result.itemId;
                stateId = result.stateId;
                break;
            }
            case PROPOSED: {
                itemId = result.conflict.getVersionableItemId();
                stateId = result.conflict.getProposedContributorVersionableStateId();
                break;
            }
            case ANCESTOR: {
                itemId = result.conflict.getVersionableItemId();
                stateId = result.conflict.getCommonAncestorVersionableStateId();
                stateMessageOnError = Messages.ConflictsCmd_NoCommonAncestor;
                break;
            }
            case COMPARE: {
                ResolveCmd.resolveExternally(result.conflict, client, config, config.getSubcommandCommandLine(), externalCompareTool);
                return;
            }
        }
        if (stateId == null) {
            config.getWrappedOutputStream().println((CharSequence)stateMessageOnError);
            return;
        }
        IndentingPrintStream printStream = config.getOutputStream();
        if (showContent) {
            printStream.println((CharSequence)Messages.ConflictsCmd_Content);
            this.showContent(result.conflict.getVersionableItemType(), itemId, stateId, path, result.repo, printStream.indent(), config, client, resProp);
        }
        if (showProperty != Property.NONE) {
            IVersionableHandle state = RepoUtil.getVersionableHandle((ITeamRepository)result.repo, (String)itemId, (String)stateId, (String)result.conflict.getVersionableItemType(), (IScmClientConfiguration)config);
            printStream.println((CharSequence)Messages.ConflictsCmd_Properties);
            this.showProperties(state, path, showProperty, propertyName, result.repo, printStream.indent(), config);
        }
    }

    private void showLocalConflictItemInfo(List<LocalConflictResult> conflictResults, IScmCommandLineArgument conflictItem, Mode conflictMode, boolean showContent, Property showProperty, String propertyName, IFilesystemRestClient client, IScmClientConfiguration config, String externalCompareTool) throws FileSystemException {
        ResourcePropertiesDTO resProp = null;
        IUuidAliasRegistry.IUuidAlias conflictAlias = null;
        ILocation path = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)conflictItem.getItemSelector());
        if (!SubcommandUtil.exists((ILocation)path, null)) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)conflictItem, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            conflictAlias = RepoUtil.lookupUuidAndAlias((String)conflictItem.getItemSelector());
        } else {
            resProp = RepoUtil.getResourceProperties((String)path.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        LocalConflictResult result = ConflictsCmd.findLocalConflict(conflictResults, conflictAlias, resProp, config);
        if (result == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_2, (Object)conflictItem.getItemSelector()));
        }
        String itemId = null;
        String stateId = null;
        String stateMessageOnError = null;
        switch (conflictMode) {
            case MINE: {
                itemId = result.itemId;
                break;
            }
            case PROPOSED: {
                itemId = result.conflict.getVersionableItemId();
                stateId = result.conflict.getProposedContributorVersionableStateId();
                break;
            }
            case ANCESTOR: {
                itemId = result.conflict.getVersionableItemId();
                stateId = result.conflict.getCommonAncestorVersionableStateId();
                stateMessageOnError = Messages.ConflictsCmd_NoCommonAncestor;
                break;
            }
            case COMPARE: {
                ResolveCmd.resolveExternally(result.conflict, client, config, config.getSubcommandCommandLine(), externalCompareTool);
                return;
            }
        }
        if (stateMessageOnError != null && stateId == null) {
            config.getWrappedOutputStream().println(stateMessageOnError);
            return;
        }
        IndentingPrintStream printStream = config.getOutputStream();
        if (showContent && !config.isJSONEnabled()) {
            printStream.println((CharSequence)Messages.ConflictsCmd_Content);
            this.showContent(result.conflict.getVersionableItemType(), itemId, stateId, path, result.repo, printStream.indent(), config, client, resProp);
        }
        if (showProperty != Property.NONE) {
            if (!config.isJSONEnabled()) {
                printStream.println((CharSequence)Messages.ConflictsCmd_Properties);
            }
            if (stateId != null) {
                IVersionableHandle state = RepoUtil.getVersionableHandle((ITeamRepository)result.repo, (String)itemId, (String)stateId, (String)result.conflict.getVersionableItemType(), (IScmClientConfiguration)config);
                this.showProperties(state, path, showProperty, propertyName, result.repo, printStream.indent(), config);
            } else if (resProp != null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                if (resProp.getUserProperties() != null) {
                    properties.putAll(resProp.getUserProperties());
                }
                if (resProp.getFileProperties() != null) {
                    this.addInternalProperties(properties, resProp.getFileProperties());
                }
                this.internalShowProperties(showProperty, propertyName, printStream.indent(), properties);
            }
        }
    }

    private void addInternalProperties(Map<String, String> properties, FilePropertiesDTO fileProperties) {
        properties.put("jazz.executable", Boolean.toString(fileProperties.isExecutable()));
        properties.put("jazz.line-delimiter", fileProperties.getLineDelimiter().toString());
        properties.put("jazz.mime", fileProperties.getContentType());
        properties.put("jazz.encoding", fileProperties.getOriginalEncoding());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showContent(String itemType, String itemId, String stateId, ILocation path, ITeamRepository repo, IndentingPrintStream printStream, IScmClientConfiguration config, IFilesystemRestClient client, ResourcePropertiesDTO resProp) throws FileSystemException {
        ByteArrayOutputStream out = null;
        String fileContents = null;
        try {
            block26: {
                block25: {
                    out = new ByteArrayOutputStream();
                    if (!itemType.equals("file")) break block25;
                    if (stateId != null) {
                        RepoUtil.httpDownloadFile((ITeamRepository)repo, (String)"-", (String)"-", (String)itemId, (String)stateId, (OutputStream)out, (IScmClientConfiguration)config);
                        break block26;
                    } else {
                        File file = new File(path.toOSString());
                        if (!file.exists()) {
                            return;
                        }
                        Charset streamEncoding = this.getEncodingFor(resProp);
                        BufferedInputStream in = null;
                        try {
                            try {
                                in = new BufferedInputStream(new FileInputStream(file));
                                RepoUtil.transfer((InputStream)in, (OutputStream)out);
                            }
                            catch (IOException e) {
                                this.safeClose(in);
                                this.safeClose(out);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            this.safeClose(in);
                            throw throwable;
                        }
                        this.safeClose(in);
                        try {
                            fileContents = out.toString(streamEncoding.name());
                        }
                        catch (UnsupportedEncodingException e) {
                            this.safeClose(out);
                            return;
                        }
                    }
                }
                if (!itemType.equals("symbolic_link")) return;
                if (stateId == null) return;
                IVersionableHandle verHandle = RepoUtil.getVersionableHandle((ITeamRepository)repo, (String)itemId, (String)stateId, (String)itemType, (IScmClientConfiguration)config);
                if (verHandle != null) {
                    ISymbolicLink symbolicLink;
                    try {
                        symbolicLink = (ISymbolicLink)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(verHandle, null);
                    }
                    catch (VersionablePermissionDeniedException e) {
                        throw StatusHelper.permissionFailure((String)Messages.Common_VERSIONABLE_PERMISSSION_DENIED);
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.ConflictsCmd_4, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
                    }
                    try {
                        out.write(symbolicLink.getTarget().getBytes(Charset.defaultCharset().name()));
                        out.flush();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e.getMessage(), e);
                    }
                }
            }
            if (fileContents != null) {
                printStream.print(fileContents);
                return;
            }
            printStream.println((CharSequence)out.toString());
            return;
        }
        finally {
            this.safeClose(out);
        }
    }

    private final void safeClose(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Charset getEncodingFor(ResourcePropertiesDTO resProp) {
        if (resProp != null && resProp.getFileProperties() != null) {
            String encoding = resProp.getFileProperties().getEncoding();
            return this.getEncoding(encoding);
        }
        return Charset.defaultCharset();
    }

    private Charset getEncoding(String encoding) {
        if (encoding != null && encoding.length() > 0) {
            try {
                if (encoding != null) {
                    return Charset.forName(encoding);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return Charset.defaultCharset();
    }

    private void showProperties(IVersionableHandle state, ILocation path, Property showProperty, String propertyGetName, ITeamRepository repo, IndentingPrintStream printStream, IScmClientConfiguration config) throws FileSystemException {
        IVersionable versionable = null;
        try {
            versionable = (IVersionable)RepoUtil.getVersionables(Collections.singletonList(state), (ITeamRepository)repo, (IScmClientConfiguration)config).get(0);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.CheckInCmd_PATH_NOT_IN_REMOTE, (Object)path.toOSString()), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        Map<String, String> properties = this.getInternalProperties(versionable);
        properties.putAll(versionable.getUserProperties());
        this.internalShowProperties(showProperty, propertyGetName, printStream, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalShowProperties(Property showProperty, String propertyGetName, IndentingPrintStream printStream, Map<String, String> properties) throws CLIFileSystemClientException {
        List<String> unMatchedComponents = this.getUnMatchedComponents();
        if (this.config.isJSONEnabled()) {
            JSONObject props = JSONPrintUtil.jsonizeProperties(properties, (Property)showProperty, (String)propertyGetName);
            if (unMatchedComponents != null && !unMatchedComponents.isEmpty()) {
                props.put((Object)"status", (Object)ConflictsCmd.createStatusMessage(unMatchedComponents));
            }
            this.config.getOutputStream().print((CharSequence)props.toString());
            return;
        } else {
            if (showProperty == Property.NAME_VALUE) {
                if (!properties.keySet().contains(propertyGetName)) throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.PropertyListCmd_CouldNotGetProperty, (Object)propertyGetName));
                printStream.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)propertyGetName, (Object)properties.get(propertyGetName)));
            } else {
                int maxWidth = 0;
                for (String propertyValue : properties.keySet()) {
                    maxWidth = Math.max(maxWidth, propertyValue.length());
                }
                TreeSet<String> propertyNames = new TreeSet<String>(properties.keySet());
                for (String propertyName : propertyNames) {
                    if (showProperty == Property.ALL) {
                        printStream.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)propertyName, (int)maxWidth), (Object)properties.get(propertyName)));
                        continue;
                    }
                    if (showProperty != Property.LIST_NAMES) continue;
                    printStream.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_Key, (Object)propertyName));
                }
            }
            ConflictsCmd.printUnMatchedComponentsMessage(unMatchedComponents, printStream, false);
        }
    }

    private Map<String, String> getInternalProperties(IVersionable versionable) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (versionable instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)versionable;
            properties.put("jazz.executable", Boolean.toString(fileItem.isExecutable()));
            properties.put("jazz.line-delimiter", fileItem.getContent().getLineDelimiter().toString());
            properties.put("jazz.mime", fileItem.getContentType());
            properties.put("jazz.encoding", fileItem.getContent().getCharacterEncoding());
        }
        return properties;
    }

    private List<ConflictResult> findConflicts(List<ParmsWorkspace> wsList, boolean hasComponentFilter, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        SyncViewDTO syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        List<ConflictResult> conflicts = this.getConflicts(syncView, hasComponentFilter);
        return conflicts;
    }

    private List<LocalConflictResult> findLocalConflicts(List<ParmsWorkspace> wsList, boolean hasComponentFilter, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        SyncViewDTO syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        List<LocalConflictResult> conflicts = this.getLocalConflicts(syncView, hasComponentFilter);
        return conflicts;
    }

    private static ConflictResult findConflict(List<ConflictResult> conflicts, IUuidAliasRegistry.IUuidAlias conflictAlias, ResourcePropertiesDTO resProp, IScmClientConfiguration config) {
        if (conflictAlias == null && resProp == null) {
            return null;
        }
        for (ConflictResult result : conflicts) {
            if ((conflictAlias == null || !conflictAlias.getUuid().getUuidValue().equals(result.itemId)) && (resProp == null || !resProp.getItemId().equals(result.itemId))) continue;
            return result;
        }
        return null;
    }

    private static LocalConflictResult findLocalConflict(List<LocalConflictResult> conflicts, IUuidAliasRegistry.IUuidAlias conflictAlias, ResourcePropertiesDTO resProp, IScmClientConfiguration config) {
        if (conflictAlias == null && resProp == null) {
            return null;
        }
        for (LocalConflictResult result : conflicts) {
            if ((conflictAlias == null || !conflictAlias.getUuid().getUuidValue().equals(result.itemId)) && (resProp == null || !resProp.getItemId().equals(result.itemId))) continue;
            return result;
        }
        return null;
    }

    public static ChangeSyncDTO matchPath(String conflictPath, List<ChangeSetSyncDTO> outgoingChangeSets) {
        for (ChangeSetSyncDTO csDTO : outgoingChangeSets) {
            for (ChangeFolderSyncDTO changeFolderDTO : csDTO.getChanges()) {
                for (ChangeSyncDTO changeDTO : changeFolderDTO.getChanges()) {
                    String pathToCompare = changeDTO.getPathHint();
                    if (changeDTO.isMoveType()) {
                        pathToCompare = changeDTO.getNewPathHint();
                    }
                    if (!pathToCompare.equalsIgnoreCase(conflictPath)) continue;
                    return changeDTO;
                }
            }
        }
        return null;
    }

    private void createSelectorListFromCompOpts(ICommandLine subargs) throws FileSystemException {
        List componentSelectors = null;
        componentSelectors = ScmCommandLineArgument.createList((List)subargs.getOptionValues((IOptionKey)ConflictsCmdOpts.OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)componentSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        for (IScmCommandLineArgument compSelector : componentSelectors) {
            IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector.getItemSelector());
            if (compAlias != null) {
                this.compSelectorToUUIDMap.put(compSelector.getItemSelector(), compAlias.getUuid());
                continue;
            }
            this.missingCompSelectors.add(compSelector.getItemSelector());
        }
    }

    private boolean matchComponentAgainstComponentFilter(ComponentSyncDTO compSync) {
        boolean componentFound = false;
        UUID compItemId = UUID.valueOf((String)compSync.getComponentItemId());
        if (this.compSelectorToUUIDMap.values().contains(compItemId)) {
            this.matchedCompIdSet.add(compItemId);
            componentFound = true;
        } else if (this.missingCompSelectors.contains(compSync.getComponentItemId())) {
            componentFound = true;
            this.matchedCompSelectors.add(compSync.getComponentItemId());
        } else if (this.missingCompSelectors.contains(compSync.getComponentName())) {
            componentFound = true;
            this.matchedCompSelectors.add(compSync.getComponentName());
        }
        return componentFound;
    }

    private List<LocalConflictResult> getLocalConflicts(SyncViewDTO srcSyncView, boolean filterComponents) {
        ArrayList<LocalConflictResult> conflictList = new ArrayList<LocalConflictResult>();
        for (WorkspaceSyncDTO wsSync : srcSyncView.getWorkspaces()) {
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                if (filterComponents && !this.matchComponentAgainstComponentFilter(compSync)) continue;
                for (UnresolvedFolderSyncDTO unresolvedSync : compSync.getUnresolved()) {
                    for (LocalConflictSyncDTO conflictSync : unresolvedSync.getLocalConflicts()) {
                        conflictList.add(new LocalConflictResult(conflictSync, RepoUtil.getSharedRepository((String)wsSync.getRepositoryUrl(), (boolean)false)));
                    }
                }
            }
        }
        return conflictList;
    }

    private List<ConflictResult> getConflicts(SyncViewDTO srcSyncView, boolean filterComponents) throws CLIFileSystemClientException {
        ArrayList<ConflictResult> conflicts = new ArrayList<ConflictResult>();
        for (WorkspaceSyncDTO wsSync : srcSyncView.getWorkspaces()) {
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                if (filterComponents && !this.matchComponentAgainstComponentFilter(compSync)) continue;
                for (UnresolvedFolderSyncDTO unresolvedSync : compSync.getUnresolved()) {
                    for (ConflictSyncDTO conflictSync : unresolvedSync.getConflicts()) {
                        if (!conflictSync.isSetCommonAncestorVersionableStateId()) {
                            ChangeSyncDTO changeDTO = ConflictsCmd.matchPath(conflictSync.getPathHint(), compSync.getOutgoingChangeSetsAfterBasis());
                            if (changeDTO != null) {
                                conflicts.add(new ConflictResult(conflictSync, RepoUtil.getSharedRepository((String)wsSync.getRepositoryUrl(), (boolean)false), changeDTO.getVersionableItemId(), changeDTO.getAfterStateId()));
                                continue;
                            }
                            throw StatusHelper.internalError((String)NLS.bind((String)Messages.ConflictsCmd_ConflictItem_NotFound, (Object)conflictSync.getPathHint()));
                        }
                        conflicts.add(new ConflictResult(conflictSync, RepoUtil.getSharedRepository((String)wsSync.getRepositoryUrl(), (boolean)false)));
                    }
                }
            }
        }
        return conflicts;
    }

    private List<String> getUnMatchedComponents() {
        ArrayList<String> unMatchedComponents = new ArrayList<String>();
        Collection<UUID> compItemIdSet = this.compSelectorToUUIDMap.values();
        compItemIdSet.removeAll(this.matchedCompIdSet);
        this.missingCompSelectors.removeAll(this.matchedCompSelectors);
        for (UUID uuid : compItemIdSet) {
            for (Map.Entry<String, UUID> entry : this.compSelectorToUUIDMap.entrySet()) {
                if (!entry.getValue().equals((Object)uuid)) continue;
                unMatchedComponents.add(entry.getKey());
            }
        }
        unMatchedComponents.addAll(this.missingCompSelectors);
        return unMatchedComponents;
    }

    private static void printConflictsInJsonFormat(IScmClientConfiguration config, boolean legacyDisplay, List<JSONObject> jsonConflictList, boolean isLocalConflict, List<String> unMatchedComponents) {
        String nodeName;
        String string = nodeName = isLocalConflict ? "local-conflicts" : "conflicts";
        if (!legacyDisplay) {
            JSONObject root = new JSONObject();
            JSONArray conflictsArray = new JSONArray();
            for (JSONObject jsonObj : jsonConflictList) {
                conflictsArray.add(jsonObj.get((Object)nodeName));
            }
            root.put((Object)nodeName, (Object)conflictsArray);
            if (unMatchedComponents != null && unMatchedComponents.size() > 0) {
                root.put((Object)"status", (Object)ConflictsCmd.createStatusMessage(unMatchedComponents));
            }
            config.getOutputStream().print((CharSequence)root.toString());
        } else {
            for (JSONObject jsonObj : jsonConflictList) {
                JSONArray conflictsArray = (JSONArray)jsonObj.get((Object)nodeName);
                for (Object conflictObj : conflictsArray) {
                    JSONObject conflict = (JSONObject)conflictObj;
                    if (unMatchedComponents == null || unMatchedComponents.size() <= 0) continue;
                    conflict.put((Object)"status", (Object)ConflictsCmd.createStatusMessage(unMatchedComponents));
                }
                config.getOutputStream().print((CharSequence)jsonObj.toString());
            }
        }
    }

    private static void printUnMatchedComponentsMessage(List<String> unMatchedCompList, IndentingPrintStream iPrintStream, boolean displayConflictMessage) {
        if (unMatchedCompList != null && unMatchedCompList.size() > 0) {
            iPrintStream.println((CharSequence)Messages.ConflictsCmd_Components_NotFound1);
            IndentingPrintStream indentPrntStr = iPrintStream.indent();
            for (String comp : unMatchedCompList) {
                indentPrntStr.println((CharSequence)comp);
            }
        }
        if (displayConflictMessage) {
            iPrintStream.println((CharSequence)Messages.ConflictsCmd_10);
        }
    }

    private static class ConflictResult {
        final ITeamRepository repo;
        final ConflictSyncDTO conflict;
        final String itemId;
        final String stateId;

        ConflictResult(ConflictSyncDTO conflict, ITeamRepository repo) {
            this.conflict = conflict;
            this.repo = repo;
            this.itemId = conflict.getVersionableItemId();
            this.stateId = conflict.getOriginalSelectedContributorVersionableStateId();
        }

        ConflictResult(ConflictSyncDTO conflict, ITeamRepository repo, String itemId, String stateId) {
            this.conflict = conflict;
            this.repo = repo;
            this.itemId = itemId;
            this.stateId = stateId;
        }
    }

    private static class LocalConflictResult {
        final ITeamRepository repo;
        final LocalConflictSyncDTO conflict;
        final String itemId;

        LocalConflictResult(LocalConflictSyncDTO conflict, ITeamRepository repo) {
            this.conflict = conflict;
            this.repo = repo;
            this.itemId = conflict.getVersionableItemId();
        }
    }

    static enum Mode {
        MINE,
        PROPOSED,
        ANCESTOR,
        COMPARE;

    }
}

