/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.CompareCmdOpts;
import com.ibm.team.filesystem.cli.client.util.CliChangeLogStreamOutput;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.snapshot.FlowType;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeLogCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompareCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContext;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogBaselineEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogChangeSetEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogComponentEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogDirectionEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogOslcLinkEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntry2DTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogVersionableEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogWorkItemEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.rcp.core.internal.changelog.BaseChangeLogEntryVisitor;
import com.ibm.team.filesystem.rcp.core.internal.changelog.ChangeLogCustomizer;
import com.ibm.team.filesystem.rcp.core.internal.changelog.IChangeLogOutput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentReference;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHistoryReferenceDescription;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class CompareCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument repoSelector = null;
        CompareType type1 = this.findType(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPARE_TYPE_1));
        CompareType type2 = this.findType(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_COMPARE_TYPE_2));
        repoSelector = type2.equals((Object)CompareType.STREAM) ? ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_2), (IScmClientConfiguration)this.config) : (type1.equals((Object)CompareType.STREAM) ? ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_1), (IScmClientConfiguration)this.config) : (type1.equals((Object)CompareType.WORKSPACE) ? ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_1), (IScmClientConfiguration)this.config) : ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_1), (IScmClientConfiguration)this.config)));
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)repoSelector);
        ArrayList<ScmCommandLineArgument> componentArgSelectors = null;
        if (subargs.hasOption((IOptionKey)CompareCmdOpts.OPT_COMPONENTS)) {
            componentArgSelectors = ScmCommandLineArgument.createList((List)subargs.getOptionValues((IOptionKey)CompareCmdOpts.OPT_COMPONENTS), (IScmClientConfiguration)this.config);
        } else if (subargs.hasOption((IOptionKey)CompareCmdOpts.OPT_COMPONENT)) {
            componentArgSelectors = new ArrayList<ScmCommandLineArgument>(1);
            componentArgSelectors.add(ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPONENT, null), (IScmClientConfiguration)this.config));
        }
        if ((type1.equals((Object)CompareType.BASELINE) || type2.equals((Object)CompareType.BASELINE)) && componentArgSelectors != null && componentArgSelectors.size() > 1) {
            throw StatusHelper.argSyntax((String)Messages.CompareCmd_BASELINE_SPECIFY_ONE_COMPONENT);
        }
        ArrayList<String> componentSelectors1 = null;
        if (componentArgSelectors != null) {
            SubcommandUtil.validateArgument(componentArgSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            componentSelectors1 = RepoUtil.getSelectors(componentArgSelectors);
        }
        ArrayList<String> unresolvedComponentSelectors = new ArrayList<String>();
        ScmCommandLineArgument item1Selector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_1), (IScmClientConfiguration)this.config);
        CompareItem item1 = this.resolveItem(type1, (IScmCommandLineArgument)item1Selector, (List<String>)componentSelectors1, unresolvedComponentSelectors, client, this.config);
        ArrayList<String> componentSelectors2 = null;
        if (type2.equals((Object)CompareType.BASELINE)) {
            componentSelectors2 = componentSelectors1;
        } else if (!unresolvedComponentSelectors.isEmpty()) {
            componentSelectors2 = new ArrayList<String>(unresolvedComponentSelectors.size());
            componentSelectors2.addAll(unresolvedComponentSelectors);
            unresolvedComponentSelectors.clear();
        }
        ScmCommandLineArgument item2Selector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CompareCmdOpts.OPT_COMPARE_ITEM_2), (IScmClientConfiguration)this.config);
        CompareItem item2 = this.resolveItem(type2, (IScmCommandLineArgument)item2Selector, componentSelectors2, unresolvedComponentSelectors, client, this.config);
        if (!unresolvedComponentSelectors.isEmpty()) {
            String message = NLS.bind((String)Messages.CompareCmd_COMPONENTS_NOT_FOUND, (Object)item1.name, (Object)item2.name);
            if (this.config.isJSONEnabled()) {
                JSONObject errorJson = new JSONObject();
                errorJson.put((Object)"message", (Object)message);
                JSONArray unresolvedComponents = new JSONArray();
                for (String componentSelector : unresolvedComponentSelectors) {
                    unresolvedComponents.add((Object)componentSelector);
                }
                errorJson.put((Object)"content", (Object)unresolvedComponents);
                this.config.getErrorStream().println((CharSequence)errorJson.toString());
            } else {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)message);
                err.indent();
                for (String componentSelector : unresolvedComponentSelectors) {
                    err.println((CharSequence)componentSelector);
                }
            }
            throw StatusHelper.ambiguousSelector((String)Messages.CompareCmd_UNRESOLVED_COMPONENTS);
        }
        ChangeLogEntryDTO changelog = null;
        ChangeLogCustomizer customizer = this.createChangeLogParms(subargs, this.config);
        ArrayList<String> componentIds = new ArrayList<String>();
        String[] componentIdsArray = null;
        if (!type1.equals((Object)CompareType.BASELINE) && componentArgSelectors != null) {
            if (componentSelectors1 != null) {
                componentIds.addAll(componentSelectors1);
            }
            if (componentSelectors2 != null) {
                componentIds.addAll(componentSelectors2);
            }
            componentIdsArray = componentIds.toArray(new String[componentIds.size()]);
        }
        changelog = this.doCompare(item1, item2, componentIdsArray, customizer);
        CLIChangeLogEntryVisitor visitor = new CLIChangeLogEntryVisitor(new CliChangeLogStreamOutput(this.config.getWrappedOutputStream()), repo.getRepositoryURI(), this.config);
        visitor.setContributorFormat(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_FMT_CONTRIB, visitor.getContribFormat()));
        SimpleDateFormat sdf = SubcommandUtil.getDateFormat((String)visitor.getDateFormat(), (IScmClientConfiguration)this.config);
        visitor.setDateFormat(subargs.getOption((IOptionKey)CompareCmdOpts.OPT_FMT_DATE, sdf.toPattern()));
        boolean shouldShowFullVersionId = this.findShouldShowVersionIdentifier(subargs, true);
        visitor.setShowFullVersionIDs(shouldShowFullVersionId);
        if (shouldShowFullVersionId || this.findShouldShowVersionIdentifier(subargs, false)) {
            visitor.setShowVersionIDs(true);
        }
        if (!this.config.isJSONEnabled()) {
            boolean shouldShowContrib = this.findShouldShowContrib(subargs);
            boolean shouldShowDate = this.findShouldShowDate(subargs);
            boolean shouldShowChangeSetWorkItems = this.findShouldShowChangeSetWorkItems(subargs);
            boolean shouldShowFlowDirection = this.findShouldShowFlowDirection(subargs);
            boolean shouldShowChangeSetOslcLinks = this.findShouldShowChangeSetOslcLinks(subargs);
            visitor.setShowBaselineCreationDate(shouldShowDate);
            visitor.setShowChangeSetCreationDate(shouldShowDate);
            visitor.setShowBaselineCreator(shouldShowContrib);
            visitor.setShowChangeSetCreator(shouldShowContrib);
            visitor.setShowChangeSetWorkItems(shouldShowChangeSetWorkItems);
            visitor.setShowChangeSetOslcLinks(shouldShowChangeSetOslcLinks);
            visitor.setShowDirectionNodes(shouldShowFlowDirection);
        }
        JSONObject obj = new JSONObject();
        visitor.acceptInto(changelog, obj);
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)obj.toString());
        }
    }

    private ChangeLogEntryDTO doCompare(CompareItem item1, CompareItem item2, String[] componentIds, ChangeLogCustomizer customizer) throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsCompareCE parmsCompare = new ParmsCompareCE();
        parmsCompare.context1 = item1.getParmsContext();
        parmsCompare.context2 = item2.getParmsContext();
        parmsCompare.includedComponents = componentIds;
        String compareId = null;
        try {
            compareId = client.postCompareCE(parmsCompare, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DeliverCmd_ERROR_ON_WS_COMPARE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        ParmsChangeLogCE parmsChangeLog = new ParmsChangeLogCE();
        parmsChangeLog.inputID = compareId;
        String flowDirection = customizer.shouldIncludeOutgoing() && !customizer.shouldIncludeIncoming() ? "outgoing" : (!customizer.shouldIncludeOutgoing() && customizer.shouldIncludeIncoming() ? "incoming" : "incoming_outgoing");
        parmsChangeLog.flowDirection = flowDirection;
        parmsChangeLog.includeChangeSets = customizer.shouldIncludeChangeSets();
        parmsChangeLog.includeBaselines = customizer.shouldIncludeBaselines();
        parmsChangeLog.flowDirection = flowDirection;
        parmsChangeLog.includeComponents = customizer.shouldIncludeComponents();
        parmsChangeLog.includeContributors = customizer.shouldIncludeContributors();
        parmsChangeLog.includeDirection = customizer.shouldIncludeDirection();
        parmsChangeLog.includePaths = customizer.shouldIncludePaths();
        parmsChangeLog.includeWorkItems = customizer.shouldIncludeWorkItems();
        parmsChangeLog.pruneEmptyDirections = customizer.shouldPruneEmptyDirections();
        parmsChangeLog.pruneUnchangedComponents = customizer.shouldPruneUnchangedComponents();
        parmsChangeLog.includeOslcLinks = customizer.shouldIncludeOslcLinks();
        parmsChangeLog.includeVersionIdentifiers = customizer.shouldIncludeVersionIdentifiers() || customizer.shouldIncludeFullVersionIdentifiers();
        parmsChangeLog.useRepositoryPathsOnly = customizer.shouldUseRepositoryPathsOnly();
        ChangeLogEntryDTO changeLogEntry = null;
        try {
            changeLogEntry = client.getChangeLogCE(parmsChangeLog, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DeliverCmd_ERROR_ON_GET_CHANGELOG, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        return changeLogEntry;
    }

    private ChangeLogCustomizer createChangeLogParms(ICommandLine subargs, IScmClientConfiguration config) throws FileSystemException {
        String filter;
        ChangeLogCustomizer customizer = new ChangeLogCustomizer();
        String show = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_SHOW, "dcbswo");
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cdo");
        SwitchString ssDisplay = new SwitchString(display);
        if (show.contains("A")) {
            customizer.setIncludeDirection(true);
            customizer.setIncludeBaselines(true);
            customizer.setIncludeChangeSets(true);
            customizer.setIncludeComponents(true);
            customizer.setIncludePaths(true);
            customizer.setIncludeWorkItems(true);
            customizer.setIncludeOslcLinks(true);
            this.setVersionIdentifier(ssDisplay, customizer);
        } else {
            SwitchString ssShow = new SwitchString(show);
            customizer.setIncludeDirection(ssShow.contains("d"));
            customizer.setIncludeBaselines(ssShow.contains("b"));
            customizer.setIncludeChangeSets(ssShow.contains("s"));
            customizer.setIncludeComponents(ssShow.contains("c"));
            customizer.setIncludePaths(ssShow.contains("f"));
            customizer.setIncludeWorkItems(ssShow.contains("w"));
            customizer.setIncludeOslcLinks(ssShow.contains("o"));
            this.setVersionIdentifier(ssDisplay, customizer);
            if (ssShow.getRemainder().length() > 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_BAD_INCLUDE_SWITCHES, (Object)ssShow.getRemainder()));
            }
        }
        String dir = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DIRECTIONS, null);
        if (dir == null || "b".equals(dir)) {
            customizer.setFlowsToInclude(FlowType.Both);
        } else if ("i".equals(dir)) {
            customizer.setFlowsToInclude(FlowType.Incoming);
        } else if ("o".equals(dir)) {
            customizer.setFlowsToInclude(FlowType.Outgoing);
        } else {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_BAD_FLOW_DIRECTION, (Object[])new String[]{dir, "b", "i", "o"}));
        }
        String reroot = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_REROOT, null);
        if (reroot != null) {
            if ("r".equals(reroot = reroot.trim())) {
                customizer.setWorkItemRerootDepth("clentry_root");
            } else if ("d".equals(reroot)) {
                customizer.setWorkItemRerootDepth("clentry_direction");
            } else if ("c".equals(reroot)) {
                customizer.setWorkItemRerootDepth("clentry_component");
            } else if ("b".equals(reroot)) {
                customizer.setWorkItemRerootDepth("clentry_baseline");
            } else {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_UNKNOWN_REROOT_TYPE, (Object[])new String[]{reroot, "r", "d", "c", "b"}));
            }
        }
        if ((filter = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_PRUNE, null)) != null) {
            SwitchString ss = new SwitchString(filter);
            customizer.setPruneEmptyDirections(ss.contains("d"));
            customizer.setPruneUnchangedComponents(ss.contains("c"));
            if (ss.getRemainder().length() > 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_BAD_PRUNE_SWITCHES, (Object)ss.getRemainder()));
            }
        }
        customizer.setUseRepositoryPathsOnly(!subargs.hasOption((IOptionKey)CompareCmdOpts.OPT_SANDBOX_PATH));
        return customizer;
    }

    private void setVersionIdentifier(SwitchString ss, ChangeLogCustomizer customizer) {
        if (ss.contains("V")) {
            customizer.setIncludeFullVersionIdentifiers(true);
        } else if (ss.contains("v")) {
            customizer.setIncludeVersionIdentifiers(true);
        }
    }

    private boolean findShouldShowFlowDirection(ICommandLine subargs) {
        String show = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_SHOW, "dcbswo");
        return show.contains("d") || "A".equals(show);
    }

    private boolean findShouldShowContrib(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cdo");
        return display.contains("c");
    }

    private boolean findShouldShowDate(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cdo");
        return display.contains("d");
    }

    private boolean findShouldShowChangeSetWorkItems(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cdo");
        return display.contains("i");
    }

    private boolean findShouldShowChangeSetOslcLinks(ICommandLine subargs) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cdo");
        return display.contains("o");
    }

    private boolean findShouldShowVersionIdentifier(ICommandLine subargs, boolean longVersionId) {
        String display = subargs.getOption((IOptionKey)CompareCmdOpts.OPT_DISPLAY, "cdo");
        String displayOption = longVersionId ? "V" : "v";
        return display.contains(displayOption);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CompareItem resolveItem(CompareType type, IScmCommandLineArgument selector, List<String> componentSelectors, List<String> unresolvedComponentSelectors, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        CompareItem item = null;
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
        switch (type) {
            case HISTORY_REFERENCE: {
                IAlias alias = RepoUtil.lookupByIdOrAlias((String)selector.getItemSelector(), (String)repo.getRepositoryURI());
                if (alias == null) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_INVALID_ALIAS_UUID, (Object)selector.getItemSelector()));
                }
                if (!alias.getItemType().equals((Object)RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE)) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)selector.getItemSelector()));
                }
                ParmsHistoryReference historyRefParms = SubcommandUtil.createParmsHistoryReference((String)alias.getId(), (String)repo.getRepositoryURI());
                if (historyRefParms == null) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)alias.getId()));
                }
                IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
                IScmRichClientRestService.ParmsGetHistoryDescription parms = new IScmRichClientRestService.ParmsGetHistoryDescription();
                parms.historyReferenceId = alias.getId();
                parms.historyReferenceType = "WorkspaceComponentState";
                String wsName = null;
                HashMap<String, String> componentIdToName = new HashMap<String, String>();
                try {
                    ScmHistoryReferenceDescription description = scmService.postGetHistoryDescription(parms);
                    wsName = description.getName() != null ? description.getName() : NLS.bind((String)Messages.WorkspaceHistory_DeletedItem, (Object)historyRefParms.workspaceId);
                    for (ScmComponentReference component : description.getComponents()) {
                        componentIdToName.put(component.getComponent(), component.getName());
                    }
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)e.getMessage(), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
                }
                item = new CompareItem(type, alias.getId(), repo, wsName);
                this.validateComponents(componentIdToName, componentSelectors, unresolvedComponentSelectors);
                return item;
            }
            case WORKSPACE: 
            case STREAM: {
                RepoUtil.ItemType itemType = type.equals((Object)CompareType.WORKSPACE) ? RepoUtil.ItemType.WORKSPACE : RepoUtil.ItemType.STREAM;
                boolean isWorkspace = type.equals((Object)CompareType.WORKSPACE);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)itemType);
                IWorkspace ws = RepoUtil.getWorkspace((String)selector.getItemSelector(), (boolean)isWorkspace, (!isWorkspace ? 1 : 0) != 0, (ITeamRepository)repo, (IScmClientConfiguration)config);
                String wsName = AliasUtil.selector((String)ws.getName(), (UUID)ws.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)itemType);
                item = new CompareItem(type, ws.getItemHandle(), repo, wsName);
                ParmsWorkspace parmsWorkspace = new ParmsWorkspace(repo, (IWorkspaceHandle)ws);
                WorkspaceDetailsDTO wsDetails = RepoUtil.getWorkspaceDetail((ParmsWorkspace)parmsWorkspace, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                HashMap<String, String> componentIdToName = new HashMap<String, String>(wsDetails.getComponents().size());
                for (WorkspaceComponentDTO componentDTO : wsDetails.getComponents()) {
                    componentIdToName.put(componentDTO.getItemId(), componentDTO.getName());
                }
                this.validateComponents(componentIdToName, componentSelectors, unresolvedComponentSelectors);
                return item;
            }
            case BASELINE: {
                IBaseline bl;
                SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
                if (componentSelectors == null) {
                    IUuidAliasRegistry.IUuidAlias blAlias = RepoUtil.lookupUuidAndAlias((String)selector.getItemSelector(), (String)repo.getRepositoryURI());
                    if (blAlias == null) throw StatusHelper.argSyntax((String)Messages.CompareCmd_SPECIFY_COMPONENT);
                    BaselineDTO blDTO = RepoUtil.getBaselineById((String)blAlias.getUuid().getUuidValue(), (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    if (blDTO == null) {
                        throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_UNMATCHED_BASELINE_OR_COMP_MISSING, (Object)selector.getItemSelector(), (Object)CompareCmdOpts.OPT_COMPONENTS.getLongOpt()));
                    }
                    bl = (IBaseline)RepoUtil.getItem((IItemType)IBaseline.ITEM_TYPE, (UUID)UUID.valueOf((String)blDTO.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)config);
                } else {
                    IComponent comp = RepoUtil.getComponent((String)componentSelectors.get(0), (ITeamRepository)repo, (IScmClientConfiguration)config);
                    componentSelectors.set(0, comp.getItemId().getUuidValue());
                    bl = RepoUtil.getBaseline((String)selector.getItemSelector(), (String)comp.getItemId().getUuidValue(), (String)comp.getName(), (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                }
                String blName = AliasUtil.selector((String)bl.getName(), (UUID)bl.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
                return new CompareItem(type, bl.getItemHandle(), repo, blName);
            }
            case SNAPSHOT: {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
                IBaselineSet baselineSet = RepoUtil.getSnapshot(null, (String)selector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                String snapshotName = AliasUtil.selector((String)baselineSet.getName(), (UUID)baselineSet.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
                item = new CompareItem(type, baselineSet.getItemHandle(), repo, snapshotName);
                ArrayList<String> blIdList = new ArrayList<String>(baselineSet.getBaselines().size());
                for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
                    blIdList.add(baselineHandle.getItemId().getUuidValue());
                }
                List blDTOList = RepoUtil.getBaselinesById(blIdList, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                HashMap<String, String> componentIdToName = new HashMap<String, String>();
                for (BaselineDTO baselineDTO : blDTOList) {
                    componentIdToName.put(baselineDTO.getComponentItemId(), baselineDTO.getComponentName());
                }
                this.validateComponents(componentIdToName, componentSelectors, unresolvedComponentSelectors);
            }
        }
        return item;
    }

    private void validateComponents(Map<String, String> componentIdToName, List<String> componentSelectors, List<String> unresolvedComponentSelectors) throws CLIFileSystemClientException {
        if (componentSelectors == null) {
            return;
        }
        int index = 0;
        while (index < componentSelectors.size()) {
            String uuid;
            String componentSelector = componentSelectors.get(index);
            IUuidAliasRegistry.IUuidAlias alias = RepoUtil.lookupUuidAndAlias((String)componentSelector);
            if (alias != null) {
                uuid = alias.getUuid().getUuidValue();
                if (!componentIdToName.containsKey(uuid)) {
                    unresolvedComponentSelectors.add(componentSelector);
                } else {
                    componentSelectors.set(index, uuid);
                }
            } else {
                uuid = null;
                for (Map.Entry<String, String> entryMap : componentIdToName.entrySet()) {
                    if (!entryMap.getValue().equals(componentSelector)) continue;
                    uuid = entryMap.getKey();
                    break;
                }
                if (uuid != null) {
                    componentSelectors.set(index, uuid);
                } else {
                    unresolvedComponentSelectors.add(componentSelector);
                }
            }
            ++index;
        }
        componentSelectors.removeAll(unresolvedComponentSelectors);
    }

    private CompareType findType(String typeString) throws FileSystemException {
        CompareType[] compareTypeArray = CompareType.values();
        int n = compareTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareType t = compareTypeArray[n2];
            String[] stringArray = t.getNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String candidate = stringArray[n4];
                if (candidate.equals(typeString)) {
                    return t;
                }
                ++n4;
            }
            ++n2;
        }
        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CompareCmd_UNKNOWN_TYPE_STRING, (Object[])new String[]{typeString, CompareType.NAMES[0], CompareType.NAMES[1], CompareType.NAMES[2], CompareType.NAMES[3], CompareType.NAMES[4]}));
    }

    private static class CLIChangeLogEntryVisitor
    extends BaseChangeLogEntryVisitor {
        String repoUri;
        IScmClientConfiguration config = null;
        JSONObject currJsonObj = null;

        public CLIChangeLogEntryVisitor(IChangeLogOutput out, String repoUri, IScmClientConfiguration config) {
            this.setOutput(out);
            this.repoUri = repoUri;
            this.config = config;
        }

        private void jsonizeDTO(ChangeLogEntryDTO dto, JSONObject obj) {
            obj.put((Object)"name", (Object)dto.getEntryName());
            obj.put((Object)"uuid", (Object)dto.getItemId());
            obj.put((Object)"url", (Object)this.repoUri);
        }

        protected String findComponentName(ChangeLogComponentEntryDTO dto) {
            return AliasUtil.selector((String)dto.getEntryName(), (UUID)UUID.valueOf((String)dto.getItemId()), (String)this.repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }

        protected String findChangeSetName(ChangeLogChangeSetEntryDTO dto) {
            String alias = AliasUtil.alias((String)dto.getItemId(), (String)this.repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            if (alias != null && alias.length() > 0) {
                return NLS.bind((String)Messages.CompareCmd_CHANGESET_ALIAS_AND_NAME, (Object)alias, (Object)super.findChangeSetName(dto));
            }
            return super.findChangeSetName(dto);
        }

        protected String findBaselineName(ChangeLogBaselineEntryDTO dto, boolean printCreator, boolean printCreationDate, boolean printItemIDs) {
            String alias = AliasUtil.alias((String)dto.getItemId(), (String)this.repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            if (alias != null && alias.length() > 0) {
                return NLS.bind((String)Messages.CompareCmd_CHANGESET_ALIAS_AND_NAME, (Object)alias, (Object)super.findBaselineName(dto, true, true, true));
            }
            return super.findBaselineName(dto, true, true, true);
        }

        protected String findVersionableName(ChangeLogVersionableEntryDTO dto) {
            if (this.config.getAliasConfig().showUuid()) {
                String itemIdStr = NLS.bind((String)Messages.Common_SURROUND_PARANTHESIS, (Object)dto.getItemId());
                return NLS.bind((String)Messages.CompareCmd_CHANGESET_ALIAS_AND_NAME, (Object)itemIdStr, (Object)super.findVersionableName(dto));
            }
            return super.findVersionableName(dto);
        }

        protected String findWorkItemName(ChangeLogWorkItemEntryDTO dto) {
            String alias = AliasUtil.alias((String)dto.getItemId(), (String)this.repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.WORKITEM);
            if (alias != null && alias.length() > 0) {
                return NLS.bind((String)Messages.CompareCmd_CHANGESET_ALIAS_AND_NAME, (Object)alias, (Object)super.findWorkItemName(dto));
            }
            return super.findWorkItemName(dto);
        }

        public void acceptInto(ChangeLogEntryDTO root, JSONObject jObj) {
            if (!this.enter(root)) {
                return;
            }
            if ("clentry_changeset".equals(root.getEntryType())) {
                ChangeLogChangeSetEntryDTO cs = (ChangeLogChangeSetEntryDTO)root;
                JSONArray wiArray = new JSONArray();
                for (ChangeLogWorkItemEntryDTO wi : cs.getWorkItems()) {
                    JSONObject wiObj = this.createEntry(root, (ChangeLogEntryDTO)wi);
                    if (wiObj.size() <= 0) continue;
                    wiArray.add((Object)wiObj);
                }
                if (wiArray.size() > 0) {
                    jObj.put((Object)"workitems", (Object)wiArray);
                }
                JSONArray oslcArray = new JSONArray();
                for (ChangeLogOslcLinkEntryDTO link : cs.getOslcLinks()) {
                    JSONObject wiObj = this.createEntry(root, (ChangeLogEntryDTO)link);
                    if (wiObj.size() <= 0) continue;
                    oslcArray.add((Object)wiObj);
                }
                if (oslcArray.size() > 0) {
                    jObj.put((Object)"change-requests", (Object)oslcArray);
                }
            }
            for (ChangeLogEntryDTO child : root.getChildEntries()) {
                JSONObject childObj;
                String entryType = CLIChangeLogEntryVisitor.getEntryType(child);
                JSONArray childArray = (JSONArray)jObj.get((Object)entryType);
                if (childArray == null) {
                    childArray = new JSONArray();
                    jObj.put((Object)entryType, (Object)childArray);
                }
                if ((childObj = this.createEntry(root, child)).size() <= 0) continue;
                childArray.add((Object)childObj);
            }
            this.exit(root);
        }

        public JSONObject createEntry(ChangeLogEntryDTO root, ChangeLogEntryDTO child) {
            JSONObject jobj;
            this.currJsonObj = jobj = new JSONObject();
            this.visitChild(root, child);
            JSONArray arr = new JSONArray();
            String entryType = CLIChangeLogEntryVisitor.getEntryType(child);
            jobj.put((Object)entryType, (Object)arr);
            this.acceptInto(child, jobj);
            if (arr.size() == 0) {
                jobj.remove((Object)entryType);
            }
            return jobj;
        }

        protected void visitDirection(ChangeLogEntryDTO parent, ChangeLogDirectionEntryDTO dto) {
            if (!this.config.isJSONEnabled()) {
                super.visitDirection(parent, dto);
                return;
            }
            if (this.getShowDirectionNodes()) {
                boolean incoming = true;
                boolean outgoing = false;
                if (!"incoming".equals(dto.getFlowDirection())) {
                    incoming = false;
                    outgoing = true;
                }
                this.currJsonObj.put((Object)"incoming-changes", (Object)incoming);
                this.currJsonObj.put((Object)"outgoing-changes", (Object)outgoing);
            }
        }

        protected void visitComponent(ChangeLogEntryDTO parent, ChangeLogComponentEntryDTO dto) {
            if (!this.config.isJSONEnabled()) {
                super.visitComponent(parent, dto);
                return;
            }
            this.currJsonObj.put((Object)"item-type", (Object)"component");
            this.jsonizeDTO((ChangeLogEntryDTO)dto, this.currJsonObj);
            if ("addComponent".equals(dto.getChangeType())) {
                this.currJsonObj.put((Object)"added", (Object)true);
                this.currJsonObj.put((Object)"removed", (Object)false);
            } else if ("removeComponent".equals(dto.getChangeType())) {
                this.currJsonObj.put((Object)"removed", (Object)true);
                this.currJsonObj.put((Object)"added", (Object)false);
            } else {
                this.currJsonObj.put((Object)"added", (Object)false);
                this.currJsonObj.put((Object)"removed", (Object)false);
            }
        }

        protected void visitChangeSet(ChangeLogEntryDTO parent, ChangeLogChangeSetEntryDTO dto) {
            if (!this.config.isJSONEnabled()) {
                super.visitChangeSet(parent, dto);
                return;
            }
            this.currJsonObj.put((Object)"item-type", (Object)"changeset");
            if (dto.getEntryName() != null) {
                this.currJsonObj.put((Object)"comment", (Object)dto.getEntryName());
            }
            this.currJsonObj.put((Object)"url", (Object)this.repoUri);
            this.currJsonObj.put((Object)"uuid", (Object)dto.getItemId());
            if (dto.getWorkItems().size() > 0) {
                JSONArray wiArray = new JSONArray();
                for (ChangeLogWorkItemEntryDTO wi : dto.getWorkItems()) {
                    JSONObject wiObj = new JSONObject();
                    wiObj.put((Object)"item-type", (Object)"workitem");
                    wiObj.put((Object)"uuid", (Object)wi.getItemId());
                    wiObj.put((Object)"url", (Object)this.repoUri);
                    wiObj.put((Object)"workitem-number", (Object)wi.getWorkItemNumber());
                    wiObj.put((Object)"workitem-label", (Object)wi.getEntryName());
                    wiArray.add((Object)wiObj);
                }
                if (wiArray.size() > 0) {
                    this.currJsonObj.put((Object)"workitems", (Object)wiArray);
                }
            }
            if (dto.getOslcLinks().size() > 0) {
                JSONArray oslcLinksArray = new JSONArray();
                for (ChangeLogOslcLinkEntryDTO oL : dto.getOslcLinks()) {
                    JSONObject olObj = new JSONObject();
                    String oslcLabel = oL.getEntryName();
                    oslcLabel = SubcommandUtil.sanitizeHTMLText((String)oslcLabel);
                    JSONPrintUtil.ChangeRequestInfo oslcInfo = new JSONPrintUtil.ChangeRequestInfo(oslcLabel);
                    olObj.put((Object)"info", (Object)oslcInfo.getDisplayString(true));
                    String targetUri = oL.getTargetUri();
                    if (targetUri == null) {
                        olObj.put((Object)"target-uri", (Object)com.ibm.team.filesystem.cli.core.internal.Messages.PendingChangesUtil_NO_TARGET_URI);
                    } else {
                        olObj.put((Object)"target-uri", (Object)targetUri);
                    }
                    oslcLinksArray.add((Object)olObj);
                }
                if (oslcLinksArray.size() > 0) {
                    this.currJsonObj.put((Object)"change-requests", (Object)oslcLinksArray);
                }
            }
            if (this.getShowChangeSetCreator() && dto.getCreator() != null) {
                JSONObject creatorObj = new JSONObject();
                creatorObj.put((Object)"userId", (Object)dto.getCreator().getUserId());
                creatorObj.put((Object)"userName", (Object)dto.getCreator().getFullName());
                creatorObj.put((Object)"mail", (Object)dto.getCreator().getEmailAddress());
                creatorObj.put((Object)"uuid", (Object)dto.getCreator().getContributorItemId());
                this.currJsonObj.put((Object)"author", (Object)creatorObj);
            }
            if (this.getShowChangeSetCreationDate() && dto.getCreationDate() != 0L) {
                SimpleDateFormat formatter = new SimpleDateFormat(this.getDateFormat());
                String date = formatter.format(dto.getCreationDate());
                this.currJsonObj.put((Object)"creationDate", (Object)date);
            }
        }

        protected void visitBaseline(ChangeLogEntryDTO parent, ChangeLogBaselineEntryDTO dto) {
            if (!this.config.isJSONEnabled()) {
                super.visitBaseline(parent, dto);
                return;
            }
            this.currJsonObj.put((Object)"item-type", (Object)"baseline");
            this.jsonizeDTO((ChangeLogEntryDTO)dto, this.currJsonObj);
            this.currJsonObj.put((Object)"id", (Object)dto.getBaselineId());
        }

        protected void visitVersionable(ChangeLogEntryDTO parent, ChangeLogVersionableEntryDTO dto) {
            if (!this.config.isJSONEnabled()) {
                super.visitVersionable(parent, dto);
                return;
            }
            this.currJsonObj.put((Object)"item-type", (Object)"versionable");
            this.currJsonObj.put((Object)"uuid", (Object)dto.getItemId());
            this.currJsonObj.put((Object)"url", (Object)this.repoUri);
            this.currJsonObj.put((Object)"path", (Object)dto.getEntryName());
            if (this.getShowVersionIds() && dto instanceof ChangeLogVersionableEntry2DTO) {
                ChangeLogVersionableEntry2DTO dto2 = (ChangeLogVersionableEntry2DTO)dto;
                this.currJsonObj.put((Object)"long-id", (Object)(dto2.getLongVersionId() != null ? dto2.getLongVersionId() : ""));
                this.currJsonObj.put((Object)"short-id", (Object)(dto2.getShortVersionId() != null ? dto2.getShortVersionId() : ""));
            }
        }

        protected void visitWorkItem(ChangeLogEntryDTO parent, ChangeLogWorkItemEntryDTO dto, boolean inChangeSet) {
            if (!this.config.isJSONEnabled()) {
                super.visitWorkItem(parent, dto, inChangeSet);
                return;
            }
            if (!inChangeSet || this.getShowChangeSetWorkItems()) {
                this.currJsonObj.put((Object)"item-type", (Object)"workitem");
                this.currJsonObj.put((Object)"uuid", (Object)dto.getItemId());
                this.currJsonObj.put((Object)"url", (Object)this.repoUri);
                this.currJsonObj.put((Object)"workitem-number", (Object)dto.getWorkItemNumber());
                this.currJsonObj.put((Object)"workitem-label", (Object)dto.getEntryName());
            }
        }

        protected void visitOslcLink(ChangeLogEntryDTO parent, ChangeLogOslcLinkEntryDTO dto, boolean inChangeSet) {
            if (!this.config.isJSONEnabled()) {
                super.visitOslcLink(parent, dto, inChangeSet);
                return;
            }
            if (!inChangeSet || this.getShowChangeSetOslcLinks()) {
                this.currJsonObj.put((Object)"item-type", (Object)"change-requests");
                String oslcLabel = dto.getEntryName();
                oslcLabel = SubcommandUtil.sanitizeHTMLText((String)oslcLabel);
                JSONPrintUtil.ChangeRequestInfo oslcInfo = new JSONPrintUtil.ChangeRequestInfo(oslcLabel);
                this.currJsonObj.put((Object)"info", (Object)oslcInfo.getDisplayString(true));
                String targetUri = dto.getTargetUri();
                if (targetUri == null) {
                    this.currJsonObj.put((Object)"target-uri", (Object)com.ibm.team.filesystem.cli.core.internal.Messages.PendingChangesUtil_NO_TARGET_URI);
                } else {
                    this.currJsonObj.put((Object)"target-uri", (Object)targetUri);
                }
            }
        }

        public static String getEntryType(ChangeLogEntryDTO entry) {
            String entryType = entry.getEntryType();
            if ("clentry_direction".equals(entryType)) {
                return "direction";
            }
            if ("clentry_component".equals(entryType)) {
                return "components";
            }
            if ("clentry_changeset".equals(entryType)) {
                return "changesets";
            }
            if ("clentry_baseline".equals(entryType)) {
                return "baselines";
            }
            if ("clentry_versionable".equals(entryType)) {
                return "versionables";
            }
            if ("clentry_workitem".equals(entryType)) {
                return "workitems";
            }
            if ("clentry_oslc".equals(entryType)) {
                return "change-requests";
            }
            return "entries";
        }
    }

    private static class CompareItem {
        CompareType type;
        IItemHandle handle;
        String name;
        String historyRef;
        ITeamRepository repo;

        public CompareItem(CompareType type, IItemHandle handle, ITeamRepository repo, String name) {
            this.type = type;
            this.handle = handle;
            this.name = name;
            this.repo = repo;
        }

        public CompareItem(CompareType type, String historyRef, ITeamRepository repo, String name) {
            this.type = type;
            this.historyRef = historyRef;
            this.name = name;
            this.repo = repo;
        }

        public ParmsContext getParmsContext() throws CLIFileSystemClientException {
            ParmsContext result = null;
            switch (this.type) {
                case HISTORY_REFERENCE: {
                    ParmsHistoryReference historyRefParms = SubcommandUtil.createParmsHistoryReference((String)this.historyRef, (String)this.repo.getRepositoryURI());
                    if (historyRefParms == null) {
                        throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CompareCmd_NOT_A_HISTORY_REF, (Object)this.historyRef));
                    }
                    result = new ParmsContext("historyreference", this.repo.getRepositoryURI(), historyRefParms.workspaceId);
                    result.subContext = new ParmsContext("component", this.repo.getRepositoryURI(), historyRefParms.componentId);
                    result.state = historyRefParms.state;
                    break;
                }
                case WORKSPACE: 
                case STREAM: {
                    result = new ParmsContext("workspace", this.repo.getRepositoryURI(), this.handle.getItemId().getUuidValue());
                    break;
                }
                case SNAPSHOT: {
                    result = new ParmsContext("baselineset", this.repo.getRepositoryURI(), this.handle.getItemId().getUuidValue());
                    break;
                }
                case BASELINE: {
                    result = new ParmsContext("baseline", this.repo.getRepositoryURI(), this.handle.getItemId().getUuidValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("CompareItem type was not handled");
                }
            }
            return result;
        }
    }

    static enum CompareType {
        WORKSPACE("workspace", "workspace", "ws"),
        STREAM("workspace", "stream", "s"),
        BASELINE("baseline", "baseline", "bl"),
        SNAPSHOT("baselineset", "snapshot", "ss"),
        HISTORY_REFERENCE("historyRef", "historyRef", "hr");

        static final String[] NAMES;
        final String[] typeStrings;
        final String wireName;

        static {
            NAMES = new String[]{CompareType.WORKSPACE.typeStrings[0], CompareType.STREAM.typeStrings[0], CompareType.BASELINE.typeStrings[0], CompareType.SNAPSHOT.typeStrings[0], CompareType.HISTORY_REFERENCE.typeStrings[0]};
        }

        private CompareType(String wireName, String ... t) {
            this.wireName = wireName;
            this.typeStrings = t;
        }

        String[] getNames() {
            return this.typeStrings;
        }

        String getWireName() {
            return this.wireName;
        }
    }

    private static class SwitchString {
        String switches;

        SwitchString(String switches) {
            this.switches = switches;
        }

        public boolean contains(String s) {
            if (this.switches.contains(s)) {
                this.switches = this.switches.replace(s, "");
                return true;
            }
            return false;
        }

        public String getRemainder() {
            return this.switches;
        }
    }
}

