/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetAssociateWorkitemCmd;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommentCmd;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCompleteCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.CheckInCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.IUnmodifiedInfo;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInShareablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCheckInVersionablesRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCommitDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsEncodingDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxPaths;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CheckInResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.PathDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SandboxPathsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SymlinkWarningDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.CompletedChangeSetException;
import com.ibm.team.scm.common.ItemAlreadyInActiveChangeSetException;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CheckInCmd
extends AbstractSubcommand {
    private static final Log log = LogFactory.getLog((String)CheckInCmd.class.getName());
    int workitemNumber = -1;
    String wiRepoUri;
    DelimiterControl delimPolicy = DelimiterControl.FAIL_ON_ERROR;

    /*
     * Unable to fully structure code
     */
    public void run() throws FileSystemException {
        ResourcesPlugin.getWorkspace().getRoot();
        subargs = this.config.getSubcommandCommandLine();
        if (!subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_TO_COMMIT)) {
            throw StatusHelper.argSyntax((String)Messages.CheckInCmd_0);
        }
        wi = null;
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_WORKITEM)) {
            wiSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CheckInCmdOptions.OPT_WORKITEM.getId()), (IScmClientConfiguration)this.config, (boolean)false);
            this.wiRepoUri = wiSelector.getRepositorySelector();
            wi = wiSelector.getItemSelector();
        }
        if (wi != null) {
            try {
                this.workitemNumber = Integer.parseInt(wi);
            }
            catch (NumberFormatException e) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_2, wi));
            }
        }
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        root = new JSONObject();
        v0 = verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE) != false || this.config.isJSONEnabled() != false;
        if (SubcommandUtil.isCorrupt((JSONObject)root, (boolean)verbose, (IScmClientConfiguration)this.config)) {
            if (this.config.isJSONEnabled()) {
                throw StatusHelper.internalError((String)Messages.CheckInCmd_CORRUPT_FILE_SYSTEM);
            }
            throw StatusHelper.returnValue((int)7);
        }
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_CONSISTENT) && subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_NONE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_MAY_NOT_SPECIFY_BOTH_DELIM_ARGS, (Object)CheckInCmdOptions.OPT_DELIM_CONSISTENT.toString(), (Object)CheckInCmdOptions.OPT_DELIM_NONE.toString()));
        }
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_COMMIT_DELETED_CONTENT) && subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_SKIP_DELETED_CONTENT)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CheckInCmd_MAY_NOT_SPECIFY_BOTH_DELIM_ARGS, (Object)CheckInCmdOptions.OPT_COMMIT_DELETED_CONTENT.toString(), (Object)CheckInCmdOptions.OPT_SKIP_DELETED_CONTENT.toString()));
        }
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_CONSISTENT)) {
            this.delimPolicy = DelimiterControl.REWRITE;
        } else if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_DELIM_NONE)) {
            this.delimPolicy = DelimiterControl.SET_NO_DELIM;
        }
        paths = subargs.getOptions((IOptionKey)CheckInCmdOptions.OPT_TO_COMMIT);
        for (String path : paths) {
            if (!path.contains("*") && !path.contains("?")) continue;
            throw StatusHelper.ambiguousDirectorySelector((String)NLS.bind((String)Messages.UndoCmd_CHANGES_DIRECTORY_CONTENT, (Object)path));
        }
        csSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)CheckInCmdOptions.OPT_COMMIT_TARGET, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        repo = null;
        changeset = null;
        if (csSelector != null) {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
            changeset = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (boolean)false, null, null, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (!changeset.isIsActive()) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_30, (Object)csSelector.getItemSelector()));
            }
        }
        changes = new ParmsCheckInChanges();
        wsList = this.generateParams(changes, paths, changeset, client, this.config);
        result = null;
        retried = false;
        while (true) {
            block27: {
                try {
                    result = client.postCheckInChanges(changes, null);
                }
                catch (ItemAlreadyInActiveChangeSetException e) {
                    throw StatusHelper.disallowed((String)e.getLocalizedMessage());
                }
                catch (CompletedChangeSetException e) {
                    throw StatusHelper.inappropriateArgument((String)e.getLocalizedMessage());
                }
                catch (FileSystemStatusException e) {
                    err = this.config.getWrappedErrorStream();
                    if (e.getData() == null) break block27;
                    status = (IStatus)e.getData();
                    var20_24 = status.getChildren();
                    var19_25 = var20_24.length;
                    var18_26 = 0;
                    ** while (var18_26 < var19_25)
                }
lbl-1000:
                // 1 sources

                {
                    childStatus = var20_24[var18_26];
                    err.indent().println((CharSequence)childStatus.getMessage());
                    ex = childStatus.getException();
                    if (ex != null) {
                        err.indent().indent().println((CharSequence)ex.getLocalizedMessage());
                    }
                    ++var18_26;
                    continue;
                }
lbl74:
                // 1 sources

                throw StatusHelper.malformedInput((String)status.getMessage());
            }
            throw StatusHelper.wrap((String)Messages.CheckInCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)err, null);
            catch (VersionablePermissionDeniedException e) {
                throw StatusHelper.permissionFailure((String)(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : Messages.Common_VERSIONABLE_PERMISSSION_DENIED));
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.CheckInCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
            }
            if (retried || !result.isCancelled() || result.getCommitDilemma().getLineDelimiterFailures().size() <= 0 || this.delimPolicy == DelimiterControl.FAIL_ON_ERROR) break;
            this.setLineDelimPolicyForFailures(result.getCommitDilemma().getLineDelimiterFailures(), changes);
            retried = true;
        }
        this.processResult1(result, wsList, client, subargs);
        wsToChangeSets = this.getWsToChangesetMap(result.getChangeSetsCommitted(), wsList, client);
        try {
            this.setChangesetInfo(result, wsList, client, subargs);
        }
        finally {
            this.processResult2(result, wsToChangeSets, client, subargs);
        }
    }

    private void setLineDelimPolicyForFailures(List<LineDelimiterErrorDTO> lineDelimiterFailures, ParmsCheckInChanges parmsChanges) {
        ArrayList<ParmsLineDelimiterErrorInstructions> parmsLDInstrs = new ArrayList<ParmsLineDelimiterErrorInstructions>(lineDelimiterFailures.size());
        for (LineDelimiterErrorDTO ldError : lineDelimiterFailures) {
            ParmsLineDelimiterErrorInstructions ldInstr = new ParmsLineDelimiterErrorInstructions();
            ldInstr.sandboxPath = ldError.getShare().getSandboxPath();
            ldInstr.filePath = StringUtil.createPathString((List)ldError.getFileName().getSegments());
            ldInstr.forceConsistentDelimiters = this.delimPolicy == DelimiterControl.REWRITE;
            parmsLDInstrs.add(ldInstr);
        }
        parmsChanges.commitDilemmaHandler.lineDelimiterDilemmaHandler.lineDelimiterErrorInstructions = parmsLDInstrs.toArray(new ParmsLineDelimiterErrorInstructions[parmsLDInstrs.size()]);
    }

    private void processResult1(CheckInResultDTO result, List<ParmsWorkspace> wsList, IFilesystemRestClient client, ICommandLine cli) throws FileSystemException {
        IndentingPrintStream err = this.config.getWrappedErrorStream();
        if (result.isCancelled()) {
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
            }
            if (result.getCommitDilemma().getLineDelimiterFailures().size() > 0) {
                err.println((CharSequence)Messages.CheckInCmd_17);
                for (LineDelimiterErrorDTO ldError : result.getCommitDilemma().getLineDelimiterFailures()) {
                    StringBuffer printBuffer = new StringBuffer(StringUtil.createPathString((List)ldError.getFileName().getSegments()));
                    if (ldError.isSetLineDelimiter()) {
                        printBuffer.append(" ");
                        printBuffer.append(NLS.bind((String)Messages.Common_SURROUND_PARANTHESIS, (Object)ldError.getLineDelimiter()));
                    }
                    err.indent().println((CharSequence)printBuffer);
                    if (!ldError.isSetReason()) continue;
                    err.indent().indent().println((CharSequence)NLS.bind((String)Messages.CheckInCmd_Reason, (Object)ldError.getReason()));
                }
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, CheckInCmd.class);
                throw StatusHelper.malformedInput((String)NLS.bind((String)Messages.CheckInCmd_LineDelimiter_Error, (Object[])new String[]{SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), CheckInCmdOptions.OPT_DELIM_CONSISTENT.getName(), CheckInCmdOptions.OPT_DELIM_NONE.getName()}));
            }
            if (result.getCommitDilemma().getEncodingFailures().size() > 0) {
                err.println((CharSequence)Messages.CheckInCmd_18);
                for (EncodingErrorDTO encError : result.getCommitDilemma().getEncodingFailures()) {
                    StringBuffer printBuffer = new StringBuffer(StringUtil.createPathString((List)encError.getShareable().getRelativePath().getSegments()));
                    printBuffer.append(" ");
                    printBuffer.append(NLS.bind((String)Messages.Common_SURROUND_PARANTHESIS, (Object)encError.getEncoding()));
                    err.indent().println((CharSequence)printBuffer);
                }
                throw StatusHelper.malformedInput((String)Messages.CheckInCmd_FileEncoding_Error);
            }
            if (result.getCommitDilemma().getPredecessorDeletedShareables().size() > 0) {
                err.println((CharSequence)Messages.CheckInCmd_PREDECESSOR_DELETED);
                for (ShareableDTO shareable : result.getCommitDilemma().getPredecessorDeletedShareables()) {
                    err.indent().println((CharSequence)StringUtil.createPathString((List)shareable.getRelativePath().getSegments()));
                }
                err.println((CharSequence)NLS.bind((String)Messages.CheckInCmd_FORCE_COMMIT_DELETED_CONTENT, (Object)CheckInCmdOptions.OPT_COMMIT_DELETED_CONTENT.toString(), (Object)CheckInCmdOptions.OPT_SKIP_DELETED_CONTENT.toString()));
                throw StatusHelper.malformedInput((String)Messages.CheckInCmd_PREDECESSOR_DELETED_ERROR);
            }
            if (result.getUpdateDilemma().getInaccessibleForUpdate().size() > 0) {
                err.println((CharSequence)Messages.Common_INACCESSIBLE_VERSIONABLE_ITEMS_HEADER);
                for (ShareableDTO shareable : result.getUpdateDilemma().getInaccessibleForUpdate()) {
                    err.indent().println((CharSequence)StringUtil.createPathString((List)shareable.getRelativePath().getSegments()));
                }
                throw StatusHelper.permissionFailure((String)Messages.Common_VERSIONABLE_PERMISSSION_DENIED);
            }
            if (result.getCommitDilemma().getNonPatchShareables().size() > 0) {
                StringBuffer msg = new StringBuffer();
                msg.append(NLS.bind((String)Messages.CheckInCmd_CURRENT_MERGE_FAILURE, (Object)CheckInCmdOptions.OPT_CURRENT_MERGE.toString()));
                if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                    String NEWLINE = System.getProperty("line.separator");
                    for (Object o : result.getCommitDilemma().getNonPatchShareables()) {
                        msg.append(NEWLINE);
                        ShareableDTO shareable = (ShareableDTO)o;
                        msg.append(StringUtil.createPathString((List)shareable.getRelativePath().getSegments()));
                    }
                }
                throw StatusHelper.portsInProgress((String)msg.toString());
            }
            if (result.getCommitDilemma().getLocalConflictShareables().size() > 0) {
                StringBuffer msg = new StringBuffer();
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, CheckInCmd.class);
                msg.append(NLS.bind((String)Messages.CheckInCmd_LOCAL_CONFLICTS_FAILURE, (Object)SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), (Object)CheckInCmdOptions.OPT_IGNORE_LOCAL_CONFLICTS.toString()));
                if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                    String NEWLINE = System.getProperty("line.separator");
                    for (Object o : result.getCommitDilemma().getLocalConflictShareables()) {
                        msg.append(NEWLINE);
                        ShareableDTO shareable = (ShareableDTO)o;
                        msg.append(StringUtil.createPathString((List)shareable.getRelativePath().getSegments()));
                    }
                }
                throw StatusHelper.localConflicts((String)msg.toString());
            }
        }
    }

    private void processResult2(CheckInResultDTO result, Map<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> wsToChangeSets, IFilesystemRestClient client, ICommandLine cli) throws FileSystemException {
        SymlinkWarningDTO warning;
        StringBuffer msg;
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (result.getChangeSetsCommitted().size() > 0) {
            this.printCommittedChanges(wsToChangeSets, client);
        }
        if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0 && !this.config.isJSONEnabled()) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed());
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0 && !this.config.isJSONEnabled()) {
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out);
        }
        String NEWLINE = System.getProperty("line.separator");
        if (result.getCommitDilemma().getNonInteroperableLinks().size() > 0) {
            msg = new StringBuffer();
            msg.append(Messages.CheckInCmd_2);
            msg.append(NEWLINE);
            for (Object o : result.getCommitDilemma().getNonInteroperableLinks()) {
                warning = (SymlinkWarningDTO)o;
                msg.append(NLS.bind((String)Messages.CheckInCmd_4, (Object[])new Object[]{warning.getLocation(), warning.getTarget(), warning.getType()}));
                msg.append(NEWLINE);
            }
            log.warn((Object)msg);
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                out.print((CharSequence)msg);
            }
        }
        if (result.getCommitDilemma().getBrokenLinks().size() > 0) {
            msg = new StringBuffer();
            msg.append(Messages.CheckInCmd_5);
            msg.append(NEWLINE);
            for (Object o : result.getCommitDilemma().getBrokenLinks()) {
                warning = (SymlinkWarningDTO)o;
                msg.append(NLS.bind((String)Messages.CheckInCmd_4, (Object[])new Object[]{warning.getLocation(), warning.getTarget(), warning.getType()}));
                msg.append(NEWLINE);
            }
            out.print((CharSequence)msg);
            log.warn((Object)msg);
        }
    }

    private Map<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> getWsToChangesetMap(List<String> changeSetIds, List<ParmsWorkspace> wsList, IFilesystemRestClient client) throws FileSystemException {
        SyncViewDTO syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashMap<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> wsToChangeSets = new HashMap<WorkspaceSyncDTO, List<ChangeSetSyncDTO>>();
        for (WorkspaceSyncDTO ws : syncView.getWorkspaces()) {
            for (ComponentSyncDTO comp : ws.getComponents()) {
                for (ChangeSetSyncDTO cs : comp.getOutgoingChangeSetsAfterBasis()) {
                    for (String csId : changeSetIds) {
                        if (!csId.equals(cs.getChangeSetItemId())) continue;
                        ArrayList<ChangeSetSyncDTO> csList = (ArrayList<ChangeSetSyncDTO>)wsToChangeSets.get(ws);
                        if (csList == null) {
                            csList = new ArrayList<ChangeSetSyncDTO>();
                            wsToChangeSets.put(ws, csList);
                        }
                        cs.setComponentItemId(comp.getComponentItemId());
                        csList.add(cs);
                    }
                }
            }
        }
        return wsToChangeSets;
    }

    private void printCommittedChanges(Map<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> wsToChangeSets, IFilesystemRestClient client) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions opts = new PendingChangesUtil.PendingChangesOptions();
        opts.enableFilter(1);
        opts.enableFilter(4);
        opts.enablePrinter(0);
        opts.enablePrinter(1);
        opts.enablePrinter(11);
        opts.enablePrinter(24);
        opts.enablePrinter(25);
        opts.enablePrinter(8);
        opts.enablePrinter(4);
        opts.enablePrinter(23);
        opts.enablePrinter(6);
        if (this.config.getSubcommandCommandLine().hasOption((IOptionKey)CheckInCmdOptions.OPT_WORKITEM)) {
            opts.enablePrinter(7);
        }
        opts.setMaxChanges(CommonOptions.getMaxChangesToInterpret((IClientConfiguration)this.config));
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(wsToChangeSets.keySet().size());
        for (Map.Entry<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> entry : wsToChangeSets.entrySet()) {
            wsList.add(new ParmsWorkspace(entry.getKey().getRepositoryUrl(), entry.getKey().getWorkspaceItemId()));
            for (ChangeSetSyncDTO csSync : entry.getValue()) {
                opts.addFilter(UUID.valueOf((String)csSync.getChangeSetItemId()), 4);
                if (opts.isInFilter(UUID.valueOf((String)csSync.getComponentItemId()), 1)) continue;
                opts.addFilter(UUID.valueOf((String)csSync.getComponentItemId()), 1);
            }
        }
        JSONArray workspaces = JSONPrintUtil.jsonizePendingChanges3((IFilesystemRestClient)client, wsList, (PendingChangesUtil.PendingChangesOptions)opts, (IScmClientConfiguration)this.config);
        if (this.config.getSubcommandCommandLine().hasOption((IOptionKey)CheckInCmdOptions.OPT_COMPLETE)) {
            this.updateWorkspaces(workspaces, wsToChangeSets, opts, client);
        }
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)workspaces.toString());
        } else {
            IndentingPrintStream ps = this.config.getWrappedOutputStream();
            PendingChangesUtil.printWorkspaces((JSONArray)workspaces, (PendingChangesUtil.PendingChangesOptions)opts, (IndentingPrintStream)ps);
        }
    }

    private void updateWorkspaces(JSONArray workspaces, Map<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> wsToChangeSets, PendingChangesUtil.PendingChangesOptions options, IFilesystemRestClient client) throws FileSystemException {
        for (Object workspace : workspaces) {
            JSONObject jWs = (JSONObject)workspace;
            String wsItemId = (String)jWs.get((Object)"uuid");
            String repoUri = (String)jWs.get((Object)"url");
            Map<String, List<ChangeSetSyncDTO>> compToChangeSets = null;
            JSONArray components = (JSONArray)jWs.get((Object)"components");
            ArrayList<String> csIdList = new ArrayList<String>();
            for (Object comp : components) {
                JSONObject jComp = (JSONObject)comp;
                String compItemId = (String)jComp.get((Object)"uuid");
                JSONArray outgoingChanges = (JSONArray)jComp.get((Object)"outgoing-changes");
                if (outgoingChanges != null && outgoingChanges.size() != 0) continue;
                if (compToChangeSets == null) {
                    compToChangeSets = this.getCompToChangeSetsMap(wsToChangeSets, wsItemId);
                }
                if (!compToChangeSets.containsKey(compItemId)) continue;
                List<ChangeSetSyncDTO> csDtoList = compToChangeSets.get(compItemId);
                for (ChangeSetSyncDTO csDto : csDtoList) {
                    csIdList.add(csDto.getChangeSetItemId());
                }
            }
            ChangeSetSyncDTO[] csDTOArray = RepoUtil.findChangeSets(csIdList, (boolean)true, (String)wsItemId, (String)"workspace", (String)repoUri, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            csIdList.clear();
            for (Object comp : components) {
                JSONObject jComp = (JSONObject)comp;
                String compItemId = (String)jComp.get((Object)"uuid");
                ArrayList<ChangeSetSyncDTO> csSyncDTOListForComponent = new ArrayList<ChangeSetSyncDTO>();
                ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOArray;
                int n = csDTOArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSetSyncDTO csDTO = changeSetSyncDTOArray[n2];
                    String compId = csDTO.getComponentItemId();
                    if (compItemId.equals(compId)) {
                        csSyncDTOListForComponent.add(csDTO);
                    }
                    ++n2;
                }
                if (csSyncDTOListForComponent.size() <= 0) continue;
                JSONPrintUtil.jsonizeChangeSets((JSONObject)jComp, (String)"outgoing-changes", csSyncDTOListForComponent, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            }
        }
    }

    private Map<String, List<ChangeSetSyncDTO>> getCompToChangeSetsMap(Map<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> wsToChangeSets, String wsItemId) {
        HashMap<String, List<ChangeSetSyncDTO>> compToChangeSets = new HashMap<String, List<ChangeSetSyncDTO>>();
        for (Map.Entry<WorkspaceSyncDTO, List<ChangeSetSyncDTO>> entry : wsToChangeSets.entrySet()) {
            if (!entry.getKey().getWorkspaceItemId().equals(wsItemId)) continue;
            for (ChangeSetSyncDTO csDTO : entry.getValue()) {
                ArrayList<ChangeSetSyncDTO> csList = (ArrayList<ChangeSetSyncDTO>)compToChangeSets.get(csDTO.getComponentItemId());
                if (csList == null) {
                    csList = new ArrayList<ChangeSetSyncDTO>(entry.getValue().size());
                    compToChangeSets.put(csDTO.getComponentItemId(), csList);
                }
                csList.add(csDTO);
            }
        }
        return compToChangeSets;
    }

    /*
     * WARNING - void declaration
     */
    private void setChangesetInfo(CheckInResultDTO result, List<ParmsWorkspace> wsList, IFilesystemRestClient client, ICommandLine subargs) throws FileSystemException {
        if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_COMMENT) || subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_COMPLETE) || subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_WORKITEM)) {
            ArrayList<String> repos = new ArrayList<String>();
            SyncViewDTO syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            List changeSetIds = result.getChangeSetsCommitted();
            HashMap<WorkspaceSyncDTO, ArrayList<ChangeSetSyncDTO>> wsToChangeSets = new HashMap<WorkspaceSyncDTO, ArrayList<ChangeSetSyncDTO>>();
            for (WorkspaceSyncDTO workspaceSyncDTO : syncView.getWorkspaces()) {
                for (ComponentSyncDTO comp : workspaceSyncDTO.getComponents()) {
                    for (ChangeSetSyncDTO cs : comp.getOutgoingChangeSetsAfterBasis()) {
                        for (String csId : changeSetIds) {
                            if (!csId.equals(cs.getChangeSetItemId())) continue;
                            ArrayList<ChangeSetSyncDTO> csDTOList = (ArrayList<ChangeSetSyncDTO>)wsToChangeSets.get(workspaceSyncDTO);
                            if (csDTOList == null) {
                                csDTOList = new ArrayList<ChangeSetSyncDTO>();
                                wsToChangeSets.put(workspaceSyncDTO, csDTOList);
                            }
                            csDTOList.add(cs);
                        }
                    }
                }
                if (wsToChangeSets.get(workspaceSyncDTO) == null || repos.contains(workspaceSyncDTO.getRepositoryId())) continue;
                repos.add(workspaceSyncDTO.getRepositoryId());
            }
            for (Map.Entry entry : wsToChangeSets.entrySet()) {
                ArrayList<String> csIds = new ArrayList<String>();
                for (ChangeSetSyncDTO csDTO : (List)entry.getValue()) {
                    csIds.add(csDTO.getChangeSetItemId());
                    if (!subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_COMMENT)) continue;
                    String comment = subargs.getOption((IOptionKey)CheckInCmdOptions.OPT_COMMENT);
                    ChangesetCommentCmd.setComment(csDTO.getChangeSetItemId(), comment, csDTO.getRepositoryUrl(), client, this.config);
                }
                if (!subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_COMPLETE)) continue;
                ChangesetCompleteCmd.setComplete(new ParmsWorkspace(((WorkspaceSyncDTO)entry.getKey()).getRepositoryUrl(), ((WorkspaceSyncDTO)entry.getKey()).getWorkspaceItemId()), csIds, ((WorkspaceSyncDTO)entry.getKey()).getRepositoryUrl(), client, this.config);
            }
            if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_WORKITEM) && repos.size() == 1) {
                Object var9_13 = null;
                for (Map.Entry entry : wsToChangeSets.entrySet()) {
                    for (ChangeSetSyncDTO csDTO : (List)entry.getValue()) {
                        void var9_14;
                        if (var9_14 == null) {
                            ITeamRepository repo;
                            if (this.wiRepoUri == null) {
                                repo = RepoUtil.getSharedRepository((String)((WorkspaceSyncDTO)entry.getKey()).getRepositoryUrl(), (boolean)true);
                            } else {
                                repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(this.wiRepoUri));
                                this.wiRepoUri = repo.getRepositoryURI();
                            }
                            IWorkItem iWorkItem = RepoUtil.findWorkItem((int)this.workitemNumber, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                        }
                        ChangesetAssociateWorkitemCmd.setWorkitem(((WorkspaceSyncDTO)entry.getKey()).getWorkspaceItemId(), csDTO.getChangeSetItemId(), var9_14.getItemId().getUuidValue(), ((WorkspaceSyncDTO)entry.getKey()).getRepositoryUrl(), this.wiRepoUri, this.config);
                    }
                }
            }
            if (subargs.hasOption((IOptionKey)CheckInCmdOptions.OPT_WORKITEM) && repos.size() > 1) {
                ISubcommandDefinition iSubcommandDefinition = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ChangesetAssociateWorkitemCmd.class);
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_WORKITEM_CANNOT_SPAN_REPOS, (Object[])new String[]{Integer.toString(this.workitemNumber), this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)iSubcommandDefinition).toString()}));
            }
        }
    }

    private List<ParmsWorkspace> generateParams(ParmsCheckInChanges changes, List<String> checkinPaths, ChangeSetSyncDTO changeset, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        String[] pathSegs;
        PathDTO pathDTO;
        Iterator iterator;
        Object shares;
        ArrayList<String> pathSelectors = new ArrayList<String>();
        for (String checkinPath : checkinPaths) {
            ILocation path = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)checkinPath);
            pathSelectors.add(path.toOSString());
        }
        ParmsSandboxPaths parmsPaths = new ParmsSandboxPaths();
        parmsPaths.includeNonRegisteredSandboxes = true;
        parmsPaths.pathsToResolve = pathSelectors.toArray(new String[pathSelectors.size()]);
        SandboxPathsResultDTO pathsResult = null;
        try {
            pathsResult = client.getSandboxPaths(parmsPaths, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.Common_UNABLE_TO_GET_SANDBOX_PATHS, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), null);
        }
        ArrayList<String> reposOfPaths = new ArrayList<String>();
        HashMap<String, ParmsWorkspace> wsIdToWs = new HashMap<String, ParmsWorkspace>();
        ArrayList<ResourcePropertiesDTO> resources = new ArrayList<ResourcePropertiesDTO>();
        int count = 0;
        HashMap sandboxToSharesMap = new HashMap();
        HashMap<String, ArrayList<ShareableDTO>> sandboxToPaths = new HashMap<String, ArrayList<ShareableDTO>>();
        HashMap<String, ShareDTO> pathToShareMap = new HashMap<String, ShareDTO>();
        for (ShareableDTO shareableDTO : pathsResult.getPaths()) {
            if (shareableDTO.getSandboxPath() == null || shareableDTO.getSandboxPath().length() == 0) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, pathSelectors.get(count)));
            }
            HashMap<String, ShareDTO> sharePathToDTO = null;
            if (sandboxToSharesMap.containsKey(shareableDTO.getSandboxPath())) {
                sharePathToDTO = (HashMap<String, ShareDTO>)sandboxToSharesMap.get(shareableDTO.getSandboxPath());
            } else {
                shares = RepoUtil.getSharesInSandbox(null, (ILocation)new PathLocation(shareableDTO.getSandboxPath()), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                sharePathToDTO = new HashMap<String, ShareDTO>();
                iterator = shares.iterator();
                while (iterator.hasNext()) {
                    ShareDTO share = (ShareDTO)iterator.next();
                    pathDTO = share.getPath();
                    pathSegs = pathDTO.getSegments().toArray(new String[pathDTO.getSegments().size()]);
                    Path sharePath = new Path(String.valueOf(shareableDTO.getSandboxPath()) + StringUtil.createPathString((String[])pathSegs));
                    sharePathToDTO.put(sharePath.toString(), share);
                }
                sandboxToSharesMap.put(shareableDTO.getSandboxPath(), sharePathToDTO);
            }
            ArrayList<ShareableDTO> paths = (ArrayList<ShareableDTO>)sandboxToPaths.get(shareableDTO.getSandboxPath());
            if (paths == null) {
                paths = new ArrayList<ShareableDTO>();
                sandboxToPaths.put(shareableDTO.getSandboxPath(), paths);
            }
            paths.add(shareableDTO);
            ++count;
        }
        for (Map.Entry entry : sandboxToPaths.entrySet()) {
            List shareables = (List)entry.getValue();
            shares = (Map)sandboxToSharesMap.get(entry.getKey());
            iterator = shareables.iterator();
            while (iterator.hasNext()) {
                Path path;
                block18: {
                    block17: {
                        ShareableDTO shareable = (ShareableDTO)iterator.next();
                        pathDTO = shareable.getRelativePath();
                        pathSegs = pathDTO.getSegments().toArray(new String[pathDTO.getSegments().size()]);
                        path = new Path(String.valueOf(shareable.getSandboxPath()) + StringUtil.createPathString((String[])pathSegs));
                        if (pathDTO.getSegments().size() != 0) break block17;
                        if (pathToShareMap.containsKey(shareable.getSandboxPath())) break block18;
                        pathToShareMap.put(shareable.getSandboxPath(), null);
                        break block18;
                    }
                    for (Map.Entry entry2 : shares.entrySet()) {
                        Path sharePath = new Path((String)entry2.getKey());
                        if (!sharePath.isPrefixOf((IPath)path)) continue;
                        pathToShareMap.put(path.toOSString(), (ShareDTO)entry2.getValue());
                        break;
                    }
                }
                if (pathToShareMap.containsKey(path.toOSString())) continue;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, (Object)path.toOSString()));
            }
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : pathToShareMap.entrySet()) {
            String path = (String)entry.getKey();
            ShareDTO shareOfPath = (ShareDTO)entry.getValue();
            Object sandboxPath = shareOfPath == null ? path : shareOfPath.getSandboxPath();
            HashSet<String> paths = (HashSet<String>)hashMap.get(sandboxPath);
            if (paths == null) {
                paths = new HashSet<String>();
                hashMap.put((String)sandboxPath, (Set<String>)paths);
            }
            if (entry.getValue() != null) {
                this.addResourcesForCheckin(resources, reposOfPaths, wsIdToWs, changeset, paths, path, shareOfPath, client);
                continue;
            }
            Map shares2 = (Map)sandboxToSharesMap.get(sandboxPath);
            if (shares2.size() <= 0) continue;
            for (ShareDTO share : shares2.values()) {
                if (changeset != null && (changeset == null || !changeset.getComponentItemId().equals(share.getComponentItemId()))) continue;
                String absolutePath = new File(share.getSandboxPath(), this.getRelativePathFromSegments(share.getPath().getSegments())).getAbsolutePath();
                this.addResourcesForCheckin(resources, reposOfPaths, wsIdToWs, changeset, paths, absolutePath, share, client);
            }
        }
        SubcommandUtil.registerSandboxes((String[])hashMap.keySet().toArray(new String[hashMap.keySet().size()]), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        ICommandLine iCommandLine = config.getSubcommandCommandLine();
        for (String repoUri : reposOfPaths) {
            RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(repoUri));
        }
        ArrayList<ParmsWorkspace> parmsWorkspace = new ArrayList<ParmsWorkspace>(wsIdToWs.values());
        RepoUtil.validateWorkspacesAreTracked(parmsWorkspace, (String)Messages.CheckInCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)config);
        Map<String, ParmsCheckInVersionablesRequest> versionablesToCheckIn = null;
        String comment = config.getSubcommandCommandLine().getOption((IOptionKey)CheckInCmdOptions.OPT_COMMENT, "");
        versionablesToCheckIn = this.createVersionables(resources, client, changeset, comment);
        Map parmPaths = SubcommandUtil.getNonOverlappingResources(resources);
        this.recomputeLocalChanges(parmPaths, client);
        this.generateCheckinParms(changes, hashMap, changeset, versionablesToCheckIn, comment);
        return parmsWorkspace;
    }

    private String getRelativePathFromSegments(List<String> pathSegments) {
        StringBuffer resultantPath = new StringBuffer();
        for (String pathSegment : pathSegments) {
            resultantPath.append(String.valueOf(pathSegment) + File.separator);
        }
        return resultantPath.toString();
    }

    private Map<String, ParmsCheckInVersionablesRequest> createVersionables(List<ResourcePropertiesDTO> resources, IFilesystemRestClient client, ChangeSetSyncDTO changeset, String comment) throws FileSystemException {
        HashMap<String, ParmsCheckInVersionablesRequest> versionablesToCheckIn = new HashMap<String, ParmsCheckInVersionablesRequest>();
        for (ResourcePropertiesDTO resource : resources) {
            ParmsCheckInVersionablesRequest aVersionalble;
            ShareDTO share = resource.getShare();
            String fullPath = resource.getFullPath();
            PathLocation path = new PathLocation(fullPath);
            String repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ILocation)path);
            ParmsWorkspace ws = new ParmsWorkspace(repositoryUrl, share.getContextItemId());
            if (versionablesToCheckIn.get(share.getComponentItemId()) == null) {
                aVersionalble = new ParmsCheckInVersionablesRequest();
                aVersionalble.workspace = ws;
                aVersionalble.componentItemId = share.getComponentItemId();
                if (changeset != null) {
                    aVersionalble.changeSetItemId = changeset.getChangeSetItemId();
                } else {
                    aVersionalble.newChangeSetComment = comment;
                }
                aVersionalble.versionablesToCheckIn = new String[]{resource.getItemId()};
                versionablesToCheckIn.put(share.getComponentItemId(), aVersionalble);
                continue;
            }
            aVersionalble = (ParmsCheckInVersionablesRequest)versionablesToCheckIn.get(share.getComponentItemId());
            ArrayList<String> Ids = new ArrayList<String>(Arrays.asList(aVersionalble.versionablesToCheckIn));
            Ids.add(resource.getItemId());
            aVersionalble.versionablesToCheckIn = Ids.toArray(new String[Ids.size()]);
            versionablesToCheckIn.put(share.getComponentItemId(), aVersionalble);
        }
        return versionablesToCheckIn;
    }

    private void recomputeLocalChanges(Map<ILocation, Set<ILocation>> parmPaths, IFilesystemRestClient client) throws FileSystemException {
        Set<ILocation> locnList = parmPaths.keySet();
        for (ILocation locn : locnList) {
            Set<ILocation> allPaths = parmPaths.get(locn);
            SubcommandUtil.refreshPaths((ILocation)locn, new ArrayList<ILocation>(allPaths), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
    }

    private void addCheckinPath(ChangeSetSyncDTO changeset, PathDTO path, ShareDTO share, Set<String> paths, List<String> reposOfPaths, Map<String, ParmsWorkspace> wsIdToWs, IFilesystemRestClient client) throws FileSystemException {
        if (changeset != null && !changeset.getComponentItemId().equals(share.getComponentItemId())) {
            StringBuffer pathBuffer = new StringBuffer(share.getSandboxPath());
            pathBuffer.append(StringUtil.createPathString((List)share.getPath().getSegments()));
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_26, (Object)pathBuffer, (Object)changeset.getComponentName()));
        }
        if (path != null && paths != null) {
            paths.add(StringUtil.createPathString((List)path.getSegments()));
        }
        String repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ShareDTO)share);
        if (reposOfPaths != null && !reposOfPaths.contains(repositoryUrl)) {
            reposOfPaths.add(repositoryUrl);
        }
        if (!wsIdToWs.keySet().contains(share.getContextItemId())) {
            wsIdToWs.put(share.getContextItemId(), new ParmsWorkspace(repositoryUrl, share.getContextItemId()));
        }
    }

    private void generateCheckinParms(ParmsCheckInChanges parmsChanges, Map<String, Set<String>> sandboxToCheckinPaths, ChangeSetSyncDTO changeset, Map<String, ParmsCheckInVersionablesRequest> versionablesToCheckIn, String comment) {
        ArrayList<ParmsCheckInShareablesRequest> parmsCheckinShareables = new ArrayList<ParmsCheckInShareablesRequest>();
        for (Map.Entry<String, Set<String>> entry : sandboxToCheckinPaths.entrySet()) {
            ParmsCheckInShareablesRequest checkinRequest = new ParmsCheckInShareablesRequest();
            if (changeset != null) {
                checkinRequest.changeSet = new ParmsChangeSet();
                checkinRequest.changeSet.changeSetItemId = changeset.getChangeSetItemId();
                checkinRequest.changeSet.repositoryUrl = changeset.getRepositoryUrl();
            } else {
                checkinRequest.newChangeSetComment = comment;
            }
            checkinRequest.sandboxPath = entry.getKey();
            checkinRequest.resourcesToCheckIn = entry.getValue().toArray(new String[entry.getValue().size()]);
            parmsCheckinShareables.add(checkinRequest);
        }
        parmsChanges.versionables = versionablesToCheckIn.values().toArray(new ParmsCheckInVersionablesRequest[versionablesToCheckIn.values().size()]);
        parmsChanges.paths = parmsCheckinShareables.toArray(new ParmsCheckInShareablesRequest[parmsCheckinShareables.size()]);
        parmsChanges.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        parmsChanges.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parmsChanges.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parmsChanges.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parmsChanges.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parmsChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parmsChanges.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parmsChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parmsChanges.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        parmsChanges.updateDilemmaHandler = new ParmsUpdateDilemmaHandler();
        parmsChanges.updateDilemmaHandler.inaccessibleForUpdateInstruction = "cancel";
        parmsChanges.commitDilemmaHandler = new ParmsCommitDilemmaHandler();
        parmsChanges.commitDilemmaHandler.encodingDilemmaHandler = new ParmsEncodingDilemmaHandler();
        parmsChanges.commitDilemmaHandler.encodingDilemmaHandler.performDefaultHandling = true;
        parmsChanges.commitDilemmaHandler.encodingDilemmaHandler.generalEncodingErrorInstruction = "cancel";
        parmsChanges.commitDilemmaHandler.lineDelimiterDilemmaHandler = new ParmsLineDelimiterDilemmaHandler();
        parmsChanges.commitDilemmaHandler.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "cancel";
        boolean ignoreLocalConflicts = ((ScmClientConfiguration)this.config).getSubcommandCommandLine().hasOption((IOptionKey)CheckInCmdOptions.OPT_IGNORE_LOCAL_CONFLICTS);
        String string = parmsChanges.commitDilemmaHandler.localConflictsInstruction = ignoreLocalConflicts ? "continue" : "cancel";
        parmsChanges.commitDilemmaHandler.predecessorContentDeletedInstruction = ((ScmClientConfiguration)this.config).getSubcommandCommandLine().hasOption((IOptionKey)CheckInCmdOptions.OPT_COMMIT_DELETED_CONTENT) ? "continue" : (((ScmClientConfiguration)this.config).getSubcommandCommandLine().hasOption((IOptionKey)CheckInCmdOptions.OPT_SKIP_DELETED_CONTENT) ? "no" : "cancel");
        parmsChanges.commitDilemmaHandler.nonPatchShareablesInstruction = ((ScmClientConfiguration)this.config).getSubcommandCommandLine().hasOption((IOptionKey)CheckInCmdOptions.OPT_CURRENT_MERGE) ? "continue" : "cancel";
        int atomicMaximum = ((ScmClientConfiguration)this.config).getPersistentPreferences().getAtomicCommitMaximum();
        if (atomicMaximum != -1) {
            parmsChanges.checkInOptions = new ParmsCheckInOptions();
            parmsChanges.checkInOptions.allowNonAtomicCommit = true;
            parmsChanges.checkInOptions.numberOfUploads = atomicMaximum;
        }
    }

    private boolean isSandboxRoot(IShareable shareable) {
        return shareable.getSandbox().getRoot().equals((Object)shareable.getFullPath());
    }

    private void addResourcesForCheckin(List<ResourcePropertiesDTO> resources, List<String> reposOfPaths, Map<String, ParmsWorkspace> wsIdToWs, ChangeSetSyncDTO changeset, Set<String> paths, String pathSelector, ShareDTO share, IFilesystemRestClient client) throws FileSystemException {
        String fullPath;
        PathLocation ipath;
        ResourcePropertiesDTO resource = RepoUtil.getResourceProperties((String)pathSelector, (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, (boolean)false, (ShareDTO)share);
        if (!resource.isSetVersionableItemType()) {
            ILocation path = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)pathSelector);
            IShareable parent = SharingManager.getInstance().findShareable(path.getParent(), ResourceType.FOLDER);
            if (parent == null || parent.getRemote(null) == null && !this.isSandboxRoot(parent)) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_MISSING_SHARED_PARENT, (Object)path.toOSString()));
            }
            IUnmodifiedInfo childInfo = SharingManager.getInstance().findUnmodifiedInfoForChild(parent, path.getName(), null);
            if (childInfo == null && parent.exists(null)) {
                IShareable shareable = SharingManager.getInstance().findShareable(path, ResourceType.FILE);
                if (shareable.exists(null)) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.CheckInCmd_MISSING_SHARED_PARENT, (Object)path.toOSString()));
                }
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)path.toOSString()));
            }
            resource.setItemId(childInfo.getVersionable().getItemId().getUuidValue());
            resource.setVersionableItemType(SubcommandUtil.getVersionableItemType((IItemType)childInfo.getVersionable().getItemType()));
            resource.setRemote(true);
        }
        if (!SubcommandUtil.exists((ILocation)(ipath = new PathLocation(fullPath = resource.getFullPath())), null) && resource.isRemote()) {
            resources.add(resource);
            this.addCheckinPath(changeset, null, resource.getShare(), null, null, wsIdToWs, client);
        } else {
            this.addCheckinPath(changeset, resource.getPath().getRelativePath(), resource.getShare(), paths, reposOfPaths, wsIdToWs, client);
        }
    }

    static enum DelimiterControl {
        FAIL_ON_ERROR,
        SET_NO_DELIM,
        REWRITE;

    }
}

