/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentSeed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsItemHandle;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSetVersionablePermissionsRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePathList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public class ChangeAccessCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client = null;
    public static final PositionalOptionDefinition OPT_ITEM = new PositionalOptionDefinition("item", 1, -1);
    public static final IOptionKey OPT_WORKSPACE = new OptionKey("workspace");
    public static final IOptionKey OPT_COMPONENT = new OptionKey("component");
    public static final IOptionKey OPT_COMPONENT_ACCESS = new OptionKey("componentaccess");
    public static final IOptionKey OPT_CONTRIBUTOR = new OptionKey("contributor");
    public static final IOptionKey OPT_PROJECTAREA = new OptionKey("projectarea");
    public static final IOptionKey OPT_TEAMAREA = new OptionKey("teamarea");
    public static final IOptionKey OPT_ACCESS_GROUP = new OptionKey("accessgroup");
    public static final IOptionKey OPT_APPLY_TO_CHILD_ITEMS = new OptionKey("apply-to-child-items");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption(OPT_APPLY_TO_CHILD_ITEMS, null, "apply-to-child-items", Messages.ChangeAccessCmdOptions_APPLY_TO_CHILD_ITEMS, 0).addOption((IOptionGroup)new SimpleGroup(false).addOption((INamedOptionDefinition)new NamedOptionDefinition(OPT_WORKSPACE, "w", "workspace", 1), Messages.ChangeAccessCmdOption_WORKSPACE, true).addOption((INamedOptionDefinition)new NamedOptionDefinition(OPT_COMPONENT, "C", "component", 1), CommonOptions.OPT_COMPONENT_SELECTOR_HELP, true)).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption(OPT_CONTRIBUTOR, null, "contrib", Messages.ChangeAccessCmdOptions_CONTRIBUTOR, 1, false).addOption(OPT_PROJECTAREA, null, "projectarea", Messages.ChangeAccessCmdOptions_PROJECTAREA, 1, false).addOption(OPT_TEAMAREA, null, "teamarea", Messages.ChangeAccessCmdOptions_TEAMAREA, 1, false).addOption(OPT_COMPONENT_ACCESS, null, "componentaccess", Messages.ChangeAccessCmdOptions_COMPONENT_ACCESS, 0, false).addOption(OPT_ACCESS_GROUP, null, "accessgroup", Messages.ChangeAccessCmdOptions_ACCESS_GROUP, 1, false)).addOption((IPositionalOptionDefinition)OPT_ITEM, Messages.ChangeAccessCmdOptions_ITEM);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption(OPT_WORKSPACE) && !cli.hasOption(OPT_COMPONENT) || !cli.hasOption(OPT_WORKSPACE) && cli.hasOption(OPT_COMPONENT)) {
            throw StatusHelper.argSyntax((String)Messages.ChangeAccessCmd_SPECIFY_WSCOMP);
        }
        int count = 0;
        if (cli.hasOption(OPT_COMPONENT_ACCESS)) {
            ++count;
        }
        if (cli.hasOption(OPT_CONTRIBUTOR)) {
            ++count;
        }
        if (cli.hasOption(OPT_PROJECTAREA)) {
            ++count;
        }
        if (cli.hasOption(OPT_TEAMAREA)) {
            ++count;
        }
        if (cli.hasOption(OPT_ACCESS_GROUP)) {
            ++count;
        }
        if (count > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_5_ARGUMENTS, (Object[])new Object[]{cli.getDefinition().getOption(OPT_COMPONENT_ACCESS).getName(), cli.getDefinition().getOption(OPT_CONTRIBUTOR).getName(), cli.getDefinition().getOption(OPT_PROJECTAREA).getName(), cli.getDefinition().getOption(OPT_TEAMAREA).getName(), cli.getDefinition().getOption(OPT_ACCESS_GROUP).getName()}));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        List items = cli.getOptions((IOptionKey)OPT_ITEM);
        Map<Object, Object> repoToCompToItems = new HashMap();
        if (cli.hasOption(OPT_WORKSPACE)) {
            ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE), (IScmClientConfiguration)this.config);
            ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT), (IScmClientConfiguration)this.config);
            repoToCompToItems = this.getRemoteItems((IScmCommandLineArgument)wsSelector, (IScmCommandLineArgument)compSelector, items);
        } else {
            repoToCompToItems = this.getLocalItems(items);
        }
        for (Map.Entry<Object, Object> entry : repoToCompToItems.entrySet()) {
            this.changeAccess((ITeamRepository)entry.getKey(), (Map)entry.getValue(), cli);
        }
    }

    private Map<ITeamRepository, Map<WsComp, List<ParmsVersionable>>> getRemoteItems(IScmCommandLineArgument wsSelector, IScmCommandLineArgument compSelector, List<String> items) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)wsSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        String wsId = wsFound.getItemId().getUuidValue();
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsId);
        WorkspaceComponentDTO wsComp = RepoUtil.getComponent((ParmsWorkspace)ws, (String)compSelector.getItemSelector(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        String compId = wsComp.getItemId();
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        ArrayList<String> remotePaths = new ArrayList<String>();
        IScmRichClientRestService.ParmsGetVersionables parmsByPath = new IScmRichClientRestService.ParmsGetVersionables();
        parmsByPath.componentItemId = wsComp.getItemId();
        parmsByPath.contextItemId = wsFound.getItemId().getUuidValue();
        parmsByPath.contextItemNamespace = wsFound.getItemType().getNamespaceURI();
        parmsByPath.contextItemType = wsFound.getItemType().getName();
        for (String item : items) {
            String[] path = StringUtil.splitEscapedPath((String)item);
            remotePaths.add(StringUtil.createPathString((String[])path));
        }
        parmsByPath.paths = remotePaths.toArray(new String[remotePaths.size()]);
        ScmVersionablePathList versionablesByPaths = null;
        try {
            versionablesByPaths = scmService.postGetVersionables(parmsByPath);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
        this.validateVersionables(versionablesByPaths.getPaths(), parmsByPath.paths);
        ArrayList<ParmsVersionable> verItems = new ArrayList<ParmsVersionable>();
        for (ScmVersionablePath ver : versionablesByPaths.getPaths()) {
            if (verItems.contains(ver.getVersionable().getItemId().getUuidValue())) continue;
            ParmsVersionable parm = new ParmsVersionable(ver.getVersionable());
            verItems.add(parm);
        }
        HashMap<WsComp, ArrayList<ParmsVersionable>> compToItems = new HashMap<WsComp, ArrayList<ParmsVersionable>>();
        compToItems.put(new WsComp(wsId, compId), verItems);
        HashMap<ITeamRepository, Map<WsComp, List<ParmsVersionable>>> repoToCompToItems = new HashMap<ITeamRepository, Map<WsComp, List<ParmsVersionable>>>();
        repoToCompToItems.put(repo, compToItems);
        return repoToCompToItems;
    }

    private void validateVersionables(List<ScmVersionablePath> versionables, String[] aliases) throws FileSystemException {
        ArrayList<String> invalidAliases = new ArrayList<String>();
        int index = 0;
        for (ScmVersionablePath verPath : versionables) {
            if (verPath.getVersionable() != null) continue;
            invalidAliases.add(aliases[index]);
        }
        if (invalidAliases.size() > 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_INVALID_ALIAS_UUID_PATH, (Object)invalidAliases.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "))));
        }
        ++index;
    }

    private Map<ITeamRepository, Map<WsComp, List<ParmsVersionable>>> getLocalItems(List<String> items) throws FileSystemException {
        List resProps = RepoUtil.getResourceProperties(items, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        HashMap<String, ITeamRepository> repoUrlToObj = new HashMap<String, ITeamRepository>();
        HashMap<ITeamRepository, Map<WsComp, List<ParmsVersionable>>> repoToCompToItems = new HashMap<ITeamRepository, Map<WsComp, List<ParmsVersionable>>>();
        HashMap compToWsComp = new HashMap();
        for (ResourcePropertiesDTO resProp : resProps) {
            ArrayList<ParmsVersionable> verItems;
            WsComp wsComp;
            HashMap compToItems;
            String repositoryUrl = this.config.getRepositoryURI(resProp.getShare().getRepositoryId(), null);
            ITeamRepository repo = (ITeamRepository)repoUrlToObj.get(repositoryUrl);
            if (repo == null) {
                repo = RepoUtil.getSharedRepository((String)repositoryUrl, (boolean)true);
                repoUrlToObj.put(repositoryUrl, repo);
            }
            if ((compToItems = (HashMap)repoToCompToItems.get(repo)) == null) {
                compToItems = new HashMap();
                repoToCompToItems.put(repo, compToItems);
            }
            if ((wsComp = (WsComp)compToWsComp.get(resProp.getShare().getComponentItemId())) == null) {
                wsComp = new WsComp(resProp.getShare().getContextItemId(), resProp.getShare().getComponentItemId());
            }
            if ((verItems = (ArrayList<ParmsVersionable>)compToItems.get(wsComp)) == null) {
                verItems = new ArrayList<ParmsVersionable>();
                compToItems.put(wsComp, verItems);
            }
            ParmsVersionable ver = new ParmsVersionable();
            ver.itemId = resProp.getItemId();
            ver.versionableItemType = resProp.getVersionableItemType();
            verItems.add(ver);
        }
        return repoToCompToItems;
    }

    private void changeAccess(ITeamRepository repo, Map<WsComp, List<ParmsVersionable>> compIdToItems, ICommandLine cli) throws FileSystemException {
        ParmsItemHandle parmsContext = this.getAccessContext(repo, cli);
        for (Map.Entry<WsComp, List<ParmsVersionable>> entry : compIdToItems.entrySet()) {
            ParmsSetVersionablePermissionsRequest parms = new ParmsSetVersionablePermissionsRequest();
            parms.repositoryUrl = repo.getRepositoryURI();
            parms.readContext = parmsContext;
            parms.componentItemId = entry.getKey().getCompId();
            parms.versionables = entry.getValue().toArray(new ParmsVersionable[entry.getValue().size()]);
            if (cli.hasOption(OPT_APPLY_TO_CHILD_ITEMS)) {
                ParmsComponentSeed seed = new ParmsComponentSeed();
                seed.repositoryUrl = repo.getRepositoryURI();
                seed.itemId = entry.getKey().getWsId();
                seed.itemTypeId = "workspace";
                parms.seed = seed;
            }
            try {
                this.client.postSetVersionablePermissions(parms, null);
            }
            catch (VersionablePermissionDeniedException e) {
                throw StatusHelper.permissionFailure((String)(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : Messages.Common_VERSIONABLE_PERMISSSION_DENIED));
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ChangeAccessCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangeAccessCmd_SUCCESS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParmsItemHandle getAccessContext(ITeamRepository repo, ICommandLine cli) throws FileSystemException {
        ParmsItemHandle context = null;
        if (cli.hasOption(OPT_COMPONENT_ACCESS)) return context;
        if (cli.hasOption(OPT_CONTRIBUTOR)) {
            String contribName = cli.getOption(OPT_CONTRIBUTOR);
            IContributor contrib = RepoUtil.fetchContributor((String)contribName, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            if (contrib == null) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)contribName, (Object)repo.getRepositoryURI()));
            return new ParmsItemHandle((IItemHandle)contrib);
        }
        if (cli.hasOption(OPT_TEAMAREA)) {
            String teamAreaSelector = cli.getOption(OPT_TEAMAREA);
            ITeamArea teamArea = RepoUtil.getTeamArea((String)teamAreaSelector, null, (IScmClientConfiguration)this.config, (ITeamRepository)repo);
            if (teamArea != null) return new ParmsItemHandle((IItemHandle)teamArea);
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListCmd_TeamAreaNotFound, (Object)teamAreaSelector));
        }
        if (cli.hasOption(OPT_PROJECTAREA)) {
            String projAreaSelector = cli.getOption(OPT_PROJECTAREA);
            IProjectArea projArea = RepoUtil.getProjectArea((ITeamRepository)repo, (String)projAreaSelector, (IScmClientConfiguration)this.config);
            if (projArea != null) return new ParmsItemHandle((IItemHandle)projArea);
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projAreaSelector));
        }
        if (!cli.hasOption(OPT_ACCESS_GROUP)) return context;
        ScmCommandLineArgument accessGroupSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_ACCESS_GROUP, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)accessGroupSelector, (RepoUtil.ItemType)RepoUtil.ItemType.ACCESSGROUP);
        IAccessGroup accessGroup = RepoUtil.getAccessGroup((IScmCommandLineArgument)accessGroupSelector, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        if (accessGroup == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_ACCESS_GROUP, (Object)accessGroupSelector));
        }
        context = new ParmsItemHandle((IItemHandle)accessGroup);
        context.itemId = accessGroup.getGroupContextId().getUuidValue();
        return context;
    }

    public static class WsComp {
        String wsId;
        String compId;

        public WsComp(String wsId, String compId) {
            this.wsId = wsId;
            this.compId = compId;
        }

        public String getWsId() {
            return this.wsId;
        }

        public String getCompId() {
            return this.compId;
        }
    }
}

