/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.List;

public class BaselineHierarchyCmd
extends AbstractSubcommand
implements IOptionSource {
    private IFilesystemRestClient client;
    static final PositionalOptionDefinition OPT_BASELINES_SELECTOR = new PositionalOptionDefinition("baseline", 0, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IPositionalOptionDefinition)OPT_BASELINES_SELECTOR, Messages.BaselineHierarchyCmdOptions_BASELINE_HIERARCHY_TO_SHOW);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IUuidAliasRegistry.IUuidAlias uuid = null;
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (cli.hasOption((IOptionKey)OPT_BASELINES_SELECTOR)) {
            List baselineSelectors = cli.getOptions((IOptionKey)OPT_BASELINES_SELECTOR);
            baselineSelectors.size();
            for (String selector : baselineSelectors) {
                uuid = RepoUtil.lookupUuidAndAlias((String)selector);
            }
        }
        if (uuid == null) {
            return;
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client);
        ParmsBaseline parms = new ParmsBaseline();
        parms.baselineItemId = uuid.getUuid().getUuidValue();
        parms.repositoryUrl = repo.getRepositoryURI();
        try {
            BaselineDTO baselineDTO = this.client.postBaselineHierarchy(parms, null);
            this.printResult(repo, baselineDTO);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.BaselineHierarchyCmd_COULD_NOT_DISPLAY_HIERARCHY, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    private void printResult(ITeamRepository repo, BaselineDTO baselineDTO) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(5);
        options.enablePrinter(39);
        JSONObject baseline = JSONPrintUtil.jsonizeBaseline((BaselineDTO)baselineDTO, (PendingChangesUtil.PendingChangesOptions)options);
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)baseline.toString());
        } else {
            IndentingPrintStream printStream = this.config.getWrappedOutputStream();
            PendingChangesUtil.printBaseline((JSONObject)baseline, (String)repo.getRepositoryURI(), (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)printStream);
        }
    }
}

