/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AnnotateCmdOptions;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.common.internal.rest.IFilesystemRestService;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkItemSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.VersionedContentDeleted;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class AnnotateCmd
extends AbstractSubcommand {
    private final int NUMBER_OF_PRINT_COLUMNS = 7;
    IFilesystemRestClient client = null;

    public void run() throws FileSystemException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        String pathName = subargs.getOption((IOptionKey)AnnotateCmdOptions.OPT_PATH);
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ILocation annotatePath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)pathName);
        if (!SubcommandUtil.exists((ILocation)annotatePath, null)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_PathDoesNotExist, (Object)annotatePath.toOSString()));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ResourcePropertiesDTO resProps = RepoUtil.getResourceProperties((String)annotatePath.toOSString(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        if (resProps.getItemId() == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_NoRemotePath, (Object)annotatePath.toOSString()));
        }
        if (!resProps.getVersionableItemType().equals("file")) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AnnotateCmd_MUST_BE_FILE, (Object)annotatePath.toOSString()));
        }
        ITeamRepository repo = RepoUtil.loginUrlArgAncOrOnPath((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ILocation)new PathLocation(annotatePath.toOSString()));
        String[] csIds = this.getChangeSetIds(repo, resProps);
        try {
            this.PrintAnnotations(repo, resProps, csIds);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    private String[] getChangeSetIds(ITeamRepository repo, ResourcePropertiesDTO resProps) throws FileSystemException {
        String[] result;
        IFilesystemRestService service = (IFilesystemRestService)((IClientLibraryContext)repo).getServiceInterface(IFilesystemRestService.class);
        IFilesystemRestService.ParmsGetBlame parms = new IFilesystemRestService.ParmsGetBlame();
        parms.fileItemId = resProps.getItemId();
        parms.workspaceItemId = resProps.getShare().getContextItemId();
        parms.componentItemId = resProps.getShare().getComponentItemId();
        try {
            result = service.getBlame(parms);
        }
        catch (TeamRepositoryException e) {
            if (e instanceof VersionedContentDeleted) {
                throw StatusHelper.versionedContentDeleted((String)NLS.bind((String)Messages.DiffCmd_DELETED_CONTENT, (Object)StringUtil.createPathString((List)resProps.getPath().getRelativePath().getSegments())));
            }
            throw StatusHelper.wrap((String)Messages.AnnotateCmd_ServiceError, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        return result;
    }

    private void PrintAnnotations(ITeamRepository repo, ResourcePropertiesDTO resProps, String[] csIds) throws FileSystemException, TeamRepositoryException {
        JSONObject jResult = this.jsonizeAnnotations(repo, resProps, csIds);
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)jResult.toString());
            return;
        }
        ArrayList<String> strings = new ArrayList<String>(csIds.length * 7);
        assert (jResult != null);
        JSONArray jAnnotations = (JSONArray)jResult.get((Object)"annotations");
        for (Object obj : jAnnotations) {
            JSONObject jAnnotation = (JSONObject)obj;
            strings.add((String)jAnnotation.get((Object)"line-no"));
            strings.add((String)jAnnotation.get((Object)"author"));
            String alias = AliasUtil.alias((String)((String)jAnnotation.get((Object)"uuid")), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            if (alias == null) {
                alias = "";
            }
            strings.add(alias);
            strings.add((String)jAnnotation.get((Object)"modified"));
            strings.add((String)jAnnotation.get((Object)"workitem"));
            strings.add((String)jAnnotation.get((Object)"comment"));
            strings.add((String)jAnnotation.get((Object)"line"));
        }
        IndentingPrintStream ps = this.config.getWrappedOutputStream();
        StringUtil.printTable((IndentingPrintStream)ps, (int)7, (boolean)true, (CharSequence[])strings.toArray(new String[strings.size()]));
    }

    private JSONObject jsonizeAnnotations(ITeamRepository repo, ResourcePropertiesDTO resProps, String[] csIds) throws FileSystemException, TeamRepositoryException {
        ArrayList<String> distinctCsIds = new ArrayList<String>();
        String[] stringArray = csIds;
        int n = csIds.length;
        int n2 = 0;
        while (n2 < n) {
            String csId = stringArray[n2];
            if (!distinctCsIds.contains(csId)) {
                distinctCsIds.add(csId);
            }
            ++n2;
        }
        ChangeSetSyncDTO[] csDTOList = RepoUtil.findChangeSets(distinctCsIds, (boolean)false, null, null, (String)repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        ArrayList<ChangeSetSyncDTO> csList = new ArrayList<ChangeSetSyncDTO>(csIds.length);
        String[] stringArray2 = csIds;
        int n3 = csIds.length;
        int n4 = 0;
        while (n4 < n3) {
            String csId = stringArray2[n4];
            ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOList;
            int n5 = csDTOList.length;
            int n6 = 0;
            while (n6 < n5) {
                ChangeSetSyncDTO csDTO = changeSetSyncDTOArray[n6];
                if (csId.equals(csDTO.getChangeSetItemId())) {
                    csList.add(csDTO);
                    break;
                }
                ++n6;
            }
            ++n4;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream stream = null;
        BufferedReader reader = null;
        JSONObject jResult = new JSONObject();
        try {
            try {
                RepoUtil.httpDownloadFile((ITeamRepository)repo, (String)resProps.getShare().getContextItemId(), (String)resProps.getShare().getComponentItemId(), (String)resProps.getItemId(), (String)resProps.getStateId(), (OutputStream)bos, (IScmClientConfiguration)this.config);
                stream = new ByteArrayInputStream(bos.toByteArray());
                String line = null;
                int count = 0;
                JSONArray jAnnotations = new JSONArray();
                jResult.put((Object)"annotations", (Object)jAnnotations);
                String encoding = null;
                FilePropertiesDTO fileProps = resProps.getFileProperties();
                if (fileProps != null) {
                    encoding = fileProps.getEncoding();
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)stream, encoding));
                while ((line = reader.readLine()) != null) {
                    assert (count <= csIds.length);
                    JSONObject jAnnotation = new JSONObject();
                    ChangeSetSyncDTO cs = (ChangeSetSyncDTO)csList.get(count);
                    String wiString = this.getWorkItemIds(cs);
                    SimpleDateFormat df = SubcommandUtil.getDateFormat((String)"yyyy-MM-dd hh:mm a", (IScmClientConfiguration)this.config);
                    jAnnotation.put((Object)"line-no", (Object)Integer.toString(count + 1));
                    jAnnotation.put((Object)"author", (Object)cs.getAuthorContributorName());
                    jAnnotation.put((Object)"uuid", (Object)cs.getChangeSetItemId());
                    jAnnotation.put((Object)"modified", (Object)df.format(cs.getLastChangeDate()));
                    jAnnotation.put((Object)"workitem", (Object)wiString);
                    jAnnotation.put((Object)"comment", (Object)cs.getChangeSetComment().substring(0, cs.getChangeSetComment().length() > 20 ? 20 : cs.getChangeSetComment().length()));
                    jAnnotation.put((Object)"line", (Object)line);
                    ++count;
                    jAnnotations.add((Object)jAnnotation);
                }
            }
            catch (IOException e) {
                throw StatusHelper.failure((String)Messages.AnnotateCmd_IOReadError, (Throwable)e);
            }
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return jResult;
    }

    private String getWorkItemIds(ChangeSetSyncDTO cs) {
        StringBuffer wiString = new StringBuffer();
        if (cs.getWorkItems().size() > 0) {
            List wiDTOList = cs.getWorkItems();
            int count = 0;
            int[] wiIds = new int[wiDTOList.size()];
            for (WorkItemSyncDTO wiDTO : wiDTOList) {
                JSONPrintUtil.ChangeRequestInfo crInfo = new JSONPrintUtil.ChangeRequestInfo(wiDTO.getLabel());
                wiIds[count++] = crInfo.getId();
            }
            Arrays.sort(wiIds);
            int index = 0;
            while (index < wiIds.length) {
                if (wiString.length() > 0) {
                    wiString.append(",");
                }
                wiString.append(wiIds[index]);
                ++index;
            }
        }
        return wiString.toString();
    }
}

