/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.DeliverCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdLauncher;
import com.ibm.team.filesystem.cli.client.internal.subcommands.LoadCmdOptions;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.JSONPatchPrinter;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.PortsUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContext;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverComponents;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAcceptDetailed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredBaselineUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceComponentOperationsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CurrentPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class AcceptResultDisplayer {
    public static JSONObject showResult(IFilesystemRestClient client, ITeamRepository repo, boolean flowedComponents, ParmsWorkspaceUpdate parms, WorkspaceUpdateResultDTO result, List<ShareableDTO> deletedContentAutoMergeShareables, boolean verbose, IScmClientConfiguration config, JSONArray status) throws FileSystemException {
        JSONObject deletedContentShareablesInfo;
        JSONObject deletedContentAutoMergeShareablesInfo;
        JSONObject shedInfo;
        JSONObject jResult = new JSONObject();
        JSONArray jRepos = AcceptResultDisplayer.jsonizeResults(client, result.getStructuredResult(), verbose, config);
        if (jRepos.size() > 0) {
            jResult.put((Object)"repos", (Object)jRepos);
        }
        HashMap<String, Map<String, Map<String, WarningType>>> warnings = AcceptResultDisplayer.populateWarnings(result);
        JSONArray jNonFlowedComps = null;
        if (!flowedComponents && warnings.size() > 0) {
            Map<String, ITeamRepository> comp2Repo = AcceptResultDisplayer.getComponentToRepoMapping(repo, warnings, parms, config);
            jNonFlowedComps = AcceptResultDisplayer.jsonizeRemainingComponentOperations(repo, warnings, client, config, comp2Repo);
            jResult.put((Object)"non-flowed-comps", (Object)jNonFlowedComps);
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (!config.isJSONEnabled()) {
            AcceptResultDisplayer.showResults(jRepos, verbose, config, out.indent());
            String msgString = NLS.bind((String)Messages.AcceptResultDisplayer_COMPONENT_CHANGE_TITLE, (Object)AcceptCmdOptions.OPT_FLOW_COMPONENTS.getName());
            AcceptResultDisplayer.showRemainingComponentOperations(jNonFlowedComps, out, config, msgString);
        }
        if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0 && (shedInfo = SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed(), (boolean)config.isJSONEnabled())) != null) {
            status.add((Object)shedInfo);
        }
        if (deletedContentAutoMergeShareables != null && deletedContentAutoMergeShareables.size() > 0 && (deletedContentAutoMergeShareablesInfo = SubcommandUtil.showDeletedContent((String)Messages.AcceptResultDisplayer_DELETED_CONTENT_WHEN_AUTOMERGING, deletedContentAutoMergeShareables, (IndentingPrintStream)out, (boolean)config.isJSONEnabled())) != null) {
            status.add((Object)deletedContentAutoMergeShareablesInfo);
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0 && (deletedContentShareablesInfo = SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out, (boolean)config.isJSONEnabled())) != null) {
            status.add((Object)deletedContentShareablesInfo);
        }
        if (result.getStructuredResult().size() == 0) {
            if (config.isJSONEnabled()) {
                status.add((Object)JSONPrintUtil.getJsonStatusObject((int)52, (String)Messages.AcceptResultDisplayer_WORKSPACE_UNCHANGED, (String)Constants.Severity.info.toString()));
            } else {
                out.println((CharSequence)Messages.AcceptResultDisplayer_WORKSPACE_UNCHANGED);
            }
        }
        return jResult;
    }

    public static JSONArray jsonizeResults(IFilesystemRestClient client, List<StructuredUpdateReportDTO> result, boolean verbose, IScmClientConfiguration config) throws FileSystemException {
        HashMap<String, ArrayList<StructuredUpdateReportDTO>> repos = new HashMap<String, ArrayList<StructuredUpdateReportDTO>>();
        for (StructuredUpdateReportDTO report : result) {
            ArrayList<StructuredUpdateReportDTO> reports = (ArrayList<StructuredUpdateReportDTO>)repos.get(report.getRepositoryUrl());
            if (reports == null) {
                reports = new ArrayList<StructuredUpdateReportDTO>(result.size());
                repos.put(report.getRepositoryUrl(), reports);
            }
            reports.add(report);
        }
        JSONArray jRepos = new JSONArray();
        for (List reports : repos.values()) {
            boolean showRepo = true;
            JSONObject jRepo = new JSONObject();
            JSONArray jWorkspaces = new JSONArray();
            for (StructuredUpdateReportDTO report : reports) {
                if (showRepo) {
                    String repoUrl = report.getRepositoryUrl();
                    jRepo.put((Object)"repo-url", (Object)repoUrl);
                    showRepo = false;
                }
                AcceptResultDisplayer.jsonizeWorkspaceUpdateReport(jWorkspaces, client, report, verbose, config);
            }
            jRepo.put((Object)"workspaces", (Object)jWorkspaces);
            jRepos.add((Object)jRepo);
        }
        return jRepos;
    }

    public static JSONObject showDeliverResult(IFilesystemRestClient client, boolean printFlowComponentInfo, ParmsDeliver parms, DeliverResultDTO result, boolean verbose, IScmClientConfiguration config, IndentingPrintStream out, JSONArray status) throws FileSystemException {
        JSONObject deletedContentShareablesInfo;
        JSONObject shedInfo;
        JSONObject jResult = new JSONObject();
        JSONArray jRepos = AcceptResultDisplayer.jsonizeResults(client, result.getStructuredResult(), verbose, config);
        if (jRepos.size() > 0) {
            jResult.put((Object)"repos", (Object)jRepos);
        }
        HashMap<String, Map<String, Map<String, WarningType>>> warnings = AcceptResultDisplayer.populateDeliverWarnings(result);
        JSONArray jNonFlowedComps = null;
        if (printFlowComponentInfo && warnings.size() > 0) {
            Map<String, ITeamRepository> comp2Repo = AcceptResultDisplayer.getComponentToRepoMapping(null, warnings, parms, config);
            jNonFlowedComps = AcceptResultDisplayer.jsonizeRemainingComponentOperations(null, warnings, client, config, comp2Repo);
            jResult.put((Object)"non-flowed-comps", (Object)jNonFlowedComps);
        }
        if (!config.isJSONEnabled()) {
            AcceptResultDisplayer.showResults(jRepos, verbose, config, out);
            String msgString = NLS.bind((String)Messages.AcceptResultDisplayer_COMPONENT_DELIVER_CHANGE_TITLE, (Object[])new String[]{DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS.getName(), DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS.getName()});
            AcceptResultDisplayer.showRemainingComponentOperations(jNonFlowedComps, out, config, msgString);
        } else {
            config.getOutputStream().print((CharSequence)jResult.toString());
        }
        if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0 && (shedInfo = SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed(), (boolean)config.isJSONEnabled())) != null) {
            status.add((Object)shedInfo);
        }
        if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0 && (deletedContentShareablesInfo = SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out, (boolean)config.isJSONEnabled())) != null) {
            status.add((Object)deletedContentShareablesInfo);
        }
        return jResult;
    }

    public static void showResults(JSONArray jRepos, boolean verbose, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        if (jRepos == null) {
            return;
        }
        boolean isStream = false;
        for (Object obj : jRepos) {
            JSONObject jRepo = (JSONObject)obj;
            String repoUrl = (String)jRepo.get((Object)"repo-url");
            out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_REPOSITORY_DESCRIPTION, (Object)repoUrl));
            JSONArray jWorkspaces = (JSONArray)jRepo.get((Object)"workspaces");
            ArrayList workspaceJsons = new ArrayList(jWorkspaces);
            Collections.sort(workspaceJsons, new JsonNameComparator());
            for (Object jObj : workspaceJsons) {
                JSONObject jWorkspace = (JSONObject)jObj;
                isStream = (Boolean)jWorkspace.get((Object)"isStream");
                AcceptResultDisplayer.showWorkspaceUpdateReport(config, jWorkspace, out, verbose, isStream);
            }
        }
    }

    private static JSONArray jsonizeRemainingComponentOperations(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, IFilesystemRestClient client, IScmClientConfiguration config, Map<String, ITeamRepository> comp2Repo) throws FileSystemException {
        String repoUrl = null;
        Map<UUID, String> names = null;
        if (repo != null) {
            names = AcceptResultDisplayer.fetchNames(repo, warnings, comp2Repo, config);
            repoUrl = repo.getRepositoryURI();
        }
        JSONArray jNonFlowedComps = new JSONArray();
        for (Map.Entry<String, Map<String, Map<String, WarningType>>> repoEntry : warnings.entrySet()) {
            if (repo == null) {
                repoUrl = repoEntry.getKey();
                ITeamRepository targetRepo = RepoUtil.getSharedRepository((String)repoEntry.getKey(), (boolean)true);
                names = AcceptResultDisplayer.fetchNames(targetRepo, warnings, comp2Repo, config);
            }
            JSONObject jRepo = new JSONObject();
            jRepo.put((Object)"repo", (Object)repoEntry.getKey());
            JSONArray jWorkspaces = new JSONArray();
            for (Map.Entry<String, Map<String, WarningType>> wsEntry : repoEntry.getValue().entrySet()) {
                JSONObject jWS = new JSONObject();
                ParmsWorkspace targetWs = new ParmsWorkspace(repoUrl, wsEntry.getKey());
                WorkspaceDetailsDTO targetWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
                RepoUtil.ItemType targetWsType = targetWsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE;
                String name = names.get(UUID.valueOf((String)wsEntry.getKey()));
                jWS.put((Object)"name", (Object)name);
                jWS.put((Object)"uuid", (Object)wsEntry.getKey());
                jWS.put((Object)"type", (Object)targetWsType.toString());
                jWS.put((Object)"url", (Object)repoUrl);
                JSONArray jComps = new JSONArray();
                for (Map.Entry<String, WarningType> compEntry : wsEntry.getValue().entrySet()) {
                    JSONObject jComp = new JSONObject();
                    name = names.get(UUID.valueOf((String)compEntry.getKey()));
                    jComp.put((Object)"name", (Object)name);
                    String srcRepoUrl = comp2Repo.get(compEntry.getKey()).getRepositoryURI();
                    jComp.put((Object)"url", (Object)srcRepoUrl);
                    jComp.put((Object)"uuid", (Object)compEntry.getKey());
                    switch (compEntry.getValue()) {
                        case ADD: {
                            jComp.put((Object)"type", (Object)"add");
                            break;
                        }
                        case DELETE: {
                            jComp.put((Object)"type", (Object)"delete");
                            break;
                        }
                        case REPLACE: {
                            jComp.put((Object)"type", (Object)"replace");
                            break;
                        }
                        default: {
                            jComp.put((Object)"type", (Object)name);
                        }
                    }
                    jComps.add((Object)jComp);
                }
                if (jComps.size() > 0) {
                    jWS.put((Object)"components", (Object)jComps);
                }
                jWorkspaces.add((Object)jWS);
            }
            if (jWorkspaces.size() > 0) {
                jRepo.put((Object)"workspaces", (Object)jWorkspaces);
            }
            jNonFlowedComps.add((Object)jRepo);
        }
        return jNonFlowedComps;
    }

    private static void showRemainingComponentOperations(JSONArray jNonFlowedComps, IndentingPrintStream out, IScmClientConfiguration config, String msgString) throws FileSystemException {
        if (jNonFlowedComps == null) {
            return;
        }
        out.println((CharSequence)msgString);
        for (Object obj : jNonFlowedComps) {
            JSONObject jRepo = (JSONObject)obj;
            IndentingPrintStream repoOut = out.indent();
            repoOut.println((CharSequence)((String)jRepo.get((Object)"repo")));
            JSONArray jWorkspaces = (JSONArray)jRepo.get((Object)"workspaces");
            if (jWorkspaces == null) continue;
            for (Object wsObj : jWorkspaces) {
                JSONObject jWS = (JSONObject)wsObj;
                IndentingPrintStream wsOut = repoOut.indent();
                String name = (String)jWS.get((Object)"name");
                String uuid = (String)jWS.get((Object)"uuid");
                String wsTypeStr = (String)jWS.get((Object)"type");
                String url = (String)jWS.get((Object)"url");
                RepoUtil.ItemType wsType = PendingChangesUtil.getWorkspaceType((String)wsTypeStr);
                wsOut.println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)name, (UUID)UUID.valueOf((String)uuid), (String)url, (RepoUtil.ItemType)wsType));
                JSONArray jComps = (JSONArray)jWS.get((Object)"components");
                IndentingPrintStream compOut = wsOut.indent();
                if (jComps == null) continue;
                for (Object jCompObj : jComps) {
                    JSONObject jComp = (JSONObject)jCompObj;
                    String compUUID = (String)jComp.get((Object)"uuid");
                    String compName = (String)jComp.get((Object)"name");
                    String srcRepoUrl = (String)jComp.get((Object)"url");
                    String opType = (String)jComp.get((Object)"type");
                    if (opType.equals("add")) {
                        compOut.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_COMP_ADD, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)compName, (UUID)UUID.valueOf((String)compUUID), (String)srcRepoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                        continue;
                    }
                    if (opType.equals("delete")) {
                        compOut.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_COMP_DELETE, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)compName, (UUID)UUID.valueOf((String)compUUID), (String)srcRepoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                        continue;
                    }
                    if (opType.equals("replace")) {
                        compOut.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_COMP_REPLACE, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)compName, (UUID)UUID.valueOf((String)compUUID), (String)srcRepoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                        continue;
                    }
                    compOut.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_ERROR_MSG, (Object)compName));
                }
            }
        }
    }

    private static Map<String, ITeamRepository> getComponentToRepoMapping(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, ParmsWorkspaceUpdate parms, IScmClientConfiguration config) throws CLIFileSystemClientException {
        HashMap<String, ITeamRepository> comp2Repo = new HashMap<String, ITeamRepository>();
        HashMap<String, ITeamRepository> url2Repo = new HashMap<String, ITeamRepository>();
        if (parms.workspaceAcceptDetailed != null) {
            ParmsWorkspaceAcceptDetailed[] parmsWorkspaceAcceptDetailedArray = parms.workspaceAcceptDetailed;
            int n = parms.workspaceAcceptDetailed.length;
            int n2 = 0;
            while (n2 < n) {
                ParmsWorkspaceAcceptDetailed acceptParms = parmsWorkspaceAcceptDetailedArray[n2];
                if (acceptParms.componentItemIds != null) {
                    ITeamRepository sourceRepo = (ITeamRepository)url2Repo.get(acceptParms.sourceWorkspace.repositoryUrl);
                    if (sourceRepo == null) {
                        sourceRepo = RepoUtil.getSharedRepository((String)acceptParms.sourceWorkspace.repositoryUrl, (boolean)true);
                        url2Repo.put(acceptParms.sourceWorkspace.repositoryUrl, sourceRepo);
                    }
                    String[] stringArray = acceptParms.componentItemIds;
                    int n3 = acceptParms.componentItemIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String componentItemId = stringArray[n4];
                        comp2Repo.put(componentItemId, sourceRepo);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        AcceptResultDisplayer.getHierarchialComponentsToRepoMapping(repo, warnings, comp2Repo);
        return comp2Repo;
    }

    private static Map<String, ITeamRepository> getComponentToRepoMapping(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, ParmsDeliver parms, IScmClientConfiguration config) throws CLIFileSystemClientException, FileSystemException {
        ITeamRepository sourceRepo;
        List componentItemIds;
        int n;
        int n2;
        ParmsDeliverComponents[] parmsDeliverComponentsArray;
        HashMap<String, ITeamRepository> comp2Repo = new HashMap<String, ITeamRepository>();
        HashMap<String, ITeamRepository> url2Repo = new HashMap<String, ITeamRepository>();
        if (parms.deliverComponents != null) {
            parmsDeliverComponentsArray = parms.deliverComponents;
            n2 = parms.deliverComponents.length;
            n = 0;
            while (n < n2) {
                ParmsDeliverComponents deliverParms = parmsDeliverComponentsArray[n];
                if (deliverParms.componentItemIds != null) {
                    ITeamRepository sourceRepo2 = (ITeamRepository)url2Repo.get(deliverParms.sourceWorkspace.repositoryUrl);
                    if (sourceRepo2 == null) {
                        sourceRepo2 = RepoUtil.getSharedRepository((String)deliverParms.sourceWorkspace.repositoryUrl, (boolean)true);
                        url2Repo.put(deliverParms.sourceWorkspace.repositoryUrl, sourceRepo2);
                    }
                    String[] stringArray = deliverParms.componentItemIds;
                    int n3 = deliverParms.componentItemIds.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String componentItemId = stringArray[n4];
                        comp2Repo.put(componentItemId, sourceRepo2);
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (parms.deliverWorkspaces != null) {
            parmsDeliverComponentsArray = parms.deliverWorkspaces;
            n2 = parms.deliverWorkspaces.length;
            n = 0;
            while (n < n2) {
                ParmsDeliverComponents deliverWorkspace = parmsDeliverComponentsArray[n];
                componentItemIds = null;
                try {
                    componentItemIds = deliverWorkspace.sourceWorkspace.getWorkspaceConnection(null).getComponents();
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.DeliverCmd_UNABLE_TO_GET_WORKSPACE_CONNECTION, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)deliverWorkspace.sourceWorkspace.repositoryUrl);
                }
                if (componentItemIds != null) {
                    sourceRepo = (ITeamRepository)url2Repo.get(deliverWorkspace.sourceWorkspace.repositoryUrl);
                    if (sourceRepo == null) {
                        sourceRepo = RepoUtil.getSharedRepository((String)deliverWorkspace.sourceWorkspace.repositoryUrl, (boolean)true);
                        url2Repo.put(deliverWorkspace.sourceWorkspace.repositoryUrl, sourceRepo);
                    }
                    for (IComponentHandle componentItemId : componentItemIds) {
                        comp2Repo.put(componentItemId.getItemId().getUuidValue(), sourceRepo);
                    }
                }
                ++n;
            }
        }
        if (parms.deliverChangeSetsOrBaselines != null) {
            parmsDeliverComponentsArray = parms.deliverChangeSetsOrBaselines;
            n2 = parms.deliverChangeSetsOrBaselines.length;
            n = 0;
            while (n < n2) {
                ParmsDeliverComponents deliverChangeSets = parmsDeliverComponentsArray[n];
                componentItemIds = null;
                try {
                    componentItemIds = deliverChangeSets.sourceWorkspace.getWorkspaceConnection(null).getComponents();
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.DeliverCmd_UNABLE_TO_GET_WORKSPACE_CONNECTION, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)deliverChangeSets.sourceWorkspace.repositoryUrl);
                }
                if (componentItemIds != null) {
                    sourceRepo = (ITeamRepository)url2Repo.get(deliverChangeSets.sourceWorkspace.repositoryUrl);
                    if (sourceRepo == null) {
                        sourceRepo = RepoUtil.getSharedRepository((String)deliverChangeSets.sourceWorkspace.repositoryUrl, (boolean)true);
                        url2Repo.put(deliverChangeSets.sourceWorkspace.repositoryUrl, sourceRepo);
                    }
                    for (IComponentHandle componentItemId : componentItemIds) {
                        comp2Repo.put(componentItemId.getItemId().getUuidValue(), sourceRepo);
                    }
                }
                ++n;
            }
        }
        AcceptResultDisplayer.getHierarchialComponentsToRepoMapping(repo, warnings, comp2Repo);
        return comp2Repo;
    }

    private static void getHierarchialComponentsToRepoMapping(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, Map<String, ITeamRepository> comp2Repo) throws CLIFileSystemClientException {
        ITeamRepository targetRepo = repo;
        for (Map.Entry<String, Map<String, Map<String, WarningType>>> repoEntry : warnings.entrySet()) {
            if (repo == null) {
                targetRepo = RepoUtil.getSharedRepository((String)repoEntry.getKey(), (boolean)true);
            }
            for (Map.Entry<String, Map<String, WarningType>> wsEntry : repoEntry.getValue().entrySet()) {
                for (Map.Entry<String, WarningType> compEntry : wsEntry.getValue().entrySet()) {
                    String componentUuid = compEntry.getKey();
                    if (compEntry.getValue() == WarningType.ADD) {
                        boolean found = comp2Repo.containsKey(componentUuid);
                        if (!found) {
                            for (ITeamRepository testRepo : comp2Repo.values()) {
                                IItemHandle componentHandle = IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentUuid), null);
                                IItem component = null;
                                try {
                                    component = testRepo.itemManager().fetchCompleteItem(componentHandle, 0, null);
                                }
                                catch (TeamRepositoryException teamRepositoryException) {
                                    // empty catch block
                                }
                                if (component == null) continue;
                                comp2Repo.put(componentUuid, testRepo);
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangeDisplayer_7, (Object)componentUuid));
                    }
                    comp2Repo.put(componentUuid, targetRepo);
                }
            }
        }
    }

    private static HashMap<String, Map<String, Map<String, WarningType>>> populateDeliverWarnings(DeliverResultDTO result) {
        HashMap<String, Map<String, Map<String, WarningType>>> toReturn = new HashMap<String, Map<String, Map<String, WarningType>>>();
        if (result.getComponentOperations().size() > 0) {
            for (Object o2 : result.getComponentOperations()) {
                WorkspaceComponentOperationsDTO wcoDTO = (WorkspaceComponentOperationsDTO)o2;
                AcceptResultDisplayer.populateDeliverWarning(wcoDTO.getAddedComponents(), wcoDTO.getTargetWorkspace(), toReturn, WarningType.ADD);
                AcceptResultDisplayer.populateDeliverWarning(wcoDTO.getRemovedComponents(), wcoDTO.getTargetWorkspace(), toReturn, WarningType.DELETE);
                AcceptResultDisplayer.populateDeliverWarning(wcoDTO.getReplacedComponents(), wcoDTO.getTargetWorkspace(), toReturn, WarningType.REPLACE);
            }
        }
        return toReturn;
    }

    private static Map<UUID, String> fetchNames(ITeamRepository repo, HashMap<String, Map<String, Map<String, WarningType>>> warnings, Map<String, ITeamRepository> comp2Repo, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, HashSet<IItemHandle>> repo2ItemHandles = new HashMap<ITeamRepository, HashSet<IItemHandle>>();
        for (Map.Entry<String, Map<String, Map<String, WarningType>>> repoEntry : warnings.entrySet()) {
            for (Map.Entry<String, Map<String, WarningType>> entry : repoEntry.getValue().entrySet()) {
                HashSet<IItemHandle> itemHandles = (HashSet<IItemHandle>)repo2ItemHandles.get(repo);
                if (itemHandles == null) {
                    itemHandles = new HashSet<IItemHandle>();
                    repo2ItemHandles.put(repo, itemHandles);
                }
                itemHandles.add(IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)entry.getKey()), null));
                for (Map.Entry<String, WarningType> compEntry : entry.getValue().entrySet()) {
                    ITeamRepository srcRepo = comp2Repo.get(compEntry.getKey());
                    HashSet<IItemHandle> itemCompHandles = (HashSet<IItemHandle>)repo2ItemHandles.get(srcRepo);
                    if (itemCompHandles == null) {
                        itemCompHandles = new HashSet<IItemHandle>();
                        repo2ItemHandles.put(srcRepo, itemCompHandles);
                    }
                    itemCompHandles.add(IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)compEntry.getKey()), null));
                }
            }
        }
        ArrayList items = new ArrayList();
        try {
            for (Map.Entry repoEntry : repo2ItemHandles.entrySet()) {
                ArrayList itemHandles = new ArrayList((Collection)repoEntry.getValue());
                List repoItems = ((ITeamRepository)repoEntry.getKey()).itemManager().fetchCompleteItems(itemHandles, 0, null);
                items.addAll(repoItems);
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.AcceptResultDisplayer_FETCH_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        HashMap<UUID, String> names = new HashMap<UUID, String>();
        for (IItem iItem : items) {
            String name = iItem instanceof IWorkspace ? ((IWorkspace)iItem).getName() : (iItem instanceof IComponent ? ((IComponent)iItem).getName() : NLS.bind((String)Messages.AcceptResultDisplayer_UNKNOWN_INTERNAL_CLASS, (Object)iItem.getClass().getSimpleName()));
            names.put(iItem.getItemId(), name);
        }
        return names;
    }

    private static HashMap<String, Map<String, Map<String, WarningType>>> populateWarnings(WorkspaceUpdateResultDTO result) {
        HashMap<String, Map<String, Map<String, WarningType>>> toReturn = new HashMap<String, Map<String, Map<String, WarningType>>>();
        AcceptResultDisplayer.populateWarning(result.getComponentFlowAdditions(), toReturn, WarningType.ADD);
        AcceptResultDisplayer.populateWarning(result.getComponentFlowDeletions(), toReturn, WarningType.DELETE);
        AcceptResultDisplayer.populateWarning(result.getComponentReplacementCandidates(), toReturn, WarningType.REPLACE);
        return toReturn;
    }

    private static void populateWarning(List<ConfigurationDescriptorDTO> comps, HashMap<String, Map<String, Map<String, WarningType>>> toReturn, WarningType type) {
        String url = null;
        String wsId = null;
        String compId = null;
        for (ConfigurationDescriptorDTO comp : comps) {
            url = comp.getConnection().getRepositoryURL();
            wsId = comp.getConnection().getContextItemId();
            compId = comp.getComponentItemId();
            AcceptResultDisplayer.populateToReturn(wsId, url, compId, type, toReturn);
        }
    }

    private static void populateDeliverWarning(List<ComponentDTO> comps, WorkspaceDTO targetWS, HashMap<String, Map<String, Map<String, WarningType>>> toReturn, WarningType type) {
        String url = targetWS.getRepositoryURL();
        String wsId = targetWS.getItemId();
        String compId = null;
        for (ComponentDTO comp : comps) {
            compId = comp.getItemId();
            AcceptResultDisplayer.populateToReturn(wsId, url, compId, type, toReturn);
        }
    }

    private static void populateToReturn(String wsId, String repoUrl, String compId, WarningType type, HashMap<String, Map<String, Map<String, WarningType>>> toReturn) {
        String contextId;
        Map<String, WarningType> containedComps;
        Map<String, Map<String, WarningType>> ws = toReturn.get(repoUrl);
        if (ws == null) {
            ws = new HashMap<String, Map<String, WarningType>>();
            toReturn.put(repoUrl, ws);
        }
        if ((containedComps = ws.get(contextId = wsId)) == null) {
            containedComps = new HashMap<String, WarningType>();
            ws.put(contextId, containedComps);
        }
        containedComps.put(compId, type);
    }

    private static HashSet<String> extractConflicts(StructuredComponentUpdateReportDTO compDto) {
        HashSet<String> conflicts = new HashSet<String>();
        conflicts.addAll(compDto.getConflictedItemIds());
        return conflicts;
    }

    private static void jsonizeWorkspaceUpdateReport(JSONArray jWorkspaces, IFilesystemRestClient client, StructuredUpdateReportDTO dto, boolean verbose, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jWS = new JSONObject();
        boolean isStream = false;
        jWorkspaces.add((Object)jWS);
        jWS.put((Object)"name", (Object)dto.getWorkspaceName());
        jWS.put((Object)"uuid", (Object)dto.getWorkspaceItemId());
        jWS.put((Object)"url", (Object)dto.getRepositoryUrl());
        ParmsWorkspace targetWs = new ParmsWorkspace(dto.getRepositoryUrl(), dto.getWorkspaceItemId());
        List targetWsList = RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        if (!targetWsList.isEmpty()) {
            WorkspaceDetailsDTO targetWsDetails = (WorkspaceDetailsDTO)targetWsList.get(0);
            isStream = targetWsDetails.isStream();
        }
        jWS.put((Object)"isStream", (Object)isStream);
        JSONArray jComps = new JSONArray();
        for (StructuredComponentUpdateReportDTO compDto : dto.getComponents()) {
            List baselineDtos;
            List<ChangeSetSyncDTO> csDtos;
            JSONObject jComp = new JSONObject();
            jComp.put((Object)"name", (Object)compDto.getComponentName());
            jComp.put((Object)"uuid", (Object)compDto.getComponentItemId());
            jComp.put((Object)"url", (Object)dto.getRepositoryUrl());
            HashSet<String> conflictIds = AcceptResultDisplayer.extractConflicts(compDto);
            CurrentPatchDTO currentPort = compDto.getCurrentPatch();
            if (currentPort != null) {
                PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                options.enablePrinter(4);
                options.setVerbose(verbose || config.isJSONEnabled());
                JSONPatchPrinter portChangeSets = PortsUtil.getChangeSets((String)dto.getRepositoryUrl(), (CurrentPatchDTO)currentPort, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                portChangeSets.jsonize(jComp, options, config);
            }
            if (!(csDtos = AcceptResultDisplayer.getChangeSets(client, dto.getRepositoryUrl(), dto.getWorkspaceItemId(), compDto.getChangeSetItemIds(), config)).isEmpty()) {
                PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                options.enablePrinter(4);
                options.enablePrinter(23);
                options.enablePrinter(6);
                options.enablePrinter(7);
                options.setVerbose(verbose || config.isJSONEnabled());
                ChangeSetStateFactory stateFactory = new ChangeSetStateFactory();
                stateFactory.setConflictItems(new ArrayList<String>(conflictIds));
                JSONPrintUtil.jsonizeChangeSets((JSONObject)jComp, (String)"changes", csDtos, (ChangeSetStateFactory)stateFactory, (PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            }
            if (!(baselineDtos = compDto.getBaselines()).isEmpty()) {
                JSONArray jBaselines = new JSONArray();
                AcceptResultDisplayer.jsonizeBaselines(jBaselines, baselineDtos, dto.getRepositoryUrl());
                jComp.put((Object)"baselines", (Object)jBaselines);
            }
            jComps.add((Object)jComp);
        }
        if (jComps.size() > 0) {
            jWS.put((Object)"components", (Object)jComps);
        }
    }

    private static void showWorkspaceUpdateReport(IScmClientConfiguration config, JSONObject jWorkspace, IndentingPrintStream out, boolean verbose, boolean isStream) throws FileSystemException {
        String message = null;
        message = isStream ? Messages.AcceptResultDisplayer_STREAM_DESCRIPTION : Messages.AcceptResultDisplayer_WORKSPACE_DESCRIPTION;
        out.println((CharSequence)NLS.bind((String)message, (Object)AliasUtil.selector((String)((String)jWorkspace.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jWorkspace.get((Object)"uuid"))), (String)((String)jWorkspace.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE)));
        out = out.indent();
        JSONArray jComps = (JSONArray)jWorkspace.get((Object)"components");
        if (jComps != null) {
            ArrayList componentJsons = new ArrayList(jComps);
            Collections.sort(componentJsons, new JsonNameComparator());
            for (JSONObject jComp : componentJsons) {
                JSONArray jBaselines;
                out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_COMPONENT_DESCRIPTION, (Object)AliasUtil.selector((String)((String)jComp.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jComp.get((Object)"uuid"))), (String)((String)jComp.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                IndentingPrintStream compOut = out.indent();
                PendingChangesUtil.PendingChangesOptions pOptions = new PendingChangesUtil.PendingChangesOptions();
                pOptions.enablePrinter(4);
                pOptions.enablePrinter(32);
                pOptions.setVerbose(verbose || config.isJSONEnabled());
                PendingChangesUtil.printCurrentPort((String)((String)jComp.get((Object)"url")), (JSONObject)jComp, (PendingChangesUtil.PendingChangesOptions)pOptions, (IndentingPrintStream)compOut);
                if (jComp.get((Object)"changes") != null) {
                    PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                    options.enablePrinter(4);
                    options.enablePrinter(23);
                    options.enablePrinter(6);
                    options.enablePrinter(7);
                    options.setVerbose(verbose || config.isJSONEnabled());
                    PendingChangesUtil.printChangeSets((JSONObject)jComp, (String)"changes", (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)compOut);
                }
                if ((jBaselines = (JSONArray)jComp.get((Object)"baselines")) == null) continue;
                compOut.println((CharSequence)Messages.AcceptResultDisplayer_LIST_OF_ACCEPTED_BASELINES);
                IndentingPrintStream blOut = compOut.indent();
                AcceptResultDisplayer.showBaselines(jBaselines, blOut, (String)jComp.get((Object)"url"));
            }
        }
    }

    private static List<ChangeSetSyncDTO> getChangeSets(IFilesystemRestClient restClient, String repositoryUrl, String workspaceItemId, List<String> changeSetItemIds, IScmClientConfiguration config) throws FileSystemException {
        if (changeSetItemIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ParmsGetChangeSets parmsGetChangeSets = new ParmsGetChangeSets();
        parmsGetChangeSets.changeSetItemIds = changeSetItemIds.toArray(new String[changeSetItemIds.size()]);
        parmsGetChangeSets.repositoryUrl = repositoryUrl;
        ParmsResolveChangeSet csParms = new ParmsResolveChangeSet();
        csParms.context = new ParmsContext();
        csParms.context.repositoryUrl = repositoryUrl;
        csParms.context.itemId = workspaceItemId;
        csParms.context.type = "workspace";
        csParms.includeChanges = true;
        csParms.includeFoldersInChangeLists = true;
        parmsGetChangeSets.settings = csParms;
        try {
            ChangeSetSyncDTO[] result = restClient.postGetChangeSets(parmsGetChangeSets, null);
            return Arrays.asList(result);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.AcceptResultDisplayer_FETCH_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repositoryUrl);
        }
    }

    private static void jsonizeBaselines(JSONArray jBaselines, List<StructuredBaselineUpdateReportDTO> baselineDtos, String repoUrl) {
        for (StructuredBaselineUpdateReportDTO blDto : baselineDtos) {
            JSONObject jBaseline = new JSONObject();
            jBaseline.put((Object)"uuid", (Object)blDto.getBaselineItemId());
            jBaseline.put((Object)"id", (Object)blDto.getBaselineId());
            jBaseline.put((Object)"name", (Object)blDto.getBaselineName());
            jBaselines.add((Object)jBaseline);
        }
    }

    private static void showBaselines(JSONArray jBaselines, IndentingPrintStream out, String repoUrl) {
        for (Object obj : jBaselines) {
            JSONObject jBaseline = (JSONObject)obj;
            String alias = AliasUtil.alias((String)((String)jBaseline.get((Object)"uuid")), (String)repoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            String id = Long.toString((Long)jBaseline.get((Object)"id"));
            String name = (String)jBaseline.get((Object)"name");
            out.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_BASELINE_DESCRIPTION, (Object[])new String[]{alias, id, name}));
        }
    }

    public static String getChangeSetFlags(boolean hasConflict, boolean hasCollision, boolean isActive) {
        StringBuilder flags = new StringBuilder();
        flags.append(hasCollision ? "!" : "-");
        flags.append(hasConflict ? "#" : "-");
        flags.append(isActive ? "@" : "$");
        return flags.toString();
    }

    public static void showOutOfSync(List<ShareDTO> outOfSyncShareList, IScmClientConfiguration config) throws FileSystemException {
        if (outOfSyncShareList.size() > 0) {
            HashMap<String, ArrayList<ShareDTO>> ws2Shares = new HashMap<String, ArrayList<ShareDTO>>();
            for (ShareDTO share : outOfSyncShareList) {
                ArrayList<ShareDTO> shares = (ArrayList<ShareDTO>)ws2Shares.get(share.getContextItemId());
                if (shares == null) {
                    shares = new ArrayList<ShareDTO>();
                    ws2Shares.put(share.getContextItemId(), shares);
                }
                shares.add(share);
            }
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.AcceptCmd_OUT_OF_SYNC);
            HashSet<String> itemSet = new HashSet<String>();
            for (Map.Entry entry : ws2Shares.entrySet()) {
                err.println((CharSequence)NLS.bind((String)Messages.AcceptResultDisplayer_WORKSPACE_DESCRIPTION, (Object)AliasUtil.selector((String)((ShareDTO)((List)entry.getValue()).get(0)).getContextName(), (UUID)UUID.valueOf((String)((ShareDTO)((List)entry.getValue()).get(0)).getContextItemId()), (String)config.getRepositoryURI(((ShareDTO)((List)entry.getValue()).get(0)).getRepositoryId(), null), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE)));
                for (ShareDTO share : (List)entry.getValue()) {
                    if (itemSet.contains(share.getComponentItemId())) continue;
                    err.indent().println((CharSequence)AliasUtil.selector((String)share.getComponentName(), (UUID)UUID.valueOf((String)share.getComponentItemId()), (String)config.getRepositoryURI(share.getRepositoryId(), null), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
                    itemSet.add(share.getComponentItemId());
                }
            }
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, LoadCmdLauncher.class);
            throw StatusHelper.outOfSync((String)NLS.bind((String)Messages.CheckInCmd_9, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), ((OptionKey)LoadCmdOptions.OPT_FORCE).getName(), ((OptionKey)LoadCmdOptions.OPT_RESYNC).getName()}));
        }
    }

    private static final class JsonNameComparator
    implements Comparator<JSONObject> {
        private JsonNameComparator() {
        }

        @Override
        public int compare(JSONObject object1, JSONObject object2) {
            return ((String)object1.get((Object)"name")).compareTo((String)object2.get((Object)"name"));
        }
    }

    static enum WarningType {
        ADD,
        DELETE,
        REPLACE;

    }
}

