/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.subcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.GapInPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.InPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListPortsCmd;
import com.ibm.team.filesystem.cli.client.internal.portcommand.CurrentPortCmd;
import com.ibm.team.filesystem.cli.client.internal.portcommand.PortResolveCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmdOpts;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmd;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.ITypedPreferenceRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsExternalTool;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsStructuredResultOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceAcceptDetailed;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredComponentUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CurrentPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.BaselineSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyNodeDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.subcommands.HelpCmd;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.PatchInProgressException;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSet;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmGapFillingChangeSetsReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmGapFillingChangeSetsReportList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class AcceptCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        JSONObject portWarning;
        WorkspaceUpdateResultDTO result;
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ICommandLine subcmd = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(subcmd.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        boolean automergeDisabled = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE);
        if (automergeDisabled && subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_INVALID_INPLACE_CONFLICT_MARKER_REQUEST, (Object)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER.getName(), (Object)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE.getName()));
        }
        ITeamRepository repo = null;
        ParmsWorkspaceUpdate parms = new ParmsWorkspaceUpdate();
        repo = this.generateAcceptParms(this.config, client, subcmd, parms);
        if (this.config.isDryRun()) {
            return;
        }
        try {
            result = client.postWorkspaceUpdate(parms, null);
        }
        catch (TeamRepositoryException e) {
            if (this.isActiveChangeSetsException(e)) {
                throw StatusHelper.disallowed((String)Messages.AcceptCmd2_CANNOT_ACCEPT_ACTIVE_CS);
            }
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            PatchInProgressException port = (PatchInProgressException)SubcommandUtil.findExceptionByType(PatchInProgressException.class, (TeamRepositoryException)e);
            if (port != null) {
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, HelpCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, AcceptCmd.class);
                throw StatusHelper.portsInProgress((String)(String.valueOf(port.getLocalizedMessage()) + " " + NLS.bind((String)Messages.AcceptCmd_PORT_IN_PROGRESS_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString()})));
            }
            GapException gap = (GapException)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e);
            if (gap != null) {
                String commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, HelpCmd.class);
                throw StatusHelper.gap((String)(String.valueOf(Messages.AcceptCmd_MISSING_CHANGE_SETS) + "\n" + NLS.bind((String)Messages.DeliverCmd2_HINT_ON_GAP, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), commandName})));
            }
            NWayConflictUnsupportedException nway = (NWayConflictUnsupportedException)SubcommandUtil.findExceptionByType(NWayConflictUnsupportedException.class, (TeamRepositoryException)e);
            if (nway != null) {
                throw StatusHelper.nWayConflict((String)Messages.AcceptCmd2_ACCEPT_WOULD_CAUSE_NWAY_CONFLICT);
            }
            throw StatusHelper.wrap((String)Messages.AcceptCmd2_COULD_NOT_UPDATE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        if (result.isCancelled()) {
            int noOfUncheckedInChanges;
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
            }
            if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
            if (!result.getComponentsWithNWayConflicts().isEmpty()) {
                ComponentDTO cd = (ComponentDTO)result.getComponentsWithNWayConflicts().get(0);
                throw StatusHelper.createException((String)NLS.bind((String)Messages.AcceptCmd_0, (Object)cd.getName(), (Object)AcceptCmdOptions.OPT_NWAY_CONFLICT.getName()), (int)21, null);
            }
            if (!result.getComponentsWithConflictingTargets().isEmpty()) {
                ArrayList componentsWithConflictingTargets = new ArrayList(result.getComponentsWithConflictingTargets());
                Collections.sort(componentsWithConflictingTargets, new PendingChangesUtil.ComponentSyncDTOComparator());
                StringBuilder builder = new StringBuilder();
                builder.append(Messages.AcceptCmd_INCOMPATIBLE_COMPONENT_FLOW_TARGETS);
                for (ComponentSyncDTO syncDto : componentsWithConflictingTargets) {
                    builder.append(NLS.bind((String)Messages.AcceptCmd_INCOMPATIBLE_SELECTORS, (Object[])new String[]{AliasUtil.selector((String)syncDto.getLocalWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getLocalWorkspaceItemId()), (String)syncDto.getLocalRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIslocalStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE)), AliasUtil.selector((String)syncDto.getComponentName(), (UUID)UUID.valueOf((String)syncDto.getComponentItemId()), (String)syncDto.getTargetIncomingRepositoryUrl(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), AliasUtil.selector((String)syncDto.getTargetIncomingWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getTargetIncomingWorkspaceItemId()), (String)syncDto.getTargetIncomingRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIsTargetIncomingStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))}));
                }
                throw StatusHelper.createException((String)builder.toString(), (int)58, null);
            }
            if (!result.getComponentsWithMultipleParticipants().isEmpty()) {
                ArrayList componentsWithMultipleParticpants = new ArrayList(result.getComponentsWithMultipleParticipants());
                Collections.sort(componentsWithMultipleParticpants, new PendingChangesUtil.ComponentSyncDTOComparator());
                StringBuilder builder = new StringBuilder();
                builder.append(Messages.AcceptCmd_INCOMPATIBLE_COMPONENT_MULTIPLE_PARTICPANT);
                for (ComponentSyncDTO syncDto : componentsWithMultipleParticpants) {
                    builder.append(NLS.bind((String)Messages.AcceptCmd_INCOMPATIBLE_SELECTORS, (Object[])new String[]{AliasUtil.selector((String)syncDto.getLocalWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getLocalWorkspaceItemId()), (String)syncDto.getLocalRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIslocalStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE)), AliasUtil.selector((String)syncDto.getComponentName(), (UUID)UUID.valueOf((String)syncDto.getComponentItemId()), (String)syncDto.getTargetIncomingRepositoryUrl(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), AliasUtil.selector((String)syncDto.getTargetIncomingWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getTargetIncomingWorkspaceItemId()), (String)syncDto.getTargetIncomingRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIsTargetIncomingStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))}));
                }
                throw StatusHelper.createException((String)builder.toString(), (int)59, null);
            }
        }
        ArrayList<ShareableDTO> deletedContentShareables = new ArrayList<ShareableDTO>();
        if (!automergeDisabled && result != null && result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            deletedContentShareables.addAll(result.getSandboxUpdateDilemma().getDeletedContentShareables());
        }
        List<String> unresolvedWorkspaces = AcceptCmd.hasConflicts(result);
        JSONArray status = null;
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        boolean verbose = subcmd.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        if (this.config.isJSONEnabled()) {
            status = new JSONArray();
        } else {
            out.println((CharSequence)Messages.AcceptCmd_ACCEPT_MESSAGE);
        }
        JSONObject jResult = AcceptResultDisplayer.showResult(client, repo, this.isFlowingComponents(this.config), parms, result, deletedContentShareables, verbose, this.config, status);
        if (unresolvedWorkspaces.size() == 0 && result.getStructuredResult().size() == 0) {
            if (this.config.isJSONEnabled()) {
                this.config.getOutputStream().print((CharSequence)jResult.toString());
            }
            StatusHelper.workspaceUnchanged();
        }
        if ((unresolvedWorkspaces.size() > 0 || this.hasPorts(result)) && subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            AcceptCmd.markInPlaceConflicts(this.config, result, client, verbose);
            if (this.config.isJSONEnabled()) {
                status.add((Object)JSONPrintUtil.getJsonStatusObject((int)70, (String)Messages.Conflicts_InPlaceMarkers_Help, (String)Constants.Severity.info.toString()));
            } else {
                out.println((CharSequence)Messages.Conflicts_InPlaceMarkers_Help);
            }
        }
        if (unresolvedWorkspaces.size() > 0) {
            ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ResolveCmd.class);
            ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ConflictsCmd.class);
            ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
            String errMessage = NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()});
            JSONObject unresolvedWorkspacesWarning = AcceptCmd.populateJsonOrPrintOutput(unresolvedWorkspaces, Messages.AcceptCmd_CONFLICT_MESSAGE, errMessage, out, 11, Constants.Severity.error.toString(), this.config.isJSONEnabled());
            if (unresolvedWorkspacesWarning != null) {
                status.add((Object)unresolvedWorkspacesWarning);
                jResult.put((Object)"status", (Object)status);
                this.config.getOutputStream().print((CharSequence)jResult.toString());
                throw StatusHelper.returnValue((int)11);
            }
            throw StatusHelper.conflict((String)Messages.AcceptCmd_CONFLICT_ERROR_MESSAGE);
        }
        AcceptCmd.reportErrorOnUnresolvedLocalConflicts(this.config, client, parms, out, status, jResult);
        if (result.isSetEclipseReadFailureMessage()) {
            for (Object nextMsg : result.getEclipseReadFailureMessage()) {
                if (this.config.isJSONEnabled()) {
                    status.add((Object)JSONPrintUtil.getJsonStatusObject((int)71, (String)((String)nextMsg), (String)Constants.Severity.warning.toString()));
                    continue;
                }
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)((String)nextMsg));
            }
        }
        if (this.hasPorts(result) && (portWarning = this.printPorts(result, out)) != null) {
            status.add((Object)portWarning);
        }
        if (this.config.isJSONEnabled()) {
            if (status.size() > 0) {
                jResult.put((Object)"status", (Object)status);
            }
            this.config.getOutputStream().print((CharSequence)jResult.toString());
        } else {
            out.println((CharSequence)Messages.AcceptCmd_SUCCESS);
        }
    }

    public static JSONObject populateJsonOrPrintOutput(Collection<String> itemsToDisplay, String messageTitle, String errorMessage, IndentingPrintStream out, int statusCode, String severity, boolean isJSONEnabled) {
        if (itemsToDisplay == null || itemsToDisplay.isEmpty()) {
            return null;
        }
        if (isJSONEnabled) {
            StringBuffer outputMessage = new StringBuffer();
            outputMessage.append(messageTitle);
            StringBuffer itemBuffer = null;
            for (String item : itemsToDisplay) {
                if (itemBuffer == null) {
                    itemBuffer = new StringBuffer();
                    itemBuffer.append(" ").append(item);
                    continue;
                }
                itemBuffer.append(NLS.bind((String)Messages.AcceptCmd_1, (Object)item));
            }
            if (itemBuffer != null) {
                outputMessage.append(itemBuffer.toString());
            }
            outputMessage.append(NLS.bind((String)Messages.AcceptCmd_2, (Object)errorMessage));
            return JSONPrintUtil.getJsonStatusObject((int)statusCode, (String)outputMessage.toString(), (String)severity);
        }
        out.println((CharSequence)messageTitle);
        for (String item : itemsToDisplay) {
            out.indent().println((CharSequence)item);
        }
        out.println((CharSequence)errorMessage);
        return null;
    }

    public static void reportErrorOnUnresolvedLocalConflicts(IScmClientConfiguration config, IFilesystemRestClient client, ParmsWorkspaceUpdate parms, IndentingPrintStream out, JSONArray status, JSONObject jResult) throws FileSystemException, CLIFileSystemClientException {
        if (parms.acceptChangeSets == null) {
            return;
        }
        ArrayList<ParmsWorkspace> targetWorkspaces = new ArrayList<ParmsWorkspace>();
        int i = 0;
        while (i < parms.acceptChangeSets.length) {
            targetWorkspaces.add(parms.acceptChangeSets[i].workspace);
            ++i;
        }
        HashSet<String> conflictedWorkspaces = new HashSet<String>();
        SyncViewDTO syncView = SubcommandUtil.getSyncView(targetWorkspaces, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                for (UnresolvedFolderSyncDTO unresolvedSync : compSync.getUnresolved()) {
                    if (unresolvedSync.getLocalConflicts().isEmpty()) continue;
                    conflictedWorkspaces.add(wsSync.getWorkspaceName());
                }
            }
        }
        if (!conflictedWorkspaces.isEmpty()) {
            ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ResolveCmd.class);
            ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ConflictsCmd.class);
            ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, StatusCmd.class);
            String localOption = "-" + ConflictsCmdOpts.OPT_LOCAL.getShortOpt();
            String errMessage = NLS.bind((String)Messages.AcceptCmd_LOCAL_CONFLICT_GUIDANCE, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString(), localOption});
            JSONObject warningObj = AcceptCmd.populateJsonOrPrintOutput(conflictedWorkspaces, Messages.AcceptCmd_CONFLICT_MESSAGE, errMessage, out, 11, Constants.Severity.error.toString(), config.isJSONEnabled());
            if (warningObj != null) {
                status.add((Object)warningObj);
                jResult.put((Object)"status", (Object)status);
                config.getOutputStream().print((CharSequence)jResult.toString());
                throw StatusHelper.returnValue((int)11);
            }
            throw StatusHelper.conflict((String)Messages.AcceptCmd_CONFLICT_ERROR_MESSAGE);
        }
    }

    private JSONObject printPorts(WorkspaceUpdateResultDTO result, IndentingPrintStream out) {
        ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, PortResolveCmd.class);
        ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, CurrentPortCmd.class);
        ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ListPortsCmd.class);
        ISubcommandDefinition defnTemp4 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
        String errMessage = NLS.bind((String)Messages.AcceptCmd_PORT_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp4).toString()});
        ArrayList<String> itemsToDisplay = new ArrayList<String>();
        for (StructuredUpdateReportDTO wsReport : result.getStructuredResult()) {
            for (StructuredComponentUpdateReportDTO compReport : wsReport.getComponents()) {
                if (compReport.getCurrentPatch() == null) continue;
                itemsToDisplay.add(NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)wsReport.getWorkspaceName(), (Object)compReport.getComponentName()));
            }
        }
        return AcceptCmd.populateJsonOrPrintOutput(itemsToDisplay, Messages.AcceptCmd_PORT_MESSAGE, errMessage, out, 72, Constants.Severity.warning.toString(), this.config.isJSONEnabled());
    }

    public static void markInPlaceConflicts(IScmClientConfiguration config, WorkspaceUpdateResultDTO updateResult, IFilesystemRestClient client, boolean verbose) throws FileSystemException {
        File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
        if (cfaRootPath != null) {
            Path cfaRoot = new Path(cfaRootPath.getAbsolutePath());
            List workspaces = updateResult.getStructuredResult();
            for (StructuredUpdateReportDTO ws : workspaces) {
                ParmsWorkspace conflictWs = new ParmsWorkspace(ws.getRepositoryUrl(), ws.getWorkspaceItemId());
                InPlaceConflictHandler handler = new InPlaceConflictHandler();
                handler.configureVerbose(verbose);
                if (ws.isHasConflicts()) {
                    handler.handleConflicts((IPath)cfaRoot, conflictWs, client, config);
                }
                handler = new GapInPlaceConflictHandler();
                List components = ws.getComponents();
                for (StructuredComponentUpdateReportDTO comp : components) {
                    CurrentPatchDTO currentPort = comp.getCurrentPatch();
                    if (currentPort == null) continue;
                    handler.handleConflicts((IPath)cfaRoot, conflictWs, currentPort, client, config);
                }
            }
        }
    }

    public static List<String> hasConflicts(WorkspaceUpdateResultDTO result) {
        ArrayList<String> unresolvedWorkspaces = new ArrayList<String>();
        for (StructuredUpdateReportDTO wsReport : result.getStructuredResult()) {
            if (!wsReport.isHasConflicts()) continue;
            unresolvedWorkspaces.add(wsReport.getWorkspaceName());
        }
        return unresolvedWorkspaces;
    }

    private boolean hasPorts(WorkspaceUpdateResultDTO result) {
        for (StructuredUpdateReportDTO wsReport : result.getStructuredResult()) {
            for (StructuredComponentUpdateReportDTO compReport : wsReport.getComponents()) {
                if (compReport.getCurrentPatch() == null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isActiveChangeSetsException(TeamRepositoryException e) {
        int tries = 0;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ActiveChangeSetsException)) continue;
            return true;
        }
        return false;
    }

    private boolean isFlowingComponents(IScmClientConfiguration config) {
        return config.getSubcommandCommandLine().hasOption((IOptionKey)AcceptCmdOptions.OPT_FLOW_COMPONENTS);
    }

    private ITeamRepository generateAcceptParms(IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine subcmd, ParmsWorkspaceUpdate parms) throws FileSystemException {
        ITypedPreferenceRegistry prefs;
        String mergeTool;
        ParmsAcceptChangeSets update;
        ITeamRepository repo = null;
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        Mode mode = Mode.UNSET;
        int modeCount = 0;
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_BASELINES)) {
            mode = Mode.BASELINE;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_COMPONENTS)) {
            mode = Mode.COMPONENT;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_CHANGESETS)) {
            mode = Mode.CS;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_WORKITEMS)) {
            mode = Mode.WI;
            ++modeCount;
        }
        if (modeCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_USE_SINGLE_MODE_ARGUMENT, (Object[])new String[]{AcceptCmdOptions.OPT_MODE_BASELINES.getName(), AcceptCmdOptions.OPT_MODE_COMPONENTS.getName(), AcceptCmdOptions.OPT_MODE_CHANGESETS.getName(), AcceptCmdOptions.OPT_MODE_WORKITEMS.getName()}));
        }
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_MODE_WORKITEMS) && subcmd.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SOURCE_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)AcceptCmdOptions.OPT_MODE_WORKITEMS.getName(), (Object)CommonOptions.OPT_STREAM_SOURCE_SELECTOR.getName()));
        }
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = subcmd.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        parms.structuredResultOptions = new ParmsStructuredResultOptions();
        parms.workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parms.workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        String compStrategy = "no";
        if (this.isFlowingComponents(config)) {
            compStrategy = "continue";
        }
        parms.workspaceUpdateDilemmaHandler.componentFlowDirection = compStrategy;
        parms.workspaceUpdateDilemmaHandler.componentReplacementCandidatesDirection = compStrategy;
        parms.workspaceUpdateDilemmaHandler.nWayConflictDirection = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_NWAY_CONFLICT) ? "continue" : "cancel";
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_REPORT_DELETE_DELETE_CONFLICT)) {
            parms.reportDeleteDeleteConflicts = true;
        }
        parms.workspaceUpdateDilemmaHandler.multipleParticipantsDirection = subcmd.hasOption((IOptionKey)CommonOptions.OPT_MULTIPLE_PARTICIPANTS) ? "continue" : "cancel";
        parms.workspaceUpdateDilemmaHandler.gapDirection = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_ACCEPT_WITH_PORTING) ? "continue" : "fail";
        parms.workspaceUpdateDilemmaHandler.portInProgressDirection = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_ACCEPT_WITH_PORTING) ? "continue" : "fail";
        ArrayList<ParmsWorkspace> targetWs = new ArrayList<ParmsWorkspace>(1);
        if (!subcmd.hasOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR)) {
            repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)config, (IFilesystemRestClient)client);
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)config);
            for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
                if (!wsInSandbox.getRepositoryId().equals(repo.getId().getUuidValue())) continue;
                try {
                    RepoUtil.getWorkspaceById((String)wsInSandbox.getWorkspaceItemId(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                }
                catch (CLIFileSystemClientException e) {
                    if (e.getStatus().getCode() == 25) {
                        StatusHelper.logException(null, (Throwable)e);
                        continue;
                    }
                }
                catch (FileSystemException e) {
                    // empty catch block
                }
                targetWs.add(new ParmsWorkspace(repo.getRepositoryURI(), wsInSandbox.getWorkspaceItemId()));
            }
            if (targetWs.size() == 0) {
                throw StatusHelper.misconfiguredLocalFS((String)Messages.Common_WS_NOT_FOUND);
            }
        } else {
            ScmCommandLineArgument targetSelector = ScmCommandLineArgument.create((ICommandLineArgument)subcmd.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)targetSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)targetSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)targetSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)config);
            ParmsWorkspace parm = new ParmsWorkspace();
            parm.repositoryUrl = repo.getRepositoryURI();
            parm.workspaceItemId = ws.getItemId().getUuidValue();
            targetWs.add(parm);
        }
        RepoUtil.validateWorkspacesAreTracked(targetWs, (String)Messages.AcceptCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)config);
        ParmsWorkspace sourceWs = null;
        ITeamRepository srcRepo = null;
        if (subcmd.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SOURCE_SELECTOR)) {
            ScmCommandLineArgument sourceSelector = ScmCommandLineArgument.create((ICommandLineArgument)subcmd.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_SOURCE_SELECTOR), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)sourceSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            srcRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)sourceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)sourceSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
            sourceWs = new ParmsWorkspace();
            sourceWs.repositoryUrl = srcRepo.getRepositoryURI();
            sourceWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        List argSelectors = Collections.EMPTY_LIST;
        List selectors = Collections.EMPTY_LIST;
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_SELECTORS)) {
            argSelectors = ScmCommandLineArgument.createList((List)subcmd.getOptionValues((IOptionKey)AcceptCmdOptions.OPT_SELECTORS), (IScmClientConfiguration)config, (mode != Mode.WI ? 1 : 0) != 0);
            selectors = RepoUtil.getSelectors((List)argSelectors);
        }
        if (mode == Mode.UNSET && selectors.size() == 0) {
            ArrayList<ParmsWorkspaceAcceptDetailed> updates = new ArrayList<ParmsWorkspaceAcceptDetailed>(targetWs.size());
            RepoUtil.loginToWsCollabRepos(targetWs, (IFilesystemRestClient)client, (IScmClientConfiguration)config, (boolean)true);
            for (ParmsWorkspace target : targetWs) {
                updates.addAll(this.generateDefaultFlowAcceptParms(sourceWs, target, client, config));
            }
            parms.workspaceAcceptDetailed = updates.toArray(new ParmsWorkspaceAcceptDetailed[updates.size()]);
        } else if ((mode == Mode.UNSET || mode == Mode.CS) && selectors.size() > 0) {
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES, (Object)subcmd.getDefinition().getOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            if (sourceWs != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, (List)argSelectors, (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
            }
            update = new ParmsAcceptChangeSets();
            update.workspace = (ParmsWorkspace)targetWs.get(0);
            update.changeSets = AcceptCmd.normalizeCsUuidAndAlias(sourceWs, (ParmsWorkspace)targetWs.get(0), argSelectors, config, client);
            parms.acceptChangeSets = new ParmsAcceptChangeSets[]{update};
        } else if (mode == Mode.COMPONENT) {
            if (selectors.size() < 1) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_NO_COMPONENTS_SPECIFIED, (Object)AcceptCmdOptions.OPT_MODE_COMPONENTS.getName()));
            }
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES_FOR_COMPONENT, (Object)subcmd.getDefinition().getOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            if (sourceWs != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (List)argSelectors, (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
            }
            parms.workspaceAcceptDetailed = this.generateComponentFlowAcceptParms(config, (ParmsWorkspace)targetWs.get(0), sourceWs, selectors, client);
        } else if (mode == Mode.BASELINE) {
            if (selectors.size() < 1) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_NO_BASELINES_SPECIFIED, (Object)AcceptCmdOptions.OPT_MODE_BASELINES.getName()));
            }
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES_FOR_BASELINE, (Object)subcmd.getDefinition().getOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            if (sourceWs != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.BASELINE, (List)argSelectors, (ITeamRepository)srcRepo, (IScmClientConfiguration)config);
            }
            parms.workspaceAcceptDetailed = this.generateBaselineAcceptParms(config, (ParmsWorkspace)targetWs.get(0), sourceWs, selectors, client);
        } else if (mode == Mode.WI) {
            if (selectors.size() < 1) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_NO_WORKITEMS_SPECIFIED, (Object)AcceptCmdOptions.OPT_MODE_WORKITEMS.getName()));
            }
            if (targetWs.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_TOO_MANY_WORKSPACES_FOR_WORKITEM, (Object)subcmd.getDefinition().getOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.WORKITEM);
            update = new ParmsAcceptChangeSets();
            update.workspace = (ParmsWorkspace)targetWs.get(0);
            update.changeSets = this.getChangeSetsFromWorkitem(argSelectors, (ParmsWorkspace)targetWs.get(0), client, config, repo, subcmd);
            parms.acceptChangeSets = new ParmsAcceptChangeSets[]{update};
        } else {
            throw StatusHelper.internalError((String)Messages.AcceptCmd2_UNEXPECTED_CASE);
        }
        if (config.getSubcommandCommandLine().hasOption((IOptionKey)AcceptCmdOptions.OPT_ACCEPT_MISSING_CHANGESETS)) {
            if (mode != Mode.UNSET && mode != Mode.CS || selectors.size() <= 0) {
                throw StatusHelper.argSyntax((String)Messages.AcceptCmd_UNEXPECTED_MISSING_CHANGESET);
            }
            List<ParmsChangeSet> changes = AcceptCmd.fetchGapFillingChangeSets(repo, (ParmsWorkspace)targetWs.get(0), argSelectors);
            if (changes != null && !changes.isEmpty()) {
                ParmsAcceptChangeSets update2 = new ParmsAcceptChangeSets();
                update2.workspace = (ParmsWorkspace)targetWs.get(0);
                update2.changeSets = changes.toArray(new ParmsChangeSet[changes.size()]);
                ParmsAcceptChangeSets[] b = new ParmsAcceptChangeSets[parms.acceptChangeSets.length + 1];
                System.arraycopy(parms.acceptChangeSets, 0, b, 0, parms.acceptChangeSets.length);
                b[parms.acceptChangeSets.length] = update2;
                parms.acceptChangeSets = b;
            }
        }
        if ((mergeTool = (prefs = ((ScmClientConfiguration)config).getPersistentPreferences()).getExternalAutoResolveTool()) != null && !mergeTool.isEmpty()) {
            parms.updateDilemmaHandler = new ParmsUpdateDilemmaHandler();
            parms.updateDilemmaHandler.externalAutoResolveTool = mergeTool;
            ParmsExternalTool parmsTool = new ParmsExternalTool();
            parmsTool.externalTool = mergeTool;
            parmsTool.filePatterns = prefs.getExternalAutoResolveToolFilePatterns();
            parmsTool.policy = prefs.getExternalAutoResolveToolPolicy();
            parms.updateDilemmaHandler.externalTool = parmsTool;
        }
        if (!subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE)) {
            parms.autoResolve = Boolean.TRUE;
        }
        return repo;
    }

    private ParmsChangeSet[] getChangeSetsFromWorkitem(List<IScmCommandLineArgument> argSelectors, ParmsWorkspace ws, IFilesystemRestClient client, IScmClientConfiguration config, ITeamRepository repo, ICommandLine subcmd) throws FileSystemException {
        ChangeSetUtil csUtil = new ChangeSetUtil();
        csUtil.validateRepoAndLogin(argSelectors, client, config, subcmd, repo == null);
        ArrayList<WorkItemHierarchyNodeDTO> wiHierarchyList = new ArrayList<WorkItemHierarchyNodeDTO>();
        Map<String, ChangeSetSyncDTO> csList = csUtil.getChangeSetsFromWorkitem(argSelectors, repo, client, config, false, wiHierarchyList);
        if (csList == null || csList.size() == 0) {
            config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetLocateCmd_CS_NOT_FOUND_FOR_WI);
            StatusHelper.workspaceUnchanged();
        }
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        ArrayList<String> compIds = new ArrayList<String>(wsDetails.getComponents().size());
        for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
            compIds.add(compDTO.getItemId());
        }
        ArrayList<ParmsChangeSet> parmsCsList = new ArrayList<ParmsChangeSet>(csList.size());
        for (ChangeSetSyncDTO csDTO : csList.values()) {
            if (!compIds.contains(csDTO.getComponentItemId())) continue;
            ParmsChangeSet parmsCs = new ParmsChangeSet();
            parmsCs.changeSetItemId = csDTO.getChangeSetItemId();
            parmsCs.repositoryUrl = csDTO.getRepositoryUrl();
            parmsCsList.add(parmsCs);
        }
        return parmsCsList.toArray(new ParmsChangeSet[parmsCsList.size()]);
    }

    public static List<ParmsChangeSet> fetchGapFillingChangeSets(ITeamRepository repo, ParmsWorkspace ws, List<IScmCommandLineArgument> selectors) throws FileSystemException {
        ArrayList<ParmsChangeSet> changesParm = new ArrayList<ParmsChangeSet>();
        ArrayList<String> toExclude = new ArrayList<String>();
        String repositoryURL = null;
        HashSet<String> UuidSet = new HashSet<String>();
        for (IScmCommandLineArgument selector : selectors) {
            IUuidAliasRegistry.IUuidAlias alias = selector.getUuidAlias();
            if (alias == null) {
                throw new RuntimeException();
            }
            if (!UuidSet.add(alias.getUuid().getUuidValue())) continue;
            ParmsChangeSet parmsCs = new ParmsChangeSet();
            parmsCs.changeSetItemId = alias.getUuid().getUuidValue();
            toExclude.add(parmsCs.changeSetItemId);
            parmsCs.repositoryUrl = repositoryURL = repositoryURL == null ? (alias.getRepositoryUrl() == null ? ws.repositoryUrl : alias.getRepositoryUrl()) : repositoryURL;
            changesParm.add(parmsCs);
        }
        IScmRichClientRestService.ParmsFillGapChangeSets fillGapsParms = null;
        ScmGapFillingChangeSetsReportList reports = null;
        try {
            fillGapsParms = AcceptCmd.generateFillGapsChangeSetsParms(ws, changesParm);
            IScmRichClientRestService scmRichService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            reports = scmRichService.postGetChangeSetsFillingGap(fillGapsParms);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
        ArrayList changes = new ArrayList();
        for (ScmGapFillingChangeSetsReport report : reports.getReports()) {
            changes.addAll(report.getChanges().getChangeSets());
        }
        if (changes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ParmsChangeSet> result = new ArrayList<ParmsChangeSet>();
        for (ScmChangeSet change : changes) {
            String itemId = change.getItemId();
            if (toExclude.contains(itemId)) continue;
            ParmsChangeSet parmsCs = new ParmsChangeSet();
            parmsCs.changeSetItemId = itemId;
            parmsCs.repositoryUrl = repositoryURL;
            result.add(parmsCs);
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    private static IScmRichClientRestService.ParmsFillGapChangeSets generateFillGapsChangeSetsParms(ParmsWorkspace ws, List<ParmsChangeSet> changesets) throws TeamRepositoryException {
        IScmRichClientRestService.ParmsFillGapChangeSets result = new IScmRichClientRestService.ParmsFillGapChangeSets();
        result.workspaceItemId = ws.getWorkspaceHandle().getItemId().getUuidValue();
        ArrayList<String> ids = new ArrayList<String>();
        for (ParmsChangeSet cs : changesets) {
            ids.add(cs.getChangeSetHandle().getItemId().getUuidValue());
        }
        result.changeSetItemIds = ids.toArray(new String[ids.size()]);
        return result;
    }

    private static ParmsChangeSet[] normalizeCsUuidAndAlias(ParmsWorkspace srcWs, ParmsWorkspace ws, List<IScmCommandLineArgument> csSelectors, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        ArrayList<ParmsChangeSet> normalized = new ArrayList<ParmsChangeSet>();
        HashSet<String> csSet = new HashSet<String>(csSelectors.size());
        int i = 0;
        while (i < csSelectors.size()) {
            IScmCommandLineArgument selector = csSelectors.get(i);
            IUuidAliasRegistry.IUuidAlias uuid = RepoUtil.lookupUuidAndAlias((String)selector.getItemSelector());
            if (uuid == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_CANNOT_FIND_CHANGE_SET, (Object)selector.getItemSelector()));
            }
            if (srcWs == null) {
                srcWs = ws;
            }
            ITeamRepository csRepo = RepoUtil.getSharedRepository((String)srcWs.repositoryUrl, (boolean)true);
            if (selector.isRepoExplicit()) {
                csRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
            } else if (uuid.getRepositoryUrl() != null) {
                csRepo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(uuid.getRepositoryUrl(), null, false, true));
            }
            IChangeSet changeSet = RepoUtil.findChangeSet((String)selector.getItemSelector(), (ITeamRepository)csRepo, (IScmClientConfiguration)config);
            if (csSet.add(changeSet.getItemId().getUuidValue())) {
                ParmsChangeSet parmsCs = new ParmsChangeSet();
                parmsCs.changeSetItemId = changeSet.getItemId().getUuidValue();
                parmsCs.repositoryUrl = csRepo.getRepositoryURI();
                normalized.add(parmsCs);
            }
            ++i;
        }
        ParmsChangeSet[] str = new ParmsChangeSet[normalized.size()];
        return normalized.toArray(str);
    }

    private List<ParmsWorkspaceAcceptDetailed> generateDefaultFlowAcceptParms(ParmsWorkspace sourceWs, ParmsWorkspace target, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsWorkspace ws;
        HashMap componentFlows = new HashMap();
        if (sourceWs != null && !this.isCurrentIncomingFlow(sourceWs, target, client)) {
            List srcWsDetailsList = RepoUtil.getWorkspaceDetails(Collections.singletonList(sourceWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            WorkspaceDetailsDTO srcWsDetails = (WorkspaceDetailsDTO)srcWsDetailsList.get(0);
            List srcCompDTOList = srcWsDetails.getComponents();
            List tgtWsDetailsList = RepoUtil.getWorkspaceDetails(Collections.singletonList(target), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            List tgtCompDTOList = ((WorkspaceDetailsDTO)tgtWsDetailsList.get(0)).getComponents();
            ArrayList<String> components = new ArrayList<String>();
            block0: for (WorkspaceComponentDTO tgtCompDTO : tgtCompDTOList) {
                for (WorkspaceComponentDTO srcCompDTO : srcCompDTOList) {
                    if (!tgtCompDTO.getItemId().equals(srcCompDTO.getItemId())) continue;
                    components.add(tgtCompDTO.getItemId());
                    continue block0;
                }
            }
            if (components.size() > 0) {
                ws = new ParmsWorkspace(srcWsDetails.getRepositoryURL(), srcWsDetails.getItemId());
                componentFlows.put(ws, components);
            }
        } else {
            SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(target), (boolean)true, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
            for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (!wsSync.getWorkspaceItemId().equals(target.workspaceItemId)) continue;
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    ws = new ParmsWorkspace(compSync.getTargetIncomingRepositoryUrl(), compSync.getTargetIncomingWorkspaceItemId());
                    ParmsWorkspace wsMatched = this.findWorkspace(wsList, ws);
                    ArrayList<String> components = null;
                    if (wsMatched != null) {
                        components = (ArrayList<String>)componentFlows.get(wsMatched);
                    }
                    if (components == null) {
                        components = new ArrayList<String>();
                        componentFlows.put(ws, components);
                        wsList.add(ws);
                    }
                    components.add(compSync.getComponentItemId());
                }
            }
        }
        ArrayList<ParmsWorkspaceAcceptDetailed> parms = new ArrayList<ParmsWorkspaceAcceptDetailed>(componentFlows.size());
        for (Map.Entry entry : componentFlows.entrySet()) {
            ParmsWorkspaceAcceptDetailed detailed = new ParmsWorkspaceAcceptDetailed();
            detailed.workspace = target;
            detailed.sourceWorkspace = (ParmsWorkspace)entry.getKey();
            detailed.componentItemIds = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
            parms.add(detailed);
        }
        return parms;
    }

    private boolean isCurrentIncomingFlow(ParmsWorkspace sourceWs, ParmsWorkspace target, IFilesystemRestClient client) throws FileSystemException {
        WorkspaceDetailsDTO details;
        List workspaceDetails = RepoUtil.getWorkspaceDetails(Collections.singletonList(target), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (!workspaceDetails.isEmpty() && (details = (WorkspaceDetailsDTO)workspaceDetails.get(0)) != null) {
            for (Object o : details.getFlowEntries()) {
                WorkspaceFlowEntryDTO entry = (WorkspaceFlowEntryDTO)o;
                if (!entry.isCurrentIncomingFlow()) continue;
                return entry.getWorkspaceItemId().equals(sourceWs.workspaceItemId);
            }
        }
        return false;
    }

    private ParmsWorkspaceAcceptDetailed[] generateComponentFlowAcceptParms(IScmClientConfiguration config, ParmsWorkspace targetWs, ParmsWorkspace sourceWs, List<String> selectors, IFilesystemRestClient client) throws FileSystemException {
        boolean sourceWorkspaceExplicit;
        ArrayList<ParmsWorkspaceAcceptDetailed> parms = new ArrayList<ParmsWorkspaceAcceptDetailed>(5);
        HashSet<String> selectorSet = new HashSet<String>(selectors);
        HashMap componentFlows = new HashMap();
        String wsName = null;
        boolean bl = sourceWorkspaceExplicit = sourceWs != null;
        if (sourceWs != null) {
            List srcWsDetailsList = RepoUtil.getWorkspaceDetails(Collections.singletonList(sourceWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            WorkspaceDetailsDTO workspaceDetailsDTO = (WorkspaceDetailsDTO)srcWsDetailsList.get(0);
            List srcCompDTOList = workspaceDetailsDTO.getComponents();
            wsName = workspaceDetailsDTO.getName();
            List tgtWsDetailsList = RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            List tgtCompDTOList = ((WorkspaceDetailsDTO)tgtWsDetailsList.get(0)).getComponents();
            HashMap<String, Object> componentId2selector = new HashMap<String, Object>();
            HashMap<Object, String> selector2componentName = new HashMap<Object, String>();
            for (WorkspaceComponentDTO srcCompDTO : srcCompDTOList) {
                String matchedSelector = AcceptCmd.matchesSelector(config, srcCompDTO.getItemId(), srcCompDTO.getName(), selectorSet, sourceWs.repositoryUrl);
                if (matchedSelector == null) continue;
                selectorSet.remove(matchedSelector);
                componentId2selector.put(srcCompDTO.getItemId(), matchedSelector);
                selector2componentName.put(matchedSelector, srcCompDTO.getName());
            }
            if (selectorSet.size() == 0) {
                wsName = ((WorkspaceDetailsDTO)tgtWsDetailsList.get(0)).getName();
                RepoUtil.ItemType itemType = ((WorkspaceDetailsDTO)tgtWsDetailsList.get(0)).isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE;
                for (String component : componentId2selector.keySet()) {
                    boolean found = false;
                    for (WorkspaceComponentDTO tgtCompDTO : tgtCompDTOList) {
                        if (!tgtCompDTO.getItemId().equals(component)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    selectorSet.add((String)componentId2selector.get(component));
                }
                if (selectorSet.size() > 0) {
                    IndentingPrintStream err = config.getWrappedErrorStream();
                    err.println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_NOT_IN_WORKSPACE, (Object)AliasUtil.selector((String)wsName, (UUID)UUID.valueOf((String)targetWs.workspaceItemId), (String)targetWs.repositoryUrl, (RepoUtil.ItemType)itemType)));
                    err.indent();
                    for (String selector : selectorSet) {
                        err.println((CharSequence)selector2componentName.get(selector));
                    }
                    throw StatusHelper.ambiguousSelector((String)Messages.CreateBaselineCmd_12);
                }
                ParmsWorkspace ws = new ParmsWorkspace(workspaceDetailsDTO.getRepositoryURL(), workspaceDetailsDTO.getItemId());
                componentFlows.put(ws, new ArrayList(componentId2selector.keySet()));
            }
        } else {
            SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(targetWs), (boolean)true, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            ArrayList<ParmsWorkspace> arrayList = new ArrayList<ParmsWorkspace>();
            block4: for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                if (!wsSync.getWorkspaceItemId().equals(targetWs.workspaceItemId)) continue;
                wsName = wsSync.getWorkspaceName();
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    String matchedSelector = AcceptCmd.matchesSelector(config, compSync.getComponentItemId(), compSync.getComponentName(), selectorSet, wsSync.getRepositoryUrl());
                    if (matchedSelector != null) {
                        selectorSet.remove(matchedSelector);
                        ParmsWorkspace ws = new ParmsWorkspace(compSync.getTargetIncomingRepositoryUrl(), compSync.getTargetIncomingWorkspaceItemId());
                        ParmsWorkspace wsMatched = this.findWorkspace(arrayList, ws);
                        ArrayList<String> components = null;
                        if (wsMatched != null) {
                            components = (ArrayList<String>)componentFlows.get(wsMatched);
                        }
                        if (components == null) {
                            components = new ArrayList<String>();
                            componentFlows.put(ws, components);
                            arrayList.add(ws);
                        }
                        components.add(compSync.getComponentItemId());
                    }
                    if (selectorSet.size() == 0) break block4;
                }
            }
        }
        if (selectorSet.size() > 0) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.AcceptCmd2_MISSING_COMPONENT_SELECTOR_LIST_START);
            err = err.indent();
            for (String string : selectorSet) {
                err.println((CharSequence)string);
            }
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_MISSING_COMPONENT_SELECTOR_MESSAGE, (Object)wsName));
        }
        boolean hierarchicalAccept = config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_COMPONENT_HIERARCHY);
        for (Map.Entry entry : componentFlows.entrySet()) {
            ParmsWorkspaceAcceptDetailed detailed = new ParmsWorkspaceAcceptDetailed();
            detailed.workspace = targetWs;
            detailed.sourceWorkspace = (ParmsWorkspace)entry.getKey();
            detailed.componentItemIds = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
            detailed.hierarchicalAccept = hierarchicalAccept;
            detailed.sourceWorkspaceExplicit = sourceWorkspaceExplicit;
            parms.add(detailed);
        }
        return parms.toArray(new ParmsWorkspaceAcceptDetailed[parms.size()]);
    }

    ParmsWorkspace findWorkspace(List<ParmsWorkspace> wsList, ParmsWorkspace ws) {
        for (ParmsWorkspace wsInList : wsList) {
            if (!wsInList.repositoryUrl.equals(ws.repositoryUrl) || !wsInList.workspaceItemId.equals(ws.workspaceItemId)) continue;
            return wsInList;
        }
        return null;
    }

    private ParmsWorkspaceAcceptDetailed[] generateBaselineAcceptParms(IScmClientConfiguration config, ParmsWorkspace targetWs, ParmsWorkspace sourceWs, List<String> selectors, IFilesystemRestClient client) throws FileSystemException {
        HashSet<String> selectorSet = new HashSet<String>(selectors);
        HashMap ws2Baseline = new HashMap();
        String wsName = null;
        if (sourceWs != null) {
            WorkspaceDetailsDTO sourceWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(sourceWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
            List sourceWsComps = sourceWsDetails.getComponents();
            ITeamRepository iTeamRepository = RepoUtil.getSharedRepository((String)sourceWs.repositoryUrl, (boolean)true);
            wsName = sourceWsDetails.getName();
            WorkspaceDetailsDTO targetWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
            List targetWsComps = targetWsDetails.getComponents();
            HashSet<String> baselines = new HashSet<String>();
            block2: for (WorkspaceComponentDTO targetComp : targetWsComps) {
                for (WorkspaceComponentDTO sourceComp : sourceWsComps) {
                    if (!targetComp.getItemId().equals(sourceComp.getItemId())) continue;
                    int blCount = 0;
                    for (String selector : selectors) {
                        IBaseline bl;
                        block17: {
                            bl = null;
                            try {
                                bl = RepoUtil.getBaseline((String)selector, (String)sourceComp.getItemId(), (String)sourceComp.getName(), (ITeamRepository)iTeamRepository, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                            }
                            catch (FileSystemException e) {
                                if (e instanceof CLIFileSystemClientException && ((CLIFileSystemClientException)((Object)e)).getStatus().getCode() == 25) break block17;
                                throw e;
                            }
                        }
                        if (bl == null) continue;
                        selectorSet.remove(selector);
                        baselines.add(bl.getItemId().getUuidValue());
                        ++blCount;
                    }
                    if (blCount <= true) continue block2;
                    throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_SPECIFY_ONLY_ONE_BASLELINE_PER_COMPONENT);
                }
            }
            if (baselines.size() > 0) {
                ParmsWorkspace ws = sourceWs;
                ws2Baseline.put(ws, baselines);
            }
        } else {
            SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(targetWs), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
            for (WorkspaceSyncDTO workspaceSyncDTO : syncView.getWorkspaces()) {
                if (!workspaceSyncDTO.getWorkspaceItemId().equals(targetWs.workspaceItemId)) continue;
                wsName = workspaceSyncDTO.getWorkspaceName();
                for (ComponentSyncDTO compSync : workspaceSyncDTO.getComponents()) {
                    int blCount = 0;
                    for (BaselineSyncDTO blSync : compSync.getIncomingBaselines()) {
                        String matchedSelector = AcceptCmd.matchesSelector(config, blSync, selectors);
                        if (matchedSelector == null) continue;
                        if (++blCount > 1) {
                            throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_SPECIFY_ONLY_ONE_BASLELINE_PER_COMPONENT);
                        }
                        selectorSet.remove(matchedSelector);
                        ParmsWorkspace ws = new ParmsWorkspace(compSync.getTargetIncomingRepositoryUrl(), compSync.getTargetIncomingWorkspaceItemId());
                        ParmsWorkspace wsMatched = this.findWorkspace(wsList, ws);
                        HashSet<String> baselines = null;
                        if (wsMatched != null) {
                            baselines = (HashSet<String>)ws2Baseline.get(wsMatched);
                        }
                        if (baselines == null) {
                            baselines = new HashSet<String>();
                            ws2Baseline.put(ws, baselines);
                            wsList.add(ws);
                        }
                        baselines.add(blSync.getBaselineItemId());
                    }
                }
            }
        }
        if (selectorSet.size() > 0) {
            IndentingPrintStream err = config.getWrappedErrorStream();
            err.println((CharSequence)Messages.AcceptCmd2_MISSING_BASELINE_SELECTOR_START);
            err = err.indent();
            for (String blSelector : selectorSet) {
                err.println((CharSequence)blSelector);
            }
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.AcceptCmd2_MISSING_BASELINE_SELECTOR_MESSAGE, (Object)wsName));
        }
        ParmsWorkspaceAcceptDetailed[] parms = new ParmsWorkspaceAcceptDetailed[ws2Baseline.size()];
        int i = 0;
        for (Map.Entry entry : ws2Baseline.entrySet()) {
            ParmsWorkspaceAcceptDetailed detailed = new ParmsWorkspaceAcceptDetailed();
            detailed.workspace = targetWs;
            detailed.sourceWorkspace = (ParmsWorkspace)entry.getKey();
            detailed.baselineItemIds = ((HashSet)entry.getValue()).toArray(new String[((HashSet)entry.getValue()).size()]);
            parms[i++] = detailed;
        }
        return parms;
    }

    private static String matchesSelector(IScmClientConfiguration config, String componentItemId, String componentName, HashSet<String> selectors, String repoUrl) throws FileSystemException {
        String compAlias = null;
        IUuidAliasRegistry.IUuidAlias alias = RepoUtil.lookupUuidAndAlias((String)componentItemId, (String)repoUrl);
        if (alias != null) {
            compAlias = alias.getMonicker();
        }
        for (String selector : selectors) {
            if (!componentItemId.equals(selector) && !selector.equals(compAlias) && !selector.equals(componentName)) continue;
            return selector;
        }
        return null;
    }

    private static String matchesSelector(IScmClientConfiguration config, BaselineSyncDTO blSync, List<String> selectors) {
        String baselineNumber = Integer.toString(blSync.getId());
        for (String selector : selectors) {
            IUuidAliasRegistry.IUuidAlias alias;
            try {
                alias = config.getAliasRegistry().findAliasByName(selector);
            }
            catch (IUuidAliasRegistry.NoSuchAliasException e) {
                alias = null;
            }
            if (!blSync.getBaselineItemId().equals(selector) && !blSync.getBaselineName().equals(selector) && !baselineNumber.equals(selector) && (alias == null || !alias.getUuid().getUuidValue().equals(blSync.getBaselineItemId()))) continue;
            return selector;
        }
        return null;
    }

    static enum Mode {
        UNSET,
        WS,
        CS,
        BASELINE,
        COMPONENT,
        WI;

    }
}

