/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.snapshot;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.snapshot.PromoteSnapshotCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;

public class PromoteSnapshotCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument target = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(PromoteSnapshotCmdOpts.OPT_TARGET.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)target, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)target);
        IWorkspace targetWs = RepoUtil.getWorkspace((String)target.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        List ssSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(PromoteSnapshotCmdOpts.OPT_SNAPSHOTS.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)ssSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT, (List)ssSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        List selectors = RepoUtil.getSelectors((List)ssSelectors);
        List snapshots = RepoUtil.getSnapShots(null, (List)selectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        ParmsUpdateBaselineSet updateParms = new ParmsUpdateBaselineSet();
        updateParms.baselineSet = new ParmsBaselineSet();
        int idx = 0;
        for (IBaselineSet snapshot : snapshots) {
            try {
                updateParms.promotionWorkspace = new ParmsWorkspace(repo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
                updateParms.baselineSet.repositoryUrl = repo.getRepositoryURI();
                updateParms.baselineSet.baselineSetItemId = snapshot.getItemId().getUuidValue();
                client.postUpdateBaselineSet(updateParms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.PromoteSnapshotCmd_PROMOTION_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
            if (idx == 0) {
                out.println((CharSequence)Messages.PromoteSnapshotCmd_PROMOTED_SNAPSHOT);
            }
            out.println((CharSequence)("  " + (String)selectors.get(idx++)));
        }
    }
}

