/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.snapshot;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.List;

public class DeleteSnapshotCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IPositionalOptionDefinition OPT_SNAPSHOTS = new PositionalOptionDefinition(CommonOptions.OPT_SNAPSHOTS, "snapshots", 0, -1);
    public static final IPositionalOptionDefinition OPT_TARGET = new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.DeleteSnapshotCmdOpts_OPT_VERBOSE).addOption(OPT_TARGET, Messages.ReplaceComponentsCmdOptions_TARGET_WORKSPACE).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)CommonOptions.OPT_ALL, Messages.DeleteSnapshotCmdOpts_OPT_ALL_HELP, false).addOption(OPT_SNAPSHOTS, Messages.DeleteSnapshotCmdOpts_OPT_SNAPSHOTS_HELP));
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption(OPT_SNAPSHOTS.getId()) && cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeleteSnapshotCmd_SNAPSHOTS_OR_ALL, (Object)OPT_SNAPSHOTS.getName(), (Object[])new Object[]{CommonOptions.OPT_ALL.getName()}));
        }
        if (!cli.hasOption(OPT_SNAPSHOTS.getId()) && !cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeleteSnapshotCmd_SPECIFY_SNAPSHOTS_OR_ALL, (Object)OPT_SNAPSHOTS.getName(), (Object[])new Object[]{CommonOptions.OPT_ALL.getName()}));
        }
        ScmCommandLineArgument target = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_TARGET.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)target, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)target);
        IWorkspace targetWs = RepoUtil.getWorkspace((String)target.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        List snapshots = null;
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_ALL)) {
            snapshots = RepoUtil.getSnapshotByName((String)targetWs.getItemId().getUuidValue(), (String)"", (boolean)false, (int)Integer.MAX_VALUE, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            List ssSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_SNAPSHOTS.getId()), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)ssSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            List selectors = RepoUtil.getSelectors((List)ssSelectors);
            snapshots = RepoUtil.getSnapShots((String)targetWs.getItemId().getUuidValue(), (List)selectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        }
        ParmsRemoveBaselineSet removeParms = new ParmsRemoveBaselineSet();
        removeParms.baselineSet = new ParmsBaselineSet();
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        ArrayList<IBaselineSet> deletedSnapshots = new ArrayList<IBaselineSet>();
        for (IBaselineSet snapshot : snapshots) {
            try {
                removeParms.workspace = new ParmsWorkspace(repo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
                removeParms.baselineSet.repositoryUrl = repo.getRepositoryURI();
                removeParms.baselineSet.baselineSetItemId = snapshot.getItemId().getUuidValue();
                client.postRemoveBaselineSet(removeParms, null);
                deletedSnapshots.add(snapshot);
            }
            catch (TeamRepositoryException e) {
                this.printDeletedSnapshots(deletedSnapshots, repo, out);
                throw StatusHelper.wrap((String)NLS.bind((String)Messages.DeleteSnapshotCmd_FAILED, (Object)AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT), (Object[])new Object[0]), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_JSON)) {
            this.printJsonizedDeletedSnapshots(deletedSnapshots, repo);
        } else if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            this.printDeletedSnapshots(deletedSnapshots, repo, out);
        }
        if (!cli.hasOption((IOptionKey)CommonOptions.OPT_JSON)) {
            if (deletedSnapshots.size() > 1) {
                out.println((CharSequence)Messages.DeleteSnapshotCmd_SUCCESS2);
            } else {
                out.println((CharSequence)Messages.DeleteSnapshotCmd_SUCCESS);
            }
        }
    }

    private void printJsonizedDeletedSnapshots(List<IBaselineSet> deletedSnapshots, ITeamRepository repo) {
        JSONArray jSnapshots = new JSONArray();
        for (IBaselineSet snapshot : deletedSnapshots) {
            JSONObject jSnapshot = JSONPrintUtil.jsonize((String)snapshot.getName(), (String)snapshot.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
            jSnapshots.add((Object)jSnapshot);
        }
        this.config.getOutputStream().print((CharSequence)jSnapshots.toString());
    }

    public void printDeletedSnapshots(List<IBaselineSet> deletedSnapshots, ITeamRepository repo, IndentingPrintStream out) {
        if (deletedSnapshots.size() == 0) {
            return;
        }
        out.println((CharSequence)Messages.DeleteSnapshotCmd_DELETED_SNAPSHOTS);
        for (IBaselineSet snapshot : deletedSnapshots) {
            out.indent().println((CharSequence)AliasUtil.selector((String)snapshot.getName(), (UUID)snapshot.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT));
        }
    }
}

