/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.snapshot;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.SetAttributesCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSetRelease;
import com.ibm.team.filesystem.client.rest.parameters.ParmsItemHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.workitem.common.model.IDeliverable;
import org.eclipse.osgi.util.NLS;

public class AddReleaseToSnapshotCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_RELEASE = new NamedOptionDefinition(null, "release", 1);
    public static final PositionalOptionDefinition OPT_SNAPSHOT = new PositionalOptionDefinition("snapshot", 1, 1, "@");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_RELEASE, Messages.AddReleaseToSnapshotCmd_RELEASE_HELP, false).addOption((INamedOptionDefinition)SetAttributesCmd.OPT_PROJECTAREA, Messages.SnapshotPropertiesCmdOptions_PROJECTAREA_HELP).addOption((IPositionalOptionDefinition)OPT_SNAPSHOT, Messages.AddReleaseToSnapshotCmd_SNAPSHOT_TO_ADD);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (!cli.hasOption((IOptionKey)OPT_RELEASE)) {
            throw StatusHelper.argSyntax((String)Messages.AddReleaseToSnapshotCmd_SPECIFY_RELEASE);
        }
        ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SNAPSHOT, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument release = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_RELEASE), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument projectArea = null;
        if (cli.hasOption((IOptionKey)SetAttributesCmd.OPT_PROJECTAREA)) {
            projectArea = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)SetAttributesCmd.OPT_PROJECTAREA), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)projectArea, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.PROJECTAREA, RepoUtil.ItemType.TEAMAREA});
        }
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
        IBaselineSet ss = RepoUtil.getSnapshot(null, (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        AddReleaseToSnapshotCmd.setProperties(ss, (IScmCommandLineArgument)release, (IScmCommandLineArgument)projectArea, repo, client, this.config);
        this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.AddReleaseToSnapshotCmd_SUCCESS, (Object)release.getItemSelector(), (Object)ss.getName()));
    }

    private static void setProperties(IBaselineSet ss, IScmCommandLineArgument releaseArg, IScmCommandLineArgument projectArea, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsBaselineSetRelease parms = new ParmsBaselineSetRelease();
        parms.baselineSet = new ParmsBaselineSet();
        parms.baselineSet.baselineSetItemId = ss.getItemId().getUuidValue();
        parms.baselineSet.repositoryUrl = repo.getRepositoryURI();
        IProcessArea processArea = null;
        if (projectArea != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)projectArea, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.PROJECTAREA, RepoUtil.ItemType.TEAMAREA});
            processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)projectArea, null, (ITeamRepository)repo, (IScmClientConfiguration)config);
        } else {
            processArea = RepoUtil.getSnapshotProjectArea((IBaselineSet)ss, (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IDeliverable release = RepoUtil.getReleaseByName((String)releaseArg.getItemSelector(), (IProjectAreaHandle)processArea.getProjectArea(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        parms.release = new ParmsItemHandle(release.getItemHandle());
        try {
            client.postAssociateBaselineSetWithRelease(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.AddReleaseToSnapshotCmd_FAILURE, (Object)releaseArg.getItemSelector(), (Object)ss.getName()), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }
}

