/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.sharecommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.sharecommand.ShareCmdOpts;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.core.SharingMetadataFactory;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShare;
import com.ibm.team.filesystem.client.rest.parameters.ParmsShareRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.EncodingErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SymlinkWarningDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareOverlapDTO;
import com.ibm.team.filesystem.common.internal.rest.client.share.ShareResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePathList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public class ShareCmd
extends AbstractSubcommand {
    private static final Log log = LogFactory.getLog((String)ShareCmd.class.getName());

    public void run() throws FileSystemException {
        SymlinkWarningDTO warning;
        StringBuffer msg;
        JSONObject warning2;
        String path;
        List pathSegments;
        ShareResultDTO shareResult;
        ResourcesPlugin.getWorkspace();
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (!cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE) && cli.hasOption((IOptionKey)ShareCmdOpts.OPT_EXPAND_CHANGESET)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_INVALID_OPTIONS_1, (Object)cli.getDefinition().getOption((IOptionKey)ShareCmdOpts.OPT_EXPAND_CHANGESET).getName(), (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_VERBOSE).getName()));
        }
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShareCmdOpts.OPT_WORKSPACE_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShareCmdOpts.OPT_COMPONENT_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        RepoUtil.validateWorkspaceIsTracked((ParmsWorkspace)ws, (String)Messages.ShareCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)this.config);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, Collections.singletonList(compSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        WorkspaceComponentDTO component = RepoUtil.getComponent((WorkspaceDetailsDTO)wsDetails, (String)compSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        String remotePathUUID = null;
        if (cli.hasOption((IOptionKey)ShareCmdOpts.OPT_REMOTE_PATH)) {
            ScmVersionablePath scmPath;
            String originalRemotePathInput;
            block49: {
                originalRemotePathInput = cli.getOption((IOptionKey)ShareCmdOpts.OPT_REMOTE_PATH);
                scmPath = null;
                IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
                if (RepoUtil.isUuid((String)originalRemotePathInput)) {
                    IScmRichClientRestService.ParmsGetPaths parms = null;
                    parms = new IScmRichClientRestService.ParmsGetPaths();
                    parms.componentItemId = component.getItemId();
                    parms.contextItemId = wsDetails.getItemId();
                    parms.contextItemType = IWorkspace.ITEM_TYPE.getName();
                    parms.contextItemNamespace = IWorkspace.ITEM_TYPE.getNamespaceURI();
                    parms.versionableItemIds = new String[]{originalRemotePathInput};
                    parms.versionableItemTypes = new String[]{IFolder.ITEM_TYPE.getName()};
                    parms.versionableItemNamespaces = new String[]{IFolder.ITEM_TYPE.getNamespaceURI()};
                    try {
                        List pathsList;
                        ScmVersionablePathList vPathList = scmService.postGetVersionablePaths(parms);
                        if (vPathList == null || (pathsList = vPathList.getPaths()) == null) break block49;
                        int pathSize = pathsList.size();
                        if (pathSize == 1) {
                            scmPath = (ScmVersionablePath)pathsList.get(0);
                        } else if (pathSize > 1) {
                            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ShareCmd_18, (Object)originalRemotePathInput));
                        }
                    }
                    catch (TeamRepositoryException vPathList) {}
                } else {
                    String[] path2 = StringUtil.splitEscapedPath((String)originalRemotePathInput);
                    String remotePathInput = path2.length == 0 ? Character.toString('/') : String.valueOf(StringUtil.createPathString((String[])path2)) + '/';
                    scmPath = RepoUtil.getVersionable2((IScmRichClientRestService)scmService, (String)wsDetails.getItemId(), (IItemType)IWorkspace.ITEM_TYPE, (String)component.getItemId(), (String)remotePathInput, (IScmClientConfiguration)this.config);
                }
            }
            if (scmPath == null || scmPath.getVersionable() == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ShareCmd_17, (Object)originalRemotePathInput));
            }
            remotePathUUID = scmPath.getVersionable().getItemId().getUuidValue();
        }
        ParmsShare parmsShare = new ParmsShare();
        ArrayList<ParmsShareRequest> shareRequestsList = new ArrayList<ParmsShareRequest>();
        boolean isPartialStatus = this.generateShareRequests(ws, component, remotePathUUID, this.config, client, cli, shareRequestsList);
        parmsShare.shareRequests = shareRequestsList.toArray(new ParmsShareRequest[shareRequestsList.size()]);
        parmsShare.overwrite = cli.hasOption((IOptionKey)ShareCmdOpts.OPT_IGNORE_EXISTING_SHARE);
        parmsShare.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parmsShare.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parmsShare.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parmsShare.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parmsShare.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        try {
            shareResult = client.postShare(parmsShare, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ShareCmd_10, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        JSONObject workspace = new JSONObject();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE) && shareResult.getChangeSetsCommitted().size() > 0) {
            workspace = this.printStatus(ws, component.getItemId(), shareResult.getChangeSetsCommitted(), client, this.config, out);
        }
        IndentingPrintStream err = this.config.getWrappedErrorStream();
        if (shareResult.getShareOverlaps().size() > 0) {
            err.println((CharSequence)Messages.ShareCmd_OVERLAPPING_SHARES);
            for (ShareOverlapDTO shareOverlap : shareResult.getShareOverlaps()) {
                for (ShareDTO shareDTO : shareOverlap.getOverlappingShares()) {
                    List pathSegments2 = shareDTO.getPath().getSegments();
                    String path3 = StringUtil.createPathString((String[])pathSegments2.toArray(new String[pathSegments2.size()]));
                    err.indent().println((CharSequence)path3);
                }
            }
            throw StatusHelper.disallowed((String)Messages.ShareCmd_OVERLAPPING_SHARES_FAILURE);
        }
        if (shareResult.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            if (this.config.isJSONEnabled()) {
                JSONObject deletedContentShareablesJson = new JSONObject();
                JSONArray deletedContentShareablesArray = new JSONArray();
                deletedContentShareablesJson.put((Object)"message", (Object)Messages.ShareCmd_DELETED_CONTENT_SHARABLES);
                List deletedContentShareables = shareResult.getSandboxUpdateDilemma().getDeletedContentShareables();
                for (ShareableDTO shareable : deletedContentShareables) {
                    deletedContentShareablesArray.add((Object)StringUtil.createPathString((List)shareable.getRelativePath().getSegments()));
                }
                deletedContentShareablesJson.put((Object)"content", (Object)deletedContentShareablesArray);
                workspace.put((Object)"content_deleted", (Object)deletedContentShareablesJson);
            } else {
                SubcommandUtil.showDeletedContent((List)shareResult.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out);
            }
        }
        JSONArray status = null;
        if (this.config.isJSONEnabled()) {
            status = new JSONArray();
        }
        String NEWLINE = System.getProperty("line.separator");
        if (shareResult.getCommitDilemma().getEncodingFailures().size() > 0) {
            StringBuffer encFailureMessage = new StringBuffer();
            encFailureMessage.append(Messages.ShareCmd_ENCODING_FAILURES);
            for (EncodingErrorDTO encErr : shareResult.getCommitDilemma().getEncodingFailures()) {
                pathSegments = encErr.getShareable().getRelativePath().getSegments();
                path = StringUtil.createPathString((String[])pathSegments.toArray(new String[pathSegments.size()]));
                encFailureMessage.append(NEWLINE);
                encFailureMessage.append(path);
            }
            log.warn((Object)encFailureMessage.toString());
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                if (this.config.isJSONEnabled()) {
                    warning2 = new JSONObject();
                    warning2.put((Object)"code", (Object)20);
                    warning2.put((Object)"message", (Object)encFailureMessage.toString());
                    warning2.put((Object)"severity", (Object)Constants.Severity.warning.toString());
                    status.add((Object)warning2);
                } else {
                    out.print((CharSequence)encFailureMessage);
                }
            }
        }
        if (shareResult.getCommitDilemma().getLineDelimiterFailures().size() > 0) {
            StringBuffer ldFailureMessage = new StringBuffer();
            ldFailureMessage.append(Messages.ShareCmd_LINE_DELIM_FAILURES);
            for (LineDelimiterErrorDTO ldErr : shareResult.getCommitDilemma().getLineDelimiterFailures()) {
                pathSegments = ldErr.getFileName().getSegments();
                path = StringUtil.createPathString((String[])pathSegments.toArray(new String[pathSegments.size()]));
                ldFailureMessage.append(NEWLINE);
                ldFailureMessage.append(path);
            }
            log.warn((Object)ldFailureMessage.toString());
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                if (this.config.isJSONEnabled()) {
                    warning2 = new JSONObject();
                    warning2.put((Object)"code", (Object)20);
                    warning2.put((Object)"message", (Object)ldFailureMessage.toString());
                    warning2.put((Object)"severity", (Object)Constants.Severity.warning.toString());
                    status.add((Object)warning2);
                } else {
                    out.print((CharSequence)ldFailureMessage);
                }
            }
        }
        if (shareResult.getCommitDilemma().getNonInteroperableLinks().size() > 0) {
            msg = new StringBuffer();
            msg.append(Messages.CheckInCmd_2);
            msg.append(NEWLINE);
            for (Object o : shareResult.getCommitDilemma().getNonInteroperableLinks()) {
                warning = (SymlinkWarningDTO)o;
                msg.append(NLS.bind((String)Messages.CheckInCmd_4, (Object[])new Object[]{warning.getLocation(), warning.getTarget(), warning.getType()}));
                msg.append(NEWLINE);
            }
            log.warn((Object)msg);
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                if (this.config.isJSONEnabled()) {
                    warning2 = new JSONObject();
                    warning2.put((Object)"code", (Object)67);
                    warning2.put((Object)"message", (Object)msg.toString());
                    warning2.put((Object)"severity", (Object)Constants.Severity.warning.toString());
                    status.add((Object)warning2);
                } else {
                    out.print((CharSequence)msg);
                }
            }
        }
        if (shareResult.getCommitDilemma().getBrokenLinks().size() > 0) {
            msg = new StringBuffer();
            msg.append(Messages.CheckInCmd_5);
            for (Object o : shareResult.getCommitDilemma().getBrokenLinks()) {
                warning = (SymlinkWarningDTO)o;
                msg.append(NLS.bind((String)Messages.CheckInCmd_4, (Object[])new Object[]{warning.getLocation(), warning.getTarget(), warning.getType()}));
                msg.append(NEWLINE);
            }
            log.warn((Object)msg);
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                if (this.config.isJSONEnabled()) {
                    warning2 = new JSONObject();
                    warning2.put((Object)"code", (Object)67);
                    warning2.put((Object)"message", (Object)msg.toString());
                    warning2.put((Object)"severity", (Object)Constants.Severity.warning.toString());
                    status.add((Object)warning2);
                } else {
                    out.print((CharSequence)msg);
                }
            }
        }
        if (this.config.isJSONEnabled()) {
            JSONObject success = new JSONObject();
            if (isPartialStatus) {
                success.put((Object)"code", (Object)54);
                success.put((Object)"message", (Object)Messages.ShareCmd_Partial_Success);
                success.put((Object)"severity", (Object)Constants.Severity.success.toString());
            } else {
                success.put((Object)"code", (Object)Constants.STATUS_OK);
                success.put((Object)"message", (Object)Messages.ShareCmd_6);
                success.put((Object)"severity", (Object)Constants.Severity.success.toString());
            }
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                if (!workspace.isEmpty()) {
                    status.add((Object)success);
                    workspace.put((Object)"status", (Object)status);
                    this.config.getOutputStream().print((CharSequence)workspace.toString());
                }
            } else {
                this.config.getOutputStream().print((CharSequence)success.toString());
            }
        } else {
            if (isPartialStatus) {
                err.println((CharSequence)Messages.ShareCmd_Partial_Success);
                throw StatusHelper.partialStatus();
            }
            out.println((CharSequence)Messages.ShareCmd_6);
        }
    }

    private boolean generateShareRequests(ParmsWorkspace ws, WorkspaceComponentDTO comp, String remotePathUUID, IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine cli, List<ParmsShareRequest> shareRequestsList) throws FileSystemException {
        HashMap<String, ArrayList<String>> sandboxToShares = new HashMap<String, ArrayList<String>>();
        boolean isPartialStatus = false;
        List roots = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)config, (List)cli.getOptions((IOptionKey)ShareCmdOpts.OPT_TO_SHARE));
        HashMap<String, ResourcePropertiesDTO> invalidShareToComponent = new HashMap<String, ResourcePropertiesDTO>();
        ArrayList<String> toIgnoreList = new ArrayList<String>();
        String[] stringArray = SharingMetadataFactory.SUPPORTED_METADATA_FOLDERS;
        int n = SharingMetadataFactory.SUPPORTED_METADATA_FOLDERS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            toIgnoreList.add(string);
            ++n2;
        }
        toIgnoreList.add(".jazzShed");
        toIgnoreList.add(".metadata");
        for (ILocation iLocation : roots) {
            ArrayList<String> shares;
            Object sandboxPath;
            if (toIgnoreList.contains(iLocation.getName())) continue;
            if (!SubcommandUtil.exists((ILocation)iLocation, null)) {
                throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.ShareCmd_2, (Object)iLocation));
            }
            ILocation rootParent = iLocation.getParent();
            Object sandboxFile = null;
            if (!rootParent.isEmpty()) {
                sandboxFile = SubcommandUtil.findAncestorCFARoot((String)iLocation.toOSString());
            }
            if (!rootParent.equals(sandboxPath = sandboxFile == null ? rootParent : new PathLocation(((File)sandboxFile).getAbsolutePath()))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ShareCmd_3, (Object)rootParent.toOSString(), (Object)sandboxPath.toOSString()));
            }
            if (!cli.hasOption((IOptionKey)ShareCmdOpts.OPT_IGNORE_EXISTING_SHARE)) {
                try {
                    ResourcePropertiesDTO resource = RepoUtil.getResourceProperties((String)iLocation.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    if (resource.isShared()) {
                        if (invalidShareToComponent.keySet().contains(iLocation.toOSString())) continue;
                        invalidShareToComponent.put(iLocation.toOSString(), resource);
                        continue;
                    }
                }
                catch (CLIFileSystemClientException resource) {
                    // empty catch block
                }
            }
            if ((shares = (ArrayList<String>)sandboxToShares.get(sandboxPath.toOSString())) == null) {
                shares = new ArrayList<String>();
                sandboxToShares.put(sandboxPath.toOSString(), shares);
            }
            shares.add(iLocation.getLocationRelativeTo(sandboxPath).toString());
        }
        if (!invalidShareToComponent.isEmpty()) {
            isPartialStatus = true;
            HashSet<String> hashSet = new HashSet<String>();
            for (ResourcePropertiesDTO res : invalidShareToComponent.values()) {
                hashSet.add(res.getShare().getComponentItemId());
            }
            HashMap componentToInvalidShares = new HashMap();
            for (String uniqueCompId : hashSet) {
                String component = null;
                String repoUri = null;
                ArrayList<String> sharesInComp = new ArrayList<String>();
                for (Map.Entry entry : invalidShareToComponent.entrySet()) {
                    if (!((ResourcePropertiesDTO)entry.getValue()).getShare().getComponentItemId().equals(uniqueCompId)) continue;
                    if (repoUri == null && component == null) {
                        repoUri = RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (String)((ResourcePropertiesDTO)entry.getValue()).getShare().getRepositoryId());
                        component = AliasUtil.selector((String)((ResourcePropertiesDTO)entry.getValue()).getShare().getComponentName(), (UUID)UUID.valueOf((String)((ResourcePropertiesDTO)entry.getValue()).getShare().getComponentItemId()), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                    }
                    sharesInComp.add(AliasUtil.selector((String)((String)entry.getKey()), (UUID)UUID.valueOf((String)((ResourcePropertiesDTO)entry.getValue()).getItemId()), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.UNKNOWN));
                }
                componentToInvalidShares.put(component, sharesInComp);
            }
            if (!componentToInvalidShares.isEmpty()) {
                IndentingPrintStream err = config.getWrappedErrorStream();
                String componentToShareInto = AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getItemId()), (String)ws.repositoryUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                err.println((CharSequence)NLS.bind((String)Messages.ShareCmd_INVALID_MULTIPLE_SHARE_1, (Object)componentToShareInto));
                for (Map.Entry entry : componentToInvalidShares.entrySet()) {
                    err.indent().println((CharSequence)NLS.bind((String)Messages.ShareCmd_INVALID_MULTIPLE_SHARE_2, entry.getKey()));
                    for (String invalidShare : (List)entry.getValue()) {
                        err.indent().indent().println((CharSequence)NLS.bind((String)Messages.ShareCmd_INVALID_MULTIPLE_SHARE_3, (Object)invalidShare));
                    }
                }
                if (cli.hasOption((IOptionKey)ShareCmdOpts.OPT_TO_TERMINATE_SHARE)) {
                    throw StatusHelper.inappropriateArgument((String)Messages.ShareCmd_INVALID_MULTIPLE_SHARE_4);
                }
            }
        }
        if (sandboxToShares.isEmpty()) {
            throw StatusHelper.inappropriateArgument((String)Messages.ShareCmd_NOTHING_TO_SHARE);
        }
        for (Map.Entry entry : sandboxToShares.entrySet()) {
            ParmsShareRequest shareRequest = new ParmsShareRequest();
            shareRequest.workspace = ws;
            shareRequest.componentItemId = comp.getItemId();
            shareRequest.parentFolderItemId = remotePathUUID == null ? comp.getRootFolder() : remotePathUUID;
            shareRequest.sandboxPath = (String)entry.getKey();
            shareRequest.itemsToShare = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
            shareRequestsList.add(shareRequest);
        }
        return isPartialStatus;
    }

    private JSONObject printStatus(ParmsWorkspace ws, String compId, List<String> csList, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.setVerbose(true);
        options.enableFilter(1);
        options.enableFilter(4);
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(11);
        options.enablePrinter(24);
        options.enablePrinter(25);
        options.enablePrinter(4);
        options.enablePrinter(8);
        ICommandLine cli = config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)ShareCmdOpts.OPT_EXPAND_CHANGESET)) {
            options.enablePrinter(6);
        }
        options.setMaxChanges(CommonOptions.getMaxChangesToInterpret((IClientConfiguration)config));
        ArrayList<ChangeSetSyncDTO> changeSetList = new ArrayList<ChangeSetSyncDTO>(csList.size());
        for (String cs : csList) {
            ChangeSetSyncDTO changeSet = RepoUtil.findChangeSet((String)cs, (boolean)false, (String)ws.workspaceItemId, (String)"workspace", (String)ws.repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            changeSetList.add(changeSet);
            options.addFilter(UUID.valueOf((String)changeSet.getChangeSetItemId()), 4);
            options.addFilter(UUID.valueOf((String)changeSet.getComponentItemId()), 1);
        }
        JSONArray workspaces = JSONPrintUtil.jsonizePendingChanges3((IFilesystemRestClient)client, Arrays.asList(ws), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
        if (config.isJSONEnabled()) {
            return (JSONObject)workspaces.get(0);
        }
        IndentingPrintStream ps = config.getWrappedOutputStream();
        PendingChangesUtil.printWorkspaces((JSONArray)workspaces, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)ps);
        return null;
    }
}

