/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand.parser;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.QueryOperations;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public final class QueryParserUtil {
    private static IProjectArea getProjectAreaByName(String projectAreaName, ITeamRepository repo) {
        List projectAreas;
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(Messages.QueryBuilder_LookupFailure);
        }
        for (IProjectArea pa : projectAreas) {
            if (!pa.getName().equals(projectAreaName)) continue;
            return pa;
        }
        throw new RuntimeException(NLS.bind((String)Messages.QueryBuilder_NoSuchProjectArea, (Object)projectAreaName));
    }

    private static ITeamArea getTeamAreaByName(String teamAreaName, ITeamRepository repo) {
        IProcessItemService itemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        try {
            List projectAreas = itemService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, null);
            for (IProjectArea projectArea : projectAreas) {
                List teamAreas = repo.itemManager().fetchPartialItems(projectArea.getTeamAreas(), 0, Collections.singletonList("name"), null);
                for (ITeamArea teamArea : teamAreas) {
                    if (!teamArea.getName().equals(teamAreaName)) continue;
                    return teamArea;
                }
            }
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(Messages.QueryBuilder_LookupFailure);
        }
        throw new RuntimeException(NLS.bind((String)Messages.QueryBuilder_NoSuchTeamArea, (Object)teamAreaName));
    }

    private static IComponentHandle getComponentByName(String componentName, ITeamRepository repo) {
        List compHandles;
        IComponentSearchCriteria criteria = IComponentSearchCriteria.FACTORY.newInstance();
        criteria.setExactName(componentName);
        try {
            compHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findComponents(criteria, Integer.MAX_VALUE, null);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(Messages.QueryBuilder_LookupFailure);
        }
        if (compHandles.size() == 1) {
            return (IComponentHandle)compHandles.get(0);
        }
        throw new RuntimeException(NLS.bind((String)Messages.QueryBuilder_NoSuchComponent, (Object)componentName));
    }

    private static IWorkspace getWorkspaceByName(String workspaceName, boolean getStream, ITeamRepository repo) {
        IScmRichClientRestService scmRichClientService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IScmRichClientRestService.ParmsSearchWorkspaces workspaceSearchParms = new IScmRichClientRestService.ParmsSearchWorkspaces();
        workspaceSearchParms.workspaceName = workspaceName;
        workspaceSearchParms.workspaceNameKind = "exact";
        workspaceSearchParms.workspaceKind = getStream ? "streams" : "workspaces";
        ScmWorkspaceList scmWrkspcList = null;
        IItemHandle wrkSpcHndl = null;
        IWorkspace wrkSpc = null;
        try {
            scmWrkspcList = scmRichClientService.postSearchWorkspaces(workspaceSearchParms);
            if (scmWrkspcList.getWorkspaces() != null && !scmWrkspcList.getWorkspaces().isEmpty()) {
                for (ScmWorkspace ws : scmWrkspcList.getWorkspaces()) {
                    if (!ws.getName().equals(workspaceSearchParms.workspaceName)) continue;
                    wrkSpcHndl = IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)ws.getItemId()), null);
                    wrkSpc = (IWorkspace)repo.itemManager().fetchCompleteItem(wrkSpcHndl, 0, null);
                    return wrkSpc;
                }
            }
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(Messages.QueryBuilder_LookupFailure);
        }
        throw new RuntimeException(NLS.bind((String)Messages.QueryBuilder_NoSuchWorkspace, (Object)workspaceName));
    }

    private static IBaselineSetHandle getSnapshotByName(String snapshotName, ITeamRepository repo) {
        List baselineSetHandles;
        IBaselineSetSearchCriteria criteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
        criteria.setExactName(snapshotName);
        try {
            baselineSetHandles = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).findBaselineSets(criteria, Integer.MAX_VALUE, null);
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(Messages.QueryBuilder_LookupFailure);
        }
        if (baselineSetHandles.size() > 0) {
            return (IBaselineSetHandle)baselineSetHandles.get(0);
        }
        throw new RuntimeException(NLS.bind((String)Messages.QueryBuilder_NoSuchSnapshot, (Object)snapshotName));
    }

    public static UUID getUUIDForName(String functionName, String objectName, ITeamRepository repo) {
        IProjectArea itemHandle = null;
        if (functionName.equals(QueryOperations.OPERATION_IN_PROJECT_AREA)) {
            itemHandle = QueryParserUtil.getProjectAreaByName(objectName, repo);
        } else if (functionName.equals(QueryOperations.OPERATION_IN_TEAM_AREA)) {
            itemHandle = QueryParserUtil.getTeamAreaByName(objectName, repo);
        } else if (functionName.equals(QueryOperations.OPERATION_FOR_COMPONENT)) {
            itemHandle = QueryParserUtil.getComponentByName(objectName, repo);
        } else if (functionName.equals(QueryOperations.OPERATION_IN_STREAM) || functionName.equals(QueryOperations.OPERATION_FOR_STREAM)) {
            itemHandle = QueryParserUtil.getWorkspaceByName(objectName, true, repo);
        } else if (functionName.equals(QueryOperations.OPERATION_IN_WORKSPACE) || functionName.equals(QueryOperations.OPERATION_FOR_WORKSPACE)) {
            itemHandle = QueryParserUtil.getWorkspaceByName(objectName, false, repo);
        } else if (functionName.equals(QueryOperations.OPERATION_IN_SNAPSHOT)) {
            itemHandle = QueryParserUtil.getSnapshotByName(objectName, repo);
        }
        if (itemHandle != null) {
            return itemHandle.getItemId();
        }
        return null;
    }

    private static String removePrefix(String rawString, char prefix) {
        StringBuilder bufString = new StringBuilder(rawString);
        if (bufString.length() > 0 && bufString.charAt(0) == prefix) {
            bufString.deleteCharAt(0);
        }
        return bufString.toString();
    }

    public static UUID getUUIDForAlias(String aliasString) {
        String aliasValue = QueryParserUtil.removePrefix(aliasString, '@');
        IUuidAliasRegistry.IUuidAlias alias = RepoUtil.lookupUuidAndAlias((String)aliasValue);
        if (alias == null) {
            throw new RuntimeException(NLS.bind((String)Messages.QueryBuilder_UnknownAlias, (Object)aliasValue));
        }
        return alias.getUuid();
    }
}

