/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand.parser;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.parser.ConjunctionType;
import com.ibm.team.filesystem.cli.client.internal.querycommand.parser.QueryParserUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.dto.QueryOperations;
import com.ibm.team.scm.common.internal.query.parser.generated.QueryBaseListener;
import com.ibm.team.scm.common.internal.query.parser.generated.QueryLexer;
import com.ibm.team.scm.common.internal.query.parser.generated.QueryParser;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class QueryBuilder
extends QueryBaseListener {
    private final Parser parser;
    private final ITeamRepository repo;
    private final Map<ParseTree, IGenericQueryNode> queries = new HashMap<ParseTree, IGenericQueryNode>();

    public static IGenericQueryNode createScmQuery(String queryText, ITeamRepository repo) {
        ANTLRInputStream stream = new ANTLRInputStream(queryText);
        QueryLexer lexer = new QueryLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        QueryParser parser = new QueryParser((TokenStream)tokens);
        QueryParser.QueryContext queryParseTree = parser.query();
        QueryBuilder builder = new QueryBuilder((Parser)parser, repo);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)builder, (ParseTree)queryParseTree);
        return builder.queries.get(queryParseTree.getChild(0));
    }

    public QueryBuilder(Parser parser, ITeamRepository repo) {
        this.parser = parser;
        this.repo = repo;
    }

    public void exitAttribute_equals(QueryParser.Attribute_equalsContext ctx) {
        TokenStream tokens = this.parser.getTokenStream();
        QueryParser.Equality_valueContext value = ctx.equality_value();
        String attributeName = this.getAttributeName(ctx.attribute_name());
        String stringLiteral = this.unquoteString(tokens.getText(value.getSourceInterval()));
        IGenericQueryNode query = IGenericQueryNode.FACTORY.newInstance(QueryOperations.OPERATION_EQUALS);
        query.addChild(attributeName);
        query.addChild(stringLiteral);
        this.queries.put((ParseTree)ctx, query);
    }

    public void exitAttribute_matches(QueryParser.Attribute_matchesContext ctx) {
        TokenStream tokens = this.parser.getTokenStream();
        QueryParser.String_valueContext value = ctx.string_value();
        String attributeName = this.getAttributeName(ctx.attribute_name());
        String stringLiteral = this.unquoteString(tokens.getText(value.getSourceInterval()));
        IGenericQueryNode query = IGenericQueryNode.FACTORY.newInstance(QueryOperations.OPERATION_MATCHES);
        query.addChild(attributeName);
        query.addChild(stringLiteral);
        this.queries.put((ParseTree)ctx, query);
    }

    public void exitAttribute_contains(QueryParser.Attribute_containsContext ctx) {
        TokenStream tokens = this.parser.getTokenStream();
        QueryParser.String_valueContext value = ctx.string_value();
        String attributeName = this.getAttributeName(ctx.attribute_name());
        String stringLiteral = this.unquoteString(tokens.getText(value.getSourceInterval()));
        IGenericQueryNode query = IGenericQueryNode.FACTORY.newInstance(QueryOperations.OPERATION_CONTAINS);
        query.addChild(attributeName);
        query.addChild(stringLiteral);
        this.queries.put((ParseTree)ctx, query);
    }

    public void exitClauseExpr(QueryParser.ClauseExprContext ctx) {
        this.queries.put((ParseTree)ctx, this.queries.get(ctx.clause()));
    }

    public void exitConjunctionExpr(QueryParser.ConjunctionExprContext ctx) {
        ConjunctionType conjunction = ConjunctionType.getConjunctionType(ctx);
        IGenericQueryNode query = conjunction.create(this.queries.get(ctx.expression().get(0)), this.queries.get(ctx.expression().get(1)));
        this.queries.put((ParseTree)ctx, query);
    }

    public void exitClause(QueryParser.ClauseContext ctx) {
        this.queries.put((ParseTree)ctx, this.getChildExpression((ParserRuleContext)ctx));
    }

    public void exitFunction(QueryParser.FunctionContext ctx) {
        TokenStream tokens = this.parser.getTokenStream();
        String functionName = tokens.getText(ctx.IDENTIFIER().getSourceInterval());
        IGenericQueryNode query = IGenericQueryNode.FACTORY.newInstance(functionName);
        QueryParser.Arg_listContext argListCtx = ctx.arg_list();
        if (argListCtx != null) {
            for (QueryParser.ArgumentContext arg : argListCtx.argument()) {
                this.addFunctionArg(query, arg, functionName);
            }
        }
        this.queries.put((ParseTree)ctx, query);
    }

    public void exitParenExpr(QueryParser.ParenExprContext ctx) {
        this.queries.put((ParseTree)ctx, this.queries.get(ctx.expression()));
    }

    private void addFunctionArg(IGenericQueryNode query, QueryParser.ArgumentContext arg, String functionName) {
        TokenStream tokens = this.parser.getTokenStream();
        QueryParser.Arg_valueContext argCtx = arg.arg_value();
        if (argCtx.equality_value() != null) {
            QueryParser.String_valueContext value = argCtx.equality_value().string_value();
            String stringLiteral = this.unquoteString(tokens.getText(value.getSourceInterval()));
            UUID itemUUID = QueryParserUtil.getUUIDForName(functionName, stringLiteral, this.repo);
            if (itemUUID != null) {
                query.addChild(itemUUID);
            } else {
                query.addChild(stringLiteral);
            }
        } else if (argCtx.uuid_value() != null) {
            QueryParser.Uuid_valueContext value = argCtx.uuid_value();
            String stringLiteral = this.unquoteString(tokens.getText(value.getSourceInterval()));
            query.addChild(UUID.valueOf((String)stringLiteral));
        } else if (argCtx.attribute_name() != null) {
            String stringLiteral = this.getAttributeName(argCtx.attribute_name());
            query.addChild(stringLiteral);
        } else if (argCtx.integer_value() != null) {
            QueryParser.Integer_valueContext value = argCtx.integer_value();
            Integer intValue = Integer.getInteger(tokens.getText(value.getSourceInterval()));
            query.addChild(intValue);
        } else if (argCtx.alias_value() != null) {
            QueryParser.Alias_valueContext value = argCtx.alias_value();
            String aliasString = tokens.getText(value.getSourceInterval());
            UUID itemUUID = QueryParserUtil.getUUIDForAlias(aliasString);
            query.addChild(itemUUID);
        } else {
            throw new RuntimeException(Messages.QueryBuilder_UnexpectedArgument);
        }
    }

    private IGenericQueryNode getChildExpression(ParserRuleContext context) {
        int numChildren = context.getChildCount();
        int i = 0;
        while (i < numChildren) {
            IGenericQueryNode childExpr;
            ParseTree child = context.getChild(i);
            IGenericQueryNode iGenericQueryNode = childExpr = child instanceof ParserRuleContext ? this.getChildExpression((ParserRuleContext)child) : this.queries.get(child);
            if (childExpr != null) {
                return childExpr;
            }
            ++i;
        }
        return this.queries.get(context);
    }

    private String getAttributeName(QueryParser.Attribute_nameContext context) {
        String name;
        TokenStream tokens = this.parser.getTokenStream();
        TerminalNode id = context.IDENTIFIER();
        TerminalNode literal = context.STRING_LITERAL();
        if (id != null) {
            name = tokens.getText(id.getSourceInterval());
        } else if (literal != null) {
            name = this.unquoteString(tokens.getText(literal.getSourceInterval()));
        } else {
            throw new RuntimeException(Messages.QueryBuilder_UnexpectedArgument);
        }
        return name;
    }

    private String unquoteString(String rawString) {
        StringBuilder bufString = new StringBuilder(rawString);
        if (bufString.length() > 0 && (bufString.charAt(0) == '\'' && bufString.charAt(bufString.length() - 1) == '\'' || bufString.charAt(0) == '\"' && bufString.charAt(bufString.length() - 1) == '\"')) {
            bufString.deleteCharAt(bufString.length() - 1);
            bufString.deleteCharAt(0);
        }
        return bufString.toString();
    }
}

