/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class WorkspaceQueryCmd
extends ObjectQueryCmd {
    public static void queryWorkspace(String queryString, ITeamRepository repo, int maxResult, boolean maxDefined, IScmRichClientRestService scmService, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        IWorkspaceHandle[] workspaces;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IGenericQueryNode query = null;
        try {
            query = WorkspaceQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = WorkspaceQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jWorkspace = new JSONArray();
            jWorkspace.clear();
            int extraResults = maxResult == Integer.MAX_VALUE ? maxResult : maxResult + 1;
            workspaces = RepoUtil.findWorkspacesQuery((IGenericQueryNode)query, (ITeamRepository)repo, (int)extraResults, (IScmClientConfiguration)config);
            if (workspaces != null && workspaces.length > 0) {
                WorkspaceQueryCmd.jsonizeWorkspaces(jWorkspace, workspaces, scmService, repo, config, client, maxResult);
                WorkspaceQueryCmd.printWorkspaces(jWorkspace, out, config, !maxDefined && workspaces.length > maxResult);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = WorkspaceQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (workspaces == null || workspaces.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QueryWorkspaceCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static void printWorkspaces(JSONArray jWorkspaces, IndentingPrintStream out, IScmClientConfiguration config, boolean printMoreMsg) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jWorkspaces.toString());
            return;
        }
        for (Object obj : jWorkspaces) {
            JSONObject jWorkspace = (JSONObject)obj;
            RepoUtil.ItemType itemType = PendingChangesUtil.getWorkspaceType((String)((String)jWorkspace.get((Object)"type")));
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jWorkspace.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jWorkspace.get((Object)"uuid"))), (String)((String)jWorkspace.get((Object)"url")), (RepoUtil.ItemType)itemType), (Object)jWorkspace.get((Object)"owner")));
        }
        if (printMoreMsg) {
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private static void jsonizeWorkspaces(JSONArray jWorkspaces, IWorkspaceHandle[] workspaces, IScmRichClientRestService scmService, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client, int maxResult) throws FileSystemException {
        int loopCount = Math.min(maxResult, workspaces.length);
        ArrayList<IWorkspaceHandle> workspaceList = new ArrayList<IWorkspaceHandle>(loopCount);
        int count = 0;
        while (count < loopCount) {
            IWorkspaceHandle handle = workspaces[count];
            workspaceList.add(handle);
            ++count;
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(0);
        JSONPrintUtil.jsonizeWorkspacesCustomAttributes((JSONArray)jWorkspaces, (ITeamRepository)repo, workspaceList, (PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
    }
}

