/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.QueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionableIdentifier;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionableIdentifierList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;

public class VersionableQueryCmd
extends ObjectQueryCmd {
    public static void queryVersionables(String queryString, ITeamRepository repo, IScmRichClientRestService scmService, QueryCmd.VersionMode vMode, IScmClientConfiguration config) throws FileSystemException {
        IVersionable[] versionables;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IGenericQueryNode query = null;
        try {
            query = VersionableQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = VersionableQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jVersionables = new JSONArray();
            versionables = RepoUtil.findVersionablesQuery((IGenericQueryNode)query, (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (versionables != null && versionables.length > 0) {
                VersionableQueryCmd.jsonizeVersionables(jVersionables, versionables, scmService, out, repo, config, vMode);
                VersionableQueryCmd.printVersionables(jVersionables, versionables, out, repo.getRepositoryURI(), config, vMode);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = VersionableQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (versionables == null || versionables.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QueryVersionableCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static void printVersionables(JSONArray versions, IVersionable[] versionables, IndentingPrintStream out, String repoUri, IScmClientConfiguration config, QueryCmd.VersionMode vMode) {
        boolean showVersionId;
        boolean bl = showVersionId = vMode == QueryCmd.VersionMode.LONG_VERSION || vMode == QueryCmd.VersionMode.SHORT_VERSION;
        if (config.isJSONEnabled()) {
            JSONObject jResult = new JSONObject();
            jResult.put((Object)"versionables", (Object)versions);
            config.getOutputStream().print((CharSequence)jResult.toString());
            return;
        }
        for (Object obj : versions) {
            JSONObject jPath = (JSONObject)obj;
            String versionId = null;
            JSONObject version = (JSONObject)jPath.get((Object)"version");
            if (version != null) {
                switch (vMode) {
                    case LONG_VERSION: {
                        versionId = JSONPrintUtil.jsonizeGetLongVersionId((JSONObject)version);
                        break;
                    }
                    case SHORT_VERSION: {
                        versionId = JSONPrintUtil.jsonizeGetShortVersionId((JSONObject)version);
                    }
                }
            }
            if (config.getAliasConfig().showUuid()) {
                if (showVersionId && versionId != null) {
                    out.println((CharSequence)NLS.bind((String)Messages.QueryVersionableCmd_PRINT_UUID_VERSION, (Object[])new String[]{(String)jPath.get((Object)"uuid"), (String)jPath.get((Object)"state-id"), (String)jPath.get((Object)"name"), versionId}));
                    continue;
                }
                out.println((CharSequence)NLS.bind((String)Messages.QueryVersionableCmd_PRINT_UUID, (Object[])new String[]{(String)jPath.get((Object)"uuid"), (String)jPath.get((Object)"state-id"), (String)jPath.get((Object)"name")}));
                continue;
            }
            if (showVersionId && versionId != null) {
                out.println((CharSequence)NLS.bind((String)Messages.QueryVersionableCmd_PRINT_NAME_VERSION, (Object[])new String[]{(String)jPath.get((Object)"name"), versionId}));
                continue;
            }
            out.println((CharSequence)NLS.bind((String)Messages.QueryVersionableCmd_PRINT_NAME, (Object[])new String[]{(String)jPath.get((Object)"name")}));
        }
    }

    private static void jsonizeVersionables(JSONArray versions, IVersionable[] versionables, IScmRichClientRestService scmService, IndentingPrintStream out, ITeamRepository repo, IScmClientConfiguration config, QueryCmd.VersionMode vMode) throws FileSystemException {
        if (versionables != null) {
            IVersionable[] iVersionableArray = versionables;
            int n = versionables.length;
            int n2 = 0;
            while (n2 < n) {
                ScmVersionableIdentifierList versionIdentifiers;
                IVersionable versionable = iVersionableArray[n2];
                JSONObject jVersionable = JSONPrintUtil.jsonize((String)versionable.getName(), (String)versionable.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
                jVersionable.put((Object)"item-type", (Object)versionable.getItemType().getName());
                jVersionable.put((Object)"state-id", (Object)versionable.getStateId().getUuidValue());
                if (vMode != QueryCmd.VersionMode.HIDE && !versionable.getItemType().equals(IFolder.ITEM_TYPE) && (versionIdentifiers = RepoUtil.getVersionIdentifiers((IScmRichClientRestService)scmService, Collections.singletonList(versionable.getStateId().getUuidValue()), (IScmClientConfiguration)config)).getVersionableIdentifiers().size() == 1) {
                    ScmVersionableIdentifier vid = (ScmVersionableIdentifier)versionIdentifiers.getVersionableIdentifiers().get(0);
                    jVersionable.put((Object)"version", (Object)JSONPrintUtil.jsonizeVersionId((ScmVersionableIdentifier)vid));
                }
                versions.add((Object)jVersionable);
                ++n2;
            }
        }
    }
}

