/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class StreamQueryCmd
extends ObjectQueryCmd {
    public static void queryStream(String queryString, ITeamRepository repo, int maxResult, boolean maxDefined, IScmRichClientRestService scmService, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        IWorkspaceHandle[] streams;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IGenericQueryNode query = null;
        try {
            query = StreamQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = StreamQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jStream = new JSONArray();
            jStream.clear();
            int extraResults = maxResult == Integer.MAX_VALUE ? maxResult : maxResult + 1;
            streams = RepoUtil.findStreamsQuery((IGenericQueryNode)query, (ITeamRepository)repo, (int)extraResults, (IScmClientConfiguration)config);
            if (streams != null && streams.length > 0) {
                StreamQueryCmd.jsonizeStreams(jStream, streams, scmService, repo, config, client, maxResult);
                StreamQueryCmd.printStreams(jStream, out, config, !maxDefined && streams.length > maxResult);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = StreamQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (streams == null || streams.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QueryStreamCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static void printStreams(JSONArray jStreams, IndentingPrintStream out, IScmClientConfiguration config, boolean printMoreMsg) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jStreams.toString());
            return;
        }
        for (Object obj : jStreams) {
            JSONObject jStream = (JSONObject)obj;
            RepoUtil.ItemType itemType = PendingChangesUtil.getWorkspaceType((String)((String)jStream.get((Object)"type")));
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jStream.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jStream.get((Object)"uuid"))), (String)((String)jStream.get((Object)"url")), (RepoUtil.ItemType)itemType), (Object)jStream.get((Object)"owner")));
        }
        if (printMoreMsg) {
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private static void jsonizeStreams(JSONArray jStreams, IWorkspaceHandle[] streams, IScmRichClientRestService scmService, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client, int maxResult) throws FileSystemException {
        int loopCount = Math.min(maxResult, streams.length);
        ArrayList<IWorkspaceHandle> streamList = new ArrayList<IWorkspaceHandle>(loopCount);
        int count = 0;
        while (count < loopCount) {
            IWorkspaceHandle handle = streams[count];
            streamList.add(handle);
            ++count;
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(0);
        JSONPrintUtil.jsonizeWorkspacesCustomAttributes((JSONArray)jStreams, (ITeamRepository)repo, streamList, (PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
    }
}

