/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class SnapshotQueryCmd
extends ObjectQueryCmd {
    public static void querySnapshot(String queryString, ITeamRepository repo, int maxResult, boolean maxDefined, IScmRichClientRestService scmService, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        IBaselineSet[] snapshots;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IGenericQueryNode query = null;
        try {
            query = SnapshotQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = SnapshotQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jSnapshots = new JSONArray();
            jSnapshots.clear();
            int extraResults = maxResult == Integer.MAX_VALUE ? maxResult : maxResult + 1;
            snapshots = RepoUtil.findSnapshotsQuery((IGenericQueryNode)query, (ITeamRepository)repo, (int)extraResults, (IScmClientConfiguration)config);
            if (snapshots != null && snapshots.length > 0) {
                SnapshotQueryCmd.jsonizeSnapshots(jSnapshots, snapshots, scmService, repo, config, client, maxResult);
                SnapshotQueryCmd.printSnapshots(jSnapshots, out, config, !maxDefined && snapshots.length > maxResult);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = SnapshotQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (snapshots == null || snapshots.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QuerySnapshotCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static void printSnapshots(JSONArray jSnapshots, IndentingPrintStream out, IScmClientConfiguration config, boolean printMoreMsg) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jSnapshots.toString());
            return;
        }
        for (Object obj : jSnapshots) {
            JSONObject jStream = (JSONObject)obj;
            String description = (String)jStream.get((Object)"description");
            if (description == null) {
                description = "";
            }
            out.println((CharSequence)NLS.bind((String)Messages.PublishedItemPrinter_Three_Args, (Object[])new String[]{AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jStream.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jStream.get((Object)"uuid"))), (String)((String)jStream.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT), description, (String)jStream.get((Object)"owner")}));
        }
        if (printMoreMsg) {
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private static void jsonizeSnapshots(JSONArray jSnapshots, IBaselineSet[] snapshots, IScmRichClientRestService scmService, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client, int maxResult) throws FileSystemException {
        int loopCount = Math.min(maxResult, snapshots.length);
        ArrayList<IBaselineSet> snapshotList = new ArrayList<IBaselineSet>(loopCount);
        int count = 0;
        while (count < loopCount) {
            IBaselineSet handle = snapshots[count];
            snapshotList.add(handle);
            ++count;
        }
        JSONPrintUtil.jsonizeSnapshotsCustomAttributes((JSONArray)jSnapshots, (ITeamRepository)repo, (IFilesystemRestClient)client, snapshotList, (IScmClientConfiguration)config);
    }
}

