/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.AbstractItemPrinter;
import com.ibm.team.filesystem.cli.client.internal.listcommand.QueryItemPrinter;
import com.ibm.team.filesystem.cli.client.internal.listcommand.SnapshotItemPrinter;
import com.ibm.team.filesystem.cli.client.internal.listcommand.UnknownItemPrinter;
import com.ibm.team.filesystem.cli.client.internal.listcommand.WorkspacePrinter;
import com.ibm.team.filesystem.cli.client.internal.querycommand.BaselineQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ChangeSetQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ComponentQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.QueryOptions;
import com.ibm.team.filesystem.cli.client.internal.querycommand.SnapshotQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.StreamQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.VersionableQueryCmd;
import com.ibm.team.filesystem.cli.client.internal.querycommand.WorkspaceQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryResult;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmQueryItem;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmSnapshot;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class QueryCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int count = 0;
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_STREAM)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_WORKSPACE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_SNAPSHOT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_BASELINE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_COMPONENT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_CHANGESET)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_FILES)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_RUN)) {
            ++count;
        }
        if (count > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_6_ARGUMENTS, (Object[])new String[]{QueryOptions.OPT_WORKSPACE.getName(), QueryOptions.OPT_STREAM.getName(), QueryOptions.OPT_SNAPSHOT.getName(), QueryOptions.OPT_BASELINE.getName(), QueryOptions.OPT_COMPONENT.getName(), QueryOptions.OPT_CHANGESET.getName(), QueryOptions.OPT_FILES.getName(), QueryOptions.OPT_RUN.getName()}));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        String queryString = cli.getOption(QueryOptions.OPT_QUERY_STR);
        if (cli.hasOption((IOptionKey)QueryOptions.OPT_STREAM)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
            StreamQueryCmd.queryStream(queryString, repo, maxResults, cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS), scmService, this.config, client);
        } else if (cli.hasOption((IOptionKey)QueryOptions.OPT_WORKSPACE)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
            WorkspaceQueryCmd.queryWorkspace(queryString, repo, maxResults, cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS), scmService, this.config, client);
        } else if (cli.hasOption((IOptionKey)QueryOptions.OPT_BASELINE)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
            BaselineQueryCmd.queryBaseline(queryString, repo, maxResults, cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS), scmService, this.config, client);
        } else if (cli.hasOption((IOptionKey)QueryOptions.OPT_SNAPSHOT)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
            SnapshotQueryCmd.querySnapshot(queryString, repo, maxResults, cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS), scmService, this.config, client);
        } else if (cli.hasOption((IOptionKey)QueryOptions.OPT_COMPONENT)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
            ComponentQueryCmd.queryComponent(queryString, repo, maxResults, cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS), scmService, this.config, client);
        } else if (cli.hasOption((IOptionKey)QueryOptions.OPT_CHANGESET)) {
            int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
            ChangeSetQueryCmd.queryChangeSet(queryString, repo, maxResults, cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS), scmService, this.config, client);
        } else if (cli.hasOption((IOptionKey)QueryOptions.OPT_RUN)) {
            String queryItemId = RepoUtil.getQueryItemUUIDForSelector((IScmClientConfiguration)this.config, (ITeamRepository)repo, (String)queryString);
            QueryResult result = this.runQuery(repo, scmService, queryItemId);
            this.printQueryResult(repo, result, false);
        } else {
            VersionMode vMode = VersionMode.HIDE;
            if (cli.hasOption(QueryOptions.OPT_SHOW_SHORT_VERSION_ID) && cli.hasOption(QueryOptions.OPT_SHOW_FULL_VERSION_ID)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)cli.getDefinition().getOption(QueryOptions.OPT_SHOW_SHORT_VERSION_ID).getName(), (Object)cli.getDefinition().getOption(QueryOptions.OPT_SHOW_FULL_VERSION_ID).getName()));
            }
            if (cli.hasOption(QueryOptions.OPT_SHOW_SHORT_VERSION_ID)) {
                vMode = VersionMode.SHORT_VERSION;
            } else if (cli.hasOption(QueryOptions.OPT_SHOW_FULL_VERSION_ID)) {
                vMode = VersionMode.LONG_VERSION;
            }
            VersionableQueryCmd.queryVersionables(queryString, repo, scmService, vMode, this.config);
        }
    }

    private QueryResult runQuery(ITeamRepository repo, IScmRichClientRestService scmService, String queryItemId) throws CLIFileSystemClientException, FileSystemException {
        IScmRichClientRestService.ParmsRunQueryItem parms = new IScmRichClientRestService.ParmsRunQueryItem();
        parms.queryItemId = queryItemId;
        int MAX_PAGE_SIZE = 512;
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)this.config.getSubcommandCommandLine());
        QueryResult result = new QueryResult();
        result.items = new ArrayList();
        try {
            boolean fetchMore = true;
            int toFetch = maxResults;
            while (fetchMore) {
                parms.maxResultSize = Math.min(512, toFetch);
                ScmItemQueryResult dto = scmService.postRunQueryItem(parms);
                result.items.addAll(dto.getItems());
                if (dto.getNextPage() == null || result.items.size() >= maxResults) {
                    fetchMore = false;
                } else {
                    parms.pageTimestamp = dto.getNextPage().getLastTimestamp().getTime();
                    toFetch = maxResults - result.items.size();
                }
                boolean bl = result.moreAvailable = dto.getNextPage() != null;
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.QueryCmd_0, (Object)queryItemId), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        return result;
    }

    private void printQueryResult(ITeamRepository repo, QueryResult result, boolean hasMoreItems) throws FileSystemException {
        if (result.items.size() == 0) {
            if (!this.config.isJSONEnabled()) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.QueryCmd_1);
            }
            return;
        }
        AbstractItemPrinter printer = this.getPrinterFor(result.items, repo);
        printer.printResult(result.items, result.moreAvailable);
    }

    private AbstractItemPrinter getPrinterFor(List<Object> result, ITeamRepository repo) throws FileSystemException {
        Object firstElement = result.get(0);
        if (firstElement instanceof ScmWorkspace) {
            return new WorkspacePrinter(this.config, repo, false){

                protected void printWorkspaces(JSONArray jWrkspcs, IndentingPrintStream out) {
                    out.println((CharSequence)Messages.WorkspacePrinter_1);
                    super.printWorkspaces(jWrkspcs, out, false);
                }
            };
        }
        if (firstElement instanceof ScmQueryItem) {
            return new QueryItemPrinter(this.config, repo);
        }
        if (firstElement instanceof ScmSnapshot) {
            return new SnapshotItemPrinter(this.config, repo);
        }
        StatusHelper.internalError((String)Messages.QueryCmd_2);
        return new UnknownItemPrinter(this.config, repo);
    }

    private class QueryResult {
        List items;
        boolean moreAvailable;

        private QueryResult() {
        }
    }

    public static enum VersionMode {
        HIDE,
        SHORT_VERSION,
        LONG_VERSION;

    }
}

