/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class ComponentQueryCmd
extends ObjectQueryCmd {
    public static void queryComponent(String queryString, ITeamRepository repo, int maxResult, boolean maxDefined, IScmRichClientRestService scmService, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        IComponent[] components;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IGenericQueryNode query = null;
        try {
            query = ComponentQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = ComponentQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jComponents = new JSONArray();
            jComponents.clear();
            int extraResults = maxResult == Integer.MAX_VALUE ? maxResult : maxResult + 1;
            components = RepoUtil.findComponentsQuery((IGenericQueryNode)query, (ITeamRepository)repo, (int)extraResults, (IScmClientConfiguration)config);
            if (components != null && components.length > 0) {
                ComponentQueryCmd.jsonizeComponents(jComponents, components, scmService, repo, config, client, maxResult);
                ComponentQueryCmd.printComponents(jComponents, out, config, !maxDefined && components.length > maxResult);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = ComponentQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (components == null || components.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QueryComponentCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static void printComponents(JSONArray jComponents, IndentingPrintStream out, IScmClientConfiguration config, boolean printMoreMsg) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jComponents.toString());
            return;
        }
        for (Object obj : jComponents) {
            JSONObject jComp = (JSONObject)obj;
            String description = (String)jComp.get((Object)"description");
            if (description == null) {
                description = "";
            }
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header, (Object)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jComp.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jComp.get((Object)"uuid"))), (String)((String)jComp.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object)description));
        }
        if (printMoreMsg) {
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private static void jsonizeComponents(JSONArray jComponents, IComponent[] components, IScmRichClientRestService scmService, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client, int maxResult) throws FileSystemException {
        int loopCount = Math.min(maxResult, components.length);
        ArrayList<IComponent> componentList = new ArrayList<IComponent>(loopCount);
        int count = 0;
        while (count < loopCount) {
            IComponent handle = components[count];
            componentList.add(handle);
            ++count;
        }
        JSONPrintUtil.jsonizeComponentCustomAttributes((JSONArray)jComponents, (ITeamRepository)repo, (IFilesystemRestClient)client, componentList, (IScmClientConfiguration)config);
    }
}

