/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveChangeSet;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class ChangeSetQueryCmd
extends ObjectQueryCmd {
    public static void queryChangeSet(String queryString, ITeamRepository repo, int maxResult, boolean maxDefined, IScmRichClientRestService scmService, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        IChangeSet[] changesets;
        IGenericQueryNode query = null;
        try {
            query = ChangeSetQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = ChangeSetQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jChangesets = new JSONArray();
            jChangesets.clear();
            int extraResults = maxResult >= 2048 ? 2048 : maxResult + 1;
            changesets = RepoUtil.findChangeSetsQuery((IGenericQueryNode)query, (ITeamRepository)repo, (int)extraResults, (IScmClientConfiguration)config);
            if (changesets != null && changesets.length > 0) {
                ArrayList<String> CSIds = new ArrayList<String>();
                IChangeSet[] iChangeSetArray = changesets;
                int n = changesets.length;
                int n2 = 0;
                while (n2 < n) {
                    IChangeSet cs = iChangeSetArray[n2];
                    CSIds.add(cs.getItemId().getUuidValue());
                    ++n2;
                }
                ChangeSetSyncDTO[] csDTOs = ChangeSetQueryCmd.getChangeSetDTOs(repo.getRepositoryURI(), client, config, CSIds.toArray(new String[CSIds.size()]));
                ChangeSetQueryCmd.jsonizeChangeSets(csDTOs, jChangesets, config);
                ChangeSetQueryCmd.printChangeSets(jChangesets, repo.getRepositoryURI(), client, config);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = ChangeSetQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (changesets == null || changesets.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QueryChangeSetCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static ChangeSetSyncDTO[] getChangeSetDTOs(String repoUrl, IFilesystemRestClient client, IScmClientConfiguration config, String[] csIds) throws FileSystemException {
        ParmsGetChangeSets parms = new ParmsGetChangeSets();
        parms.repositoryUrl = repoUrl;
        parms.settings = new ParmsResolveChangeSet();
        parms.settings.includeChanges = false;
        parms.settings.includeFoldersInChangeLists = false;
        parms.settings.includeOslcLinks = false;
        parms.settings.includeUnchangedFiles = false;
        parms.changeSetItemIds = csIds;
        try {
            return client.postGetChangeSets(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ErrorFetchingChangeSet, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.repositoryUrl);
        }
    }

    private static void printChangeSets(JSONArray jChangesets, String repoUrl, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream out = config.getWrappedOutputStream();
        int len = jChangesets.size();
        int i = 0;
        while (i < len) {
            JSONObject jBl = (JSONObject)jChangesets.get(i);
            PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
            options.enablePrinter(22);
            PendingChangesUtil.printChangeSetHeader((JSONObject)jBl, (String)repoUrl, null, null, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out);
            ++i;
        }
    }

    private static void jsonizeChangeSets(ChangeSetSyncDTO[] csDTOs, JSONArray jChangesets, IScmClientConfiguration config) {
        ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOs;
        int n = csDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO csDTO = changeSetSyncDTOArray[n2];
            JSONObject csObj = new JSONObject();
            PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
            options.enablePrinter(22);
            JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)csObj, (ChangeSetSyncDTO)csDTO, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
            jChangesets.add((Object)csObj);
            ++n2;
        }
    }
}

