/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.querycommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.querycommand.ObjectQueryCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IGenericQueryNode;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class BaselineQueryCmd
extends ObjectQueryCmd {
    public static void queryBaseline(String queryString, ITeamRepository repo, int maxResult, boolean maxDefined, IScmRichClientRestService scmService, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        IBaseline[] baselines;
        IndentingPrintStream out = config.getWrappedOutputStream();
        IGenericQueryNode query = null;
        try {
            query = BaselineQueryCmd.getQuery(queryString, repo);
        }
        catch (Exception e) {
            String msg = BaselineQueryCmd.logAndCreateExceptionMessage(queryString, e);
            throw StatusHelper.failure((String)msg, null);
        }
        try {
            JSONArray jBaselines = new JSONArray();
            jBaselines.clear();
            int extraResults = maxResult == Integer.MAX_VALUE ? maxResult : maxResult + 1;
            baselines = RepoUtil.findBaselinesQuery((IGenericQueryNode)query, (ITeamRepository)repo, (int)extraResults, (IScmClientConfiguration)config);
            if (baselines != null && baselines.length > 0) {
                BaselineQueryCmd.jsonizeBaselines(jBaselines, baselines, scmService, repo, config, client, maxResult);
                BaselineQueryCmd.printBaselines(jBaselines, out, config, !maxDefined && baselines.length > maxResult);
            }
        }
        catch (TeamRepositoryException e) {
            String msg = BaselineQueryCmd.logAndCreateExceptionMessage(queryString, (Exception)((Object)e));
            throw StatusHelper.failure((String)msg, null);
        }
        if (baselines == null || baselines.length == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.QueryBaselineCmd_NO_ITEM_MATCH, (Object)queryString));
        }
    }

    private static void printBaselines(JSONArray jBaselines, IndentingPrintStream out, IScmClientConfiguration config, boolean printMoreMsg) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jBaselines.toString());
            return;
        }
        for (Object obj : jBaselines) {
            JSONObject jStream = (JSONObject)obj;
            String description = (String)jStream.get((Object)"description");
            if (description == null) {
                description = "";
            }
            out.println((CharSequence)NLS.bind((String)Messages.PublishedItemPrinter_Three_Args, (Object[])new String[]{AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jStream.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jStream.get((Object)"uuid"))), (String)((String)jStream.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE), description, (String)jStream.get((Object)"owner")}));
        }
        if (printMoreMsg) {
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private static void jsonizeBaselines(JSONArray jBaselines, IBaseline[] baselines, IScmRichClientRestService scmService, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client, int maxResult) throws FileSystemException {
        int loopCount = Math.min(maxResult, baselines.length);
        ArrayList<IBaseline> baselineList = new ArrayList<IBaseline>(loopCount);
        int count = 0;
        while (count < loopCount) {
            IBaseline handle = baselines[count];
            baselineList.add(handle);
            ++count;
        }
        JSONPrintUtil.jsonizeBaselinesCustomAttributes((JSONArray)jBaselines, (ITeamRepository)repo, (IFilesystemRestClient)client, baselineList, (IScmClientConfiguration)config);
    }
}

