/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.VersionableSetCustomAttributesCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.common.internal.rest.client.resource.CustomAttributesDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class VersionableShowCustomAttributesCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final int PROPERTY_UNAVAILABLE = 1;
    private static final int FILE_IS_NOT_SHARED = 2;
    private static final int FILE_DOES_NOT_EXIST = 3;
    public static final OptionKey OPT_FILES = new OptionKey("files");

    public String getKey(ICommandLine cli) {
        return null;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 1, -1), Messages.ExtendedPropertyListCmd_ListPropertiesHelp);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, (List)strPaths);
        String key = cli.getOption((IOptionKey)VersionableSetCustomAttributesCmd.OPT_KEY);
        VersionableShowCustomAttributesCmd.showCustomAttributes(paths, key, this.config);
    }

    public static void showCustomAttributes(List<ILocation> paths, String key, IScmClientConfiguration config) throws FileSystemException {
        MapEntryComparator mapEntryComparator = new MapEntryComparator();
        ArrayList<Map.Entry<String, Map<String, String>>> properties = new ArrayList<Map.Entry<String, Map<String, String>>>();
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        try {
            Map<String, Map<String, String>> map = VersionableShowCustomAttributesCmd.getProperties(config, key, paths, stats);
            properties.addAll(map.entrySet());
            Collections.sort(properties, mapEntryComparator);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ExtendedPropertyListCmd_CouldNotFetchProperty, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONArray props = VersionableShowCustomAttributesCmd.jsonize(properties, mapEntryComparator);
        JSONObject jResult = new JSONObject();
        jResult.put((Object)"results", (Object)props);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jResult.toString());
        } else {
            VersionableShowCustomAttributesCmd.printProps(props, out);
        }
        if (stats.size() > 0) {
            Collections.sort(stats, new StatusComparator());
            for (IStatus status : stats) {
                config.getWrappedErrorStream().println((CharSequence)status.getMessage());
            }
            IStatus mostSevere = (IStatus)stats.get(stats.size() - 1);
            switch (mostSevere.getCode()) {
                case 1: {
                    throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.PropertyListCmd_CouldNotGetProperty, (Object)key));
                }
                case 2: {
                    throw StatusHelper.inappropriateArgument((String)Messages.PropertyListCmd_FileIsNotShared);
                }
                case 3: {
                    throw StatusHelper.disallowed((String)Messages.PropertyListCmd_FileDoesNotExist);
                }
            }
        }
    }

    public static Map<String, Map<String, String>> getProperties(IScmClientConfiguration config, String key, List<ILocation> paths, List<IStatus> stats) throws TeamRepositoryException, FileSystemException {
        Map<String, CustomAttributesDTO> resourceProperties = VersionableShowCustomAttributesCmd.getExtenedProperties(config, paths, stats);
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>(resourceProperties.size());
        for (String string : resourceProperties.keySet()) {
            HashMap map = new HashMap();
            properties.put(string, map);
        }
        for (Map.Entry entry : resourceProperties.entrySet()) {
            String path = (String)entry.getKey();
            CustomAttributesDTO resourcePropertiesDTO = (CustomAttributesDTO)entry.getValue();
            Map map = (Map)properties.get(path);
            Map extendedProperties = resourcePropertiesDTO.getCustomAttributes();
            if (key == null) {
                if (extendedProperties == null) continue;
                for (Map.Entry userProperty : extendedProperties.entrySet()) {
                    VersionableShowCustomAttributesCmd.put(map, (String)userProperty.getKey(), (String)userProperty.getValue(), true, path, stats);
                }
                continue;
            }
            VersionableShowCustomAttributesCmd.put(map, key, VersionableShowCustomAttributesCmd.getExtendedProperty(key, extendedProperties), true, path, stats);
        }
        return properties;
    }

    private static void put(Map<String, String> map, String key, String value, boolean logWarning, String path, List<IStatus> stats) {
        if (value == null) {
            if (logWarning) {
                stats.add((IStatus)new Status(2, "com.ibm.team.filesystem.client", 1, NLS.bind((String)Messages.ExtendedPropertyListCmd_CouldNotGetPropertyForPath, (Object)key, (Object)path), null));
            }
        } else {
            map.put(key, value);
        }
    }

    private static String getExtendedProperty(String key, Map<String, String> extendedProperties) {
        String value = null;
        if (extendedProperties != null) {
            for (Map.Entry<String, String> extendedProperty : extendedProperties.entrySet()) {
                if (!key.equals(extendedProperty.getKey())) continue;
                value = extendedProperty.getValue();
                break;
            }
        }
        return value;
    }

    private static Map<String, CustomAttributesDTO> getExtenedProperties(IScmClientConfiguration config, List<ILocation> paths, List<IStatus> stats) throws TeamRepositoryException, FileSystemException {
        ArrayList<ILocation> validPaths = new ArrayList<ILocation>();
        int i = 0;
        while (i < paths.size()) {
            ILocation path = paths.get(i);
            String osString = path.toOSString();
            if (!SubcommandUtil.exists((ILocation)path, null)) {
                stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 3, NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)osString), null));
            } else {
                File cfaRootFile = SubcommandUtil.findAncestorCFARoot((String)path.toOSString());
                if (cfaRootFile == null) {
                    stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 2, NLS.bind((String)Messages.PropertyListCmd_PathIsNotShared, (Object)osString), null));
                } else {
                    validPaths.add(path);
                }
            }
            ++i;
        }
        ArrayList<String> sboxes = new ArrayList<String>();
        ArrayList<String> validPathStrings = new ArrayList<String>();
        HashMap<PathLocation, Object> sandbox2FileMap = new HashMap<PathLocation, Object>(validPaths.size());
        for (ILocation path : validPaths) {
            PathLocation cfaRoot = new PathLocation((IPath)new Path(SubcommandUtil.findAncestorCFARoot((String)path.toOSString()).getAbsolutePath()));
            if (!sandbox2FileMap.containsKey(cfaRoot)) {
                ArrayList<ILocation> pathList = new ArrayList<ILocation>();
                pathList.add(path);
                sandbox2FileMap.put(cfaRoot, pathList);
                sboxes.add(cfaRoot.toOSString());
            } else {
                ((List)sandbox2FileMap.get(cfaRoot)).add(path);
            }
            validPathStrings.add(path.toOSString());
        }
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])config.getSandboxes(), (IScmClientConfiguration)config);
        RepoUtil.loginUrlArgAncOrOnPaths((IScmClientConfiguration)config, (IFilesystemRestClient)client, validPaths);
        String[] arr = sboxes.toArray(new String[sboxes.size()]);
        SubcommandUtil.registerSandboxes((String[])arr, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        if (SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)config)) {
            for (ILocation sandbox : sandbox2FileMap.keySet()) {
                SubcommandUtil.refreshPaths((ILocation)sandbox, (List)((List)sandbox2FileMap.get(sandbox)), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            }
        }
        ParmsResourceProperties parms = new ParmsResourceProperties(true, validPathStrings.toArray(new String[validPathStrings.size()]));
        CustomAttributesDTO[] resourcesDTO = client.postGetExtendedProperties(parms, null);
        HashMap<String, CustomAttributesDTO> extendedProperties = new HashMap<String, CustomAttributesDTO>(validPaths.size());
        int i2 = 0;
        while (i2 < resourcesDTO.length) {
            CustomAttributesDTO dto = resourcesDTO[i2];
            if (dto == null) {
                stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 3, Messages.PropertyListCmd_FileDoesNotExist, null));
            } else if (dto.getItemId() == null) {
                stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 3, NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)dto.getFullPath()), null));
            } else {
                String fullPath = dto.getFullPath();
                extendedProperties.put(fullPath, dto);
            }
            ++i2;
        }
        return extendedProperties;
    }

    private static JSONArray jsonize(List<Map.Entry<String, Map<String, String>>> properties, MapEntryComparator mapEntryComparator) {
        JSONArray fileProps = new JSONArray();
        int i = 0;
        while (i < properties.size()) {
            Map.Entry<String, Map<String, String>> fileProperties = properties.get(i);
            JSONObject filePath = new JSONObject();
            filePath.put((Object)"name", (Object)fileProperties.getKey());
            ArrayList<Map.Entry<String, String>> map = new ArrayList<Map.Entry<String, String>>(fileProperties.getValue().entrySet());
            Collections.sort(map, mapEntryComparator);
            JSONArray props = new JSONArray();
            for (Map.Entry entry : map) {
                JSONObject prop = new JSONObject();
                prop.put((Object)"property", entry.getKey());
                prop.put((Object)"value", entry.getValue());
                props.add((Object)prop);
            }
            if (props.size() > 0) {
                filePath.put((Object)"properties", (Object)props);
            }
            fileProps.add((Object)filePath);
            ++i;
        }
        return fileProps;
    }

    private static void printProps(JSONArray fileProps, IndentingPrintStream out) {
        if (fileProps == null) {
            return;
        }
        for (Object obj : fileProps) {
            JSONObject fileProp = (JSONObject)obj;
            out.println((CharSequence)((String)fileProp.get((Object)"name")));
            JSONArray props = (JSONArray)fileProp.get((Object)"properties");
            if (props == null) continue;
            int maxWidth = 0;
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                String property = (String)prop.get((Object)"property");
                maxWidth = Math.max(maxWidth, property.length());
            }
            IndentingPrintStream indent = out.indent();
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((String)prop.get((Object)"property")), (int)maxWidth), (Object)prop.get((Object)"value")));
            }
        }
    }

    private static final class MapEntryComparator
    implements Comparator<Map.Entry<String, ?>> {
        private MapEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, ?> o1, Map.Entry<String, ?> o2) {
            return o1.getKey().compareToIgnoreCase(o2.getKey());
        }
    }

    private static final class StatusComparator
    implements Comparator<IStatus> {
        private StatusComparator() {
        }

        @Override
        public int compare(IStatus o1, IStatus o2) {
            int compare = o1.getSeverity() - o2.getSeverity();
            if (compare == 0) {
                compare = o1.getCode() - o2.getCode();
            }
            if (compare == 0) {
                compare = o1.getMessage().compareTo(o2.getMessage());
            }
            return compare;
        }
    }
}

