/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.common.internal.rest.client.resource.InvalidPropertyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PropertyFailureDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class VersionableSetCustomAttributesCmd {
    public static final OptionKey OPT_FILES = new OptionKey("files");
    public static final OptionKey OPT_KEY = new OptionKey("key");
    public static final OptionKey OPT_VALUE = new OptionKey("value");
    private IFilesystemRestClient client;

    public static void setProperty(IScmClientConfiguration config, String key, String value, IFilesystemRestClient client, List<ILocation> paths) throws TeamRepositoryException, FileSystemException {
        RepoUtil.loginUrlArgAncOrOnPaths((IScmClientConfiguration)config, (IFilesystemRestClient)client, paths);
        ParmsResourcePropertyUpdates parms = new ParmsResourcePropertyUpdates();
        parms.resourcePropertyChanges = new ParmsResourcePropertyChange[paths.size()];
        HashMap sandbox2FileMap = new HashMap(paths.size());
        int i = 0;
        while (i < paths.size()) {
            ILocation path = paths.get(i);
            ParmsResourcePropertyChange change = new ParmsResourcePropertyChange();
            File cfaRootFile = SubcommandUtil.findAncestorCFARoot((File)((File)path.getAdapter(File.class)));
            if (cfaRootFile == null) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertySetCmd_CouldNotFindSandboxForPath, (Object)path.toOSString()));
            }
            PathLocation cfaRoot = new PathLocation(cfaRootFile.getAbsolutePath());
            IRelativeLocation filePath = path.getLocationRelativeTo((ILocation)cfaRoot);
            SubcommandUtil.registerSandboxes((String[])new String[]{cfaRoot.toOSString()}, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            change.sandboxPath = cfaRoot.toOSString();
            change.filePath = filePath.toString();
            if (!sandbox2FileMap.containsKey(cfaRoot)) {
                ArrayList<ILocation> pathList = new ArrayList<ILocation>();
                pathList.add(path);
                sandbox2FileMap.put(cfaRoot, pathList);
            } else {
                ((List)sandbox2FileMap.get(cfaRoot)).add(path);
            }
            change.propertyChanges = new ParmsProperty[1];
            ParmsProperty parmsProp = new ParmsProperty();
            parmsProp.propertyName = key;
            parmsProp.propertyValue = value;
            change.propertyChanges[0] = parmsProp;
            parms.resourcePropertyChanges[i] = change;
            ++i;
        }
        for (ILocation sandbox : sandbox2FileMap.keySet()) {
            SubcommandUtil.refreshPaths((ILocation)sandbox, (List)((List)sandbox2FileMap.get(sandbox)), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            for (ILocation path : (List)sandbox2FileMap.get(sandbox)) {
                IShareable shareable = SharingManager.getInstance().findShareable(path, ResourceType.FILE);
                ILocalChange pendingChange = shareable.getChange(null);
                if (pendingChange.getType() == 0) continue;
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.ExtendedPropertySetCmd_UnresolvedChanges, (Object)path.getName()));
            }
        }
        ResourcePropertyChangeResultDTO result = client.postExtendedProperties(parms, null);
        IndentingPrintStream printStream = config.getWrappedErrorStream();
        List propertyFailures = result.getPropertyFailures();
        String reason = null;
        if (propertyFailures.size() > 0) {
            printStream.println((CharSequence)NLS.bind((String)Messages.ExtendedPropertySetCmd_InvalidPropertyForFiles, (Object)key));
            for (PropertyFailureDTO propertyFailure : propertyFailures) {
                RelativeLocation path = new RelativeLocation(propertyFailure.getFileName().getSegments());
                if (propertyFailure.getInvalidProperties() != null) {
                    InvalidPropertyDTO invalidProp = (InvalidPropertyDTO)propertyFailure.getInvalidProperties().get(0);
                    reason = invalidProp.getReason();
                }
                printStream.indent().println((CharSequence)path.toString());
            }
        }
        if (propertyFailures.size() > 0) {
            throw StatusHelper.invalidProperty((String)(reason != null && reason.length() > 0 ? reason : NLS.bind((String)Messages.PropertySetCmd_InvalidProperty, (Object)key)));
        }
        config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_KeySuccessfullySetToValue, (Object)key, (Object)value));
    }
}

