/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSetCustomAttributes;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;

public class SnapshotUnsetCustomAttributeCmd {
    IFilesystemRestClient client;

    public static void unsetCustomAttributes(IScmCommandLineArgument ssSelector, IScmCommandLineArgument wsSelector, String[] unsetCustomAttrs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
        IWorkspace ws = null;
        if (wsSelector != null) {
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaselineSet ss = RepoUtil.getSnapshot((String)(ws != null ? ws.getItemId().getUuidValue() : null), (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        SnapshotUnsetCustomAttributeCmd.unsetCustomAttributes(ss, unsetCustomAttrs, repo, client, config);
        config.getWrappedOutputStream().println((CharSequence)Messages.SnapshotUnsetCustomAttributesCmd_PROPERTY_UNSET_SUCCESS);
    }

    private static void unsetCustomAttributes(IBaselineSet ss, String[] unsetCustomAttrs, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsBaselineSetCustomAttributes parms = new ParmsBaselineSetCustomAttributes();
        parms.baselineSet = new ParmsBaselineSet();
        parms.baselineSet.baselineSetItemId = ss.getItemId().getUuidValue();
        parms.baselineSet.repositoryUrl = repo.getRepositoryURI();
        parms.unsetCustomAttrs = unsetCustomAttrs;
        try {
            client.postSetBaselineSetCustomAttributes(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.SnapshotUnsetCustomAttributesCmd_PROPERTY_UNSET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }
}

