/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSetGetCustomAttributes;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.BaselineCustomAttributesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class SnapshotShowCustomAttributesCmd {
    IFilesystemRestClient client;

    public static void getCustomAttributes(IScmCommandLineArgument ssSelector, IScmCommandLineArgument wsSelector, String key, boolean printCaption, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        long statusCode = 0L;
        String errorMsg = null;
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
        IWorkspace ws = null;
        if (wsSelector != null) {
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaselineSet ss = RepoUtil.getSnapshot((String)(ws != null ? ws.getItemId().getUuidValue() : null), (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        JSONObject jSs = new JSONObject();
        try {
            JSONObject jProps = SnapshotShowCustomAttributesCmd.getCustomAttributes(ss, ws, key, repo, config, client);
            jSs.put((Object)"snapshot", (Object)ss.getName());
            jSs.put((Object)"properties", (Object)jProps);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (errorMsg != null) {
            jSs.put((Object)"error-message", (Object)errorMsg);
        }
        jSs.put((Object)"status-code", (Object)statusCode);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jSs.toString());
        } else {
            SnapshotShowCustomAttributesCmd.printProperties(jSs, printCaption, config);
        }
    }

    private static JSONObject getCustomAttributes(IBaselineSet ss, IWorkspace ws, String key, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client) throws TeamRepositoryException {
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        ParmsBaselineSet parms = new ParmsBaselineSet();
        parms.repositoryUrl = repo.getRepositoryURI();
        parms.baselineSetItemId = ss.getItemId().getUuidValue();
        ParmsBaselineSetGetCustomAttributes parmsBl = new ParmsBaselineSetGetCustomAttributes();
        parmsBl.baselineSet = parms;
        BaselineCustomAttributesDTO customAttrs = client.getBaselineSetCustomAttributes(parmsBl, null);
        ArrayList map = new ArrayList(customAttrs.getCustomAttributes().entrySet());
        JSONArray props = new JSONArray();
        for (Map.Entry entry : map) {
            JSONObject prop = new JSONObject();
            if (key != null && !key.equals(entry.getKey())) continue;
            prop.put((Object)"property", entry.getKey());
            prop.put((Object)"value", entry.getValue());
            props.add((Object)prop);
        }
        if (props.size() > 0) {
            jProps.put((Object)"custom_attributes", (Object)props);
        }
        jProps.put((Object)"uuid", (Object)ss.getItemId().getUuidValue());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        return jProps;
    }

    private static void printProperties(JSONObject jSs, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        JSONArray props;
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject jProps = (JSONObject)jSs.get((Object)"properties");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        String name = (String)jSs.get((Object)"snapshot");
        if (name != null) {
            name = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_NAME, (Object)name) : name));
        }
        if ((props = (JSONArray)jProps.get((Object)"custom_attributes")) != null) {
            int maxWidth = 0;
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                String property = (String)prop.get((Object)"property");
                maxWidth = Math.max(maxWidth, property.length());
            }
            IndentingPrintStream indent = out.indent();
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((String)prop.get((Object)"property")), (int)maxWidth), (Object)prop.get((Object)"value")));
            }
        }
    }
}

