/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.SetAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.SnapshotPropertyListCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsItemHandle;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class SnapshotPropertySetCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client;
    public static final PositionalOptionDefinition OPT_PROPERTY_NAME = new PositionalOptionDefinition("property-name", 1, 1);
    public static final PositionalOptionDefinition OPT_PROPERTY_VALUE = new PositionalOptionDefinition("property-value", 1, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_PROPERTY_NAME, NLS.bind((String)Messages.SnapshotPropertiesCmdOptions_OPT_PROPERTY_SET_NAME_HELP, (Object[])new String[]{"name", "ownedby", "owned", "description", "desc", "iteration"})).addOption((IPositionalOptionDefinition)OPT_PROPERTY_VALUE, Messages.SnapshotPropertiesCmdOptions_OPT_PROPERTY_VALUE_HELP).addOption((IPositionalOptionDefinition)SnapshotPropertyListCmd.OPT_SNAPSHOT_SELECTOR, Messages.SnapshotPropertiesCmdOptions_SNAPSHOT_SET_HELP).addOption((INamedOptionDefinition)SnapshotPropertyListCmd.OPT_WORKSPACE_SELECTOR, Messages.SnapshotPropertiesCmdOptions_WORKSPACE_HELP).addOption((INamedOptionDefinition)SetAttributesCmd.OPT_PROJECTAREA, Messages.SnapshotPropertiesCmdOptions_PROJECTAREA_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        String propertyName = cli.getOption((IOptionKey)OPT_PROPERTY_NAME, null);
        if (propertyName != null && !Arrays.asList(SnapshotPropertyListCmd.PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)SnapshotPropertyListCmd.OPT_SNAPSHOT_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        ScmCommandLineArgument propertyValue = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROPERTY_VALUE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument wsSelector = null;
        if (cli.hasOption((IOptionKey)SnapshotPropertyListCmd.OPT_WORKSPACE_SELECTOR)) {
            wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)SnapshotPropertyListCmd.OPT_WORKSPACE_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        }
        ScmCommandLineArgument projectArea = null;
        if (cli.hasOption((IOptionKey)SetAttributesCmd.OPT_PROJECTAREA)) {
            projectArea = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)SetAttributesCmd.OPT_PROJECTAREA), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)projectArea, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.PROJECTAREA, RepoUtil.ItemType.TEAMAREA});
        }
        HashMap<String, IScmCommandLineArgument> properties = new HashMap<String, IScmCommandLineArgument>();
        properties.put(propertyName.toLowerCase(), (IScmCommandLineArgument)propertyValue);
        SnapshotPropertySetCmd.setProperties((IScmCommandLineArgument)ssSelector, (IScmCommandLineArgument)wsSelector, (IScmCommandLineArgument)projectArea, properties, this.client, this.config);
    }

    public static void setProperties(IScmCommandLineArgument ssSelector, IScmCommandLineArgument wsSelector, IScmCommandLineArgument projectArea, Map<String, IScmCommandLineArgument> properties, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
        IWorkspace ws = null;
        if (wsSelector != null) {
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaselineSet ss = RepoUtil.getSnapshot((String)(ws != null ? ws.getItemId().getUuidValue() : null), (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        SnapshotPropertySetCmd.setProperties(ss, properties, projectArea, repo, client, config);
        config.getWrappedOutputStream().println((CharSequence)Messages.SnapshotPropertiesCmd_PROPERTY_SET_SUCCESS);
    }

    private static void setProperties(IBaselineSet ss, Map<String, IScmCommandLineArgument> properties, IScmCommandLineArgument projectArea, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IScmCommandLineArgument propertyValue;
        ParmsUpdateBaselineSet parms = new ParmsUpdateBaselineSet();
        parms.baselineSet = new ParmsBaselineSet();
        parms.baselineSet.baselineSetItemId = ss.getItemId().getUuidValue();
        parms.baselineSet.repositoryUrl = repo.getRepositoryURI();
        if (properties.containsKey("name")) {
            parms.name = properties.get("name").getItemSelector();
        }
        if (properties.containsKey("ownedby") || properties.containsKey("owned")) {
            propertyValue = properties.get("ownedby");
            if (propertyValue == null) {
                propertyValue = properties.get("owned");
            }
            SubcommandUtil.validateArgument((IScmCommandLineArgument)propertyValue, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            ITeamRepository repo2 = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)propertyValue);
            IWorkspace targetWs = RepoUtil.getWorkspace((String)propertyValue.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            parms.promotionWorkspace = new ParmsWorkspace(repo2.getRepositoryURI(), targetWs.getItemId().getUuidValue());
        }
        if (properties.containsKey("description") || properties.containsKey("desc")) {
            propertyValue = properties.get("description");
            if (propertyValue == null) {
                propertyValue = properties.get("desc");
            }
            parms.comment = propertyValue.getItemSelector();
        }
        if (properties.containsKey("iteration")) {
            IProcessArea processArea = null;
            if (projectArea != null) {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)projectArea, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.PROJECTAREA, RepoUtil.ItemType.TEAMAREA});
                processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)projectArea, null, (ITeamRepository)repo, (IScmClientConfiguration)config);
            } else {
                processArea = RepoUtil.getSnapshotProjectArea((IBaselineSet)ss, (ITeamRepository)repo, (IScmClientConfiguration)config);
            }
            IScmCommandLineArgument propertyValue2 = properties.get("iteration");
            IIterationHandle iteration = RepoUtil.getProcessAreaIterationByName((String)propertyValue2.getItemSelector(), (IProcessAreaHandle)processArea.getProjectArea(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            parms.iteration = new ParmsItemHandle((IItemHandle)iteration);
        }
        try {
            client.postUpdateBaselineSet(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.SnapshotPropertiesCmd_PROPERTY_SET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }
}

