/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class SnapshotPropertyListCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client;
    public static final String NAME_PROPERTY = "name";
    public static final String OWNEDBY_PROPERTY = "ownedby";
    public static final String OWNEDBY_ALIAS_PROPERTY = "owned";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DESCRIPTION_ALIAS_PROPERTY = "desc";
    public static final String ITERATION_PROPERTY = "iteration";
    public static final String RELEASE_PROPERTY = "release";
    public static final String CREATED_BY_PROPERTY = "createdby";
    public static final String CREATION_DATE_PROPERTY = "creationdate";
    public static final String[] PROPERTIES = new String[]{"name", "ownedby", "owned", "description", "desc", "iteration", "release"};
    public static final PositionalOptionDefinition OPT_SNAPSHOT_SELECTOR = new PositionalOptionDefinition("snapshot", 1, 1, "@");
    public static final NamedOptionDefinition OPT_WORKSPACE_SELECTOR = new NamedOptionDefinition("w", "workspace", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_SNAPSHOT_SELECTOR, Messages.SnapshotPropertiesCmdOptions_SNAPSHOT_LIST_HELP).addOption((INamedOptionDefinition)OPT_WORKSPACE_SELECTOR, Messages.SnapshotPropertiesCmdOptions_WORKSPACE_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    public void run() throws FileSystemException {
        this.listProperties(null);
    }

    protected void listProperties(String propertyName) throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (propertyName != null && !Arrays.asList(PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SNAPSHOT_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        ScmCommandLineArgument wsSelector = null;
        if (cli.hasOption((IOptionKey)OPT_WORKSPACE_SELECTOR)) {
            wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_WORKSPACE_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        }
        ArrayList<String> propertyNames = null;
        if (propertyName != null) {
            propertyNames = new ArrayList<String>(1);
            propertyNames.add(propertyName.toLowerCase());
        }
        SnapshotPropertyListCmd.listProperties((IScmCommandLineArgument)ssSelector, (IScmCommandLineArgument)wsSelector, propertyNames, propertyName == null, this.client, this.config);
    }

    public static void listProperties(IScmCommandLineArgument ssSelector, IScmCommandLineArgument wsSelector, List<String> propertyNames, boolean printCaption, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
        IWorkspace ws = null;
        if (wsSelector != null) {
            ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaselineSet ss = RepoUtil.getSnapshot((String)(ws != null ? ws.getItemId().getUuidValue() : null), (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        JSONObject jSs = new JSONObject();
        JSONObject jProps = SnapshotPropertyListCmd.getProperties(ss, propertyNames, repo, config);
        jSs.put((Object)"snapshot", (Object)ss.getName());
        jSs.put((Object)"properties", (Object)jProps);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jSs.toString());
        } else {
            SnapshotPropertyListCmd.printProperties(jSs, printCaption, config);
        }
    }

    private static JSONObject getProperties(IBaselineSet ss, List<String> propertyNames, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        JSONArray iteration;
        IWorkspace ws;
        IWorkspaceHandle wh;
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (propertyNames == null || propertyNames.contains(NAME_PROPERTY)) {
            jProps.put((Object)NAME_PROPERTY, (Object)ss.getName());
        }
        if (propertyNames == null || propertyNames.contains(DESCRIPTION_PROPERTY) || propertyNames.contains(DESCRIPTION_ALIAS_PROPERTY)) {
            jProps.put((Object)DESCRIPTION_PROPERTY, (Object)ss.getComment());
        }
        if ((propertyNames == null || propertyNames.contains(OWNEDBY_PROPERTY) || propertyNames.contains(OWNEDBY_ALIAS_PROPERTY)) && (wh = ss.getOwner()) != null && (ws = RepoUtil.getWorkspace((String)wh.getItemId().getUuidValue(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config)) != null) {
            jProps.put((Object)OWNEDBY_PROPERTY, (Object)ws.getName());
            jProps.put((Object)"ownedby_id", (Object)ws.getItemId().getUuidValue());
        }
        if (propertyNames == null || propertyNames.contains(CREATED_BY_PROPERTY)) {
            IContributor contributor = RepoUtil.getContributor((String)ss.getCreator().getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            JSONObject jCreatedBy = new JSONObject();
            jCreatedBy.put((Object)NAME_PROPERTY, (Object)contributor.getName());
            jCreatedBy.put((Object)"uuid", (Object)contributor.getItemId().getUuidValue());
            jCreatedBy.put((Object)"userId", (Object)contributor.getUserId());
            jCreatedBy.put((Object)"url", (Object)((ITeamRepository)contributor.getOrigin()).getRepositoryURI());
            jCreatedBy.put((Object)"type", (Object)RepoUtil.ItemType.CONTRIBUTOR.toString());
            jProps.put((Object)"createdBy", (Object)jCreatedBy);
        }
        if (propertyNames == null || propertyNames.contains(CREATION_DATE_PROPERTY)) {
            SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
            format = SubcommandUtil.getDateFormat((String)format.toPattern(), (IScmClientConfiguration)config);
            jProps.put((Object)"creationDate", (Object)format.format(ss.getCreationDate()));
        }
        jProps.put((Object)"uuid", (Object)ss.getItemId().getUuidValue());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        if ((propertyNames == null || propertyNames.contains(ITERATION_PROPERTY)) && (iteration = SnapshotPropertyListCmd.getIteration(ss, repo, config)) != null) {
            jProps.put((Object)ITERATION_PROPERTY, (Object)iteration);
        }
        return jProps;
    }

    private static JSONArray getIteration(IBaselineSet ss, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        List fetched = RepoUtil.getBaselineSetIterations((IBaselineSet)ss, (ITeamRepository)repo, (IScmClientConfiguration)config);
        JSONArray array = new JSONArray();
        for (IIteration iteration : fetched) {
            if (iteration == null) continue;
            JSONObject properties = new JSONObject();
            properties.put((Object)"uuid", (Object)iteration.getItemId().getUuidValue());
            properties.put((Object)"id", (Object)iteration.getId());
            properties.put((Object)NAME_PROPERTY, (Object)iteration.getName());
            properties.put((Object)"label", (Object)iteration.getLabel());
            properties.put((Object)DESCRIPTION_PROPERTY, (Object)iteration.getDescription().getSummary());
            properties.put((Object)"archived", (Object)iteration.isArchived());
            try {
                String parentId = "";
                IDevelopmentLineHandle developmentLineHandle = iteration.getDevelopmentLine();
                IIteration loopIteration = iteration;
                while (loopIteration != null && loopIteration.getParent() != null) {
                    IIteration parentIteration = (IIteration)repo.itemManager().fetchCompleteItem((IItemHandle)loopIteration.getParent(), 0, null);
                    if (parentIteration != null) {
                        parentId = parentId.length() > 0 ? String.valueOf(parentIteration.getLabel()) + '/' + parentId : parentIteration.getLabel();
                    }
                    loopIteration = parentIteration;
                }
                IDevelopmentLine line = (IDevelopmentLine)repo.itemManager().fetchCompleteItem((IItemHandle)developmentLineHandle, 0, null);
                if (line != null) {
                    parentId = parentId.length() > 0 ? String.valueOf(line.getLabel()) + '/' + parentId : line.getLabel();
                }
                if (!parentId.isEmpty()) {
                    properties.put((Object)"iteration_parent", (Object)parentId);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            array.add((Object)properties);
        }
        if (array.size() > 0) {
            return array;
        }
        return null;
    }

    private static void printProperties(JSONObject jSs, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        String creationDate;
        JSONObject jCreatedBy;
        JSONArray jIteration;
        String ownedby;
        Object obj;
        String description;
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject jProps = (JSONObject)jSs.get((Object)"properties");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        String ownedby_id = (String)jProps.get((Object)"ownedby_id");
        String name = (String)jProps.get((Object)NAME_PROPERTY);
        if (name != null) {
            name = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_NAME, (Object)name) : name));
        }
        if ((description = (String)jProps.get((Object)DESCRIPTION_PROPERTY)) != null && !description.isEmpty()) {
            if (printCaption) {
                out.println((CharSequence)Messages.WorkspacePropertiesCmd_DESCRIPTION);
            }
            out.println((CharSequence)description);
        }
        if ((obj = jProps.get((Object)OWNEDBY_PROPERTY)) != null && (ownedby = (String)obj) != null && !ownedby.isEmpty()) {
            ownedby = AliasUtil.selector((String)ownedby, (UUID)UUID.valueOf((String)ownedby_id), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.STREAM);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_OWNEDBY, (Object)ownedby) : ownedby));
        }
        if ((jIteration = (JSONArray)jProps.get((Object)ITERATION_PROPERTY)) != null) {
            if (printCaption) {
                out.println((CharSequence)Messages.SnapshotPropertiesCmd_ITERATIONS);
            }
            for (Object entry : jIteration) {
                JSONObject prop = (JSONObject)entry;
                String timeline = (String)prop.get((Object)"iteration_parent");
                String iteration = (String)prop.get((Object)"id");
                Boolean archived = (Boolean)prop.get((Object)"archived");
                String output = iteration;
                if (timeline != null && !timeline.equals("")) {
                    output = String.valueOf(timeline) + "/" + output;
                }
                if (archived.booleanValue()) {
                    output = String.valueOf(output) + " (archived)";
                }
                out.indent().println((CharSequence)output);
            }
        }
        if ((jCreatedBy = (JSONObject)jProps.get((Object)"createdBy")) != null) {
            String createdBy = AliasUtil.selector((String)((String)jCreatedBy.get((Object)NAME_PROPERTY)), (UUID)UUID.valueOf((String)((String)jCreatedBy.get((Object)"uuid"))), (String)((String)jCreatedBy.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.valueOf((String)((String)jCreatedBy.get((Object)"type"))));
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.SnapshotPropertiesCmd_CREATED_BY, (Object)createdBy) : createdBy));
        }
        if ((creationDate = (String)jProps.get((Object)"creationDate")) != null) {
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.SnapshotPropertiesCmd_CREATION_DATE, (Object)creationDate) : creationDate));
        }
    }
}

