/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.BaselinePropertyListCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ChangeSetPropertyCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ComponentPropertyListCmd;
import com.ibm.team.filesystem.cli.client.internal.property.SnapshotPropertyListCmd;
import com.ibm.team.filesystem.cli.client.internal.workspace.WorkspacePropertyListCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ShowAttributesCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_WORKSPACE = new NamedOptionDefinition("w", "workspace", 1, -1, "@");
    public static final NamedOptionDefinition OPT_SNAPSHOT = new NamedOptionDefinition("s", "snapshot", 1, "@");
    public static final NamedOptionDefinition OPT_COMPONENT = new NamedOptionDefinition("C", "component", 1, -1, "@");
    public static final NamedOptionDefinition OPT_BASELINE = new NamedOptionDefinition("b", "baseline", 1, "@");
    public static final NamedOptionDefinition OPT_SNAPSHOT_WORKSPACE = new NamedOptionDefinition(null, "snapshot-workspace", 1);
    public static final NamedOptionDefinition OPT_BASELINE_COMPONENT = new NamedOptionDefinition(null, "baseline-component", 1);
    public static final NamedOptionDefinition OPT_CHANGESET = new NamedOptionDefinition("c", "changeset", 1, "@");
    public static final NamedOptionDefinition OPT_AUTHOR = new NamedOptionDefinition(null, "author", 0);
    public static final NamedOptionDefinition OPT_COMMENT = new NamedOptionDefinition(null, "comment", 0);
    public ChangeSetPropertyCmd csPropertyCmd = new ChangeSetPropertyCmd();
    public static final NamedOptionDefinition OPT_CHANGES = new NamedOptionDefinition(null, "changes", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_WORKSPACE, Messages.ShowAttributesCmdOptions_WORKSPACE_HELP, true).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_SNAPSHOT, Messages.ShowAttributesCmdOptions_SNAPSHOT_HELP, true).addOption((INamedOptionDefinition)OPT_SNAPSHOT_WORKSPACE, Messages.SnapshotPropertiesCmdOptions_WORKSPACE_HELP, false)).addOption((INamedOptionDefinition)OPT_COMPONENT, Messages.ShowAttributesCmdOptions_COMPONENT_HELP, true).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_BASELINE, Messages.ShowAttributesCmdOptions_BASELINE_HELP, true).addOption((INamedOptionDefinition)OPT_BASELINE_COMPONENT, Messages.BaselinePropertiesCmdOptions_COMPONENT_HELP, false)).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_CHANGESET, Messages.ShowAttributesCmdOptions_CHANGESET_HELP, true))).addOption((INamedOptionDefinition)OPT_CHANGES, Messages.ShowAttributesCmdOptions_CHANGESET_CHANGES_HELP, false);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int count = 0;
        if (cli.hasOption((IOptionKey)OPT_WORKSPACE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)OPT_SNAPSHOT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)OPT_COMPONENT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)OPT_BASELINE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)OPT_CHANGESET)) {
            ++count;
        }
        if (count == 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_4_ARGUMENTS, (Object[])new String[]{OPT_WORKSPACE.getName(), OPT_SNAPSHOT.getName(), OPT_COMPONENT.getName(), OPT_BASELINE.getName()}));
        }
        if (count > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_4_ARGUMENTS, (Object[])new String[]{OPT_WORKSPACE.getName(), OPT_SNAPSHOT.getName(), OPT_COMPONENT.getName(), OPT_BASELINE.getName()}));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        IndentingPrintStream err = this.config.getWrappedErrorStream();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (cli.hasOption((IOptionKey)OPT_WORKSPACE)) {
            List workspaceSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_WORKSPACE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)workspaceSelectorList, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            WorkspacePropertyListCmd.listProperties(workspaceSelectorList, null, null, client, this.config);
        } else if (cli.hasOption((IOptionKey)OPT_SNAPSHOT)) {
            ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SNAPSHOT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            ScmCommandLineArgument wsSelector = null;
            if (cli.hasOption((IOptionKey)OPT_SNAPSHOT_WORKSPACE)) {
                wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SNAPSHOT_WORKSPACE), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            }
            SnapshotPropertyListCmd.listProperties((IScmCommandLineArgument)ssSelector, (IScmCommandLineArgument)wsSelector, null, true, client, this.config);
        } else if (cli.hasOption((IOptionKey)OPT_COMPONENT)) {
            List componentSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)componentSelectorList, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            ComponentPropertyListCmd.listProperties(componentSelectorList, null, null, client, this.config);
        } else if (cli.hasOption((IOptionKey)OPT_CHANGESET)) {
            ITeamRepository repo = null;
            if (repo == null) {
                repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
            }
            ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_CHANGESET), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            try {
                this.csPropertyCmd.listProperties((IScmCommandLineArgument)csSelector, null, true, client, this.config, repo, cli);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ShowChangeSetAttributesCmd_COULD_NOT_DISPLAY_HIERARCHY, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
        } else {
            ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_BASELINE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            ScmCommandLineArgument compSelector = null;
            if (cli.hasOption((IOptionKey)OPT_BASELINE_COMPONENT)) {
                compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_BASELINE_COMPONENT), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            }
            BaselinePropertyListCmd.listProperties((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, null, true, client, this.config);
        }
    }
}

