/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.BaselineSetCustomAttributeCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ChangeSetCustomAttributeCmdUtil;
import com.ibm.team.filesystem.cli.client.internal.property.ComponentSetCustomAttributeCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.SnapshotSetCustomAttributeCmd;
import com.ibm.team.filesystem.cli.client.internal.property.VersionableSetCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.workspace.WorkspaceSetCustomAttributeCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.osgi.util.NLS;

public class SetCustomAttributesCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_KEY = new NamedOptionDefinition(null, "key", 1);
    public static final NamedOptionDefinition OPT_VALUE = new NamedOptionDefinition(null, "value", 1);
    public static final NamedOptionDefinition OPT_FILES = new NamedOptionDefinition(null, "files", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        PositionalOptionDefinition OPT_FILES_DEFN = new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 0, -1);
        OPT_FILES_DEFN.setShowAsRequired();
        ContinuousGroup commonContinuousGroup = SetCustomAttributesCmd.getCommonOptionsForContinuousGroup(false, true, Messages.ExtendedPropertySetCmd_KeyHelp, true);
        options.addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((IPositionalOptionDefinition)OPT_FILES_DEFN, Messages.ExtendedPropertySetCmd_FilesHelp, true).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_FILE, Messages.ExtendedPropertySetCmd_FilesHelp, true).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_FILE_OLD, Messages.ExtendedPropertySetCmd_FilesHelp, true).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_STREAM, Messages.SetCustomAttributesCmdOptions_STREAM_HELP, true)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_SNAPSHOT, Messages.SetCustomAttributesCmdOptions_SNAPSHOT_HELP, true).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_SNAPSHOT_WORKSPACE, Messages.SnapshotPropertiesCmdOptions_WORKSPACE_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_BASELINE, Messages.SetCustomAttributesCmdOptions_BASELINE_HELP, true).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_BASELINE_COMPONENT, Messages.BaselinePropertiesCmdOptions_COMPONENT_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_COMPONENT, Messages.SetCustomAttributesCmdOptions_COMPONENT_HELP, true)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_CHANGESET, Messages.SetCustomAttributesCmdOptions_CHANGESET_HELP, true));
        ShowCustomAttributesCmd.OPT_FILE_OLD.hideOption();
        return options;
    }

    public static ContinuousGroup getCommonOptionsForContinuousGroup(boolean hasJSON, boolean hasKey, String keyHelp, boolean hasValue) throws ConflictingOptionException {
        ContinuousGroup group = new ContinuousGroup().addOption((INamedOptionDefinition)CommonOptions.OPT_URI, CommonOptions.OPT_URI_HELP, false).addOption(SubcommandUtil.getCredentialsGroup((boolean)false));
        if (hasJSON) {
            group.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT, false);
        }
        if (hasKey) {
            group.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_KEY, "key", 1, 1), keyHelp, true);
        }
        if (hasValue) {
            group.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_VALUE, "value", 1, 1), Messages.ExtendedPropertySetCmd_ValueHelp, true);
        }
        return group;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int count = 0;
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_STREAM)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_CHANGESET)) {
            ++count;
        }
        if (count > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_5_ARGUMENTS, (Object[])new String[]{ShowCustomAttributesCmd.OPT_WORKSPACE.getName(), ShowCustomAttributesCmd.OPT_SNAPSHOT.getName(), ShowCustomAttributesCmd.OPT_BASELINE.getName(), ShowCustomAttributesCmd.OPT_COMPONENT.getName(), ShowCustomAttributesCmd.OPT_CHANGESET.getName()}));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        String key = cli.getOption((IOptionKey)OPT_KEY);
        String value = cli.getOption((IOptionKey)OPT_VALUE);
        try {
            if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_STREAM)) {
                List wsSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)ShowCustomAttributesCmd.OPT_STREAM), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((List)wsSelectorList, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.STREAM});
                HashMap<String, String> customAttrs = new HashMap<String, String>();
                customAttrs.put(key, value);
                WorkspaceSetCustomAttributeCmd.setCustomAttributes(wsSelectorList, customAttrs, client, this.config);
            } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT)) {
                ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
                ScmCommandLineArgument wsSelector = null;
                if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT_WORKSPACE)) {
                    wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT_WORKSPACE), (IScmClientConfiguration)this.config);
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
                }
                HashMap<String, String> customAttrs = new HashMap<String, String>();
                customAttrs.put(key, value);
                SnapshotSetCustomAttributeCmd.setProperties((IScmCommandLineArgument)ssSelector, (IScmCommandLineArgument)wsSelector, customAttrs, client, this.config);
            } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE)) {
                ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
                ScmCommandLineArgument compSelector = null;
                if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE_COMPONENT)) {
                    compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE_COMPONENT), (IScmClientConfiguration)this.config);
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                }
                HashMap<String, String> customAttrs = new HashMap<String, String>();
                customAttrs.put(key, value);
                BaselineSetCustomAttributeCmd.setCustomAttributes((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, customAttrs, client, this.config);
            } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT)) {
                ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                HashMap<String, String> customAttrs = new HashMap<String, String>();
                customAttrs.put(key, value);
                ComponentSetCustomAttributeCmd.setCustomAttributes((IScmCommandLineArgument)compSelector, customAttrs, client, this.config);
            } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_CHANGESET)) {
                ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_CHANGESET), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
                HashMap<String, String> customAttrs = new HashMap<String, String>();
                customAttrs.put(key, value);
                ChangeSetCustomAttributeCmdUtil.setCustomAttributes((IScmCommandLineArgument)compSelector, customAttrs, client, this.config);
            } else {
                List strPaths = null;
                if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_FILE)) {
                    strPaths = cli.getOptions((IOptionKey)ShowCustomAttributesCmd.OPT_FILE);
                } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_FILE_OLD)) {
                    strPaths = cli.getOptions((IOptionKey)ShowCustomAttributesCmd.OPT_FILE_OLD);
                } else if (cli.hasOption((IOptionKey)OPT_FILES)) {
                    strPaths = cli.getOptions((IOptionKey)OPT_FILES);
                } else {
                    throw StatusHelper.argSyntax((String)Messages.CustomAttributesCmdOptions_FILE_MISSING);
                }
                List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, (List)strPaths);
                client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
                List resPropList = RepoUtil.getResourceProperties((List)strPaths, (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, (boolean)false);
                for (ResourcePropertiesDTO resProp : resPropList) {
                    if (resProp.getItemId() != null) continue;
                    throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)resProp.getFullPath()));
                }
                VersionableSetCustomAttributesCmd.setProperty(this.config, key, value, client, paths);
            }
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (TeamRepositoryException e) {
            String newLine = System.getProperty("line.separator");
            Log log = LogFactory.getLog((String)VersionableSetCustomAttributesCmd.class.getName());
            log.error((Object)e);
            String msg = e.getMessage();
            msg = msg == null ? String.valueOf(Messages.ExtendedPropertySetCmd_CouldNotSetProperties) + newLine + Messages.ERROR_CHECK_LOG : String.valueOf(msg) + newLine + Messages.ExtendedPropertySetCmd_CouldNotSetProperties + newLine + Messages.ERROR_CHECK_LOG;
            throw StatusHelper.failure((String)msg, null);
        }
    }
}

