/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInvalidMimeTypeDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsInvalidPropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLineDelimiterErrorInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.InvalidPropertyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.LineDelimiterErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.MimeTypeErrorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PropertyFailureDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertyChangeResultDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.osgi.util.NLS;

public class PropertySetCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final OptionKey OPT_FILES = new OptionKey("files");
    public static final OptionKey OPT_KEY = new OptionKey("key");
    public static final OptionKey OPT_VALUE = new OptionKey("value");
    public static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition("f", "force", 0);
    private IFilesystemRestClient client;

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS);
        options.addOption((INamedOptionDefinition)OPT_FORCE, Messages.PropertySetCmd_OPT_FORCE_HELP);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_KEY, "key", 1, 1), Messages.PropertySetCmd_KeyHelp);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_VALUE, "value", 1, 1), Messages.PropertySetCmd_ValueHelp);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 1, -1), Messages.PropertySetCmd_FilesHelp);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, (List)strPaths);
        String key = cli.getOption((IOptionKey)OPT_KEY);
        String value = cli.getOption((IOptionKey)OPT_VALUE);
        boolean force = cli.hasOption((IOptionKey)OPT_FORCE);
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        for (ILocation path : paths) {
            if (SubcommandUtil.exists((ILocation)path, null)) continue;
            throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)path.toOSString()));
        }
        List resPropList = RepoUtil.getResourceProperties((List)strPaths, (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config, (boolean)false);
        for (ResourcePropertiesDTO resProp : resPropList) {
            if (resProp.getItemId() != null) continue;
            throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)resProp.getFullPath()));
        }
        try {
            this.setProperty(this.config, key, value, paths, force);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.PropertySetCmd_CouldNotSetProperties, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(IScmClientConfiguration config, String key, String value, List<ILocation> paths, boolean force) throws TeamRepositoryException, FileSystemException {
        List executableFailures;
        String normalizedValue = value;
        if (key.equals("jazz.executable")) {
            normalizedValue = value.toLowerCase(Locale.ENGLISH);
            if (!"true".equals(normalizedValue) && !"false".equals(normalizedValue)) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertySetCmd_ExecutableValue, (Object)value));
            }
        } else if (key.equals("jazz.line-delimiter")) {
            if (value.equalsIgnoreCase("platform")) {
                normalizedValue = "platform";
            } else if (value.equalsIgnoreCase("cr")) {
                normalizedValue = "cr";
            } else if (value.equalsIgnoreCase("lf")) {
                normalizedValue = "lf";
            } else if (value.equalsIgnoreCase("crlf")) {
                normalizedValue = "crlf";
            } else {
                if (!value.equalsIgnoreCase("none")) throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertySetCmd_InvalidLineDelimiter, (Object)value));
                normalizedValue = "none";
            }
        } else {
            if (key.equals("jazz.encoding") || key.equals("local.encoding")) {
                throw StatusHelper.inappropriateArgument((String)Messages.PropertySetCmd_SetEncoding);
            }
            if (key.equals("jazz.link-type")) {
                if (value.equalsIgnoreCase("file")) {
                    normalizedValue = "file";
                } else {
                    if (!value.equalsIgnoreCase("directory")) throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertySetCmd_InvalidLinkType, (Object)value));
                    normalizedValue = "directory";
                }
            } else if (key.equals("jazz.read-access")) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertySetCmd_Cannot_Set_AccessContext, (Object)"jazz.read-access", (Object)config.getContext().getAppName()));
            }
        }
        RepoUtil.loginUrlArgAncOrOnPaths((IScmClientConfiguration)config, (IFilesystemRestClient)this.client, paths);
        ParmsResourcePropertyUpdates parms = new ParmsResourcePropertyUpdates();
        parms.lineDelimiterDilemmaHandler = new ParmsLineDelimiterDilemmaHandler();
        parms.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "cancel";
        if (force) {
            parms.lineDelimiterDilemmaHandler.generalLineDelimiterErrorInstruction = "continue";
            parms.lineDelimiterDilemmaHandler.lineDelimiterErrorInstructions = new ParmsLineDelimiterErrorInstructions[paths.size()];
        }
        parms.invalidPropertiesDilemmaHandler = new ParmsInvalidPropertiesDilemmaHandler();
        parms.invalidPropertiesDilemmaHandler.generalInstruction = "cancel";
        parms.invalidMimeTypeDilemmaHandler = new ParmsInvalidMimeTypeDilemmaHandler();
        parms.invalidMimeTypeDilemmaHandler.generalInstruction = "cancel";
        parms.preOpRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.resourcePropertyChanges = new ParmsResourcePropertyChange[paths.size()];
        int i = 0;
        while (i < paths.size()) {
            ILocation path = paths.get(i);
            ParmsResourcePropertyChange change = new ParmsResourcePropertyChange();
            File cfaRootFile = SubcommandUtil.findAncestorCFARoot((File)((File)path.getAdapter(File.class)));
            if (cfaRootFile == null) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertySetCmd_CouldNotFindSandboxForPath, (Object)path.toOSString()));
            }
            ResourceType resourceType = SubcommandUtil.getResourceType((ILocation)path, null);
            if (resourceType != ResourceType.FILE && (key.equals("jazz.executable") || key.equals("jazz.line-delimiter") || key.equals("jazz.mime") || key.equals("jazz.encoding") || key.equals("local.encoding"))) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertySetCmd_PropCanBeOnlySetOnFile, (Object)key, (Object)path.toOSString()));
            }
            PathLocation cfaRoot = new PathLocation(cfaRootFile.getAbsolutePath());
            IRelativeLocation filePath = path.getLocationRelativeTo((ILocation)cfaRoot);
            SubcommandUtil.registerSandboxes((String[])new String[]{cfaRoot.toOSString()}, (IFilesystemRestClient)this.client, (IScmClientConfiguration)config);
            change.sandboxPath = cfaRoot.toOSString();
            change.filePath = filePath.toString();
            if ("jazz.executable".equals(key)) {
                change.executable = Boolean.parseBoolean(normalizedValue);
            } else if (key.equals("jazz.line-delimiter")) {
                change.lineDelimiter = normalizedValue;
            } else if (key.equals("jazz.mime")) {
                change.mimeType = normalizedValue;
            } else if (key.equals("jazz.link-type")) {
                change.linkType = normalizedValue;
            } else {
                change.propertyChanges = new ParmsProperty[1];
                ParmsProperty parmsProp = new ParmsProperty();
                parmsProp.propertyName = key;
                parmsProp.propertyValue = value;
                change.propertyChanges[0] = parmsProp;
            }
            parms.resourcePropertyChanges[i] = change;
            if (force) {
                ParmsLineDelimiterErrorInstructions parmsLineDelimiterErrorInstructions = new ParmsLineDelimiterErrorInstructions();
                parmsLineDelimiterErrorInstructions.sandboxPath = cfaRoot.toOSString();
                parmsLineDelimiterErrorInstructions.filePath = filePath.toString();
                parmsLineDelimiterErrorInstructions.forceConsistentDelimiters = true;
                parms.lineDelimiterDilemmaHandler.lineDelimiterErrorInstructions[i] = parmsLineDelimiterErrorInstructions;
            }
            ++i;
        }
        ResourcePropertyChangeResultDTO result = this.client.postResourceProperties(parms, null);
        ArrayList<LineDelimiterErrorDTO> lineDelimiterFailures = new ArrayList<LineDelimiterErrorDTO>();
        List lineDelimiterFailures2 = result.getLineDelimiterFailures();
        for (LineDelimiterErrorDTO ldError : lineDelimiterFailures2) {
            boolean error = true;
            if (force && ldError.getLineDelimiter().equals(normalizedValue)) {
                error = false;
            }
            if (!error) continue;
            String path = StringUtil.createPathString((List)ldError.getFileName().getSegments());
            config.getWrappedErrorStream().println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_PathContainsInconsistentDelimiters, (Object[])new String[]{path, key, value}));
            lineDelimiterFailures.add(ldError);
        }
        IndentingPrintStream printStream = config.getWrappedErrorStream();
        List mimeTypeFailures = result.getMimeTypeFailures();
        if (mimeTypeFailures.size() > 0) {
            printStream.println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_InvalidMimeTypeForFiles, (Object)key));
            for (MimeTypeErrorDTO mimeTypeFailure : mimeTypeFailures) {
                RelativeLocation path = new RelativeLocation(mimeTypeFailure.getFileName().getSegments());
                printStream.indent().println((CharSequence)path.toString());
            }
        }
        List propertyFailures = result.getPropertyFailures();
        String reason = null;
        if (propertyFailures.size() > 0) {
            printStream.println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_InvalidPropertyForFiles, (Object)key));
            for (PropertyFailureDTO propertyFailure : propertyFailures) {
                RelativeLocation path = new RelativeLocation(propertyFailure.getFileName().getSegments());
                if (propertyFailure.getInvalidProperties() != null) {
                    InvalidPropertyDTO invalidProp = (InvalidPropertyDTO)propertyFailure.getInvalidProperties().get(0);
                    reason = invalidProp.getReason();
                }
                printStream.indent().println((CharSequence)path.toString());
            }
        }
        if ((executableFailures = result.getExecutableFailures()).size() > 0) {
            printStream.println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_ExecutableErrorForFiles, (Object)key));
            for (ShareableDTO executableFailure : executableFailures) {
                RelativeLocation path = new RelativeLocation(executableFailure.getRelativePath().getSegments());
                printStream.indent().println((CharSequence)path.toString());
            }
        }
        if (lineDelimiterFailures.size() > 0) {
            throw StatusHelper.malformedInput((String)NLS.bind((String)Messages.PropertySetCmd_NResourcesHaveInconsistentDelimiters, (Object)Integer.toString(lineDelimiterFailures.size())));
        }
        if (propertyFailures.size() > 0) {
            throw StatusHelper.invalidProperty((String)(reason != null && reason.length() > 0 ? reason : NLS.bind((String)Messages.PropertySetCmd_InvalidProperty, (Object)key)));
        }
        if (mimeTypeFailures.size() > 0) {
            throw StatusHelper.invalidMimeType((String)NLS.bind((String)Messages.PropertySetCmd_InvalidMimeType, (Object)key));
        }
        if (executableFailures.size() > 0) {
            throw StatusHelper.invalidMimeType((String)NLS.bind((String)Messages.PropertySetCmd_ExecutableError, (Object)key));
        }
        config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_KeySuccessfullySetToValue, (Object)key, (Object)value));
    }
}

