/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourcePropertyUpdates;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class PropertyRemoveCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final OptionKey OPT_FILES = new OptionKey("files");
    public static final OptionKey OPT_KEY = new OptionKey("key");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_KEY, "key", 1, 1), Messages.PropertyGetCmd_KeyHelp);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 1, -1), Messages.PropertyRemoveCmd_FilesHelp);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, (List)strPaths);
        String key = cli.getOption((IOptionKey)OPT_KEY);
        try {
            this.removeProperty(this.config, key, paths);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.PropertyRemoveCmd_CouldNotRemoveProperties, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
    }

    public void removeProperty(IScmClientConfiguration config, String key, List<ILocation> paths) throws TeamRepositoryException, FileSystemException {
        IRelativeLocation filePath;
        PathLocation cfaRoot;
        File cfaRootFile;
        if (key.equals("jazz.executable") || key.equals("jazz.line-delimiter") || key.equals("jazz.mime") || key.equals("jazz.encoding")) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertyRemoveCmd_CannotRemoveJazzInternalProperty, (Object)key));
        }
        if (key.equals("local.encoding")) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.PropertyRemoveCmd_CannotRemoveLocalEncodingProperty, (Object)key));
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        RepoUtil.loginUrlArgAncOrOnPaths((IScmClientConfiguration)config, (IFilesystemRestClient)client, paths);
        List<ILocation> validPaths = this.validatePropertyForFiles(client, key, paths);
        if (validPaths.size() > 0) {
            ParmsResourcePropertyUpdates parms = new ParmsResourcePropertyUpdates();
            parms.resourcePropertyChanges = new ParmsResourcePropertyChange[paths.size()];
            int i = 0;
            while (i < validPaths.size()) {
                ILocation path = validPaths.get(i);
                cfaRootFile = SubcommandUtil.findAncestorCFARoot((File)((File)path.getAdapter(File.class)));
                cfaRoot = new PathLocation(cfaRootFile.getAbsolutePath());
                filePath = path.getLocationRelativeTo((ILocation)cfaRoot);
                ParmsResourcePropertyChange change = new ParmsResourcePropertyChange();
                change.sandboxPath = cfaRoot.toOSString();
                change.filePath = filePath.toString();
                change.propertyRemovals = new String[]{key};
                parms.resourcePropertyChanges[i] = change;
                ++i;
            }
            client.postResourceProperties(parms, null);
        }
        paths.removeAll(validPaths);
        if (paths.size() > 0) {
            IndentingPrintStream printStream = config.getWrappedErrorStream();
            printStream.println((CharSequence)NLS.bind((String)Messages.PropertyRemoveCmd_UnabletoRemovePropertyForFiles, (Object)key));
            for (ILocation path : paths) {
                cfaRootFile = SubcommandUtil.findAncestorCFARoot((File)((File)path.getAdapter(File.class)));
                cfaRoot = new PathLocation(cfaRootFile.getAbsolutePath());
                filePath = path.getLocationRelativeTo((ILocation)cfaRoot);
                printStream.indent().println((CharSequence)filePath.toString());
            }
        }
        if (validPaths.size() <= 0) {
            throw StatusHelper.propertiesUnavailable((String)Messages.PropertyRemoveCmd_CouldNotRemoveProperties);
        }
        config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.PropertyRemoveCmd_KeySuccessfullyRemoved, (Object)key));
    }

    private List<ILocation> validatePropertyForFiles(IFilesystemRestClient client, String key, List<ILocation> paths) throws TeamRepositoryException {
        HashMap<String, ILocation> validPropertyPaths = new HashMap<String, ILocation>();
        for (ILocation path : paths) {
            if (!SubcommandUtil.exists((ILocation)path, null)) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)path.toOSString()));
            }
            File cfaRootFile = SubcommandUtil.findAncestorCFARoot((File)((File)path.getAdapter(File.class)));
            if (cfaRootFile == null) {
                throw StatusHelper.disallowed((String)NLS.bind((String)Messages.PropertySetCmd_CouldNotFindSandboxForPath, (Object)path.toOSString()));
            }
            validPropertyPaths.put(path.toOSString(), path);
        }
        ParmsResourceProperties parms = new ParmsResourceProperties(false, validPropertyPaths.keySet().toArray(new String[validPropertyPaths.size()]));
        ResourcesDTO resourcesDTO = client.postFetchResourceProperties(parms, null);
        List resourceProperties = resourcesDTO.getResourceProperties();
        for (ResourcePropertiesDTO dto : resourceProperties) {
            if (dto.getShare() != null && dto.getUserProperties().containsKey(key)) continue;
            validPropertyPaths.remove(dto.getFullPath());
        }
        return new ArrayList<ILocation>(validPropertyPaths.values());
    }
}

