/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.common.internal.rest.client.resource.FilePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.PermissionsContextDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.SymlinkPropertiesDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class PropertyListCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final int PROPERTY_UNAVAILABLE = 1;
    private static final int FILE_IS_NOT_SHARED = 2;
    private static final int FILE_DOES_NOT_EXIST = 3;
    public static final String PROPERTY_EXECUTABLE = "jazz.executable";
    public static final String PROPERTY_MIME = "jazz.mime";
    public static final String PROPERTY_LINE_DELIMITER = "jazz.line-delimiter";
    public static final String PROPERTY_LINK_TYPE = "jazz.link-type";
    public static final String PROPERTY_ENCODING = "jazz.encoding";
    public static final String PROPERTY_LOCAL_ENCODING = "local.encoding";
    public static final String PROPERTY_READ_ACCESS = "jazz.read-access";
    public static final OptionKey OPT_FILES = new OptionKey("files");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_FILES, "files", 1, -1), Messages.PropertyListCmd_ListPropertiesHelp);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        List strPaths = cli.getOptions((IOptionKey)OPT_FILES);
        List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, (List)strPaths);
        MapEntryComparator mapEntryComparator = new MapEntryComparator();
        ArrayList<Map.Entry<String, Map<String, String>>> properties = new ArrayList<Map.Entry<String, Map<String, String>>>();
        ArrayList<IStatus> stats = new ArrayList<IStatus>();
        String key = this.getKey(cli);
        try {
            Map<String, Map<String, String>> map = this.getProperties(this.config, key, paths, stats);
            properties.addAll(map.entrySet());
            Collections.sort(properties, mapEntryComparator);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.PropertyListCmd_CouldNotFetchProperty, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        JSONArray props = JSONPrintUtil.jsonizeProperties(properties, (Comparator)mapEntryComparator);
        JSONObject jResult = new JSONObject();
        jResult.put((Object)"results", (Object)props);
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)jResult.toString());
        } else {
            this.printProps(props, out);
        }
        if (stats.size() > 0) {
            Collections.sort(stats, new StatusComparator());
            for (IStatus status : stats) {
                this.config.getWrappedErrorStream().println((CharSequence)status.getMessage());
            }
            IStatus mostSevere = (IStatus)stats.get(stats.size() - 1);
            switch (mostSevere.getCode()) {
                case 1: {
                    throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.PropertyListCmd_CouldNotGetProperty, (Object)key));
                }
                case 2: {
                    throw StatusHelper.inappropriateArgument((String)Messages.PropertyListCmd_FileIsNotShared);
                }
                case 3: {
                    throw StatusHelper.disallowed((String)Messages.PropertyListCmd_FileDoesNotExist);
                }
            }
        }
    }

    public String getKey(ICommandLine cli) {
        return null;
    }

    public Map<String, Map<String, String>> getProperties(IScmClientConfiguration config, String key, List<ILocation> paths, List<IStatus> stats) throws TeamRepositoryException, FileSystemException {
        Map<String, ResourcePropertiesDTO> resourceProperties = this.getResourceProperties(config, paths, stats);
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>(resourceProperties.size());
        for (String string : resourceProperties.keySet()) {
            HashMap map = new HashMap();
            properties.put(string, map);
        }
        for (Map.Entry entry : resourceProperties.entrySet()) {
            String path = (String)entry.getKey();
            ResourcePropertiesDTO resourcePropertiesDTO = (ResourcePropertiesDTO)entry.getValue();
            Map map = (Map)properties.get(path);
            String readAccess = PropertyListCmd.getReadAccessContext(resourcePropertiesDTO, config);
            if (readAccess.equals(Messages.PropertyListCmd_Inaccessible)) {
                this.put(map, PROPERTY_READ_ACCESS, readAccess, false, path, stats);
                continue;
            }
            Map userProperties = resourcePropertiesDTO.getUserProperties();
            if (key == null) {
                if (resourcePropertiesDTO.getVersionableItemType().equals("file")) {
                    this.put(map, PROPERTY_ENCODING, PropertyListCmd.getRemoteEncoding(resourcePropertiesDTO), false, path, stats);
                    this.put(map, PROPERTY_LOCAL_ENCODING, PropertyListCmd.getLocalEncoding(resourcePropertiesDTO), false, path, stats);
                    this.put(map, PROPERTY_EXECUTABLE, PropertyListCmd.getExecutable(resourcePropertiesDTO), false, path, stats);
                    this.put(map, PROPERTY_LINE_DELIMITER, PropertyListCmd.getLineDelimiter(resourcePropertiesDTO), false, path, stats);
                    this.put(map, PROPERTY_MIME, PropertyListCmd.getMime(resourcePropertiesDTO), false, path, stats);
                } else if (resourcePropertiesDTO.getVersionableItemType().equals("symbolic_link")) {
                    this.put(map, PROPERTY_LINK_TYPE, this.getLinkType(resourcePropertiesDTO), false, path, stats);
                }
                this.put(map, PROPERTY_READ_ACCESS, readAccess, false, path, stats);
                if (userProperties == null) continue;
                for (Map.Entry userProperty : userProperties.entrySet()) {
                    this.put(map, (String)userProperty.getKey(), (String)userProperty.getValue(), true, path, stats);
                }
                continue;
            }
            if (PROPERTY_ENCODING.equals(key)) {
                boolean warn = !resourcePropertiesDTO.getVersionableItemType().equals("file");
                this.put(map, PROPERTY_ENCODING, PropertyListCmd.getRemoteEncoding(resourcePropertiesDTO), warn, path, stats);
                continue;
            }
            if (PROPERTY_LOCAL_ENCODING.equals(key)) {
                boolean warn = !resourcePropertiesDTO.getVersionableItemType().equals("file");
                this.put(map, PROPERTY_LOCAL_ENCODING, PropertyListCmd.getLocalEncoding(resourcePropertiesDTO), warn, path, stats);
                continue;
            }
            if (PROPERTY_EXECUTABLE.equals(key)) {
                this.put(map, PROPERTY_EXECUTABLE, PropertyListCmd.getExecutable(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            if (PROPERTY_LINE_DELIMITER.equals(key)) {
                this.put(map, key, PropertyListCmd.getLineDelimiter(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            if (PROPERTY_MIME.equals(key)) {
                this.put(map, key, PropertyListCmd.getMime(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            if (PROPERTY_LINK_TYPE.equals(key)) {
                this.put(map, key, this.getLinkType(resourcePropertiesDTO), true, path, stats);
                continue;
            }
            if (PROPERTY_READ_ACCESS.equals(key)) {
                this.put(map, PROPERTY_READ_ACCESS, PropertyListCmd.getReadAccessContext(resourcePropertiesDTO, config), false, path, stats);
                continue;
            }
            this.put(map, key, PropertyListCmd.getUserProperty(key, userProperties), true, path, stats);
        }
        return properties;
    }

    private void put(Map<String, String> map, String key, String value, boolean logWarning, String path, List<IStatus> stats) {
        if (value == null) {
            if (logWarning) {
                stats.add((IStatus)new Status(2, "com.ibm.team.filesystem.client", 1, NLS.bind((String)Messages.PropertyListCmd_CouldNotGetPropertyForPath, (Object)key, (Object)path), null));
            }
        } else {
            map.put(key, value);
        }
    }

    private String getLinkType(ResourcePropertiesDTO resourceProperties) {
        SymlinkPropertiesDTO symlinkProperties = resourceProperties.getSymlinkProperties();
        if (symlinkProperties != null) {
            return symlinkProperties.getType();
        }
        return null;
    }

    private static String getMime(ResourcePropertiesDTO resourceProperties) {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return fileProperties.getContentType();
        }
        return null;
    }

    private static String getLineDelimiter(ResourcePropertiesDTO resourceProperties) {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return fileProperties.getLineDelimiter();
        }
        return null;
    }

    private static String getExecutable(ResourcePropertiesDTO resourceProperties) {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return Boolean.toString(fileProperties.isExecutable());
        }
        return null;
    }

    private static String getLocalEncoding(ResourcePropertiesDTO resourceProperties) throws FileSystemException {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return fileProperties.getEncoding();
        }
        return null;
    }

    private static String getRemoteEncoding(ResourcePropertiesDTO resourceProperties) throws FileSystemException {
        FilePropertiesDTO fileProperties = resourceProperties.getFileProperties();
        if (fileProperties != null) {
            return fileProperties.getOriginalEncoding();
        }
        return null;
    }

    private static String getReadAccessContext(ResourcePropertiesDTO resourceProperties, IScmClientConfiguration config) throws FileSystemException {
        String accessContext = Messages.FilePropertiesCmd_COMPONENT_SCOPED;
        PermissionsContextDTO context = resourceProperties.getPermissionsContext();
        if (context != null) {
            if (!context.isAccessible()) {
                accessContext = Messages.PropertyListCmd_Inaccessible;
            } else if (context.getReadContext() != null) {
                ITeamRepository repo = RepoUtil.getSharedRepository((String)config.getRepositoryURI(resourceProperties.getShare().getRepositoryId(), null), (boolean)false);
                UUID itemId = context.getReadContext().getItemId();
                if (context.getReadContext().getItemType().equals(IContributor.ITEM_TYPE)) {
                    IContributor contrib = (IContributor)RepoUtil.getItem((IItemType)IContributor.ITEM_TYPE, (UUID)itemId, (ITeamRepository)repo, (IScmClientConfiguration)config);
                    accessContext = NLS.bind((String)Messages.FilePropertiesCmd_CONTRIBUTOR, (Object)contrib.getName());
                } else if (context.getReadContext().getItemType().equals(ITeamArea.ITEM_TYPE)) {
                    ITeamArea teamArea = (ITeamArea)RepoUtil.getItem((IItemType)ITeamArea.ITEM_TYPE, (UUID)itemId, (ITeamRepository)repo, (IScmClientConfiguration)config);
                    accessContext = NLS.bind((String)Messages.FilePropertiesCmd_TEAM_AREA, (Object)teamArea.getName());
                } else if (context.getReadContext().getItemType().equals(IProjectArea.ITEM_TYPE)) {
                    IProjectArea projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)itemId, (ITeamRepository)repo, (IScmClientConfiguration)config);
                    accessContext = NLS.bind((String)Messages.FilePropertiesCmd_PROJECT_AREA, (Object)projArea.getName());
                } else if (context.getReadContext().getItemType().equals(IAccessGroup.ITEM_TYPE)) {
                    IAccessGroup accessGroup = RepoUtil.getAccessGroup((UUID)itemId, (ITeamRepository)repo, (IScmClientConfiguration)config);
                    accessContext = NLS.bind((String)Messages.FilePropertiesCmd_ACCESS_GROUP, (Object)accessGroup.getName());
                } else {
                    accessContext = Messages.Common_UNKNOWN;
                }
            }
        }
        return accessContext;
    }

    private static String getUserProperty(String key, Map<String, String> userProperties) {
        String value = null;
        if (userProperties != null) {
            for (Map.Entry<String, String> userProperty : userProperties.entrySet()) {
                if (!key.equals(userProperty.getKey())) continue;
                value = userProperty.getValue();
                break;
            }
        }
        return value;
    }

    private Map<String, ResourcePropertiesDTO> getResourceProperties(IScmClientConfiguration config, List<ILocation> paths, List<IStatus> stats) throws TeamRepositoryException, FileSystemException {
        ArrayList<ILocation> validPaths = new ArrayList<ILocation>();
        int i = 0;
        while (i < paths.size()) {
            ILocation path = paths.get(i);
            String osString = path.toOSString();
            if (!SubcommandUtil.exists((ILocation)path, null)) {
                stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 3, NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)osString), null));
            } else {
                File cfaRootFile = SubcommandUtil.findAncestorCFARoot((String)path.toOSString());
                if (cfaRootFile == null) {
                    stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 2, NLS.bind((String)Messages.PropertyListCmd_PathIsNotShared, (Object)osString), null));
                } else {
                    validPaths.add(path);
                }
            }
            ++i;
        }
        ArrayList<String> sboxes = new ArrayList<String>();
        ArrayList<String> validPathStrings = new ArrayList<String>();
        HashMap sandbox2FileMap = new HashMap(validPaths.size());
        for (ILocation path : validPaths) {
            PathLocation cfaRoot = new PathLocation((IPath)new Path(SubcommandUtil.findAncestorCFARoot((String)path.toOSString()).getAbsolutePath()));
            if (!sandbox2FileMap.containsKey(cfaRoot)) {
                ArrayList<ILocation> pathList = new ArrayList<ILocation>();
                pathList.add(path);
                sandbox2FileMap.put(cfaRoot, pathList);
                sboxes.add(cfaRoot.toOSString());
            } else {
                ((List)sandbox2FileMap.get(cfaRoot)).add(path);
            }
            validPathStrings.add(path.toOSString());
        }
        IFilesystemRestClient client = SubcommandUtil.startDaemon((ISandbox[])config.getSandboxes(), (IScmClientConfiguration)config);
        List repos = RepoUtil.loginUrlArgAncOrOnPaths((IScmClientConfiguration)config, (IFilesystemRestClient)client, validPaths);
        String[] arr = sboxes.toArray(new String[sboxes.size()]);
        SubcommandUtil.registerSandboxes((String[])arr, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        if (SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)config)) {
            for (ILocation sandbox : sandbox2FileMap.keySet()) {
                SubcommandUtil.refreshPaths((ILocation)sandbox, (List)((List)sandbox2FileMap.get(sandbox)), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            }
        }
        ParmsResourceProperties parms = new ParmsResourceProperties(true, validPathStrings.toArray(new String[validPathStrings.size()]));
        ResourcesDTO resourcesDTO = client.postFetchResourceProperties(parms, null);
        HashMap<String, ResourcePropertiesDTO> resourceProperties = new HashMap<String, ResourcePropertiesDTO>(validPaths.size());
        List resourceProperties2 = resourcesDTO.getResourceProperties();
        for (ResourcePropertiesDTO dto : resourceProperties2) {
            if (dto.getShare() == null) {
                stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 2, NLS.bind((String)Messages.PropertyListCmd_PathIsNotShared, (Object)dto.getFullPath()), null));
                continue;
            }
            if (dto.getItemId() == null) {
                stats.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", 3, NLS.bind((String)Messages.PropertyListCmd_PathDoesNotExist, (Object)dto.getFullPath()), null));
                continue;
            }
            String fullPath = dto.getFullPath();
            resourceProperties.put(fullPath, dto);
        }
        return resourceProperties;
    }

    private void printProps(JSONArray fileProps, IndentingPrintStream out) {
        if (fileProps == null) {
            return;
        }
        for (Object obj : fileProps) {
            JSONObject fileProp = (JSONObject)obj;
            out.println((CharSequence)((String)fileProp.get((Object)"name")));
            JSONArray props = (JSONArray)fileProp.get((Object)"properties");
            if (props == null) continue;
            int maxWidth = 0;
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                String property = (String)prop.get((Object)"property");
                maxWidth = Math.max(maxWidth, property.length());
            }
            IndentingPrintStream indent = out.indent();
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((String)prop.get((Object)"property")), (int)maxWidth), (Object)prop.get((Object)"value")));
            }
        }
    }

    private final class MapEntryComparator
    implements Comparator<Map.Entry<String, ?>> {
        private MapEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, ?> o1, Map.Entry<String, ?> o2) {
            return o1.getKey().compareToIgnoreCase(o2.getKey());
        }
    }

    private final class StatusComparator
    implements Comparator<IStatus> {
        private StatusComparator() {
        }

        @Override
        public int compare(IStatus o1, IStatus o2) {
            int compare = o1.getSeverity() - o2.getSeverity();
            if (compare == 0) {
                compare = o1.getCode() - o2.getCode();
            }
            if (compare == 0) {
                compare = o1.getMessage().compareTo(o2.getMessage());
            }
            return compare;
        }
    }
}

