/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.BaselineShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ChangeSetCustomAttributeCmdUtil;
import com.ibm.team.filesystem.cli.client.internal.property.ComponentShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.SetCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.SnapshotShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.VersionableShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.workspace.WorkspaceShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class GetCustomAttributesCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        PositionalOptionDefinition OPT_FILES_DEFN = new PositionalOptionDefinition((IOptionKey)SetCustomAttributesCmd.OPT_FILES, "files", 0, -1);
        OPT_FILES_DEFN.setShowAsRequired();
        ContinuousGroup commonContinuousGroup = SetCustomAttributesCmd.getCommonOptionsForContinuousGroup(true, true, Messages.ExtendedPropertyGetCmd_KeyHelp, false);
        options.addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((IPositionalOptionDefinition)OPT_FILES_DEFN, Messages.ExtendedPropertyGetCmd_FilesHelp, true).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_FILE, Messages.ExtendedPropertyGetCmd_FilesHelp, true).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_FILE_OLD, Messages.ExtendedPropertyGetCmd_FilesHelp, true).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_STREAM, Messages.GetCustomAttributesCmdOptions_STREAM_HELP, true)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_SNAPSHOT, Messages.GetCustomAttributesCmdOptions_SNAPSHOT_HELP, true).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_SNAPSHOT_WORKSPACE, Messages.SnapshotPropertiesCmdOptions_WORKSPACE_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_BASELINE, Messages.GetCustomAttributesCmdOptions_BASELINE_HELP, true).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_BASELINE_COMPONENT, Messages.BaselinePropertiesCmdOptions_COMPONENT_HELP, false)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_COMPONENT, Messages.GetCustomAttributesCmdOptions_COMPONENT_HELP, true)).addOption((IOptionGroup)new ContinuousGroup(commonContinuousGroup).addOption((INamedOptionDefinition)ShowCustomAttributesCmd.OPT_CHANGESET, Messages.GetCustomAttributesCmdOptions_CHANGESET_HELP, true));
        ShowCustomAttributesCmd.OPT_FILE_OLD.hideOption();
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int count = 0;
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_STREAM)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_CHANGESET)) {
            ++count;
        }
        if (count > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_5_ARGUMENTS, (Object[])new String[]{ShowCustomAttributesCmd.OPT_STREAM.getName(), ShowCustomAttributesCmd.OPT_SNAPSHOT.getName(), ShowCustomAttributesCmd.OPT_BASELINE.getName(), ShowCustomAttributesCmd.OPT_COMPONENT.getName(), ShowCustomAttributesCmd.OPT_CHANGESET.getName()}));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        String key = cli.getOption((IOptionKey)SetCustomAttributesCmd.OPT_KEY);
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_STREAM)) {
            List workspaceSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)ShowCustomAttributesCmd.OPT_STREAM), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)workspaceSelectorList, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.STREAM});
            WorkspaceShowCustomAttributesCmd.showCustomAttributes(workspaceSelectorList, null, key, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT)) {
            ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            ScmCommandLineArgument wsSelector = null;
            if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT_WORKSPACE)) {
                wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_SNAPSHOT_WORKSPACE), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            }
            SnapshotShowCustomAttributesCmd.getCustomAttributes((IScmCommandLineArgument)ssSelector, (IScmCommandLineArgument)wsSelector, key, true, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE)) {
            ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            ScmCommandLineArgument compSelector = null;
            if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE_COMPONENT)) {
                compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE_COMPONENT), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            }
            BaselineShowCustomAttributesCmd.getCustomAttributes((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, key, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT)) {
            ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            ComponentShowCustomAttributesCmd.getCustomAttributes((IScmCommandLineArgument)compSelector, key, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_CHANGESET)) {
            ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_CHANGESET), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            ChangeSetCustomAttributeCmdUtil.getCustomAttributes((IScmCommandLineArgument)csSelector, key, client, this.config);
        } else {
            this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
            List strPaths = null;
            if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_FILE)) {
                strPaths = cli.getOptions((IOptionKey)ShowCustomAttributesCmd.OPT_FILE);
            } else if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_FILE_OLD)) {
                strPaths = cli.getOptions((IOptionKey)ShowCustomAttributesCmd.OPT_FILE_OLD);
            } else if (cli.hasOption((IOptionKey)SetCustomAttributesCmd.OPT_FILES)) {
                strPaths = cli.getOptions((IOptionKey)SetCustomAttributesCmd.OPT_FILES);
            } else {
                throw StatusHelper.argSyntax((String)Messages.CustomAttributesCmdOptions_FILE_MISSING);
            }
            List paths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, (List)strPaths);
            VersionableShowCustomAttributesCmd.showCustomAttributes(paths, key, this.config);
        }
    }
}

