/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.BaselinePropertyListCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ChangeSetPropertyCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ComponentPropertyListCmd;
import com.ibm.team.filesystem.cli.client.internal.property.ShowAttributesCmd;
import com.ibm.team.filesystem.cli.client.internal.property.SnapshotPropertyListCmd;
import com.ibm.team.filesystem.cli.client.internal.workspace.WorkspacePropertyListCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class GetAttributesCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_NAME = new NamedOptionDefinition(null, "name", 0);
    public static final NamedOptionDefinition OPT_DESCRIPTION = new NamedOptionDefinition(null, "description", 0);
    public static final NamedOptionDefinition OPT_OWNEDBY = new NamedOptionDefinition(null, "ownedby", 0);
    public static final NamedOptionDefinition OPT_VISIBILITY = new NamedOptionDefinition(null, "visibility", 0);
    public static final NamedOptionDefinition OPT_AUTO_FILE_LOCK_PATTTERN = new NamedOptionDefinition(null, "auto-lock-files", 0);
    public static final NamedOptionDefinition OPT_ITERATION = new NamedOptionDefinition(null, "iteration", 0);
    public static final NamedOptionDefinition OPT_RELEASE = new NamedOptionDefinition(null, "release", 0);
    public static final NamedOptionDefinition OPT_CREATED_BY = new NamedOptionDefinition(null, "createdby", 0);
    public static final NamedOptionDefinition OPT_CREATION_DATE = new NamedOptionDefinition(null, "creationdate", 0);
    public static final NamedOptionDefinition OPT_COMMENT = new NamedOptionDefinition(null, "comment", 0);
    public static final NamedOptionDefinition OPT_AUTHOR = new NamedOptionDefinition(null, "author", 0);
    public static final NamedOptionDefinition OPT_MODIFIEDDATE = new NamedOptionDefinition(null, "modifieddate", 0);
    public ChangeSetPropertyCmd csPropertyCmd = new ChangeSetPropertyCmd();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_WORKSPACE, Messages.GetAttributesCmdOptions_WORKSPACE_HELP, true).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_NAME, Messages.SetAttributesCmdOptions_NAME_HELP, false).addOption((INamedOptionDefinition)OPT_DESCRIPTION, Messages.SetAttributesCmdOptions_DESCRIPTION_HELP, false).addOption((INamedOptionDefinition)OPT_OWNEDBY, Messages.GetAttributesCmdOptions_OWNEDBY_HELP, false).addOption((INamedOptionDefinition)OPT_VISIBILITY, Messages.GetAttributesCmdOptions_VISIBILITY_HELP, false).addOption((INamedOptionDefinition)OPT_AUTO_FILE_LOCK_PATTTERN, Messages.GetAttributesCmdOptions_AUTO_FILE_LOCK_PATTERN_HELP, false))).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_SNAPSHOT, Messages.GetAttributesCmdOptions_SNAPSHOT_HELP, true).addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_SNAPSHOT_WORKSPACE, Messages.SnapshotPropertiesCmdOptions_WORKSPACE_HELP, false).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_NAME, Messages.SetAttributesCmdOptions_NAME_HELP, false).addOption((INamedOptionDefinition)OPT_DESCRIPTION, Messages.SetAttributesCmdOptions_DESCRIPTION_HELP, false).addOption((INamedOptionDefinition)OPT_ITERATION, Messages.GetAttributesCmdOptions_ITERATION_HELP, false).addOption((INamedOptionDefinition)OPT_RELEASE, Messages.GetAttributesCmdOptions_RELEASE_HELP, false).addOption((INamedOptionDefinition)OPT_OWNEDBY, Messages.SetAttributesCmdOptions_OWNEDBY_HELP, false).addOption((INamedOptionDefinition)OPT_CREATED_BY, Messages.GetAttributesCmdOptions_CREATED_BY_HELP, false).addOption((INamedOptionDefinition)OPT_CREATION_DATE, Messages.GetAttributesCmdOptions_CREATION_DATE_HELP, false))).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_COMPONENT, Messages.GetAttributesCmdOptions_COMPONENT_HELP, true).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_NAME, Messages.SetAttributesCmdOptions_NAME_HELP, false).addOption((INamedOptionDefinition)OPT_OWNEDBY, Messages.SetAttributesCmdOptions_OWNEDBY_HELP, false).addOption((INamedOptionDefinition)OPT_VISIBILITY, Messages.GetAttributesCmdOptions_VISIBILITY_HELP, false))).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_BASELINE, Messages.GetAttributesCmdOptions_BASELINE_HELP, true).addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_BASELINE_COMPONENT, Messages.BaselinePropertiesCmdOptions_COMPONENT_HELP, false).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_NAME, Messages.SetAttributesCmdOptions_NAME_HELP, false).addOption((INamedOptionDefinition)OPT_DESCRIPTION, Messages.SetAttributesCmdOptions_DESCRIPTION_HELP, false))).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_CHANGESET, Messages.ShowAttributesCmdOptions_CHANGESET_HELP, true).addOption(new SimpleGroup(true).addOption((INamedOptionDefinition)OPT_AUTHOR, Messages.SetAttributesCmdOptions_AUTHOR_HELP, false).addOption((INamedOptionDefinition)OPT_COMMENT, Messages.SetAttributesCmdOptions_COMMENT_HELP, false).addOption((INamedOptionDefinition)OPT_MODIFIEDDATE, Messages.SetAttributesCmdOptions_MODIFIEDDATE_HELP, false)));
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int count = 0;
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_WORKSPACE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_SNAPSHOT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_COMPONENT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_BASELINE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_CHANGESET)) {
            ++count;
        }
        if (count == 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_4_ARGUMENTS, (Object[])new String[]{ShowAttributesCmd.OPT_WORKSPACE.getName(), ShowAttributesCmd.OPT_SNAPSHOT.getName(), ShowAttributesCmd.OPT_COMPONENT.getName(), ShowAttributesCmd.OPT_BASELINE.getName()}));
        }
        if (count > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_4_ARGUMENTS, (Object[])new String[]{ShowAttributesCmd.OPT_WORKSPACE.getName(), ShowAttributesCmd.OPT_SNAPSHOT.getName(), ShowAttributesCmd.OPT_COMPONENT.getName(), ShowAttributesCmd.OPT_BASELINE.getName()}));
        }
        if (!cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_WORKSPACE) && cli.hasOption((IOptionKey)OPT_AUTO_FILE_LOCK_PATTTERN)) {
            throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.Stream_ONLY_OPTION, (Object)OPT_AUTO_FILE_LOCK_PATTTERN.getName()));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        IndentingPrintStream err = this.config.getWrappedErrorStream();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_WORKSPACE)) {
            if (!(cli.hasOption((IOptionKey)OPT_NAME) || cli.hasOption((IOptionKey)OPT_DESCRIPTION) || cli.hasOption((IOptionKey)OPT_OWNEDBY) || cli.hasOption((IOptionKey)OPT_VISIBILITY) || cli.hasOption((IOptionKey)OPT_AUTO_FILE_LOCK_PATTTERN))) {
                throw StatusHelper.argSyntax((String)(String.valueOf(NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_4_ARGUMENTS, (Object[])new String[]{OPT_NAME.getName(), OPT_DESCRIPTION.getName(), OPT_OWNEDBY.getName(), OPT_VISIBILITY.getName()})) + " " + NLS.bind((String)Messages.Stream_MUST_SPECIFY_ARGUMENT, (Object)OPT_AUTO_FILE_LOCK_PATTTERN.getName())));
            }
            List workspaceSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)ShowAttributesCmd.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)workspaceSelectorList, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (cli.hasOption((IOptionKey)OPT_NAME)) {
                propertyNames.add("name");
            }
            if (cli.hasOption((IOptionKey)OPT_DESCRIPTION)) {
                propertyNames.add("description");
            }
            if (cli.hasOption((IOptionKey)OPT_OWNEDBY)) {
                propertyNames.add("ownedby");
            }
            if (cli.hasOption((IOptionKey)OPT_VISIBILITY)) {
                propertyNames.add("visibility");
            }
            if (cli.hasOption((IOptionKey)OPT_AUTO_FILE_LOCK_PATTTERN)) {
                propertyNames.add("auto-lock-files");
            }
            WorkspacePropertyListCmd.listProperties(workspaceSelectorList, null, propertyNames, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_SNAPSHOT)) {
            if (!(cli.hasOption((IOptionKey)OPT_NAME) || cli.hasOption((IOptionKey)OPT_DESCRIPTION) || cli.hasOption((IOptionKey)OPT_OWNEDBY) || cli.hasOption((IOptionKey)OPT_ITERATION) || cli.hasOption((IOptionKey)OPT_RELEASE) || cli.hasOption((IOptionKey)OPT_CREATED_BY) || cli.hasOption((IOptionKey)OPT_CREATION_DATE))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_7_ARGUMENTS, (Object[])new String[]{OPT_NAME.getName(), OPT_DESCRIPTION.getName(), OPT_OWNEDBY.getName(), OPT_ITERATION.getName(), OPT_RELEASE.getName(), OPT_CREATED_BY.getName(), OPT_CREATION_DATE.getName()}));
            }
            ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowAttributesCmd.OPT_SNAPSHOT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            ScmCommandLineArgument wsSelector = null;
            if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_SNAPSHOT_WORKSPACE)) {
                wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowAttributesCmd.OPT_SNAPSHOT_WORKSPACE), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            }
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (cli.hasOption((IOptionKey)OPT_NAME)) {
                propertyNames.add("name");
            }
            if (cli.hasOption((IOptionKey)OPT_DESCRIPTION)) {
                propertyNames.add("description");
            }
            if (cli.hasOption((IOptionKey)OPT_OWNEDBY)) {
                propertyNames.add("ownedby");
            }
            if (cli.hasOption((IOptionKey)OPT_ITERATION)) {
                propertyNames.add("iteration");
            }
            if (cli.hasOption((IOptionKey)OPT_RELEASE)) {
                propertyNames.add("release");
            }
            if (cli.hasOption((IOptionKey)OPT_CREATED_BY)) {
                propertyNames.add("createdby");
            }
            if (cli.hasOption((IOptionKey)OPT_CREATION_DATE)) {
                propertyNames.add("creationdate");
            }
            SnapshotPropertyListCmd.listProperties((IScmCommandLineArgument)ssSelector, (IScmCommandLineArgument)wsSelector, propertyNames, true, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_COMPONENT)) {
            if (!(cli.hasOption((IOptionKey)OPT_NAME) || cli.hasOption((IOptionKey)OPT_OWNEDBY) || cli.hasOption((IOptionKey)OPT_VISIBILITY))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_3_ARGUMENTS, (Object[])new String[]{OPT_NAME.getName(), OPT_OWNEDBY.getName(), OPT_VISIBILITY.getName()}));
            }
            List componentSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)ShowAttributesCmd.OPT_COMPONENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)componentSelectorList, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (cli.hasOption((IOptionKey)OPT_NAME)) {
                propertyNames.add("name");
            }
            if (cli.hasOption((IOptionKey)OPT_DESCRIPTION)) {
                propertyNames.add("description");
            }
            if (cli.hasOption((IOptionKey)OPT_OWNEDBY)) {
                propertyNames.add("ownedby");
            }
            if (cli.hasOption((IOptionKey)OPT_VISIBILITY)) {
                propertyNames.add("visibility");
            }
            ComponentPropertyListCmd.listProperties(componentSelectorList, null, propertyNames, client, this.config);
        } else if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_CHANGESET)) {
            ITeamRepository repo = null;
            if (!(cli.hasOption((IOptionKey)OPT_AUTHOR) || cli.hasOption((IOptionKey)OPT_COMMENT) || cli.hasOption((IOptionKey)OPT_MODIFIEDDATE))) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_3_ARGUMENTS, (Object[])new String[]{OPT_AUTHOR.getName(), OPT_COMMENT.getName(), OPT_MODIFIEDDATE.getName()}));
            }
            if (repo == null) {
                repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
            }
            ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowAttributesCmd.OPT_CHANGESET), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (cli.hasOption((IOptionKey)OPT_COMMENT)) {
                propertyNames.add("comment");
            }
            if (cli.hasOption((IOptionKey)OPT_AUTHOR)) {
                propertyNames.add("author");
            }
            if (cli.hasOption((IOptionKey)OPT_MODIFIEDDATE)) {
                propertyNames.add("modifieddate");
            }
            if (csSelector != null) {
                try {
                    this.csPropertyCmd.listProperties((IScmCommandLineArgument)csSelector, propertyNames, true, client, this.config, repo, cli);
                }
                catch (Exception e) {
                    throw StatusHelper.argSyntax((String)(String.valueOf(NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_4_ARGUMENTS, (Object[])new String[]{OPT_COMMENT.getName(), OPT_AUTHOR.getName()})) + " " + NLS.bind((String)Messages.Stream_MUST_SPECIFY_ARGUMENT, (Object)OPT_AUTO_FILE_LOCK_PATTTERN.getName())));
                }
            }
        } else {
            if (!cli.hasOption((IOptionKey)OPT_NAME) && !cli.hasOption((IOptionKey)OPT_DESCRIPTION)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_MUST_SPECIFY_1_OF_2_ARGUMENTS, (Object[])new String[]{OPT_NAME.getName(), OPT_DESCRIPTION.getName()}));
            }
            ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowAttributesCmd.OPT_BASELINE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            ScmCommandLineArgument compSelector = null;
            if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_BASELINE_COMPONENT)) {
                compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowAttributesCmd.OPT_BASELINE_COMPONENT), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            }
            ArrayList<String> propertyNames = new ArrayList<String>();
            if (cli.hasOption((IOptionKey)OPT_NAME)) {
                propertyNames.add("name");
            }
            if (cli.hasOption((IOptionKey)OPT_DESCRIPTION)) {
                propertyNames.add("description");
            }
            BaselinePropertyListCmd.listProperties((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, propertyNames, true, client, this.config);
        }
    }
}

