/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentCustomAttributes;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;

public class ComponentUnsetCustomAttributeCmd {
    public static void unsetCustomAttributes(IScmCommandLineArgument compSelector, String[] unsetCustomAttrs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
        IComponent comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        ComponentUnsetCustomAttributeCmd.unsetCustomAttributes(comp, unsetCustomAttrs, repo, client, config);
        config.getWrappedOutputStream().println((CharSequence)Messages.ComponentUnsetCustomAttributesCmd_PROPERTY_UNSET_SUCCESS);
    }

    private static void unsetCustomAttributes(IComponent comp, String[] unsetCustomAttrs, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsComponentCustomAttributes parms = new ParmsComponentCustomAttributes();
        parms.componentUuid = comp.getItemId().getUuidValue();
        parms.repositoryUrl = repo.getRepositoryURI();
        parms.unsetCustomAttrs = unsetCustomAttrs;
        try {
            client.postSetComponentCustomAttributes(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ComponentUnsetCustomAttributesCmd_PROPERTY_UNSET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }
}

