/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.ComponentPropertyListCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutComponent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsReadScope;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ComponentPropertySetCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client;
    public static final PositionalOptionDefinition OPT_PROPERTY_NAME = new PositionalOptionDefinition("property-name", 1, 1);
    public static final PositionalOptionDefinition OPT_PROPERTY_VALUE = new PositionalOptionDefinition("property-value", 1, 1);
    public static final NamedOptionDefinition OPT_SCOPE_TO_TEAMAREA = new NamedOptionDefinition("s", "teamarea-scope", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_PROPERTY_NAME, NLS.bind((String)Messages.ComponentPropertiesCmdOptions_OPT_PROPERTY_SET_NAME_HELP, (Object[])new String[]{"name", "ownedby", "owned", "visibility", "visi"})).addOption((IPositionalOptionDefinition)OPT_PROPERTY_VALUE, NLS.bind((String)Messages.ComponentPropertiesCmdOptions_OPT_PROPERTY_VALUE_HELP, (Object[])new String[]{"visibility", "public", "private", "archived"})).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR, "component", 1, -1, "@"), Messages.ComponentPropertiesCmdOptions_COMPONENT_SET_HELP).addOption((INamedOptionDefinition)OPT_SCOPE_TO_TEAMAREA, Messages.ComponentPropertiesCmdOptions_OPT_SCOPE_TO_TEAMAREA_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        String propertyName = cli.getOption((IOptionKey)OPT_PROPERTY_NAME, null);
        if (propertyName != null && !Arrays.asList(ComponentPropertyListCmd.PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        ScmCommandLineArgument propertyValue = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROPERTY_VALUE, null), (IScmClientConfiguration)this.config);
        List compSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        HashMap<String, IScmCommandLineArgument> properties = new HashMap<String, IScmCommandLineArgument>();
        properties.put(propertyName.toLowerCase(), (IScmCommandLineArgument)propertyValue);
        ComponentPropertySetCmd.setProperties(compSelectorList, properties, cli.hasOption((IOptionKey)OPT_SCOPE_TO_TEAMAREA), this.client, this.config);
    }

    public static void setProperties(List<IScmCommandLineArgument> compSelectorList, Map<String, IScmCommandLineArgument> properties, boolean teamAreaScope, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        boolean setAllComponentProperties;
        JSONArray jCompArray = new JSONArray();
        for (IScmCommandLineArgument compSelector : compSelectorList) {
            JSONObject jComp = ComponentPropertySetCmd.setProperties(compSelector, properties, teamAreaScope, client, config);
            jCompArray.add((Object)jComp);
        }
        if (config.isJSONEnabled()) {
            if (!jCompArray.isEmpty()) {
                JSONObject jResult = new JSONObject();
                jResult.put((Object)"components", (Object)jCompArray);
                config.getOutputStream().print((CharSequence)jResult.toString());
            }
            setAllComponentProperties = ComponentPropertyListCmd.hasAllComponentProperties(jCompArray);
        } else {
            setAllComponentProperties = ComponentPropertySetCmd.printResult(jCompArray, config);
            if (setAllComponentProperties) {
                config.getWrappedOutputStream().println((CharSequence)Messages.ComponentPropertiesCmd_PROPERTY_SET_SUCCESS);
            }
        }
        if (!setAllComponentProperties) {
            throw StatusHelper.propertiesUnavailable((String)Messages.ComponentPropertiesCmd_PROPERTY_SET_FAILURE);
        }
    }

    private static JSONObject setProperties(IScmCommandLineArgument compSelector, Map<String, IScmCommandLineArgument> properties, boolean teamAreaScope, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jComp = new JSONObject();
        String errorMsg = null;
        long statusCode = 0L;
        ITeamRepository repo = null;
        boolean success = false;
        try {
            IComponent componentHandle = null;
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
            try {
                IComponent comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                jComp.put((Object)"component", (Object)comp.getName());
                componentHandle = comp;
            }
            catch (CLIFileSystemClientException e) {
                if (e.getStatus() != null && e.getStatus().getCode() == 18) {
                    componentHandle = RepoUtil.getComponentHandle((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                }
                throw e;
            }
            jComp.put((Object)"uuid", (Object)componentHandle.getItemId().getUuidValue());
            jComp.put((Object)"url", (Object)repo.getRepositoryURI());
            ComponentPropertySetCmd.setProperties((IComponentHandle)componentHandle, properties, teamAreaScope, repo, client, config);
            success = true;
        }
        catch (CLIFileSystemClientException e) {
            statusCode = e.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            statusCode = 3L;
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (!jComp.containsKey((Object)"component")) {
            if (success) {
                try {
                    IComponent comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                    jComp.put((Object)"component", (Object)comp.getName());
                }
                catch (Exception comp) {
                    // empty catch block
                }
            }
            if (!jComp.containsKey((Object)"component")) {
                jComp.put((Object)"component", (Object)compSelector.getItemSelector());
            }
        }
        jComp.put((Object)"status-code", (Object)statusCode);
        if (!success) {
            jComp.put((Object)"error-message", (Object)errorMsg);
        }
        StringBuffer propertyNames = new StringBuffer();
        for (String property : properties.keySet()) {
            if (propertyNames.length() != 0) {
                propertyNames.append(", ");
            }
            propertyNames.append(property);
        }
        jComp.put((Object)"property", (Object)properties.toString());
        return jComp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void setProperties(IComponentHandle comp, Map<String, IScmCommandLineArgument> properties, boolean teamareaScope, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IScmCommandLineArgument propertyValue;
        ParmsPutComponent parms = new ParmsPutComponent();
        parms.componentItemId = comp.getItemId().getUuidValue();
        parms.repositoryUrl = repo.getRepositoryURI();
        ScmComponent2 compInfo = RepoUtil.getComponentById((String)comp.getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        if (properties.containsKey("name")) {
            parms.name = properties.get("name").getItemSelector();
        }
        if (properties.containsKey("ownedby") || properties.containsKey("owned")) {
            propertyValue = properties.get("ownedby");
            if (propertyValue == null) {
                propertyValue = properties.get("owned");
            }
            SubcommandUtil.validateArgument((IScmCommandLineArgument)propertyValue, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.CONTRIBUTOR, RepoUtil.ItemType.PROJECTAREA, RepoUtil.ItemType.TEAMAREA});
            parms.readScope = new ParmsReadScope();
            IContributor contributor = null;
            try {
                contributor = RepoUtil.fetchContributor((String)propertyValue.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                if (contributor != null) {
                    parms.newOwnerItemId = contributor.getItemId().getUuidValue();
                    parms.newOwnerItemType = IContributor.ITEM_TYPE.getName();
                    parms.readScope.scope = "private_scope";
                }
            }
            catch (CLIFileSystemClientException cLIFileSystemClientException) {
                // empty catch block
            }
            if (contributor == null) {
                IProcessArea processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)propertyValue, null, (ITeamRepository)repo, (IScmClientConfiguration)config);
                parms.newOwnerItemId = processArea.getItemId().getUuidValue();
                parms.newOwnerItemType = processArea.getItemType().getName();
                parms.readScope.scope = teamareaScope && ITeamArea.ITEM_TYPE.equals(processArea.getItemType()) ? "team_area_private_scope" : "process_area_scope";
            }
        }
        if (properties.containsKey("visibility") || properties.containsKey("visi")) {
            propertyValue = properties.get("visibility");
            if (propertyValue == null) {
                propertyValue = properties.get("visi");
            }
            IItemType ownerType = SubcommandUtil.getOwnerType((String)(parms.newOwnerItemType != null ? parms.newOwnerItemType : compInfo.getOwner().getItemType()));
            String ownerId = parms.newOwnerItemId != null ? parms.newOwnerItemId : compInfo.getOwner().getItemId();
            parms.readScope = new ParmsReadScope();
            if (propertyValue.getItemSelector().equalsIgnoreCase("public")) {
                if (!IContributor.ITEM_TYPE.equals(ownerType)) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ComponentPropertiesCmd_INVALID_VISIBILITY, (Object[])new String[]{"public", "projectarea", "teamarea", "accessgroup"}));
                parms.readScope.scope = "public_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("private")) {
                parms.readScope.scope = "private_scope";
                if (!IContributor.ITEM_TYPE.equals(ownerType)) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ComponentPropertiesCmd_INVALID_VISIBILITY, (Object[])new String[]{"private", "projectarea", "teamarea", "accessgroup"}));
                parms.readScope.scope = "private_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("archived")) {
                IContributor loggedInContributor = repo.loggedInContributor();
                if (parms.newOwnerItemId != null) {
                    if (!loggedInContributor.getItemId().getUuidValue().equals(parms.newOwnerItemId)) {
                        StatusHelper.inappropriateArgument((String)Messages.ComponentPropertySetCmd_0);
                    }
                } else {
                    parms.newOwnerItemId = loggedInContributor.getItemId().getUuidValue();
                    parms.newOwnerItemType = loggedInContributor.getItemType().getName();
                }
                parms.readScope.scope = "archived_scope";
                if (!IContributor.ITEM_TYPE.equals(ownerType)) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ComponentPropertiesCmd_INVALID_VISIBILITY, (Object[])new String[]{"archived", "projectarea", "teamarea", "accessgroup"}));
                parms.readScope.scope = "archived_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("teamarea")) {
                ITeamArea processArea;
                if (IContributor.ITEM_TYPE.equals(ownerType)) {
                    throw StatusHelper.inappropriateArgument((String)Messages.ComponentPropertiesCmd_CANNOT_SET_TEAM_AREA_VISIBILITY);
                }
                if (IProjectArea.ITEM_TYPE.equals(ownerType)) {
                    throw StatusHelper.inappropriateArgument((String)Messages.ComponentPropertiesCmd_SPECIFIY_PROJECTAREA);
                }
                IScmCommandLineArgument teamSelector = properties.get("processarea");
                if (teamSelector != null && !(processArea = (ITeamArea)RepoUtil.getProcessArea((IScmCommandLineArgument)teamSelector, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA, (ITeamRepository)repo, (IScmClientConfiguration)config)).getItemId().getUuidValue().equals(ownerId)) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ComponentPropertiesCmd_TEAMAREA_ALREADY_SET, (Object)teamSelector.getItemSelector()));
                }
                parms.readScope.scope = "team_area_private_scope";
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("projectarea")) {
                IScmCommandLineArgument projectAreaValue = properties.get("processarea");
                IProcessArea processArea = null;
                if (projectAreaValue != null) {
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)projectAreaValue, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
                    processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)projectAreaValue, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA, (ITeamRepository)repo, (IScmClientConfiguration)config);
                }
                if (IContributor.ITEM_TYPE.equals(ownerType)) {
                    if (projectAreaValue == null) {
                        throw StatusHelper.argSyntax((String)Messages.WorkspacePropertiesCmd_SPECIFY_PROJECT_IDENTIFIER);
                    }
                    if (processArea == null) {
                        throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)propertyValue.getItemSelector()));
                    }
                    parms.readScope.scope = "contributor_deferring_scope";
                    parms.readScope.defer_to = processArea.getItemId().getUuidValue();
                } else {
                    if (processArea != null) {
                        ITeamArea teamArea;
                        IProjectArea projArea;
                        if (IProjectArea.ITEM_TYPE.equals(ownerType) && !processArea.getItemId().getUuidValue().equals(ownerId)) {
                            throw StatusHelper.inappropriateArgument((String)Messages.ComponentPropertiesCmd_PROJECTAREA_INVALID_PA_OWNER);
                        }
                        if (ITeamArea.ITEM_TYPE.equals(ownerType) && !(projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)(teamArea = (ITeamArea)RepoUtil.getItem((IItemType)ITeamArea.ITEM_TYPE, (UUID)UUID.valueOf((String)ownerId), (ITeamRepository)repo, (int)1, (IScmClientConfiguration)config)).getProjectArea().getItemId(), (ITeamRepository)repo, (IScmClientConfiguration)config)).getItemId().equals((Object)processArea.getItemId())) {
                            throw StatusHelper.inappropriateArgument((String)Messages.ComponentPropertiesCmd_PROJECTAREA_INVALID_TA_OWNER);
                        }
                    }
                    parms.readScope.scope = "process_area_scope";
                }
            } else if (propertyValue.getItemSelector().equalsIgnoreCase("accessgroup")) {
                IScmCommandLineArgument accessGroupValue = properties.get("accessgroup");
                if (accessGroupValue == null) {
                    throw StatusHelper.argSyntax((String)Messages.WorkspacePropertiesCmd_SPECIFY_ACCESS_GROUP);
                }
                SubcommandUtil.validateArgument((IScmCommandLineArgument)accessGroupValue, (RepoUtil.ItemType)RepoUtil.ItemType.ACCESSGROUP);
                IAccessGroup accessGroup = RepoUtil.getAccessGroup((IScmCommandLineArgument)accessGroupValue, (ITeamRepository)repo, (IScmClientConfiguration)config);
                if (accessGroup == null) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_ACCESS_GROUP, (Object)accessGroupValue.getItemSelector()));
                parms.readScope.scope = "access_group_scope";
                parms.readScope.defer_to = accessGroup.getGroupContextId().getUuidValue();
            } else {
                if (!IContributor.ITEM_TYPE.equals(ownerType)) throw StatusHelper.inappropriateArgument((String)Messages.ComponentPropertiesCmd_CANNOT_SET_VISIBILITY);
                IProcessArea processArea = null;
                SubcommandUtil.validateArgument((IScmCommandLineArgument)propertyValue, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
                processArea = RepoUtil.getProcessArea((IScmCommandLineArgument)propertyValue, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA, (ITeamRepository)repo, (IScmClientConfiguration)config);
                parms.readScope.scope = "contributor_deferring_scope";
                parms.readScope.defer_to = processArea.getItemId().getUuidValue();
            }
        }
        try {
            client.postPutComponent(parms, null);
            return;
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ComponentPropertiesCmd_PROPERTY_SET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    private static boolean printResult(JSONArray jCompArray, IScmClientConfiguration config) {
        IndentingPrintStream err = config.getWrappedErrorStream();
        boolean setAllComponentProperties = true;
        for (Object obj : jCompArray) {
            long statusCode;
            JSONObject jComp = (JSONObject)obj;
            String comp = (String)jComp.get((Object)"component");
            if (jComp.get((Object)"uuid") != null) {
                String compItemId = (String)jComp.get((Object)"uuid");
                String repoUri = (String)jComp.get((Object)"url");
                comp = AliasUtil.selector((String)comp, (UUID)UUID.valueOf((String)compItemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            }
            if ((statusCode = ((Long)jComp.get((Object)"status-code")).longValue()) == 0L) continue;
            String errorMsg = (String)jComp.get((Object)"error-message");
            err.println((CharSequence)comp);
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_CODE, (Object)statusCode));
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_MESSAGE, (Object)errorMsg));
            setAllComponentProperties = false;
        }
        return setAllComponentProperties;
    }
}

