/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ComponentPropertyListCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client;
    public static final String NAME_PROPERTY = "name";
    public static final String OWNEDBY_PROPERTY = "ownedby";
    public static final String OWNEDBY_ALIAS_PROPERTY = "owned";
    public static final String VISIBILITY_PROPERTY = "visibility";
    public static final String VISIBILITY_ALIAS_PROPERTY = "visi";
    public static final String TEAMAREA_VISIBILITY = "teamarea";
    public static final String PROJECTAREA_VISIBILITY = "projectarea";
    public static final String ACCESSGROUP_VISIBILITY = "accessgroup";
    public static final String PUBLIC_VISIBILITY = "public";
    public static final String PRIVATE_VISIBILITY = "private";
    public static final String ARCHIVED_VISIBILITY = "archived";
    public static final String UNKNOWN = "unknown";
    public static final String PROCESS_AREA_PROPERTY = "processarea";
    public static final String[] PROPERTIES = new String[]{"name", "ownedby", "owned", "visibility", "visi"};

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR, "component", 1, -1, "@"), Messages.ComponentPropertiesCmdOptions_COMPONENT_LIST_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    public void run() throws FileSystemException {
        this.listProperties(null);
    }

    protected void listProperties(String propertyName) throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (propertyName != null && !Arrays.asList(PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        List compSelectorList = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)compSelectorList, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        ArrayList<String> propertyNames = null;
        if (propertyName != null) {
            propertyNames = new ArrayList<String>(1);
            propertyNames.add(propertyName.toLowerCase());
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ComponentPropertyListCmd.listProperties(compSelectorList, propertyName, propertyNames, this.client, this.config);
    }

    public static void listProperties(List<IScmCommandLineArgument> compSelectorList, String propertyName, List<String> propertyNames, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        boolean retrievedComponentProperties;
        JSONArray jCompArray = new JSONArray();
        for (IScmCommandLineArgument compSelector : compSelectorList) {
            JSONObject jComp = ComponentPropertyListCmd.listProperties(compSelector, propertyNames, client, config);
            jCompArray.add((Object)jComp);
        }
        if (config.isJSONEnabled()) {
            if (!jCompArray.isEmpty()) {
                JSONObject jResult = new JSONObject();
                jResult.put((Object)"components", (Object)jCompArray);
                config.getOutputStream().print((CharSequence)jResult.toString());
            }
            retrievedComponentProperties = ComponentPropertyListCmd.hasAllComponentProperties(jCompArray);
        } else {
            retrievedComponentProperties = ComponentPropertyListCmd.printProperties(jCompArray, propertyName == null, config);
        }
        if (!retrievedComponentProperties) {
            throw StatusHelper.propertiesUnavailable((String)Messages.ComponentPropertiesCmd_PROPERTY_LIST_FAILURE);
        }
    }

    private static JSONObject listProperties(IScmCommandLineArgument compSelector, List<String> propertyNames, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jComp = new JSONObject();
        long statusCode = 0L;
        String errorMsg = null;
        ITeamRepository repo = null;
        IComponent comp = null;
        try {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
            comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            JSONObject jProps = ComponentPropertyListCmd.getProperties(comp, propertyNames, repo, client, config);
            jComp.put((Object)"component", (Object)comp.getName());
            jComp.put((Object)"properties", (Object)jProps);
        }
        catch (CLIFileSystemClientException e) {
            statusCode = e.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        catch (Exception e) {
            statusCode = 3L;
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (comp == null) {
            jComp.put((Object)"component", (Object)compSelector.getItemSelector());
            jComp.put((Object)"error-message", (Object)errorMsg);
        }
        jComp.put((Object)"status-code", (Object)statusCode);
        return jComp;
    }

    private static JSONObject getProperties(IComponent comp, List<String> propertyNames, ITeamRepository repo, IFilesystemRestClient client2, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        ScmComponent2 compInfo = RepoUtil.getComponentById((String)comp.getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        jProps.put((Object)NAME_PROPERTY, (Object)comp.getName());
        jProps.put((Object)"uuid", (Object)comp.getItemId().getUuidValue());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        String ownerName = RepoUtil.getOwnerName((String)compInfo.getOwner().getItemId(), (String)compInfo.getOwner().getItemType(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        if (propertyNames == null || propertyNames.contains(OWNEDBY_PROPERTY) || propertyNames.contains(OWNEDBY_ALIAS_PROPERTY)) {
            IItemType itemType = SubcommandUtil.getOwnerType((String)compInfo.getOwner().getItemType());
            JSONObject jOwnedBy = new JSONObject();
            jOwnedBy.put((Object)NAME_PROPERTY, (Object)ownerName);
            jOwnedBy.put((Object)"uuid", (Object)compInfo.getOwner().getItemId());
            jOwnedBy.put((Object)"url", (Object)repo.getRepositoryURI());
            jOwnedBy.put((Object)"type", (Object)SubcommandUtil.getItemType((IItemType)itemType).toString());
            jProps.put((Object)OWNEDBY_PROPERTY, (Object)jOwnedBy);
        }
        if (propertyNames == null || propertyNames.contains(VISIBILITY_PROPERTY) || propertyNames.contains(VISIBILITY_ALIAS_PROPERTY)) {
            JSONObject jVisibility = new JSONObject();
            JSONObject jInfo = null;
            if (compInfo.getReadScope().equalsIgnoreCase("public_scope")) {
                jVisibility.put((Object)"type", (Object)PUBLIC_VISIBILITY);
            } else if (compInfo.getReadScope().equalsIgnoreCase("private_scope")) {
                jVisibility.put((Object)"type", (Object)PRIVATE_VISIBILITY);
            } else if (compInfo.getReadScope().equalsIgnoreCase("archived_scope")) {
                jVisibility.put((Object)"type", (Object)ARCHIVED_VISIBILITY);
            } else if (compInfo.getReadScope().equalsIgnoreCase("contributor_deferring_scope")) {
                jVisibility.put((Object)"type", (Object)PROJECTAREA_VISIBILITY);
                String defersTo = RepoUtil.getOwnerName((String)compInfo.getReadDefersTo().getItemId(), (String)compInfo.getReadDefersTo().getItemType(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                jInfo = new JSONObject();
                jInfo.put((Object)NAME_PROPERTY, (Object)defersTo);
                jInfo.put((Object)"uuid", (Object)compInfo.getReadDefersTo().getItemId());
                jInfo.put((Object)"url", (Object)repo.getRepositoryURI());
                jInfo.put((Object)"type", (Object)SubcommandUtil.getItemType((IItemType)SubcommandUtil.getOwnerType((String)compInfo.getReadDefersTo().getItemType())).toString());
                jInfo.put((Object)"contributor-deferring", (Object)Boolean.TRUE);
            } else if (compInfo.getReadScope().equalsIgnoreCase("process_area_scope")) {
                jVisibility.put((Object)"type", (Object)PROJECTAREA_VISIBILITY);
                IProjectArea projArea = null;
                IItemType ownerType = SubcommandUtil.getOwnerType((String)compInfo.getOwner().getItemType());
                if (ITeamArea.ITEM_TYPE.equals(ownerType)) {
                    ITeamArea teamArea = (ITeamArea)RepoUtil.getItem((IItemType)ITeamArea.ITEM_TYPE, (UUID)UUID.valueOf((String)compInfo.getOwner().getItemId()), (ITeamRepository)repo, (int)1, (IScmClientConfiguration)config);
                    projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)teamArea.getProjectArea().getItemId(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                } else if (IProjectArea.ITEM_TYPE.equals(ownerType)) {
                    projArea = (IProjectArea)RepoUtil.getItem((IItemType)IProjectArea.ITEM_TYPE, (UUID)UUID.valueOf((String)compInfo.getOwner().getItemId()), (ITeamRepository)repo, (int)1, (IScmClientConfiguration)config);
                }
                if (projArea != null) {
                    jInfo = new JSONObject();
                    jInfo.put((Object)NAME_PROPERTY, (Object)projArea.getName());
                    jInfo.put((Object)"uuid", (Object)projArea.getItemId().getUuidValue());
                    jInfo.put((Object)"url", (Object)repo.getRepositoryURI());
                    jInfo.put((Object)"type", (Object)RepoUtil.ItemType.PROJECTAREA.toString());
                }
            } else if (compInfo.getReadScope().equalsIgnoreCase("team_area_private_scope")) {
                jVisibility.put((Object)"type", (Object)TEAMAREA_VISIBILITY);
                jInfo = new JSONObject();
                jInfo.put((Object)NAME_PROPERTY, (Object)ownerName);
                jInfo.put((Object)"uuid", (Object)compInfo.getOwner().getItemId());
                jInfo.put((Object)"url", (Object)repo.getRepositoryURI());
                jInfo.put((Object)"type", (Object)RepoUtil.ItemType.TEAMAREA.toString());
            } else if (compInfo.getReadScope().equalsIgnoreCase("access_group_scope")) {
                IAccessGroup accessGroup;
                jVisibility.put((Object)"type", (Object)ACCESSGROUP_VISIBILITY);
                ScmHandle accessGroupId = compInfo.getReadDefersTo();
                IAccessGroup iAccessGroup = accessGroup = accessGroupId != null ? RepoUtil.getAccessGroup((UUID)UUID.valueOf((String)accessGroupId.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)config) : null;
                if (accessGroup != null) {
                    jInfo = new JSONObject();
                    jInfo.put((Object)NAME_PROPERTY, (Object)accessGroup.getName());
                    jInfo.put((Object)"uuid", (Object)accessGroup.getGroupContextId().getUuidValue());
                    jInfo.put((Object)"url", (Object)repo.getRepositoryURI());
                    jInfo.put((Object)"type", (Object)RepoUtil.ItemType.ACCESSGROUP.toString());
                }
            } else {
                jVisibility.put((Object)"type", (Object)UNKNOWN);
            }
            if (jInfo != null) {
                jVisibility.put((Object)"info", jInfo);
            }
            jProps.put((Object)VISIBILITY_PROPERTY, (Object)jVisibility);
        }
        return jProps;
    }

    private static boolean printProperties(JSONArray jCompArray, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream out = config.getWrappedOutputStream();
        IndentingPrintStream err = config.getWrappedErrorStream();
        boolean retrievedAllComponentProperties = true;
        for (Object obj : jCompArray) {
            JSONObject jComp = (JSONObject)obj;
            boolean result = ComponentPropertyListCmd.printProperties(jComp, printCaption, out, err);
            if (result) continue;
            retrievedAllComponentProperties = false;
        }
        return retrievedAllComponentProperties;
    }

    public static boolean printProperties(JSONObject jComp, boolean printCaption, IndentingPrintStream out, IndentingPrintStream err) {
        JSONObject jVisibility;
        String comp = (String)jComp.get((Object)"component");
        long statusCode = (Long)jComp.get((Object)"status-code");
        if (statusCode != 0L) {
            String errorMsg = (String)jComp.get((Object)"error-message");
            err.println((CharSequence)comp);
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_CODE, (Object)statusCode));
            err.indent().println((CharSequence)NLS.bind((String)Messages.Common_ERROR_MESSAGE, (Object)errorMsg));
            return false;
        }
        JSONObject jProps = (JSONObject)jComp.get((Object)"properties");
        String name = (String)jProps.get((Object)NAME_PROPERTY);
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        String compTitle = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        out.println((CharSequence)compTitle);
        JSONObject jOwnedBy = (JSONObject)jProps.get((Object)OWNEDBY_PROPERTY);
        if (jOwnedBy != null) {
            String ownedbyName = (String)jOwnedBy.get((Object)NAME_PROPERTY);
            String ownedbyUuid = (String)jOwnedBy.get((Object)"uuid");
            String ownedbyUri = (String)jOwnedBy.get((Object)"url");
            RepoUtil.ItemType ownedbyType = RepoUtil.ItemType.valueOf((String)((String)jOwnedBy.get((Object)"type")));
            String ownedbyInfo = AliasUtil.selector((String)ownedbyName, (UUID)UUID.valueOf((String)ownedbyUuid), (String)ownedbyUri, (RepoUtil.ItemType)ownedbyType);
            out.indent().println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_OWNEDBY, (Object)ownedbyInfo) : ownedbyInfo));
        }
        if ((jVisibility = (JSONObject)jProps.get((Object)VISIBILITY_PROPERTY)) != null) {
            String infoName;
            JSONObject jInfo;
            String visibilityType = (String)jVisibility.get((Object)"type");
            String visibilityInfo = Messages.Common_UNKNOWN;
            if (visibilityType.equals(PUBLIC_VISIBILITY)) {
                visibilityInfo = Messages.Common_PUBLIC;
            } else if (visibilityType.equals(PRIVATE_VISIBILITY)) {
                visibilityInfo = Messages.Common_PRIVATE;
            } else if (visibilityType.equals(ARCHIVED_VISIBILITY)) {
                visibilityInfo = Messages.ComponentPropertyListCmd_0;
            } else if (visibilityType.equals(PROJECTAREA_VISIBILITY) || visibilityType.equals(TEAMAREA_VISIBILITY)) {
                jInfo = (JSONObject)jVisibility.get((Object)"info");
                if (jInfo != null) {
                    infoName = (String)jInfo.get((Object)NAME_PROPERTY);
                    String infoUuid = (String)jInfo.get((Object)"uuid");
                    String infoUri = (String)jInfo.get((Object)"url");
                    RepoUtil.ItemType infoType = RepoUtil.ItemType.valueOf((String)((String)jInfo.get((Object)"type")));
                    visibilityInfo = AliasUtil.selector((String)infoName, (UUID)UUID.valueOf((String)infoUuid), (String)infoUri, (RepoUtil.ItemType)infoType);
                    visibilityInfo = visibilityType.equals(PROJECTAREA_VISIBILITY) ? NLS.bind((String)Messages.WorkspacePropertiesCmd_PROJECT_SCOPED, (Object)visibilityInfo) : NLS.bind((String)Messages.WorkspacePropertiesCmd_TEAM_PRIVATE, (Object)visibilityInfo);
                }
            } else if (visibilityType.equals(ACCESSGROUP_VISIBILITY)) {
                jInfo = (JSONObject)jVisibility.get((Object)"info");
                if (jInfo != null) {
                    infoName = (String)jInfo.get((Object)NAME_PROPERTY);
                    String infoUuid = (String)jInfo.get((Object)"uuid");
                    String infoUri = (String)jInfo.get((Object)"url");
                    RepoUtil.ItemType infoType = RepoUtil.ItemType.valueOf((String)((String)jInfo.get((Object)"type")));
                    String selector = AliasUtil.selector((String)infoName, (UUID)UUID.valueOf((String)infoUuid), (String)infoUri, (RepoUtil.ItemType)infoType);
                    visibilityInfo = NLS.bind((String)Messages.WorkspacePropertiesCmd_ACCESS_GROUP, (Object)selector);
                } else {
                    visibilityInfo = NLS.bind((String)Messages.WorkspacePropertiesCmd_ACCESS_GROUP, (Object)Messages.Common_UNKNOWN);
                }
            }
            out.indent().println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_VISIBILITY, (Object)visibilityInfo) : visibilityInfo));
        }
        return true;
    }

    public static boolean hasAllComponentProperties(JSONArray jCompArray) {
        for (Object obj : jCompArray) {
            JSONObject jComp = (JSONObject)obj;
            Long statusCode = (Long)jComp.get((Object)"status-code");
            if (statusCode == 0L) continue;
            return false;
        }
        return true;
    }
}

