/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.ShowAttributesCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.impl.ChangeFolderSyncDTOImpl;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSet;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSetList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ChangeSetPropertyCmd {
    public static final String AUTHOR_PROPERTY = "author";
    public static final String COMMENT_PROPERTY = "comment";
    public static final String MODIFIEDDATE_PROPERTY = "modifieddate";
    public static final NamedOptionDefinition OPT_COMMENT = new NamedOptionDefinition(null, "comment", 0);
    public static final NamedOptionDefinition OPT_AUTHOR = new NamedOptionDefinition(null, "author", 0);
    public static final NamedOptionDefinition OPT_MODIFIEDDATE = new NamedOptionDefinition(null, "modifieddate", 0);
    protected boolean verifyUpdateReportForReplace = true;

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)ShowAttributesCmd.OPT_CHANGESET, NLS.bind((String)Messages.ShowAttributesCmdOptions_CHANGESET_HELP, (Object[])new String[]{AUTHOR_PROPERTY, COMMENT_PROPERTY, MODIFIEDDATE_PROPERTY})).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    public void listProperties(IScmCommandLineArgument creatorSelector, List<String> propertyNames, boolean printCaption, IFilesystemRestClient client, IScmClientConfiguration config, ITeamRepository repo, ICommandLine cli) throws TeamRepositoryException {
        JSONObject jb1 = new JSONObject();
        ScmChangeSetList cslist = null;
        IUuidAliasRegistry.IUuidAlias csItem = RepoUtil.lookupUuidAndAlias((String)creatorSelector.getItemSelector());
        if (csItem == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)"Unable to find change set ''{0}''", (Object)creatorSelector));
        }
        String csUuid = csItem.getUuid().getUuidValue();
        if (creatorSelector != null) {
            IScmRichClientRestService.ParmsGetChangeSets parms = new IScmRichClientRestService.ParmsGetChangeSets();
            parms.changeSetItemIds = new String[]{csUuid};
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            cslist = scmService.postGetChangeSets(parms);
        }
        if (cslist.getChangeSets().size() > 0) {
            List changeSets = cslist.getChangeSets();
            for (ScmChangeSet changeSet : changeSets) {
                jb1.put((Object)"changeset", (Object)changeSet.getItemId());
                jb1.put((Object)"property", (Object)ChangeSetPropertyCmd.getProperties(changeSet, propertyNames, repo, config));
            }
        }
        JSONArray changeArray = new JSONArray();
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_CHANGES)) {
            options.enablePrinter(6);
            options.enablePrinter(14);
            ChangeSetSyncDTO changeSetSyncDTO = RepoUtil.findChangeSet((String)creatorSelector.getItemSelector(), (boolean)true, null, null, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            if (changeSetSyncDTO != null) {
                List nextChanges = changeSetSyncDTO.getChanges();
                for (ChangeFolderSyncDTOImpl next : nextChanges) {
                    for (ChangeSyncDTO changeSyncDTO : next.getChanges()) {
                        JSONObject change = new JSONObject();
                        if (changeSyncDTO == null) continue;
                        JSONPrintUtil.jsonizeChange((JSONObject)change, (ChangeSyncDTO)changeSyncDTO, (ChangeSetStateFactory)new ChangeSetStateFactory(), (String)repo.getRepositoryURI(), (PendingChangesUtil.PendingChangesOptions)options, null);
                        changeArray.add((Object)change);
                    }
                }
            }
        }
        if (config.isJSONEnabled()) {
            if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_CHANGES)) {
                JSONArray showChangeArray = new JSONArray();
                int i = 0;
                while (i < changeArray.size()) {
                    JSONObject chg = (JSONObject)changeArray.get(i);
                    JSONObject showChange = new JSONObject();
                    showChange.put((Object)"path", chg.get((Object)"path"));
                    showChange.put((Object)"uuid", chg.get((Object)"uuid"));
                    showChangeArray.add((Object)showChange);
                    ++i;
                }
                jb1.put((Object)"changes", (Object)showChangeArray);
            }
            config.getOutputStream().print((CharSequence)jb1.toString());
        } else {
            ChangeSetPropertyCmd.printProperties(jb1, printCaption, config);
            if (cli.hasOption((IOptionKey)ShowAttributesCmd.OPT_CHANGES)) {
                boolean displayHeader = true;
                IndentingPrintStream out = config.getWrappedOutputStream();
                if (displayHeader) {
                    out.println((CharSequence)Messages.ShowAttributeCmd_1);
                    displayHeader = false;
                }
                int i = 0;
                while (i < changeArray.size()) {
                    JSONObject chg = (JSONObject)changeArray.get(i);
                    PendingChangesUtil.printChange((JSONObject)chg, (String)repo.getRepositoryURI(), (boolean)false, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out.indent());
                    ++i;
                }
            }
        }
    }

    private static JSONObject getProperties(ScmChangeSet changeSet, List<String> propertyNames, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (propertyNames == null || propertyNames.contains(AUTHOR_PROPERTY)) {
            if (changeSet.getAuthorId() != null) {
                IContributor creatorContributor = RepoUtil.fetchContributor((String)changeSet.getAuthorId(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                jProps.put((Object)AUTHOR_PROPERTY, (Object)creatorContributor.getName());
            } else {
                jProps.put((Object)AUTHOR_PROPERTY, (Object)changeSet.getAuthorId());
            }
        }
        if (propertyNames == null || propertyNames.contains(COMMENT_PROPERTY)) {
            jProps.put((Object)COMMENT_PROPERTY, (Object)changeSet.getComment());
        }
        if (propertyNames == null || propertyNames.contains(MODIFIEDDATE_PROPERTY)) {
            SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
            jProps.put((Object)"modifiedDate", (Object)format.format(changeSet.getDateModified()));
        }
        jProps.put((Object)"uuid", (Object)changeSet.getItemId());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        return jProps;
    }

    private static void printProperties(JSONObject jBl, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        String modifiedDate;
        String comment;
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject jProps = (JSONObject)jBl.get((Object)"property");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        String author = (String)jProps.get((Object)AUTHOR_PROPERTY);
        if (author != null) {
            author = AliasUtil.selector((String)author, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.ChangeSetPropertiesCmd_AUTHOR, (Object)author) : author));
        }
        if ((comment = (String)jProps.get((Object)COMMENT_PROPERTY)) != null && !comment.isEmpty()) {
            comment = AliasUtil.selector((String)comment, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.ChangeSetPropertiesCmd_COMMENT, (Object)comment) : comment));
        }
        if ((modifiedDate = (String)jProps.get((Object)"modifiedDate")) != null && !modifiedDate.isEmpty()) {
            modifiedDate = AliasUtil.selector((String)modifiedDate, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.ChangeSetPropertiesCmd_MODIFIEDDATE, (Object)modifiedDate) : modifiedDate));
        }
    }
}

