/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSetCustomAttributes;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProperty;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResolveChangeSet;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.ChangeSetCustomAttributesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ChangeSetCustomAttributeCmdUtil {
    public static void setCustomAttributes(IScmCommandLineArgument csSelector, Map<String, String> customAttrs, IFilesystemRestClient client, IScmClientConfiguration config) throws TeamRepositoryException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
        IChangeSet changeset = null;
        if (csSelector != null) {
            changeset = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        ChangeSetCustomAttributeCmdUtil.setCustomAttributes(changeset, customAttrs, repo, client, config);
        config.getWrappedOutputStream().println((CharSequence)Messages.ChangeSetSetCustomAttributesCmd_PROPERTY_SET_SUCCESS);
    }

    private static void setCustomAttributes(IChangeSet cs, Map<String, String> customAttrs, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws TeamRepositoryException {
        ParmsChangeSetCustomAttributes parms = new ParmsChangeSetCustomAttributes();
        parms.chnageSetUUID = cs.getItemId().getUuidValue();
        parms.repositoryUrl = repo.getRepositoryURI();
        ParmsProperty[] properties = new ParmsProperty[customAttrs.size()];
        int i = 0;
        for (String key : customAttrs.keySet()) {
            ParmsProperty prop = new ParmsProperty(key, customAttrs.get(key));
            properties[i++] = prop;
        }
        parms.setCustomAttrs = properties;
        client.postSetChangeSetCustomAttributes(parms, null);
    }

    public static void unsetCustomAttributes(IScmCommandLineArgument csSelector, String[] unsetCustomAttrs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
        IChangeSet changeset = null;
        if (csSelector != null) {
            changeset = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        ChangeSetCustomAttributeCmdUtil.unsetCustomAttributes(changeset, unsetCustomAttrs, repo, client, config);
        config.getWrappedOutputStream().println((CharSequence)Messages.ChangeSetUnsetCustomAttributesCmd_PROPERTY_UNSET_SUCCESS);
    }

    private static void unsetCustomAttributes(IChangeSet comp, String[] unsetCustomAttrs, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsChangeSetCustomAttributes parms = new ParmsChangeSetCustomAttributes();
        parms.chnageSetUUID = comp.getItemId().getUuidValue();
        parms.repositoryUrl = repo.getRepositoryURI();
        parms.unsetCustomAttrs = unsetCustomAttrs;
        try {
            client.postSetChangeSetCustomAttributes(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangeSetUnsetCustomAttributesCmd_PROPERTY_UNSET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    public static void getCustomAttributes(IScmCommandLineArgument csSelector, String key, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
        long statusCode = 0L;
        String errorMsg = null;
        IChangeSet changeset = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        ChangeSetSyncDTO[] changeSetsSync = ChangeSetCustomAttributeCmdUtil.getChangeSetDTO(repo.getRepositoryURI(), client, config, new String[]{changeset.getItemId().getUuidValue()});
        JSONObject csObj = new JSONObject();
        ChangeSetCustomAttributeCmdUtil.jsonizeChangeSet(changeSetsSync[0], csObj, config);
        JSONObject jBl = new JSONObject();
        try {
            JSONObject jProps = ChangeSetCustomAttributeCmdUtil.getCustomAttributes(changeset, key, repo, config, client);
            jBl.put((Object)"changeset", (Object)csObj);
            jBl.put((Object)"properties", (Object)jProps);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (errorMsg != null) {
            jBl.put((Object)"error-message", (Object)errorMsg);
        }
        jBl.put((Object)"status-code", (Object)statusCode);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jBl.toString());
        } else {
            ChangeSetCustomAttributeCmdUtil.printProperties(jBl, repo.getRepositoryURI(), client, config);
        }
    }

    private static void jsonizeChangeSet(ChangeSetSyncDTO csDto, JSONObject csObj, IScmClientConfiguration config) {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(4);
        options.enablePrinter(22);
        options.enablePrinter(7);
        JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)csObj, (ChangeSetSyncDTO)csDto, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
    }

    private static ChangeSetSyncDTO[] getChangeSetDTO(String repoUrl, IFilesystemRestClient client, IScmClientConfiguration config, String[] csIds) throws FileSystemException {
        ParmsGetChangeSets parms = new ParmsGetChangeSets();
        parms.repositoryUrl = repoUrl;
        parms.settings = new ParmsResolveChangeSet();
        parms.settings.includeChanges = false;
        parms.settings.includeFoldersInChangeLists = false;
        parms.settings.includeOslcLinks = false;
        parms.settings.includeUnchangedFiles = false;
        parms.changeSetItemIds = csIds;
        try {
            return client.postGetChangeSets(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ErrorFetchingChangeSet, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)parms.repositoryUrl);
        }
    }

    private static JSONObject getCustomAttributes(IChangeSet cs, String key, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client) throws TeamRepositoryException {
        JSONObject jProps = new JSONObject();
        jProps.put((Object)"uuid", (Object)cs.getItemId().getUuidValue());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        ParmsChangeSetCustomAttributes parms = new ParmsChangeSetCustomAttributes();
        parms.chnageSetUUID = cs.getItemId().getUuidValue();
        parms.repositoryUrl = repo.getRepositoryURI();
        ChangeSetCustomAttributesDTO customAttrs = client.postGetChangeSetCustomAttributes(parms, null);
        ArrayList map = new ArrayList(customAttrs.getCustomAttributes().entrySet());
        JSONArray props = new JSONArray();
        for (Map.Entry entry : map) {
            JSONObject prop = new JSONObject();
            if (key != null && !key.equals(entry.getKey())) continue;
            prop.put((Object)"property", entry.getKey());
            prop.put((Object)"value", entry.getValue());
            props.add((Object)prop);
        }
        if (props.size() > 0) {
            jProps.put((Object)"custom_attributes", (Object)props);
        }
        return jProps;
    }

    private static void printProperties(JSONObject jBl, String repoUrl, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject jProps = (JSONObject)jBl.get((Object)"properties");
        JSONObject changeset = (JSONObject)jBl.get((Object)"changeset");
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(22);
        PendingChangesUtil.printChangeSetHeader((JSONObject)changeset, (String)repoUrl, null, null, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out);
        JSONArray props = (JSONArray)jProps.get((Object)"custom_attributes");
        if (props != null) {
            int maxWidth = 0;
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                String property = (String)prop.get((Object)"property");
                maxWidth = Math.max(maxWidth, property.length());
            }
            IndentingPrintStream indent = out.indent();
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((String)prop.get((Object)"property")), (int)maxWidth), (Object)prop.get((Object)"value")));
            }
        }
    }
}

