/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.ShowCustomAttributesCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineCustomAttributes;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.BaselineCustomAttributesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class BaselineShowCustomAttributesCmd {
    IFilesystemRestClient client;

    protected void getCustomAttributes(String key, IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_BASELINE), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        ScmCommandLineArgument compSelector = null;
        if (cli.hasOption((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT)) {
            compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ShowCustomAttributesCmd.OPT_COMPONENT), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }
        BaselineShowCustomAttributesCmd.getCustomAttributes((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, key, this.client, config);
    }

    public static void getCustomAttributes(IScmCommandLineArgument blSelector, IScmCommandLineArgument compSelector, String key, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)blSelector);
        long statusCode = 0L;
        String errorMsg = null;
        IComponent comp = null;
        if (compSelector != null) {
            comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaseline bl = RepoUtil.getBaseline((String)blSelector.getItemSelector(), (String)(comp != null ? comp.getItemId().getUuidValue() : null), (String)(comp != null ? comp.getName() : null), (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        JSONObject jBl = new JSONObject();
        try {
            JSONObject jProps = BaselineShowCustomAttributesCmd.getCustomAttributes(bl, key, repo, config, client);
            jBl.put((Object)"baseline", (Object)bl.getName());
            jBl.put((Object)"properties", (Object)jProps);
        }
        catch (TeamRepositoryException e) {
            CLIFileSystemClientException exp = StatusHelper.wrap((String)"", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            statusCode = exp.getStatus().getCode();
            errorMsg = e.getLocalizedMessage();
            StatusHelper.logException((String)errorMsg, (Throwable)e);
        }
        if (errorMsg != null) {
            jBl.put((Object)"error-message", (Object)errorMsg);
        }
        jBl.put((Object)"status-code", (Object)statusCode);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jBl.toString());
        } else {
            BaselineShowCustomAttributesCmd.printProperties(jBl, config);
        }
    }

    private static JSONObject getCustomAttributes(IBaseline bl, String key, ITeamRepository repo, IScmClientConfiguration config, IFilesystemRestClient client) throws TeamRepositoryException {
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        jProps.put((Object)"name", (Object)bl.getName());
        jProps.put((Object)"description", (Object)bl.getComment());
        jProps.put((Object)"uuid", (Object)bl.getItemId().getUuidValue());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        ParmsBaseline parmsBl = new ParmsBaseline();
        parmsBl.repositoryUrl = repo.getRepositoryURI();
        parmsBl.baselineItemId = bl.getItemId().getUuidValue();
        ParmsBaselineCustomAttributes parms = new ParmsBaselineCustomAttributes();
        parms.baseline = parmsBl;
        BaselineCustomAttributesDTO customAttrs = client.postGetBaselineCustomAttributes(parms, null);
        ArrayList map = new ArrayList(customAttrs.getCustomAttributes().entrySet());
        JSONArray props = new JSONArray();
        for (Map.Entry entry : map) {
            JSONObject prop = new JSONObject();
            if (key != null && !key.equals(entry.getKey())) continue;
            prop.put((Object)"property", entry.getKey());
            prop.put((Object)"value", entry.getValue());
            props.add((Object)prop);
        }
        if (props.size() > 0) {
            jProps.put((Object)"custom_attributes", (Object)props);
        }
        return jProps;
    }

    private static void printProperties(JSONObject jBl, IScmClientConfiguration config) throws FileSystemException {
        JSONArray props;
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject jProps = (JSONObject)jBl.get((Object)"properties");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        String name = (String)jProps.get((Object)"name");
        if (name != null) {
            name = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            out.println((CharSequence)name);
        }
        if ((props = (JSONArray)jProps.get((Object)"custom_attributes")) != null) {
            int maxWidth = 0;
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                String property = (String)prop.get((Object)"property");
                maxWidth = Math.max(maxWidth, property.length());
            }
            IndentingPrintStream indent = out.indent();
            for (Object entry : props) {
                JSONObject prop = (JSONObject)entry;
                indent.println((CharSequence)NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)((String)prop.get((Object)"property")), (int)maxWidth), (Object)prop.get((Object)"value")));
            }
        }
    }
}

