/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.property.BaselinePropertyListCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateBaseline;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class BaselinePropertySetCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client;
    public static final PositionalOptionDefinition OPT_PROPERTY_NAME = new PositionalOptionDefinition("property-name", 1, 1);
    public static final PositionalOptionDefinition OPT_PROPERTY_VALUE = new PositionalOptionDefinition("property-value", 1, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_PROPERTY_NAME, NLS.bind((String)Messages.BaselinePropertiesCmdOptions_OPT_PROPERTY_SET_NAME_HELP, (Object[])new String[]{"name", "description", "desc"})).addOption((IPositionalOptionDefinition)OPT_PROPERTY_VALUE, Messages.BaselinePropertiesCmdOptions_OPT_PROPERTY_VALUE_HELP).addOption((IPositionalOptionDefinition)BaselinePropertyListCmd.OPT_BASELINE_SELECTOR, Messages.BaselinePropertiesCmdOptions_BASELINE_SET_HELP).addOption((INamedOptionDefinition)BaselinePropertyListCmd.OPT_COMPONENT_SELECTOR, Messages.BaselinePropertiesCmdOptions_COMPONENT_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        String propertyName = cli.getOption((IOptionKey)OPT_PROPERTY_NAME, null);
        if (propertyName != null && !Arrays.asList(BaselinePropertyListCmd.PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)BaselinePropertyListCmd.OPT_BASELINE_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        ScmCommandLineArgument compSelector = null;
        if (cli.hasOption((IOptionKey)BaselinePropertyListCmd.OPT_COMPONENT_SELECTOR)) {
            compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)BaselinePropertyListCmd.OPT_COMPONENT_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }
        ScmCommandLineArgument propertyValue = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROPERTY_VALUE, null), (IScmClientConfiguration)this.config);
        HashMap<String, IScmCommandLineArgument> properties = new HashMap<String, IScmCommandLineArgument>();
        properties.put(propertyName.toLowerCase(), (IScmCommandLineArgument)propertyValue);
        BaselinePropertySetCmd.setProperties((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, properties, this.client, this.config);
    }

    public static void setProperties(IScmCommandLineArgument blSelector, IScmCommandLineArgument compSelector, Map<String, IScmCommandLineArgument> properties, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)blSelector);
        IComponent comp = null;
        if (compSelector != null) {
            comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaseline bl = RepoUtil.getBaseline((String)blSelector.getItemSelector(), (String)(comp != null ? comp.getItemId().getUuidValue() : null), (String)(comp != null ? comp.getName() : null), (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        BaselinePropertySetCmd.setProperties(bl, properties, repo, client, config);
        config.getWrappedOutputStream().println((CharSequence)Messages.BaselinePropertiesCmd_PROPERTY_SET_SUCCESS);
    }

    private static void setProperties(IBaseline bl, Map<String, IScmCommandLineArgument> properties, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsUpdateBaseline parms = new ParmsUpdateBaseline();
        parms.baseline = new ParmsBaseline();
        parms.baseline.baselineItemId = bl.getItemId().getUuidValue();
        parms.baseline.repositoryUrl = repo.getRepositoryURI();
        if (properties.containsKey("name")) {
            parms.name = properties.get("name").getItemSelector();
        } else if (properties.containsKey("description") || properties.containsKey("desc")) {
            IScmCommandLineArgument propertyValue = properties.get("description");
            if (propertyValue == null) {
                propertyValue = properties.get("desc");
            }
            parms.comment = propertyValue.getItemSelector();
        }
        try {
            client.postUpdateBaseline(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.BaselinePropertiesCmd_PROPERTY_SET_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }
}

