/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.property;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaseline;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineCustomAttributes;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.BaselineCustomAttributesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class BaselinePropertyListCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client;
    public static final String NAME_PROPERTY = "name";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DESCRIPTION_ALIAS_PROPERTY = "desc";
    public static final String[] PROPERTIES = new String[]{"name", "description", "desc"};
    public static final PositionalOptionDefinition OPT_BASELINE_SELECTOR = new PositionalOptionDefinition("baseline", 1, 1, "@");
    public static final NamedOptionDefinition OPT_COMPONENT_SELECTOR = new NamedOptionDefinition("c", "component", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IPositionalOptionDefinition)OPT_BASELINE_SELECTOR, Messages.BaselinePropertiesCmdOptions_BASELINE_LIST_HELP).addOption((INamedOptionDefinition)OPT_COMPONENT_SELECTOR, Messages.BaselinePropertiesCmdOptions_COMPONENT_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        return options;
    }

    public void run() throws FileSystemException {
        this.listProperties(null);
    }

    protected void listProperties(String propertyName) throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (propertyName != null && !Arrays.asList(PROPERTIES).contains(propertyName)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_PROPERTY_NAME, (Object)propertyName));
        }
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_BASELINE_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        ScmCommandLineArgument compSelector = null;
        if (cli.hasOption((IOptionKey)OPT_COMPONENT_SELECTOR)) {
            compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }
        ArrayList<String> propertyNames = null;
        if (propertyName != null) {
            propertyNames = new ArrayList<String>(1);
            propertyNames.add(propertyName.toLowerCase());
        }
        BaselinePropertyListCmd.listProperties((IScmCommandLineArgument)blSelector, (IScmCommandLineArgument)compSelector, propertyNames, propertyName == null, this.client, this.config);
    }

    public static void listProperties(IScmCommandLineArgument blSelector, IScmCommandLineArgument compSelector, List<String> propertyNames, boolean printCaption, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)blSelector);
        IComponent comp = null;
        if (compSelector != null) {
            comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        IBaseline bl = RepoUtil.getBaseline((String)blSelector.getItemSelector(), (String)(comp != null ? comp.getItemId().getUuidValue() : null), (String)(comp != null ? comp.getName() : null), (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        JSONObject jProps = new JSONObject();
        JSONObject jBl = new JSONObject();
        try {
            jProps = BaselinePropertyListCmd.getProperties(bl, propertyNames, repo, config);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.BaselinePropertyListCmd_UNABLE_TO_GETPROPERTIES, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        jBl.put((Object)"baseline", (Object)bl.getName());
        jBl.put((Object)"properties", (Object)jProps);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jBl.toString());
        } else {
            BaselinePropertyListCmd.printProperties(jBl, printCaption, config);
        }
    }

    private static JSONObject getProperties(IBaseline bl, List<String> propertyNames, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException, TeamRepositoryException {
        JSONObject jProps = new JSONObject();
        IndentingPrintStream out = config.getWrappedOutputStream();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        if (propertyNames == null || propertyNames.contains(NAME_PROPERTY)) {
            jProps.put((Object)NAME_PROPERTY, (Object)bl.getName());
        }
        if (propertyNames == null || propertyNames.contains(DESCRIPTION_PROPERTY) || propertyNames.contains(DESCRIPTION_ALIAS_PROPERTY)) {
            jProps.put((Object)DESCRIPTION_PROPERTY, (Object)bl.getComment());
        }
        if (propertyNames == null) {
            jProps.put((Object)"id", (Object)bl.getId());
            IContributor creatorContributor = RepoUtil.fetchContributor((String)bl.getCreator().getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            jProps.put((Object)"createdBy", (Object)creatorContributor.getName());
            SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
            jProps.put((Object)"creationDate", (Object)format.format(bl.getCreationDate()));
            IComponent blComponent = RepoUtil.getComponent((String)bl.getComponent().getItemId().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            jProps.put((Object)"component", (Object)blComponent.getName());
            jProps.put((Object)"modifiedDate", (Object)format.format(bl.modified()));
            ParmsBaseline parmsBl = new ParmsBaseline();
            parmsBl.repositoryUrl = repo.getRepositoryURI();
            parmsBl.baselineItemId = bl.getItemId().getUuidValue();
            ParmsBaselineCustomAttributes parms = new ParmsBaselineCustomAttributes();
            parms.baseline = parmsBl;
            String key = "tags";
            BaselineCustomAttributesDTO customAttrs = client.postGetBaselineCustomAttributes(parms, null);
            if (customAttrs.isSetCustomAttributes()) {
                ArrayList map = new ArrayList(customAttrs.getCustomAttributes().entrySet());
                JSONArray props = new JSONArray();
                for (Map.Entry entry : map) {
                    JSONObject prop = new JSONObject();
                    if (!key.equals(entry.getKey())) continue;
                    prop.put((Object)"tags", entry.getKey());
                    prop.put((Object)"value", entry.getValue());
                    props.add((Object)prop);
                }
                if (props.size() > 0) {
                    jProps.put((Object)"custom_attributes", (Object)props);
                }
            }
        }
        jProps.put((Object)"uuid", (Object)bl.getItemId().getUuidValue());
        jProps.put((Object)"url", (Object)repo.getRepositoryURI());
        return jProps;
    }

    private static void printProperties(JSONObject jBl, boolean printCaption, IScmClientConfiguration config) throws FileSystemException {
        JSONArray customAttributeObj;
        String blcomponent;
        String modifieddDate;
        String createdBy;
        String creationdDate;
        String description;
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject jProps = (JSONObject)jBl.get((Object)"properties");
        String itemId = (String)jProps.get((Object)"uuid");
        String repoUri = (String)jProps.get((Object)"url");
        String name = (String)jProps.get((Object)NAME_PROPERTY);
        if (name != null) {
            name = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.WorkspacePropertiesCmd_NAME, (Object)name) : name));
        }
        if ((description = (String)jProps.get((Object)DESCRIPTION_PROPERTY)) != null && !description.isEmpty()) {
            if (printCaption) {
                out.println((CharSequence)Messages.WorkspacePropertiesCmd_DESCRIPTION);
            }
            out.println((CharSequence)description);
        }
        if (jProps.get((Object)"id") != null) {
            String blid = jProps.get((Object)"id").toString();
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.BaselinePropertiesCmd_ID, (Object)blid) : blid));
        }
        if ((creationdDate = (String)jProps.get((Object)"creationDate")) != null && !creationdDate.isEmpty()) {
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.SnapshotPropertiesCmd_CREATION_DATE, (Object)creationdDate) : creationdDate));
        }
        if ((createdBy = (String)jProps.get((Object)"createdBy")) != null) {
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.SnapshotPropertiesCmd_CREATED_BY, (Object)createdBy) : createdBy));
        }
        if (jProps.get((Object)"modifiedDate") != null && !(modifieddDate = (String)jProps.get((Object)"modifiedDate")).isEmpty()) {
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.ChangeSetPropertiesCmd_MODIFIEDDATE, (Object)modifieddDate) : modifieddDate));
        }
        if ((blcomponent = (String)jProps.get((Object)"component")) != null) {
            out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.BaselinePropertiesCmd_COMPONENT, (Object)blcomponent) : blcomponent));
        }
        if (jProps.get((Object)"custom_attributes") != null && (customAttributeObj = (JSONArray)jProps.get((Object)"custom_attributes")).size() > 0) {
            for (Object obj : customAttributeObj) {
                JSONObject tagsObj = (JSONObject)obj;
                String baselinetags = (String)tagsObj.get((Object)"tags");
                if (baselinetags == null) continue;
                String tagValue = tagsObj.get((Object)"value").toString();
                out.println((CharSequence)(printCaption ? NLS.bind((String)Messages.BaselinePropertiesCmd_TAGS, (Object)tagValue) : tagValue));
            }
        }
    }
}

